# coding: utf-8

"""
    Adobe Target Delivery API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from delivery_api_client.api_client import ApiClient
from delivery_api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DeliveryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def execute(self, ims_org_id, session_id, delivery_request, **kwargs):
        """Retrieve Target offers

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.execute(ims_org_id, session_id, delivery_request, async_req=True)
        >>> result = thread.get()

        :param ims_org_id: The IMS organization ID (required)
        :type ims_org_id: str
        :param session_id: This is the `sessionId` that should be generated and maintained by the API user for the current session the user is a part of. The `sessionId` can be any printable string except a space, ?, or /. It should be between 1 and 128 characters in length. <br><br> For a particular session, its value must stay the same across multiple requests for the same user since routing to a particular node in the edge cluster, which contains the user profile, is done using the `sessionId`. The session is active for 30 minutes on the server side. Therefore, you shouldn’t use a different `sessionId` for a particular `tntId` or `thirdPartyId` within 30 minutes of the last request made with the same `tntId` or `thirdPartyId`. Otherwise, changes to the profile could be inconsistent and unpredictable. <br><br>Furthermore, using the same `sessionId` with different `tntId` or `thirdPartyId` may cause unpredictable changes to the profiles. (required)
        :type session_id: str
        :param delivery_request: Delivery Request (required)
        :type delivery_request: DeliveryRequest
        :param version: This is the `version` of at.js.
        :type version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeliveryResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.execute_with_http_info(ims_org_id, session_id, delivery_request, **kwargs)

    def execute_with_http_info(self, ims_org_id, session_id, delivery_request, **kwargs):
        """Retrieve Target offers

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.execute_with_http_info(ims_org_id, session_id, delivery_request, async_req=True)
        >>> result = thread.get()

        :param ims_org_id: The IMS organization ID (required)
        :type ims_org_id: str
        :param session_id: This is the `sessionId` that should be generated and maintained by the API user for the current session the user is a part of. The `sessionId` can be any printable string except a space, ?, or /. It should be between 1 and 128 characters in length. <br><br> For a particular session, its value must stay the same across multiple requests for the same user since routing to a particular node in the edge cluster, which contains the user profile, is done using the `sessionId`. The session is active for 30 minutes on the server side. Therefore, you shouldn’t use a different `sessionId` for a particular `tntId` or `thirdPartyId` within 30 minutes of the last request made with the same `tntId` or `thirdPartyId`. Otherwise, changes to the profile could be inconsistent and unpredictable. <br><br>Furthermore, using the same `sessionId` with different `tntId` or `thirdPartyId` may cause unpredictable changes to the profiles. (required)
        :type session_id: str
        :param delivery_request: Delivery Request (required)
        :type delivery_request: DeliveryRequest
        :param version: This is the `version` of at.js.
        :type version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeliveryResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ims_org_id',
            'session_id',
            'delivery_request',
            'version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                'headers',
                'callback',
                'err_callback'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method execute" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ims_org_id' is set
        if self.api_client.client_side_validation and ('ims_org_id' not in local_var_params or
                                                        local_var_params['ims_org_id'] is None):
            raise ApiValueError("Missing the required parameter `ims_org_id` when calling `execute`")
        # verify the required parameter 'session_id' is set
        if self.api_client.client_side_validation and ('session_id' not in local_var_params or
                                                        local_var_params['session_id'] is None):
            raise ApiValueError("Missing the required parameter `session_id` when calling `execute`")
        # verify the required parameter 'delivery_request' is set
        if self.api_client.client_side_validation and ('delivery_request' not in local_var_params or
                                                        local_var_params['delivery_request'] is None):
            raise ApiValueError("Missing the required parameter `delivery_request` when calling `execute`")

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ims_org_id' in local_var_params and local_var_params['ims_org_id'] is not None:
            query_params.append(('imsOrgId', local_var_params['ims_org_id']))
        if 'session_id' in local_var_params and local_var_params['session_id'] is not None:
            query_params.append(('sessionId', local_var_params['session_id']))
        if 'version' in local_var_params and local_var_params['version'] is not None:
            query_params.append(('version', local_var_params['version']))

        header_params = local_var_params.get('headers', {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'delivery_request' in local_var_params:
            body_params = local_var_params['delivery_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(
            ['application/json'])

        # Authentication setting
        auth_settings = []
        
        response_types_map = {
            200: "DeliveryResponse",
            204: None,
        }

        return self.api_client.call_api(
            '/rest/v1/delivery', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_all_params =request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'),
            callback=local_var_params.get('callback'),
            err_callback=local_var_params.get('err_callback'))
