/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2ldap;

import com.teradata.tdgss.jgssp2ldap.LdapMechanism;
import com.teradata.tdgss.jgssp2ldap.LdapMinorStatus;
import com.teradata.tdgss.jgssp2ldap.LdapName;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssName;
import java.io.UnsupportedEncodingException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class LdapCredential
implements GSSCredential {
    private final TdgssLogger logger;
    private LdapName name;
    private GSSName userName;
    private GSSName passwordName;
    private GSSName logdataName;
    private int initLifetime;
    private int acceptLifetime;
    private int usage;
    private long initEnd;
    private long acceptEnd;
    private boolean indefiniteInit = false;
    private boolean indefiniteAccept = false;
    private boolean acceptOnly = false;
    private boolean initOnly = false;
    private char[] password;

    public LdapCredential(LdapName ldapName, int n, int n2, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        this.name = ldapName == null ? new LdapName(null, null, tdgssLogger) : ldapName;
        long l = System.currentTimeMillis();
        this.usage = n2;
        if (this.usage != 2) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteInit = true;
            } else {
                this.initLifetime = n;
                this.initEnd = l + (long)this.initLifetime;
            }
        } else {
            this.acceptOnly = true;
        }
        if (n2 != 1) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteAccept = true;
            } else {
                this.acceptLifetime = n;
                this.acceptEnd = l + (long)this.acceptLifetime;
            }
        } else {
            this.initOnly = true;
        }
        if (n2 != 2) {
            this.password = "dummypassword".toCharArray();
        }
        this.createLogdata(this.name);
    }

    public void dispose() throws GSSException {
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = '\u0000';
        }
        this.password = null;
    }

    public GSSName getName() throws GSSException {
        return this.name;
    }

    public GSSName getName(Oid oid) throws GSSException {
        if (oid != LdapMechanism.mechOid) {
            throw new TdgssException(2, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        return this.name;
    }

    public int getRemainingLifetime() throws GSSException {
        int n;
        if (this.initOnly) {
            return this.getRemainingInitLifetime(LdapMechanism.mechOid);
        }
        if (this.acceptOnly) {
            return this.getRemainingAcceptLifetime(LdapMechanism.mechOid);
        }
        int n2 = this.getRemainingAcceptLifetime(LdapMechanism.mechOid);
        return n2 < (n = this.getRemainingInitLifetime(LdapMechanism.mechOid)) ? n2 : n;
    }

    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        if (oid != LdapMechanism.mechOid) {
            throw new TdgssException(2, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        if (this.acceptOnly) {
            return 0;
        }
        if (this.indefiniteInit) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(System.currentTimeMillis() - this.initEnd);
        return n < 0 ? 0 : n;
    }

    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        if (oid != LdapMechanism.mechOid) {
            throw new TdgssException(2, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        if (this.initOnly) {
            return 0;
        }
        if (this.indefiniteAccept) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(System.currentTimeMillis() - this.acceptEnd);
        return n < 0 ? 0 : n;
    }

    public int getUsage() throws GSSException {
        return this.usage;
    }

    public int getUsage(Oid oid) throws GSSException {
        if (oid != LdapMechanism.mechOid) {
            throw new TdgssException(2, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        return this.usage;
    }

    public Oid[] getMechs() throws GSSException {
        Oid[] oidArray = new Oid[]{LdapMechanism.mechOid};
        return oidArray;
    }

    public void add(GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        GSSName gSSName2 = gSSName == null ? new LdapName(null, null, this.logger) : gSSName;
        this.createLogdata(gSSName2);
    }

    public boolean equals(Object object) {
        try {
            GSSCredential gSSCredential = (GSSCredential)object;
            if (gSSCredential == null) {
                return false;
            }
            if (!gSSCredential.getName().equals(this.name)) {
                return false;
            }
            Oid[] oidArray = gSSCredential.getMechs();
            for (int i = 0; i < oidArray.length; ++i) {
                if (gSSCredential.getUsage(oidArray[i]) != this.getUsage(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingAcceptLifetime(oidArray[i]) != this.getRemainingAcceptLifetime(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingInitLifetime(oidArray[i]) == this.getRemainingInitLifetime(oidArray[i])) continue;
                return false;
            }
        }
        catch (GSSException gSSException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    private static int hashCode(char[] cArray) {
        int n = 31;
        if (cArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i = 0; i < cArray.length; ++i) {
            n2 = n * n2 + cArray[i];
        }
        return n2;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.password == null ? 0 : LdapCredential.hashCode(this.password));
        n = 31 * n + this.usage;
        try {
            Oid[] oidArray = this.getMechs();
            for (int i = 0; i < oidArray.length; ++i) {
                if (!this.initOnly) {
                    n = n * 31 + (this.indefiniteAccept ? 1231 : this.acceptLifetime);
                }
                if (this.acceptOnly) continue;
                n = n * 31 + (this.indefiniteInit ? 1231 : this.initLifetime);
            }
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
        }
        return n;
    }

    protected char[] getPassword() {
        return this.password;
    }

    private void createLogdata(GSSName gSSName) throws GSSException {
        LdapName ldapName = null;
        String string = ((Object)gSSName).toString();
        Oid oid = gSSName.getStringNameType();
        if (oid.equals(TdgssName.GSS_C_NT_TDAT_USER)) {
            this.userName = gSSName;
        } else if (oid.equals(TdgssName.GSS_C_NT_TDAT_PASSWORD)) {
            this.passwordName = gSSName;
        } else {
            this.logdataName = gSSName;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (this.userName != null) {
            string2 = ((Object)this.userName).toString();
        }
        if (this.passwordName != null) {
            string3 = ((Object)this.passwordName).toString();
        }
        if (this.logdataName != null) {
            string4 = ((Object)this.logdataName).toString();
        }
        if (string2 != null && string2.length() != 0 && string3 != null && string3.length() != 0) {
            string3 = LdapCredential.processEscapeChars(string3);
            String string5 = "'" + string2 + "@@" + string3.replaceAll("'", "''") + "'";
            if (string4 != null) {
                string5 = string5 + " " + string4;
            }
            string4 = string5;
        }
        try {
            ldapName = string4 == null ? new LdapName(string.toString().getBytes("UTF-8"), TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, this.logger) : new LdapName(string4.toString().getBytes("UTF-8"), TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, this.logger);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.error(unsupportedEncodingException.getMessage());
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_INPUT, unsupportedEncodingException);
        }
        this.name = ldapName;
    }

    private static String processEscapeChars(String string) {
        String string2 = "";
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    string2 = string2 + "\\b";
                    continue block6;
                }
                case '\n': {
                    string2 = string2 + "\\n";
                    continue block6;
                }
                case '\t': {
                    string2 = string2 + "\\t";
                    continue block6;
                }
                case '/': 
                case '@': 
                case '\\': {
                    string2 = string2 + "\\" + c;
                    continue block6;
                }
                default: {
                    string2 = string2 + c;
                }
            }
        }
        return string2;
    }
}

