# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2017-05-18 02:22
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_api_base.models
import django_api_base.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AccessToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(default=django_api_base.utils.random_number_generator, max_length=50)),
                ('expires', models.DateField(default=django_api_base.models.generate_access_token_expiry)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='DeviceID',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('device_id', models.CharField(max_length=50)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='RefreshToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(default=django_api_base.utils.random_number_generator, max_length=50)),
                ('expire_count', models.IntegerField(default=10)),
                ('device_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_api_base.DeviceID')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='UserProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reset_key', models.CharField(blank=True, default=b'', max_length=30, null=True)),
                ('reset_key_expiration', models.DateTimeField(blank=True, default=None, null=True)),
                ('otp', models.CharField(blank=True, max_length=500, null=True)),
                ('otp_expiry', models.DateTimeField(blank=True, default=None, null=True)),
                ('phone_number', models.BigIntegerField(default=0)),
                ('gender', models.CharField(choices=[(b'-', b'-'), (b'male', b'Male'), (b'female', b'Female')], default=b'-', max_length=10)),
                ('date_updated', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
