export declare enum DependenciesFile {
    PIP = "requirements.txt",
    POETRY = "poetry.lock",
    PIPENV = "Pipfile.lock",
    NONE = ""
}
export interface PackagingProps {
    /**
     * Dependency file for the type of packaging.
     */
    readonly dependenciesFile: DependenciesFile;
    /**
     * Command to export the dependencies into a pip-compatible `requirements.txt` format.
     *
     * @default - No dependencies are exported.
     */
    readonly exportCommand?: string;
}
export declare class Packaging {
    /**
     * Standard packaging with `pip`.
     */
    static readonly PIP: Packaging;
    /**
     * Packaging with `pipenv`.
     */
    static readonly PIPENV: Packaging;
    /**
     * Packaging with `poetry`.
     */
    static readonly POETRY: Packaging;
    /**
     * No dependencies or packaging.
     */
    static readonly NONE: Packaging;
    static fromEntry(entry: string): Packaging;
    readonly dependenciesFile: string;
    readonly exportCommand?: string;
    constructor(props: PackagingProps);
}
