"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToSqsToLambda = void 0;
const aws_lambda_sqs_1 = require("@aws-solutions-constructs/aws-lambda-sqs");
const aws_sqs_lambda_1 = require("@aws-solutions-constructs/aws-sqs-lambda");
const core_1 = require("@aws-cdk/core");
/**
 * @summary The LambdaToSqsToLambda class.
 */
class LambdaToSqsToLambda extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToSqsToLambda class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToSqsToLambdaProps} props - user provided props for the construct.
     * @since 1.53.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        // Setup the aws-lambda-sqs pattern
        const lambdaToSqs = new aws_lambda_sqs_1.LambdaToSqs(this, 'lambda-to-sqs', {
            existingLambdaObj: props.existingProducerLambdaObj,
            lambdaFunctionProps: props.producerLambdaFunctionProps,
            existingQueueObj: props.existingQueueObj,
            queueProps: props.queueProps,
            deadLetterQueueProps: props.deadLetterQueueProps,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            maxReceiveCount: props.maxReceiveCount
        });
        // Set the queue as a pattern property
        this.sqsQueue = lambdaToSqs.sqsQueue;
        // Setup the aws-sqs-lambda pattern
        const sqsToLambda = new aws_sqs_lambda_1.SqsToLambda(this, 'sqs-to-lambda', {
            existingLambdaObj: props.existingConsumerLambdaObj,
            lambdaFunctionProps: props.consumerLambdaFunctionProps,
            existingQueueObj: this.sqsQueue,
            deployDeadLetterQueue: false
        });
        // Set other relevant pattern properties
        this.producerLambdaFunction = lambdaToSqs.lambdaFunction;
        this.deadLetterQueue = lambdaToSqs.deadLetterQueue;
        this.consumerLambdaFunction = sqsToLambda.lambdaFunction;
    }
}
exports.LambdaToSqsToLambda = LambdaToSqsToLambda;
//# sourceMappingURL=data:application/json;base64,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