import { IRepository } from 'aws-cdk-lib/aws-codecommit';
import { Schedule } from 'aws-cdk-lib/aws-events';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { Calendar } from '../time-windows/calendar/calendar';
/**
 * Props for creating a pipeline with a change controller.
 */
export interface PipelineWithChangeControlProps {
    /**
     * The name of the pipeline.
     */
    readonly pipelineName: string;
    /**
     * The role used for running the pipeline.
     *
     * @default - A new role is created when the pipeline is created.
     */
    readonly pipelineRole?: IRole;
    /**
     * The AWS CodeCommit repository to be used as the source stage.
     */
    readonly sourceRepository: IRepository;
    /**
     * The calendar used for determining time windows.
     */
    readonly changeControlCalendar: Calendar;
    /**
     * The schedule on which to check the calendar.
     */
    readonly changeControlCheckSchedule: Schedule;
    /**
     * The terms in the alarm descriptions to search for.
     *
     * These if the alarms containing those search terms are in ALARM,
     * the stage transition will be closed.
     */
    readonly searchTerms: string[];
}
/**
 * A pipeline with a change controller.
 */
export declare class PipelineWithChangeControl extends Construct {
    constructor(scope: Construct, id: string, props: PipelineWithChangeControlProps);
}
