# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RoaRequest
from aliyunsdkeas.endpoint import endpoint_data

class ListServicesRequest(RoaRequest):

	def __init__(self):
		RoaRequest.__init__(self, 'eas', '2021-07-01', 'ListServices','eas')
		self.set_uri_pattern('/api/v2/services')
		self.set_method('GET')

		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())

	def get_Filter(self): # string
		return self.get_query_params().get('Filter')

	def set_Filter(self, Filter):  # string
		self.add_query_param('Filter', Filter)
	def get_PageSize(self): # integer
		return self.get_query_params().get('PageSize')

	def set_PageSize(self, PageSize):  # integer
		self.add_query_param('PageSize', PageSize)
	def get_Sort(self): # string
		return self.get_query_params().get('Sort')

	def set_Sort(self, Sort):  # string
		self.add_query_param('Sort', Sort)
	def get_PageNumber(self): # integer
		return self.get_query_params().get('PageNumber')

	def set_PageNumber(self, PageNumber):  # integer
		self.add_query_param('PageNumber', PageNumber)
	def get_Order(self): # string
		return self.get_query_params().get('Order')

	def set_Order(self, Order):  # string
		self.add_query_param('Order', Order)
