import { Key } from 'aws-cdk-lib/aws-kms';
import { Construct } from 'constructs';
/**
 * An Amazon S3 Bucket implementing the singleton pattern
 */
export declare class SingletonKey extends Key {
    /**
       * Get the Amazon KMS Key the AWS CDK Stack based on the provided name.
       * If no key exists, it creates a new one.
       */
    static getOrCreate(scope: Construct, keyName: string): Key;
}
