import { Database, Table } from '@aws-cdk/aws-glue-alpha';
import { Stream } from 'aws-cdk-lib/aws-kinesis';
import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { Bucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
import { TrackedConstruct } from './common/tracked-construct';
/**
 * The properties for DataLakeExporter Construct.
 */
export interface DataLakeExporterProps {
    /**
     * Amazon S3 sink Bucket where the data lake exporter write data.
     */
    readonly sinkBucket: Bucket;
    /**
     * Amazon S3 sink object key where the data lake exporter write data.
     * @default - The data is written at the bucket root
     */
    readonly sinkObjectKey?: string;
    /**
     * Source must be an Amazon Kinesis Data Stream.
     */
    readonly sourceKinesisDataStream: Stream;
    /**
     * Source AWS Glue Database containing the schema of the stream.
     */
    readonly sourceGlueDatabase: Database;
    /**
     * Source AWS Glue Table containing the schema of the stream.
     */
    readonly sourceGlueTable: Table;
    /**
     * Delivery interval in seconds. The frequency of the data delivery is defined by this interval.
     * @default - Set to 900 seconds
     */
    readonly deliveryInterval?: Number;
    /**
     * Maximum delivery size in MB. The frequency of the data delivery is defined by this maximum delivery size.
     * @default - Set to 128 MB
     */
    readonly deliverySize?: Number;
}
/**
 * DataLakeExporter Construct to export data from a stream to the data lake.
 * Source can be an Amazon Kinesis Data Stream.
 * Target can be an Amazon S3 bucket.
 */
export declare class DataLakeExporter extends TrackedConstruct {
    /**
     * Constructs a new instance of the DataLakeExporter class
     * @param {Construct} scope the Scope of the AWS CDK Construct
     * @param {string} id the ID of the AWS CDK Construct
     * @param {DataLakeExporterProps} props the DataLakeExporter [properties]{@link DataLakeExporterProps}
     * @access public
     */
    readonly cfnIngestionStream: CfnDeliveryStream;
    constructor(scope: Construct, id: string, props: DataLakeExporterProps);
}
