"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrackedConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * A type of CDK Construct that is tracked via a unique code in Stack labels.
 * It is  used to measure the number of deployments and so the impact of the Analytics Reference Architecture.
 */
class TrackedConstruct extends constructs_1.Construct {
    /**
     * Constructs a new instance of the TrackedConstruct
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {TrackedConstructProps} props the TrackedConstruct [properties]{@link TrackedConstructProps}
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (!scope.node.tryGetContext('@aws-analytics-reference-architecture/disableConstructsDeploymentTracking')) {
            const stack = cdk.Stack.of(this);
            const description = `${stack.templateOptions.description} (${props.trackingCode})`;
            stack.templateOptions.description = description;
        }
    }
}
exports.TrackedConstruct = TrackedConstruct;
_a = JSII_RTTI_SYMBOL_1;
TrackedConstruct[_a] = { fqn: "aws-analytics-reference-architecture.TrackedConstruct", version: "2.7.2" };
//# sourceMappingURL=data:application/json;base64,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