import { JobExecutable, PythonSparkJobExecutableProps } from '@aws-cdk/aws-glue-alpha';
/**
 * Props for creating a Python Spark Job in Glue with pre-bundled code.
 * It extends existing PythonSparkJobExecutableProps as optional using `Partial`
 */
export interface PreBundledPysparkJobExecutableProps extends Partial<PythonSparkJobExecutableProps> {
    codePath: string;
}
/**
 * A Glue JobExecutable with prebundled code that can be used to create Glue Jobs.
 *
 * It changes of the code path by based on the environment that `cdk synth` is running on.
 *
 * This class is used together with a Projen custom task "copy-resources".
 * The task will ensure that the Glue script is available in "lib" folder, with the same relative path.
 *
 * When this construct is being run in JSII, this file will be in `node_modules` folder
 * (as it's installed as a 3rd party library.) So we need to change reference based on __dirname.
 *
 *  * Usage example:
 * ```typescript
 * import { PreBundledPysparkJobExecutable } from 'aws-analytics-reference-architecture';
 * import { Job } from '@aws-cdk/aws-glue-alpha';
 *
 * new glue.Job(this, 'PythonShellJob', {
 *   executable: PreBundledPysparkJobExecutable.pythonEtl({
 *     glueVersion: glue.GlueVersion.V3_0,
 *     pythonVersion: glue.PythonVersion.THREE,
 *     codePath: 'construct-dir/resources/glue/script.py',
 *   }),
 *   description: 'an example PySpark job with bundled script',
 * });
 * ```
 */
export declare class PreBundledPysparkJobExecutable {
    static pythonEtl(props: PreBundledPysparkJobExecutableProps): JobExecutable;
}
