import { CfnWorkGroup } from 'aws-cdk-lib/aws-athena';
import { Bucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
export interface AthenaDemoSetupProps {
    /**
     * The Amazon Athena workgroup name. The name is also used
     * @default - `demo` is used
     */
    readonly workgroupName?: string;
}
/**
 * AthenaDemoSetup Construct to automatically setup a new Amazon Athena Workgroup with proper configuration for out-of-the-box demo
 */
export declare class AthenaDemoSetup extends Construct {
    readonly resultBucket: Bucket;
    readonly athenaWorkgroup: CfnWorkGroup;
    /**
     * Constructs a new instance of the AthenaDefaultSetup class
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @access public
     */
    constructor(scope: Construct, id: string, props: AthenaDemoSetupProps);
}
