/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl;

import com.datapps.linkoopdb.jdbc.impl.JDBCBlob;
import com.datapps.linkoopdb.jdbc.impl.JDBCUtil;
import com.datapps.linkoopdb.jdbc.lib.CountdownInputStream;
import com.datapps.linkoopdb.jdbc.lib.FileUtil;
import com.datapps.linkoopdb.jdbc.lib.FrameworkLogger;
import com.datapps.linkoopdb.jdbc.lib.InOutUtil;
import com.datapps.linkoopdb.jdbc.lib.KMPSearchAlgorithm;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class JDBCBlobFile
implements Blob {
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_blob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private static final FrameworkLogger LOG = FrameworkLogger.getLog(JDBCBlobFile.class);
    private final File m_file;
    private boolean m_closed;
    private boolean m_deleteOnFree;
    private List<Object> m_streams = new ArrayList<Object>();

    public JDBCBlobFile() throws SQLException {
        this(true);
    }

    public JDBCBlobFile(boolean deleteOnFree) throws SQLException {
        this.m_deleteOnFree = deleteOnFree;
        try {
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX).getCanonicalFile();
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
    }

    public JDBCBlobFile(File file) throws SQLException {
        this(file, false);
    }

    public JDBCBlobFile(File file, boolean deleteOnFree) throws SQLException {
        this.m_deleteOnFree = deleteOnFree;
        try {
            this.m_file = file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        this.checkIsFile(false);
    }

    private static void closeSafely(RandomAccessFile target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException ignoredIoe) {
                LOG.info(ignoredIoe.getMessage(), ignoredIoe);
            }
            catch (RuntimeException ignoredRex) {
                LOG.info(ignoredRex.getMessage(), ignoredRex);
            }
        }
    }

    private static void closeSafely(InputStream target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException ignoredIoe) {
                LOG.info(ignoredIoe.getMessage(), ignoredIoe);
            }
            catch (RuntimeException ignoredRex) {
                LOG.info(ignoredRex.getMessage(), ignoredRex);
            }
        }
    }

    private static void closeSafely(OutputStream target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException ignoredIoe) {
                LOG.info(ignoredIoe.getMessage(), ignoredIoe);
            }
            catch (RuntimeException ignoredRex) {
                LOG.info(ignoredRex.getMessage(), ignoredRex);
            }
        }
    }

    private static void closeSafely(Reader target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException ignoredIoe) {
                LOG.info(ignoredIoe.getMessage(), ignoredIoe);
            }
            catch (RuntimeException ignoredRex) {
                LOG.info(ignoredRex.getMessage(), ignoredRex);
            }
        }
    }

    private static void closeSafely(Writer target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException ignoredIoe) {
                LOG.info(ignoredIoe.getMessage(), ignoredIoe);
            }
            catch (RuntimeException ignoredRex) {
                LOG.info(ignoredRex.getMessage(), ignoredRex);
            }
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkClosed();
        try {
            return this.m_file.length();
        }
        catch (SecurityException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        int initialBufferSize = Math.min(8192, length);
        try {
            is = this.getBinaryStream(pos, length);
            baos = new ByteArrayOutputStream(initialBufferSize);
            InOutUtil.copy(is, baos, (long)length);
        }
        catch (IOException ex) {
            try {
                throw JDBCUtil.sqlException(ex);
            }
            catch (Throwable throwable) {
                JDBCBlobFile.closeSafely(is);
                throw throwable;
            }
        }
        JDBCBlobFile.closeSafely(is);
        return baos.toByteArray();
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(1L, Long.MAX_VALUE);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (start < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + start);
        }
        if (pattern == null || pattern.length == 0) {
            return -1L;
        }
        long length = this.length();
        if (start > length || (long)pattern.length > length || start > length - (long)pattern.length) {
            return -1L;
        }
        return this.position0(pattern, start);
    }

    private long position0(byte[] pattern, long start) throws SQLException {
        long l;
        InputStream is = null;
        try {
            is = this.getBinaryStream(start, Long.MAX_VALUE);
            long matchOffset = KMPSearchAlgorithm.search(is, pattern, KMPSearchAlgorithm.computeTable(pattern));
            l = matchOffset == -1L ? -1L : start + matchOffset;
        }
        catch (IOException ex) {
            try {
                throw JDBCUtil.sqlException(ex);
            }
            catch (Throwable throwable) {
                JDBCBlobFile.closeSafely(is);
                throw throwable;
            }
        }
        JDBCBlobFile.closeSafely(is);
        return l;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        if (start < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + start);
        }
        if (pattern == null) {
            return -1L;
        }
        long patternLength = pattern.length();
        if (patternLength == 0L) {
            return -1L;
        }
        if (patternLength > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("pattern.length(): " + patternLength);
        }
        long length = this.length();
        if (start > length || patternLength > length || start > length - patternLength) {
            return -1L;
        }
        byte[] bytePattern = pattern instanceof JDBCBlob ? ((JDBCBlob)pattern).data() : pattern.getBytes(1L, (int)patternLength);
        return this.position0(bytePattern, start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes == null ? 0 : bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (bytes == null) {
            throw JDBCUtil.nullArgument("bytes");
        }
        OutputStream os = this.setBinaryStream(pos);
        try {
            os.write(bytes, offset, len);
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        finally {
            JDBCBlobFile.closeSafely(os);
        }
        return len;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        OutputStreamAdapter adapter;
        if (pos < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + pos);
        }
        this.checkClosed();
        this.createFile();
        try {
            adapter = new OutputStreamAdapter(this.m_file, pos - 1L){
                private boolean closed;

                @Override
                public synchronized void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (SecurityException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        this.m_streams.add(adapter);
        BufferedOutputStream result = new BufferedOutputStream(adapter);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void truncate(long len) throws SQLException {
        if (len < 0L) {
            throw JDBCUtil.invalidArgument("len: " + len);
        }
        this.checkClosed();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(len);
        }
        catch (IOException ex) {
            try {
                throw JDBCUtil.sqlException(ex);
                catch (IllegalArgumentException ex2) {
                    throw JDBCUtil.sqlException(ex2);
                }
                catch (SecurityException ex3) {
                    throw JDBCUtil.sqlException(ex3);
                }
            }
            catch (Throwable throwable) {
                JDBCBlobFile.closeSafely(randomAccessFile);
                throw throwable;
            }
        }
        JDBCBlobFile.closeSafely(randomAccessFile);
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        ArrayList<Object> streams = new ArrayList<Object>(this.m_streams);
        this.m_streams = null;
        for (Object e : streams) {
            this.closeSafely(e);
        }
        if (this.m_deleteOnFree) {
            try {
                this.m_file.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        InputStreamAdapter result;
        if (pos < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        this.checkClosed();
        try {
            result = new InputStreamAdapter(this.m_file, pos - 1L, length){
                private boolean closed;

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception ex) {
            throw JDBCUtil.sqlException(ex);
        }
        this.m_streams.add(result);
        return result;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isDeleteOnFree() {
        return this.m_deleteOnFree;
    }

    public void setDeleteOnFree(boolean deleteOnFree) {
        this.m_deleteOnFree = deleteOnFree;
    }

    protected final void checkIsFile(boolean checkExists) throws SQLException {
        boolean exists = false;
        boolean isFile = false;
        try {
            exists = this.m_file.exists();
        }
        catch (Exception ex) {
            throw JDBCUtil.sqlException(ex);
        }
        if (exists) {
            try {
                isFile = this.m_file.isFile();
            }
            catch (Exception ex) {
                throw JDBCUtil.sqlException(ex);
            }
        }
        if (exists) {
            if (!isFile) {
                throw JDBCUtil.invalidArgument("Is not a file: " + this.m_file);
            }
        } else if (checkExists) {
            throw JDBCUtil.invalidArgument("Does not exist: " + this.m_file);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    private void createFile() throws SQLException {
        try {
            if (!this.m_file.exists()) {
                FileUtil.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        this.checkIsFile(true);
    }

    private void closeSafely(Object target) {
        if (target instanceof RandomAccessFile) {
            JDBCBlobFile.closeSafely((RandomAccessFile)target);
        } else if (target instanceof InputStream) {
            JDBCBlobFile.closeSafely((InputStream)target);
        } else if (target instanceof OutputStream) {
            JDBCBlobFile.closeSafely((OutputStream)target);
        } else if (target instanceof Reader) {
            JDBCBlobFile.closeSafely((Reader)target);
        } else if (target instanceof Writer) {
            JDBCBlobFile.closeSafely((Writer)target);
        }
    }

    static class InputStreamAdapter
    extends InputStream {
        private final CountdownInputStream m_ciStream;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InputStreamAdapter(File file, long pos, long length) throws FileNotFoundException, IOException, SecurityException, NullPointerException, IllegalArgumentException {
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (pos < 0L) {
                throw new IllegalArgumentException("pos: " + pos);
            }
            if (length < 0L) {
                throw new IllegalArgumentException("length: " + length);
            }
            FileInputStream fis = null;
            boolean success = false;
            try {
                fis = new FileInputStream(file);
                if (pos > 0L) {
                    long l = fis.skip(pos);
                }
                success = true;
            }
            finally {
                if (!success) {
                    JDBCBlobFile.closeSafely(fis);
                }
            }
            BufferedInputStream bis = new BufferedInputStream(fis);
            CountdownInputStream cis = new CountdownInputStream(bis);
            cis.setCount(length);
            this.m_ciStream = cis;
        }

        @Override
        public int available() throws IOException {
            return this.m_ciStream.available();
        }

        @Override
        public int read() throws IOException {
            return this.m_ciStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.m_ciStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.m_ciStream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.m_ciStream.skip(n);
        }

        @Override
        public void close() throws IOException {
            this.m_ciStream.close();
        }
    }

    protected static class OutputStreamAdapter
    extends OutputStream {
        private final RandomAccessFile m_randomAccessFile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected OutputStreamAdapter(File file, long pos) throws FileNotFoundException, IOException, IllegalArgumentException, NullPointerException, SecurityException {
            if (pos < 0L) {
                throw new IllegalArgumentException("pos: " + pos);
            }
            this.m_randomAccessFile = new RandomAccessFile(file, "rw");
            boolean seekSucceeded = false;
            try {
                this.m_randomAccessFile.seek(pos);
                seekSucceeded = true;
            }
            finally {
                if (!seekSucceeded) {
                    JDBCBlobFile.closeSafely(this.m_randomAccessFile);
                }
            }
        }

        protected OutputStreamAdapter(RandomAccessFile randomAccessFile) {
            if (randomAccessFile == null) {
                throw new NullPointerException();
            }
            this.m_randomAccessFile = randomAccessFile;
        }

        @Override
        public void write(int b) throws IOException {
            this.m_randomAccessFile.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.m_randomAccessFile.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.m_randomAccessFile.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            if (this.m_randomAccessFile.getFD().valid()) {
                this.m_randomAccessFile.getFD().sync();
            }
        }

        @Override
        public void close() throws IOException {
            this.m_randomAccessFile.close();
        }
    }
}

