/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastload;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.GenericLogoffController;
import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.fastload.FastLoadPreparedStatement;
import com.teradata.jdbc.jdbc.fastload.FastLoadSQLOutput;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class FastLoadConnection
extends GenericTeradataConnection {
    private boolean autoCommit = true;

    public FastLoadConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        super(string, string2, string3, uRLParameters);
        try {
            GenericLogonController genericLogonController = new GenericLogonController(this);
            genericLogonController.run();
        }
        catch (SQLException sQLException) {
            if (this.io != null) {
                this.io.close();
            }
            throw sQLException;
        }
    }

    public boolean isLargeDecimalAndBigIntSupported() {
        return this.configRsp.isLargeDecimalAndBigIntSupported();
    }

    public byte getMaxDecimalPrecision() {
        if (this.configRsp.isLargeDecimalAndBigIntSupported()) {
            return 38;
        }
        return 18;
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            GenericLogoffController genericLogoffController = new GenericLogoffController(this);
            genericLogoffController.run();
            this.io.close();
        }
    }

    public void commit() throws SQLException {
        this.abortIfClosed();
    }

    public Statement createStatement() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean getAutoCommit() throws SQLException {
        this.abortIfClosed();
        return this.autoCommit;
    }

    public String getCatalog() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public int getHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getTransactionIsolation() throws SQLException {
        this.abortIfClosed();
        return 8;
    }

    public Map getTypeMap() throws SQLException {
        this.abortIfClosed();
        return new HashMap();
    }

    public boolean isReadOnly() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public String nativeSQL(String string) throws SQLException {
        this.abortIfClosed();
        return EscapeUtil.nativeSQL(string, this.getLocalEscapeFunctions());
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.abortIfClosed();
        return this.constructPreparedStatement();
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
    }

    public void rollback() throws SQLException {
        this.abortIfClosed();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.abortIfClosed();
        this.autoCommit = bl;
    }

    public void setCatalog(String string) throws SQLException {
        this.abortIfClosed();
    }

    public void setHoldability(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    public Savepoint setSavepoint() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.abortIfClosed();
    }

    protected abstract PreparedStatement constructPreparedStatement() throws SQLException;

    protected abstract FastLoadSQLOutput constructSQLOutput(FastLoadPreparedStatement var1, ArrayList var2, int var3, String var4, String var5) throws SQLException;

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Blob createBlob() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Clob createClob() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Properties getClientInfo() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public String getClientInfo(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getClientInfo(String)");
    }

    public boolean isValid(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }
}

