/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.rowio;

import com.datapps.linkoopdb.jdbc.Row;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.lib.StringConverter;
import com.datapps.linkoopdb.jdbc.rowio.RowOutputBase;
import com.datapps.linkoopdb.jdbc.rowio.RowOutputInterface;
import com.datapps.linkoopdb.jdbc.types.BinaryData;
import com.datapps.linkoopdb.jdbc.types.BlobData;
import com.datapps.linkoopdb.jdbc.types.ClobData;
import com.datapps.linkoopdb.jdbc.types.IntervalMonthData;
import com.datapps.linkoopdb.jdbc.types.IntervalSecondData;
import com.datapps.linkoopdb.jdbc.types.JavaObjectData;
import com.datapps.linkoopdb.jdbc.types.LobLocation;
import com.datapps.linkoopdb.jdbc.types.StructureType;
import com.datapps.linkoopdb.jdbc.types.TimeData;
import com.datapps.linkoopdb.jdbc.types.TimestampData;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

public class RowOutputBinary
extends RowOutputBase {
    public static final int INT_STORE_SIZE = 4;
    protected final int scale;
    final int mask;
    int storageSize;
    int sizePosition;

    public RowOutputBinary() {
        this(new byte[64]);
    }

    public RowOutputBinary(int initialSize, int scale) {
        super(initialSize);
        this.scale = scale;
        this.mask = ~(scale - 1);
        this.sizePosition = -1;
    }

    public RowOutputBinary(byte[] buffer) {
        super(buffer);
        this.scale = 1;
        this.mask = ~(this.scale - 1);
        this.sizePosition = -1;
    }

    public void writeIntData(int i, int position) {
        int temp = this.count;
        this.count = position;
        this.writeInt(i);
        if (this.count < temp) {
            this.count = temp;
        }
    }

    @Override
    public void writeData(Row row, Type[] types) {
        super.writeData(row, types);
    }

    @Override
    public long scalePosition(long position) {
        return position + (long)this.scale - 1L & (long)this.mask;
    }

    @Override
    public void setStorageSize(int size) {
        this.storageSize = size;
    }

    @Override
    public void writeEnd() {
        if (this.count > this.storageSize) {
            throw Error.runtimeError(201, "RowOutputBinary");
        }
        while (this.count < this.storageSize) {
            this.write(0);
        }
    }

    @Override
    public void writeSize(int size) {
        if (this.sizePosition < 0) {
            this.sizePosition = this.count;
            this.writeInt(size);
        } else {
            this.writeIntData(size, this.sizePosition);
        }
        this.storageSize = size;
    }

    @Override
    public void writeType(int type) {
        this.writeShort(type);
    }

    @Override
    public void writeString(String s) {
        int temp = this.count;
        this.writeInt(0);
        if (s != null && s.length() != 0) {
            StringConverter.stringToUTFBytes(s, this);
            this.writeIntData(this.count - temp - 4, temp);
        }
    }

    @Override
    public int getSize(Row row) {
        Object[] data = row.getData();
        Type[] types = row.getTable().getColumnTypes();
        int cols = row.getTable().getDataColumnCount();
        return 4 + this.getSize(data, cols, types);
    }

    @Override
    public int getStorageSize(int size) {
        return size + this.scale - 1 & this.mask;
    }

    @Override
    public void writeFieldType(Type type) {
        this.write(1);
    }

    @Override
    public void writeNull(Type type) {
        this.write(0);
    }

    @Override
    protected void writeChar(String s, Type t) {
        this.writeString(s);
    }

    @Override
    protected void writeSmallint(Number o) {
        this.writeShort(o.intValue());
    }

    @Override
    protected void writeInteger(Number o) {
        this.writeInt(o.intValue());
    }

    @Override
    protected void writeBigint(Number o) {
        this.writeLong(o.longValue());
    }

    @Override
    protected void writeReal(Double o) {
        this.writeLong(Double.doubleToLongBits(o));
    }

    @Override
    protected void writeFloat(Float f) {
        this.writeInt(Float.floatToIntBits(f.floatValue()));
    }

    @Override
    protected void writeDecimal(BigDecimal o, Type type) {
        int scale = o.scale();
        BigInteger bigint = o.unscaledValue();
        byte[] bytearr = bigint.toByteArray();
        this.writeByteArray(bytearr);
        this.writeInt(scale);
    }

    @Override
    protected void writeBoolean(Boolean o) {
        this.write(o != false ? 1 : 0);
    }

    @Override
    protected void writeDate(TimestampData o, Type type) {
        this.writeLong(o.getSeconds());
    }

    @Override
    protected void writeTime(TimeData o, Type type) {
        this.writeInt(o.getSeconds());
        this.writeInt(o.getNanos());
        if (type.typeCode == 94) {
            this.writeInt(o.getZone());
        }
    }

    @Override
    protected void writeTimestamp(TimestampData o, Type type) {
        this.writeLong(o.getSeconds());
        this.writeInt(o.getNanos());
        if (type.typeCode == 95) {
            this.writeInt(o.getZone());
        }
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData o, Type type) {
        this.writeLong(o.units);
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData o, Type type) {
        this.writeLong(o.getSeconds());
        this.writeInt(o.getNanos());
    }

    @Override
    protected void writeOther(JavaObjectData o) {
        this.writeByteArray(o.getBytes());
    }

    @Override
    protected void writeBit(BinaryData o) {
        this.writeInt((int)o.bitLength(null));
        this.write(o.getBytes(), 0, o.getBytes().length);
    }

    @Override
    protected void writeUUID(BinaryData o) {
        this.writeByteArray(o.getBytes());
    }

    @Override
    protected void writeBinary(BinaryData o) {
        this.writeByteArray(o.getBytes());
    }

    @Override
    protected void writeClob(ClobData o, Type type) {
        LobLocation lobLocation = o.getLobLocation();
        if (lobLocation == null) {
            this.writeLong(o.getId());
        } else {
            this.writeLong(0L);
            this.writeByteArray(lobLocation.serialize());
        }
    }

    @Override
    protected void writeBlob(BlobData o, Type type) {
        LobLocation lobLocation = o.getLobLocation();
        if (lobLocation == null) {
            this.writeLong(o.getId());
        } else {
            this.writeLong(0L);
            this.writeByteArray(lobLocation.serialize());
        }
    }

    @Override
    protected void writeArray(Object[] o, Type type) {
        type = type.collectionBaseType();
        this.writeInt(o.length);
        for (int i = 0; i < o.length; ++i) {
            this.writeData(o[i], type);
        }
    }

    @Override
    protected void writeStruct(Object[] o, Type type) {
        StructureType structureType = (StructureType)type;
        for (int i = 0; i < o.length; ++i) {
            this.writeData(o[i], structureType.colTypes[i]);
        }
    }

    public void writeArray(int[] o) {
        this.writeInt(o.length);
        for (int i = 0; i < o.length; ++i) {
            this.write(1);
            this.writeInt(o[i]);
        }
    }

    public void writeByteArray(byte[] b) {
        this.writeInt(b.length);
        this.write(b, 0, b.length);
    }

    public void writeByteArray16(byte[] b) {
        this.write(b, 0, 16);
    }

    public void writeCharArray(char[] c) {
        this.writeInt(c.length);
        this.write(c, 0, c.length);
    }

    public int getSize(int[] array) {
        return 4 + array.length * 5;
    }

    public int getSize(Object[] data, int l, Type[] types) {
        int s = 0;
        for (int i = 0; i < l; ++i) {
            Object o = data[i];
            s += this.getSize(o, types[i]);
        }
        return s;
    }

    private int getSize(Object o, Type type) {
        int s = 1;
        if (o == null) {
            return s;
        }
        switch (type.typeCode) {
            case 0: {
                break;
            }
            case 1: 
            case 12: {
                s += 4;
                s += StringConverter.getUTFSize((String)o);
                break;
            }
            case -6: 
            case 5: {
                s += 2;
                break;
            }
            case 4: {
                s += 4;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                s += 8;
                break;
            }
            case 2: 
            case 3: {
                s += 8;
                BigDecimal bigdecimal = (BigDecimal)o;
                BigInteger bigint = bigdecimal.unscaledValue();
                s += bigint.toByteArray().length;
                break;
            }
            case 16: {
                ++s;
                break;
            }
            case 91: {
                s += 8;
                break;
            }
            case 92: {
                s += 8;
                break;
            }
            case 94: {
                s += 12;
                break;
            }
            case 93: {
                s += 12;
                break;
            }
            case 95: {
                s += 16;
                break;
            }
            case 101: 
            case 102: 
            case 107: {
                s += 8;
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                s += 12;
                break;
            }
            case -11: 
            case 60: 
            case 61: {
                s += 4;
                s = (int)((long)s + ((BinaryData)o).length(null));
                break;
            }
            case 14: 
            case 15: {
                s += 4;
                s = (int)((long)s + ((BinaryData)o).length(null));
                break;
            }
            case 30: 
            case 40: {
                s += 8;
                break;
            }
            case 50: {
                s += 4;
                Object[] array = (Object[])o;
                type = type.collectionBaseType();
                for (int i = 0; i < array.length; ++i) {
                    s += this.getSize(array[i], type);
                }
                break;
            }
            case 1111: {
                JavaObjectData jo = (JavaObjectData)o;
                s += 4;
                s += jo.getBytesLength();
                break;
            }
            default: {
                throw Error.runtimeError(201, "RowOutputBinary");
            }
        }
        return s;
    }

    @Override
    public void ensureRoom(int extra) {
        super.ensureRoom(extra);
    }

    @Override
    public void reset() {
        super.reset();
        this.storageSize = 0;
        this.sizePosition = -1;
    }

    @Override
    public void reset(int newSize) {
        super.reset(newSize);
        this.storageSize = 0;
        this.sizePosition = -1;
    }

    @Override
    public void reset(byte[] buffer) {
        super.reset(buffer);
        this.storageSize = 0;
        this.sizePosition = -1;
    }

    @Override
    public RowOutputInterface duplicate() {
        return new RowOutputBinary(128, this.scale);
    }
}

