# coding: utf-8

"""
    Selling Partner API for Feeds

    The Selling Partner API for Feeds lets you upload data to Amazon on behalf of a selling partner.  # noqa: E501

    OpenAPI spec version: 2020-09-04
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class Feed(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'feed_id': 'str',
        'feed_type': 'str',
        'marketplace_ids': 'list[str]',
        'created_time': 'datetime',
        'processing_status': 'str',
        'processing_start_time': 'datetime',
        'processing_end_time': 'datetime',
        'result_feed_document_id': 'str'
    }

    attribute_map = {
        'feed_id': 'feedId',
        'feed_type': 'feedType',
        'marketplace_ids': 'marketplaceIds',
        'created_time': 'createdTime',
        'processing_status': 'processingStatus',
        'processing_start_time': 'processingStartTime',
        'processing_end_time': 'processingEndTime',
        'result_feed_document_id': 'resultFeedDocumentId'
    }

    def __init__(self, feed_id=None, feed_type=None, marketplace_ids=None, created_time=None, processing_status=None, processing_start_time=None, processing_end_time=None, result_feed_document_id=None):  # noqa: E501
        """Feed - a model defined in Swagger"""  # noqa: E501
        self._feed_id = None
        self._feed_type = None
        self._marketplace_ids = None
        self._created_time = None
        self._processing_status = None
        self._processing_start_time = None
        self._processing_end_time = None
        self._result_feed_document_id = None
        self.discriminator = None
        self.feed_id = feed_id
        self.feed_type = feed_type
        if marketplace_ids is not None:
            self.marketplace_ids = marketplace_ids
        self.created_time = created_time
        self.processing_status = processing_status
        if processing_start_time is not None:
            self.processing_start_time = processing_start_time
        if processing_end_time is not None:
            self.processing_end_time = processing_end_time
        if result_feed_document_id is not None:
            self.result_feed_document_id = result_feed_document_id

    @property
    def feed_id(self):
        """Gets the feed_id of this Feed.  # noqa: E501

        The identifier for the feed. This identifier is unique only in combination with a seller ID.  # noqa: E501

        :return: The feed_id of this Feed.  # noqa: E501
        :rtype: str
        """
        return self._feed_id

    @feed_id.setter
    def feed_id(self, feed_id):
        """Sets the feed_id of this Feed.

        The identifier for the feed. This identifier is unique only in combination with a seller ID.  # noqa: E501

        :param feed_id: The feed_id of this Feed.  # noqa: E501
        :type: str
        """
        if feed_id is None:
            raise ValueError("Invalid value for `feed_id`, must not be `None`")  # noqa: E501

        self._feed_id = feed_id

    @property
    def feed_type(self):
        """Gets the feed_type of this Feed.  # noqa: E501

        The feed type.  # noqa: E501

        :return: The feed_type of this Feed.  # noqa: E501
        :rtype: str
        """
        return self._feed_type

    @feed_type.setter
    def feed_type(self, feed_type):
        """Sets the feed_type of this Feed.

        The feed type.  # noqa: E501

        :param feed_type: The feed_type of this Feed.  # noqa: E501
        :type: str
        """
        if feed_type is None:
            raise ValueError("Invalid value for `feed_type`, must not be `None`")  # noqa: E501

        self._feed_type = feed_type

    @property
    def marketplace_ids(self):
        """Gets the marketplace_ids of this Feed.  # noqa: E501

        A list of identifiers for the marketplaces that the feed is applied to.  # noqa: E501

        :return: The marketplace_ids of this Feed.  # noqa: E501
        :rtype: list[str]
        """
        return self._marketplace_ids

    @marketplace_ids.setter
    def marketplace_ids(self, marketplace_ids):
        """Sets the marketplace_ids of this Feed.

        A list of identifiers for the marketplaces that the feed is applied to.  # noqa: E501

        :param marketplace_ids: The marketplace_ids of this Feed.  # noqa: E501
        :type: list[str]
        """

        self._marketplace_ids = marketplace_ids

    @property
    def created_time(self):
        """Gets the created_time of this Feed.  # noqa: E501

        The date and time when the feed was created, in ISO 8601 date time format.  # noqa: E501

        :return: The created_time of this Feed.  # noqa: E501
        :rtype: datetime
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """Sets the created_time of this Feed.

        The date and time when the feed was created, in ISO 8601 date time format.  # noqa: E501

        :param created_time: The created_time of this Feed.  # noqa: E501
        :type: datetime
        """
        if created_time is None:
            raise ValueError("Invalid value for `created_time`, must not be `None`")  # noqa: E501

        self._created_time = created_time

    @property
    def processing_status(self):
        """Gets the processing_status of this Feed.  # noqa: E501

        The processing status of the feed.  # noqa: E501

        :return: The processing_status of this Feed.  # noqa: E501
        :rtype: str
        """
        return self._processing_status

    @processing_status.setter
    def processing_status(self, processing_status):
        """Sets the processing_status of this Feed.

        The processing status of the feed.  # noqa: E501

        :param processing_status: The processing_status of this Feed.  # noqa: E501
        :type: str
        """
        if processing_status is None:
            raise ValueError("Invalid value for `processing_status`, must not be `None`")  # noqa: E501
        allowed_values = ["CANCELLED", "DONE", "FATAL", "IN_PROGRESS", "IN_QUEUE"]  # noqa: E501
        if processing_status not in allowed_values:
            raise ValueError(
                "Invalid value for `processing_status` ({0}), must be one of {1}"  # noqa: E501
                .format(processing_status, allowed_values)
            )

        self._processing_status = processing_status

    @property
    def processing_start_time(self):
        """Gets the processing_start_time of this Feed.  # noqa: E501

        The date and time when feed processing started, in ISO 8601 date time format.  # noqa: E501

        :return: The processing_start_time of this Feed.  # noqa: E501
        :rtype: datetime
        """
        return self._processing_start_time

    @processing_start_time.setter
    def processing_start_time(self, processing_start_time):
        """Sets the processing_start_time of this Feed.

        The date and time when feed processing started, in ISO 8601 date time format.  # noqa: E501

        :param processing_start_time: The processing_start_time of this Feed.  # noqa: E501
        :type: datetime
        """

        self._processing_start_time = processing_start_time

    @property
    def processing_end_time(self):
        """Gets the processing_end_time of this Feed.  # noqa: E501

        The date and time when feed processing completed, in ISO 8601 date time format.  # noqa: E501

        :return: The processing_end_time of this Feed.  # noqa: E501
        :rtype: datetime
        """
        return self._processing_end_time

    @processing_end_time.setter
    def processing_end_time(self, processing_end_time):
        """Sets the processing_end_time of this Feed.

        The date and time when feed processing completed, in ISO 8601 date time format.  # noqa: E501

        :param processing_end_time: The processing_end_time of this Feed.  # noqa: E501
        :type: datetime
        """

        self._processing_end_time = processing_end_time

    @property
    def result_feed_document_id(self):
        """Gets the result_feed_document_id of this Feed.  # noqa: E501

        The identifier for the feed document. This identifier is unique only in combination with a seller ID.  # noqa: E501

        :return: The result_feed_document_id of this Feed.  # noqa: E501
        :rtype: str
        """
        return self._result_feed_document_id

    @result_feed_document_id.setter
    def result_feed_document_id(self, result_feed_document_id):
        """Sets the result_feed_document_id of this Feed.

        The identifier for the feed document. This identifier is unique only in combination with a seller ID.  # noqa: E501

        :param result_feed_document_id: The result_feed_document_id of this Feed.  # noqa: E501
        :type: str
        """

        self._result_feed_document_id = result_feed_document_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Feed, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Feed):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
