# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient, EventHandlerFn, UnsubscribeFn
from .constants import *
from typing import Optional


class SwitchClient(SensorClient):
    """
    A switch, which keeps its position.
    Implements a client for the `Switch <https://microsoft.github.io/jacdac-docs/services/switch>`_ service.

    """

    def __init__(self, bus: Bus, role: str, *, missing_active_value: bool = None) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_SWITCH, JD_SWITCH_PACK_FORMATS, role)
        self.missing_active_value = missing_active_value

    @property
    def active(self) -> Optional[bool]:
        """
        Indicates whether the switch is currently active (on)., 
        """
        self.refresh_reading()
        return self.register(JD_SWITCH_REG_ACTIVE).bool_value(self.missing_active_value)

    @property
    def variant(self) -> Optional[SwitchVariant]:
        """
        (Optional) Describes the type of switch used., 
        """
        return self.register(JD_SWITCH_REG_VARIANT).value()

    @property
    def auto_off_delay(self) -> Optional[float]:
        """
        (Optional) Specifies the delay without activity to automatically turn off after turning on.
        For example, some light switches in staircases have such a capability., _: s
        """
        return self.register(JD_SWITCH_REG_AUTO_OFF_DELAY).value()

    def on_on(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when switch goes from `off` to `on`.
        """
        return self.on_event(JD_SWITCH_EV_ON, handler)

    def on_off(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when switch goes from `on` to `off`.
        """
        return self.on_event(JD_SWITCH_EV_OFF, handler)

    
