# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class MotorClient(Client):
    """
    A DC motor.
    Implements a client for the `Motor <https://microsoft.github.io/jacdac-docs/services/motor>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_MOTOR, JD_MOTOR_PACK_FORMATS, role)


    @property
    def duty(self) -> Optional[float]:
        """
        PWM duty cycle of the motor. Use negative/positive values to run the motor forwards and backwards.
        Positive is recommended to be clockwise rotation and negative counterclockwise. A duty of ``0`` 
        while ``enabled`` acts as brake., _: /
        """
        return self.register(JD_MOTOR_REG_DUTY).float_value(100)

    @duty.setter
    def duty(self, value: float) -> None:
        self.enabled = True
        self.register(JD_MOTOR_REG_DUTY).set_values(value / 100)


    @property
    def enabled(self) -> Optional[bool]:
        """
        Turn the power to the motor on/off., 
        """
        return self.register(JD_MOTOR_REG_ENABLED).bool_value()

    @enabled.setter
    def enabled(self, value: bool) -> None:
        self.register(JD_MOTOR_REG_ENABLED).set_values(value)


    @property
    def load_torque(self) -> Optional[float]:
        """
        (Optional) Torque required to produce the rated power of an electrical motor at load speed., _: kg/cm
        """
        return self.register(JD_MOTOR_REG_LOAD_TORQUE).value()

    @property
    def load_speed(self) -> Optional[float]:
        """
        (Optional) Revolutions per minute of the motor under full load., _: rpm
        """
        return self.register(JD_MOTOR_REG_LOAD_SPEED).value()

    @property
    def reversible(self) -> Optional[bool]:
        """
        (Optional) Indicates if the motor can run backwards., 
        """
        return self.register(JD_MOTOR_REG_REVERSIBLE).bool_value()

    
