# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.11.1-SNAPSHOT
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProvenanceNodeDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'flow_file_uuid': 'str',
        'parent_uuids': 'list[str]',
        'child_uuids': 'list[str]',
        'cluster_node_identifier': 'str',
        'type': 'str',
        'event_type': 'str',
        'millis': 'int',
        'timestamp': 'str'
    }

    attribute_map = {
        'id': 'id',
        'flow_file_uuid': 'flowFileUuid',
        'parent_uuids': 'parentUuids',
        'child_uuids': 'childUuids',
        'cluster_node_identifier': 'clusterNodeIdentifier',
        'type': 'type',
        'event_type': 'eventType',
        'millis': 'millis',
        'timestamp': 'timestamp'
    }

    def __init__(self, id=None, flow_file_uuid=None, parent_uuids=None, child_uuids=None, cluster_node_identifier=None, type=None, event_type=None, millis=None, timestamp=None):
        """
        ProvenanceNodeDTO - a model defined in Swagger
        """

        self._id = None
        self._flow_file_uuid = None
        self._parent_uuids = None
        self._child_uuids = None
        self._cluster_node_identifier = None
        self._type = None
        self._event_type = None
        self._millis = None
        self._timestamp = None

        if id is not None:
          self.id = id
        if flow_file_uuid is not None:
          self.flow_file_uuid = flow_file_uuid
        if parent_uuids is not None:
          self.parent_uuids = parent_uuids
        if child_uuids is not None:
          self.child_uuids = child_uuids
        if cluster_node_identifier is not None:
          self.cluster_node_identifier = cluster_node_identifier
        if type is not None:
          self.type = type
        if event_type is not None:
          self.event_type = event_type
        if millis is not None:
          self.millis = millis
        if timestamp is not None:
          self.timestamp = timestamp

    @property
    def id(self):
        """
        Gets the id of this ProvenanceNodeDTO.
        The id of the node.

        :return: The id of this ProvenanceNodeDTO.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ProvenanceNodeDTO.
        The id of the node.

        :param id: The id of this ProvenanceNodeDTO.
        :type: str
        """

        self._id = id

    @property
    def flow_file_uuid(self):
        """
        Gets the flow_file_uuid of this ProvenanceNodeDTO.
        The uuid of the flowfile associated with the provenance event.

        :return: The flow_file_uuid of this ProvenanceNodeDTO.
        :rtype: str
        """
        return self._flow_file_uuid

    @flow_file_uuid.setter
    def flow_file_uuid(self, flow_file_uuid):
        """
        Sets the flow_file_uuid of this ProvenanceNodeDTO.
        The uuid of the flowfile associated with the provenance event.

        :param flow_file_uuid: The flow_file_uuid of this ProvenanceNodeDTO.
        :type: str
        """

        self._flow_file_uuid = flow_file_uuid

    @property
    def parent_uuids(self):
        """
        Gets the parent_uuids of this ProvenanceNodeDTO.
        The uuid of the parent flowfiles of the provenance event.

        :return: The parent_uuids of this ProvenanceNodeDTO.
        :rtype: list[str]
        """
        return self._parent_uuids

    @parent_uuids.setter
    def parent_uuids(self, parent_uuids):
        """
        Sets the parent_uuids of this ProvenanceNodeDTO.
        The uuid of the parent flowfiles of the provenance event.

        :param parent_uuids: The parent_uuids of this ProvenanceNodeDTO.
        :type: list[str]
        """

        self._parent_uuids = parent_uuids

    @property
    def child_uuids(self):
        """
        Gets the child_uuids of this ProvenanceNodeDTO.
        The uuid of the childrent flowfiles of the provenance event.

        :return: The child_uuids of this ProvenanceNodeDTO.
        :rtype: list[str]
        """
        return self._child_uuids

    @child_uuids.setter
    def child_uuids(self, child_uuids):
        """
        Sets the child_uuids of this ProvenanceNodeDTO.
        The uuid of the childrent flowfiles of the provenance event.

        :param child_uuids: The child_uuids of this ProvenanceNodeDTO.
        :type: list[str]
        """

        self._child_uuids = child_uuids

    @property
    def cluster_node_identifier(self):
        """
        Gets the cluster_node_identifier of this ProvenanceNodeDTO.
        The identifier of the node that this event/flowfile originated from.

        :return: The cluster_node_identifier of this ProvenanceNodeDTO.
        :rtype: str
        """
        return self._cluster_node_identifier

    @cluster_node_identifier.setter
    def cluster_node_identifier(self, cluster_node_identifier):
        """
        Sets the cluster_node_identifier of this ProvenanceNodeDTO.
        The identifier of the node that this event/flowfile originated from.

        :param cluster_node_identifier: The cluster_node_identifier of this ProvenanceNodeDTO.
        :type: str
        """

        self._cluster_node_identifier = cluster_node_identifier

    @property
    def type(self):
        """
        Gets the type of this ProvenanceNodeDTO.
        The type of the node.

        :return: The type of this ProvenanceNodeDTO.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ProvenanceNodeDTO.
        The type of the node.

        :param type: The type of this ProvenanceNodeDTO.
        :type: str
        """
        allowed_values = ["FLOWFILE", "EVENT"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def event_type(self):
        """
        Gets the event_type of this ProvenanceNodeDTO.
        If the type is EVENT, this is the type of event.

        :return: The event_type of this ProvenanceNodeDTO.
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """
        Sets the event_type of this ProvenanceNodeDTO.
        If the type is EVENT, this is the type of event.

        :param event_type: The event_type of this ProvenanceNodeDTO.
        :type: str
        """

        self._event_type = event_type

    @property
    def millis(self):
        """
        Gets the millis of this ProvenanceNodeDTO.
        The timestamp of the node in milliseconds.

        :return: The millis of this ProvenanceNodeDTO.
        :rtype: int
        """
        return self._millis

    @millis.setter
    def millis(self, millis):
        """
        Sets the millis of this ProvenanceNodeDTO.
        The timestamp of the node in milliseconds.

        :param millis: The millis of this ProvenanceNodeDTO.
        :type: int
        """

        self._millis = millis

    @property
    def timestamp(self):
        """
        Gets the timestamp of this ProvenanceNodeDTO.
        The timestamp of the node formatted.

        :return: The timestamp of this ProvenanceNodeDTO.
        :rtype: str
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this ProvenanceNodeDTO.
        The timestamp of the node formatted.

        :param timestamp: The timestamp of this ProvenanceNodeDTO.
        :type: str
        """

        self._timestamp = timestamp

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProvenanceNodeDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
