"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Artifacts = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Artifacts definition for a CodeBuild Project.
 */
class Artifacts {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codebuild_ArtifactsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Artifacts);
            }
            throw error;
        }
        this.identifier = props.identifier;
    }
    static s3(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codebuild_S3ArtifactsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.s3);
            }
            throw error;
        }
        return new S3Artifacts(props);
    }
    bind(_scope, _project) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codebuild_IProject(_project);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            artifactsProperty: {
                artifactIdentifier: this.identifier,
                type: this.type,
            },
        };
    }
}
exports.Artifacts = Artifacts;
_a = JSII_RTTI_SYMBOL_1;
Artifacts[_a] = { fqn: "@aws-cdk/aws-codebuild.Artifacts", version: "1.195.0" };
/**
 * S3 Artifact definition for a CodeBuild Project.
 */
class S3Artifacts extends Artifacts {
    constructor(props) {
        super(props);
        this.props = props;
        this.type = 'S3';
    }
    bind(_scope, project) {
        this.props.bucket.grantReadWrite(project);
        const superConfig = super.bind(_scope, project);
        return {
            artifactsProperty: {
                ...superConfig.artifactsProperty,
                location: this.props.bucket.bucketName,
                path: this.props.path,
                namespaceType: this.props.includeBuildId === false ? 'NONE' : 'BUILD_ID',
                name: this.props.name == null ? undefined : this.props.name,
                packaging: this.props.packageZip === false ? 'NONE' : 'ZIP',
                encryptionDisabled: this.props.encryption === false ? true : undefined,
                overrideArtifactName: this.props.name == null ? true : undefined,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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