import { CodePipeline } from 'aws-sdk';
export declare const getStageState: (pipelineName: string, stageName: string) => Promise<CodePipeline.StageState | undefined>;
/**
 * Disables stage transitions. Will only disable if stageState.inboundTransitionState.enabled is false.
 * Strips invalid characters from the reason and truncates to 300 characters.
 */
export declare const disableStageTransition: (params: CodePipeline.Types.DisableStageTransitionInput, lastChangedByMustInclude: string, stageState?: CodePipeline.StageState | undefined) => Promise<void>;
/**
 * Enables stage transitions. Will only enable if stageState.inboundTransitionState.enabled is true
 * and if lastChangedBy includes the lastChangedByMustInclude string.
 */
export declare const enableStageTransition: (params: CodePipeline.Types.EnableStageTransitionInput, lastChangedByMustInclude: string, stageState?: CodePipeline.StageState | undefined) => Promise<void>;
