import { PythonProject, PythonProjectOptions } from "projen/lib/python";
/**
 * Configuration for the generated python client project
 */
export interface GeneratedPythonClientProjectOptions extends PythonProjectOptions {
    /**
     * The absolute path to the OpenAPI specification (spec.yaml) from which to generate code
     */
    readonly specPath: string;
    /**
     * Whether or not to generate a lambda layer for this package
     */
    readonly generateLayer?: boolean;
}
/**
 * Python project containing a python client (and lambda handler wrappers) generated using OpenAPI Generator CLI
 */
export declare class GeneratedPythonClientProject extends PythonProject {
    /**
     * The directory in which the built layer is output
     */
    layerDistDir: string;
    private synthed;
    constructor(options: GeneratedPythonClientProjectOptions);
    /**
     * @inheritDoc
     */
    synth(): void;
}
