/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.Constraint;
import com.datapps.linkoopdb.jdbc.Expression;
import com.datapps.linkoopdb.jdbc.LdbSqlNameManager;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.lib.ArrayUtil;
import com.datapps.linkoopdb.jdbc.lib.OrderedHashSet;
import com.datapps.linkoopdb.jdbc.rights.Grantee;
import com.datapps.linkoopdb.jdbc.types.Collation;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.io.Serializable;

public class UserTypeModifier
implements Serializable {
    final LdbSqlNameManager.LdbSqlName name;
    final int schemaObjectType;
    final Type dataType;
    Constraint[] constraints = Constraint.emptyArray;
    Expression defaultExpression;
    boolean isNullable = true;

    public UserTypeModifier(LdbSqlNameManager.LdbSqlName name, int type, Type dataType) {
        this.name = name;
        this.schemaObjectType = type;
        this.dataType = dataType;
    }

    public int schemaObjectType() {
        return this.schemaObjectType;
    }

    public void addConstraint(Constraint c) {
        int position = this.constraints.length;
        this.constraints = (Constraint[])ArrayUtil.resizeArray(this.constraints, position + 1);
        this.constraints[position] = c;
        this.setNotNull();
    }

    public void removeConstraint(String name) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].getName().name.equals(name)) continue;
            this.constraints = (Constraint[])ArrayUtil.toAdjustedArray(this.constraints, null, i, -1);
            break;
        }
        this.setNotNull();
    }

    public Constraint getConstraint(String name) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].getName().name.equals(name)) continue;
            return this.constraints[i];
        }
        return null;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public Expression getDefaultClause() {
        return this.defaultExpression;
    }

    public void setDefaultClause(Expression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public void removeDefaultClause() {
        this.defaultExpression = null;
    }

    private void setNotNull() {
        this.isNullable = true;
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].isNotNull()) continue;
            this.isNullable = false;
        }
    }

    public int getType() {
        return this.schemaObjectType;
    }

    public LdbSqlNameManager.LdbSqlName getName() {
        return this.name;
    }

    public LdbSqlNameManager.LdbSqlName getSchemaName() {
        return this.name.schema;
    }

    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < this.constraints.length; ++i) {
            OrderedHashSet subSet = this.constraints[i].getReferences();
            if (subSet == null) continue;
            set.addAll(subSet);
        }
        return set;
    }

    public final OrderedHashSet getComponents() {
        if (this.constraints == null) {
            return null;
        }
        OrderedHashSet set = new OrderedHashSet();
        set.addAll(this.constraints);
        return set;
    }

    public void compile(SessionInterface session) {
        for (int i = 0; i < this.constraints.length; ++i) {
            this.constraints[i].compile(session, null);
        }
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        if (this.schemaObjectType == 12) {
            Collation collation;
            sb.append("CREATE").append(' ').append("TYPE").append(' ');
            sb.append(this.name.getSchemaQualifiedStatementName());
            sb.append(' ').append("AS").append(' ');
            sb.append(this.dataType.getDefinition());
            if (this.dataType.isCharacterType() && (collation = this.dataType.getCollation()).isObjectCollation()) {
                sb.append(' ').append(collation.getCollateSQL());
            }
        } else {
            sb.append("CREATE").append(' ').append("DOMAIN").append(' ');
            sb.append(this.name.getSchemaQualifiedStatementName());
            sb.append(' ').append("AS").append(' ');
            sb.append(this.dataType.getDefinition());
            if (this.defaultExpression != null) {
                sb.append(' ').append("DEFAULT").append(' ');
                sb.append(this.defaultExpression.getSQL());
            }
            for (int i = 0; i < this.constraints.length; ++i) {
                sb.append(' ').append("CONSTRAINT").append(' ');
                sb.append(this.constraints[i].getName().statementName).append(' ');
                sb.append("CHECK").append('(').append(this.constraints[i].getCheckSQL()).append(')');
            }
        }
        return sb.toString();
    }
}

