/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jalgapi;

import com.teradata.tdgss.jalgapi.IllegalEncodingException;
import java.util.ArrayList;

public class Encoding {
    private static final int CLASS_SHIFT = 6;
    private static final int CLASS_MASK = 3;
    private static final int CONSTRUCTED_BIT = 32;
    private static final int LOW_TAG_NUMBER_MAX = 30;
    private static final int LOW_TAG_NUMBER_MASK = 31;
    private static final int HIGH_TAG_NUMBER_TAG = 31;
    private static final int HIGH_TAG_BITS_PER_OCTET = 7;
    private static final int HIGH_TAG_NUMBER_MASK = 127;
    private static final int HIGH_TAG_NUMBER_CONTINUES_BIT = 128;
    private static final int SHORT_FORM_MAX_LENGTH = 127;
    private static final int SHORT_FORM_MASK = 127;
    private static final int LONG_FORM_BIT = 128;
    private static final int LONG_FORM_MASK = 255;
    private static final int BYTE_SIZE = 8;
    private final byte[] identifierOctets;
    private final byte[] lengthOctets;
    private final byte[] contentOctets;
    private static final String IDENTIFIER_TRUNCATED = "The DER encoding is truncated in the identifier octets.";
    private static final String LENGTH_TRUNCATED = "The DER encoding is truncated in the length octets.";
    private static final String CONTENT_TRUNCATED = "The DER encoding is truncated in the content octets.";

    public Encoding(byte[] byArray, int n) throws IllegalArgumentException, IllegalEncodingException {
        int n2;
        int n3;
        int n4;
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException();
        }
        try {
            n4 = byArray[n] & 0x1F;
            if (n4 != 31) {
                this.identifierOctets = new byte[]{byArray[n]};
            } else {
                n3 = n + 1;
                while ((byArray[n3++] & 0x80) != 0) {
                }
                this.identifierOctets = new byte[n3 - n];
                System.arraycopy(byArray, n, this.identifierOctets, 0, this.identifierOctets.length);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            IllegalEncodingException illegalEncodingException = new IllegalEncodingException(IDENTIFIER_TRUNCATED);
            illegalEncodingException.initCause(arrayIndexOutOfBoundsException);
            throw illegalEncodingException;
        }
        try {
            n3 = this.identifierOctets.length + n;
            n4 = (byArray[n3] & 0x80) != 0 ? 1 : 0;
            n2 = n4 != 0 ? n3 + (byArray[n3] & 0x7F) : n3;
            this.lengthOctets = new byte[n2 - n3 + 1];
            System.arraycopy(byArray, n3, this.lengthOctets, 0, this.lengthOctets.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            IllegalEncodingException illegalEncodingException = new IllegalEncodingException(LENGTH_TRUNCATED);
            illegalEncodingException.initCause(arrayIndexOutOfBoundsException);
            throw illegalEncodingException;
        }
        n3 = n + this.identifierOctets.length;
        try {
            int n5;
            n2 = n3 + this.lengthOctets.length;
            if (n4 != 0) {
                int n6 = n3 + (byArray[n3] & 0x7F);
                n5 = 0;
                for (int i = n3 + 1; i <= n6; ++i) {
                    n5 <<= 8;
                    n5 |= byArray[i] & 0xFF;
                }
            } else {
                n5 = byArray[n3] & 0x7F;
            }
            this.contentOctets = new byte[n5];
            System.arraycopy(byArray, n2, this.contentOctets, 0, this.contentOctets.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalEncodingException(CONTENT_TRUNCATED, arrayIndexOutOfBoundsException);
        }
    }

    public static final Encoding parse(byte[] byArray, int n) throws IllegalArgumentException {
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException();
        }
        return new Encoding(byArray, n);
    }

    public final Encoding[] parse() throws IllegalStateException, IndexOutOfBoundsException, ArrayStoreException {
        Encoding encoding;
        if (!this.isConstructed()) {
            throw new IllegalStateException();
        }
        ArrayList<Encoding> arrayList = new ArrayList<Encoding>();
        int n = 0;
        for (int i = this.contentOctets.length; i > 0; i -= encoding.size()) {
            encoding = Encoding.parse(this.contentOctets, n);
            arrayList.add(encoding);
            n += encoding.size();
        }
        return arrayList.toArray(new Encoding[arrayList.size()]);
    }

    public final int size() {
        return this.identifierOctets.length + this.lengthOctets.length + this.contentOctets.length;
    }

    public final boolean isConstructed() {
        return 0 != (this.identifierOctets[0] & 0x20);
    }

    public final boolean isPrimitive() {
        return !this.isConstructed();
    }

    public final int getTag() {
        int n = this.identifierOctets[0] & 0x1F;
        if (n == 31) {
            n = 0;
            for (int i = 1; i < this.identifierOctets.length; ++i) {
                n <<= 7;
                n |= this.identifierOctets[i] & 0x7F;
            }
        }
        return n;
    }

    public final byte[] getContent() {
        byte[] byArray = new byte[this.contentOctets.length];
        System.arraycopy(this.contentOctets, 0, byArray, 0, this.contentOctets.length);
        return byArray;
    }
}

