/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.statemachine.SendState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class ReceiveElicitDataReceivedSubState
implements TDParcelState {
    private StatementReceiveState compositeState;
    private StatementController controller;
    private SendState sendState;
    protected Log log;

    public ReceiveElicitDataReceivedSubState(StatementReceiveState statementReceiveState, SendState sendState) {
        this.compositeState = statementReceiveState;
        this.controller = statementReceiveState.getController();
        this.sendState = sendState;
        this.log = this.controller.getSession().getLog();
    }

    public TDParcelState action() throws SQLException {
        TDParcelState tDParcelState;
        block10: {
            block9: {
                tDParcelState = null;
                Parcel parcel = this.compositeState.getNextParcel();
                if (parcel == null) break block9;
                this.log.debug("Event flavor: " + parcel.getFlavor());
                this.log.debug("StatementState: " + this.compositeState.getController().getStatement().getState());
                switch (parcel.getFlavor()) {
                    case 9: {
                        FailureParcel failureParcel = (FailureParcel)parcel;
                        this.log.debug("Failure parcel received: " + failureParcel.getMsg());
                        switch (this.compositeState.getController().getStatement().getState()) {
                            case 9: {
                                this.controller.getStatement().setState(11);
                                break block10;
                            }
                            case 10: {
                                this.controller.getStatement().setState(11);
                                this.controller.setStoredException(ErrorFactory.makeDriverJDBCException("TJ057"));
                                break block10;
                            }
                            default: {
                                throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                            }
                        }
                    }
                    case 49: {
                        ErrorParcel errorParcel = (ErrorParcel)parcel;
                        this.log.debug("Error parcel received: " + errorParcel.getMsg());
                        throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                    }
                    case 152: {
                        this.compositeState.setReturnState(this.sendState);
                        break block10;
                    }
                    default: {
                        this.log.error("Parcel state exception: " + parcel.getFlavor());
                        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
                    }
                }
            }
            this.log.error("Parcel state exception: parcel is null");
            throw ErrorFactory.makeIoJDBCException("TJ330", "ReceiveElicitDataReceivedSubState", this.controller.getNetworkIO(), null, this.log);
        }
        return tDParcelState;
    }
}

