/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.error;

import com.datapps.linkoopdb.jdbc.LdbSqlException;
import com.datapps.linkoopdb.jdbc.LdbSqlNameManager;
import com.datapps.linkoopdb.jdbc.error.ErrorCode;
import com.datapps.linkoopdb.jdbc.lib.StringUtil;
import com.datapps.linkoopdb.jdbc.resources.ResourceBundleHandler;
import com.datapps.linkoopdb.jdbc.result.Result;
import java.lang.reflect.Field;

public class Error {
    private static final String defaultMessage = "S1000 General error";
    private static final String errPropsName = "sql-state-messages";
    private static final int bundleHandle = ResourceBundleHandler.getBundleHandle("sql-state-messages", null);
    private static final String MESSAGE_TAG = "$$";
    private static final int SQL_STATE_DIGITS = 5;
    private static final int SQL_CODE_DIGITS = 4;
    private static final int ERROR_CODE_BASE = 11;
    public static boolean TRACE = false;
    public static boolean TRACESYSTEMOUT = false;

    public static RuntimeException runtimeError(int code, String add) {
        LdbSqlException e = Error.error(code, add);
        return new RuntimeException(e.getMessage());
    }

    public static LdbSqlException error(int code, String add) {
        return Error.error(null, code, add);
    }

    public static LdbSqlException error(int code, String add, boolean isPrintStack) {
        return Error.error((Throwable)null, code, add, isPrintStack);
    }

    public static LdbSqlException error(Throwable t, int code, String add, boolean isPrintStack) {
        String s = Error.getMessage(code);
        if (add != null) {
            s = s + ": " + add;
        }
        return new LdbSqlException(t, s.substring(6), s.substring(0, 5), -code, isPrintStack);
    }

    public static LdbSqlException error(Throwable t, int code, String add) {
        return Error.error(t, code, add, true);
    }

    public static LdbSqlException parseError(int code, String add, int lineNumber) {
        String s = Error.getMessage(code);
        if (add != null) {
            s = s + ": " + add;
        }
        if (lineNumber > 1) {
            add = Error.getMessage(24);
            s = s + " :" + add + String.valueOf(lineNumber);
        }
        return new LdbSqlException(null, s.substring(6), s.substring(0, 5), -code);
    }

    public static LdbSqlException error(int code) {
        return Error.error(null, code, 0, null);
    }

    public static LdbSqlException error(int code, Throwable t) {
        String message = Error.getMessage(code, 0, null);
        return new LdbSqlException(t, message.substring(0, 5), -code);
    }

    public static LdbSqlException error(Throwable t, int code, int subCode, Object[] add) {
        String message = Error.getMessage(code, subCode, add);
        int sqlCode = subCode < 11 ? code : subCode;
        return new LdbSqlException(t, message.substring(6), message.substring(0, 5), -sqlCode);
    }

    public static LdbSqlException parseError(int code, int subCode, int lineNumber, Object[] add) {
        String message = Error.getMessage(code, subCode, add);
        if (lineNumber > 1) {
            String sub = Error.getMessage(24);
            message = message + " :" + sub + String.valueOf(lineNumber);
        }
        int sqlCode = subCode < 11 ? code : subCode;
        return new LdbSqlException(null, message.substring(6), message.substring(0, 5), -sqlCode);
    }

    public static LdbSqlException error(int code, int code2) {
        return Error.error(code, Error.getMessage(code2));
    }

    public static LdbSqlException error(String message, String sqlState) {
        int code = Error.getCode(sqlState);
        if (code < 1000) {
            code = 5800;
        }
        if (message == null) {
            message = Error.getMessage(code);
        }
        return new LdbSqlException(null, message, sqlState, code);
    }

    public static LdbSqlException error(LdbSqlNameManager.SimpleName conditionName) {
        return new LdbSqlException(conditionName);
    }

    private static String insertStrings(String message, Object[] add) {
        StringBuffer sb = new StringBuffer(message.length() + 32);
        int lastIndex = 0;
        int escIndex = message.length();
        for (int i = 0; i < add.length && (escIndex = message.indexOf(MESSAGE_TAG, lastIndex)) != -1; ++i) {
            sb.append(message.substring(lastIndex, escIndex));
            sb.append(add[i] == null ? "null exception message" : add[i].toString());
            lastIndex = escIndex + MESSAGE_TAG.length();
        }
        escIndex = message.length();
        sb.append(message.substring(lastIndex, escIndex));
        return sb.toString();
    }

    public static String getMessage(int errorCode) {
        return Error.getMessage(errorCode, 0, null);
    }

    public static String getStateString(int errorCode) {
        return Error.getMessage(errorCode, 0, null).substring(0, 5);
    }

    public static String getMessage(int code, int subCode, Object[] add) {
        String message = Error.getResourceString(code);
        if (subCode != 0) {
            message = message + Error.getResourceString(subCode);
        }
        if (add != null) {
            message = Error.insertStrings(message, add);
        }
        return message;
    }

    private static String getResourceString(int code) {
        String string;
        String key = String.valueOf(code);
        if (key.length() <= 4) {
            key = StringUtil.toZeroPaddedString(code, 4, 4);
        }
        if ((string = ResourceBundleHandler.getString(bundleHandle, key)) == null) {
            string = defaultMessage;
        }
        return string;
    }

    public static LdbSqlException error(Result result) {
        return new LdbSqlException(result);
    }

    public static void printSystemOut(String message) {
        if (TRACESYSTEMOUT) {
            System.out.println(message);
        }
    }

    public static int getCode(String sqlState) {
        try {
            Field[] fields = ErrorCode.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                if (name.length() != 7 || !name.endsWith(sqlState)) continue;
                return fields[i].getInt(ErrorCode.class);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }
}

