/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import com.datapps.linkoopdb.jdbc.HsqlDateTime;
import com.datapps.linkoopdb.jdbc.lib.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class SimpleLog {
    public static final int LOG_NONE = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_NORMAL = 2;
    public static final int LOG_DETAIL = 3;
    public static final int LOG_RESULT = 4;
    public static final String logTypeNameEngine = "ENGINE";
    static final String[] appLogTypeNames = new String[]{"", "ERROR ", "NORMAL", "DETAIL"};
    static final String[] sqlLogTypeNames = new String[]{"", "BASIC ", "NORMAL", "DETAIL", "RESULT"};
    String[] logTypeNames;
    private PrintWriter writer;
    private int level;
    private boolean isSystem;
    private boolean isSQL;
    private String filePath;
    private StringBuffer sb;

    public SimpleLog(String path, int level, boolean isSQL) {
        this.isSystem = path == null;
        this.filePath = path;
        this.isSQL = isSQL;
        this.logTypeNames = isSQL ? sqlLogTypeNames : appLogTypeNames;
        this.sb = new StringBuffer(256);
        this.setLevel(level);
    }

    private void setupWriter() {
        if (this.level == 0) {
            this.close();
            return;
        }
        if (this.writer == null) {
            if (this.isSystem) {
                this.writer = new PrintWriter(System.out);
            } else {
                File file = new File(this.filePath);
                this.setupLog(file);
            }
        }
    }

    private void setupLog(File file) {
        try {
            FileUtil.getFileUtil().makeParentDirectories(file);
            this.writer = new PrintWriter((Writer)new FileWriter(file, true), true);
        }
        catch (Exception e) {
            this.isSystem = true;
            this.writer = new PrintWriter(System.out);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.setupWriter();
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public synchronized void logContext(int atLevel, String message) {
        if (this.level < atLevel) {
            return;
        }
        if (this.writer == null) {
            return;
        }
        this.sb.append(HsqlDateTime.getSystemTimeString()).append(' ');
        if (!this.isSQL) {
            this.sb.append(this.logTypeNames[atLevel]).append(' ');
        }
        this.sb.append(message);
        this.writer.println(this.sb.toString());
        this.sb.setLength(0);
        this.writer.flush();
    }

    public synchronized void logContext(int atLevel, String prefix, String message, String suffix) {
        if (this.level < atLevel) {
            return;
        }
        if (this.writer == null) {
            return;
        }
        this.sb.append(HsqlDateTime.getSystemTimeString()).append(' ');
        if (!this.isSQL) {
            this.sb.append(this.logTypeNames[atLevel]).append(' ');
        }
        this.sb.append(prefix).append(' ');
        this.sb.append(message).append(' ').append(suffix);
        this.writer.println(this.sb.toString());
        this.sb.setLength(0);
        this.writer.flush();
    }

    public synchronized void logContext(Throwable t, String message, int atLevel) {
        if (this.level == 0) {
            return;
        }
        if (this.writer == null) {
            return;
        }
        this.sb.append(HsqlDateTime.getSystemTimeString()).append(' ');
        if (!this.isSQL) {
            this.sb.append(this.logTypeNames[atLevel]).append(' ');
        }
        this.sb.append(message);
        Throwable temp = new Throwable();
        StackTraceElement[] elements = temp.getStackTrace();
        if (elements.length > 1) {
            this.sb.append(' ');
            this.sb.append(elements[1].getClassName()).append('.');
            this.sb.append(elements[1].getMethodName());
        }
        if ((elements = t.getStackTrace()).length > 0) {
            this.sb.append(' ');
            this.sb.append(elements[0].getClassName()).append('.');
            this.sb.append(' ').append(elements[0].getMethodName());
        }
        this.sb.append(' ').append(t.toString());
        this.writer.println(this.sb.toString());
        this.sb.setLength(0);
        this.writer.flush();
    }

    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() {
        if (this.writer != null && !this.isSystem) {
            this.writer.flush();
            this.writer.close();
        }
        this.writer = null;
    }
}

