/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc;

import com.datapps.linkoopdb.jdbc.LdbSqlNameManager;
import com.datapps.linkoopdb.jdbc.SchemaObject;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.TableBase;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.lib.OrderedHashSet;
import com.datapps.linkoopdb.jdbc.map.ValuePool;
import com.datapps.linkoopdb.jdbc.rights.Grantee;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.math.BigDecimal;

public final class NumberSequence
implements SchemaObject {
    public static final NumberSequence[] emptyArray = new NumberSequence[0];
    private LdbSqlNameManager.LdbSqlName name;
    private long currValue;
    private long lastValue;
    private boolean limitReached;
    private long startValue;
    private long minValue;
    private long maxValue;
    private long increment;
    private Type dataType;
    private boolean isCycle;
    private boolean isAlways;
    private boolean restartValueDefault;

    public NumberSequence(LdbSqlNameManager.LdbSqlName name, Type type) {
        this.setDefaults(name, type);
    }

    public NumberSequence(LdbSqlNameManager.LdbSqlName name, long value, long increment, Type type) {
        this(name, type);
        this.setStartValue(value);
        this.setIncrement(increment);
    }

    public static String getRestartSQL(TableBase t) {
        return Type.typeHelper.getRestartSQL(t);
    }

    public void setDefaults(LdbSqlNameManager.LdbSqlName name, Type type) {
        long min;
        long max;
        this.name = name;
        this.dataType = type;
        switch (this.dataType.typeCode) {
            case -6: {
                max = 127L;
                min = -128L;
                break;
            }
            case 5: {
                max = 32767L;
                min = -32768L;
                break;
            }
            case 4: {
                max = Integer.MAX_VALUE;
                min = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                if (type.scale == 0) {
                    max = Long.MAX_VALUE;
                    min = Long.MIN_VALUE;
                    break;
                }
            }
            default: {
                throw Error.error(5563);
            }
        }
        this.minValue = min;
        this.maxValue = max;
        this.increment = 1L;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getName() {
        return this.name;
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(SessionInterface session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(' ');
        sb.append("SEQUENCE").append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName()).append(' ');
        sb.append("AS").append(' ');
        sb.append(this.getDataType().getNameString()).append(' ');
        sb.append("START").append(' ');
        sb.append("WITH").append(' ');
        sb.append(this.startValue);
        if (this.getIncrement() != 1L) {
            sb.append(' ').append("INCREMENT").append(' ');
            sb.append("BY").append(' ');
            sb.append(this.getIncrement());
        }
        if (!this.hasDefaultMinMax()) {
            sb.append(' ').append("MINVALUE").append(' ');
            sb.append(this.getMinValue());
            sb.append(' ').append("MAXVALUE").append(' ');
            sb.append(this.getMaxValue());
        }
        if (this.isCycle()) {
            sb.append(' ').append("CYCLE");
        }
        if (this.name == null) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String getSQLColumnDefinition() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("GENERATED").append(' ');
        if (this.name == null) {
            if (this.isAlways()) {
                sb.append("ALWAYS");
            } else {
                sb.append("BY").append(' ').append("DEFAULT");
            }
            sb.append(' ').append("AS").append(' ').append("IDENTITY").append("(");
            sb.append("START").append(' ');
            sb.append("WITH").append(' ');
            sb.append(this.startValue);
            if (this.getIncrement() != 1L) {
                sb.append(' ').append("INCREMENT").append(' ');
                sb.append("BY").append(' ');
                sb.append(this.getIncrement());
            }
            if (!this.hasDefaultMinMax()) {
                sb.append(' ').append("MINVALUE").append(' ');
                sb.append(this.getMinValue());
                sb.append(' ').append("MAXVALUE").append(' ');
                sb.append(this.getMaxValue());
            }
            if (this.isCycle()) {
                sb.append(' ').append("CYCLE");
            }
            if (this.name == null) {
                sb.append(")");
            }
        } else {
            sb.append("BY").append(' ').append("DEFAULT");
            sb.append(' ').append("AS").append(' ');
            sb.append("SEQUENCE").append(' ');
            sb.append(this.getName().getSchemaQualifiedStatementName());
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getRestartSQL() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("ALTER").append(' ');
        sb.append("SEQUENCE");
        sb.append(' ').append(this.name.getSchemaQualifiedStatementName());
        sb.append(' ').append("RESTART");
        sb.append(' ').append("WITH").append(' ').append(this.peek());
        return sb.toString();
    }

    public Type getDataType() {
        return this.dataType;
    }

    public long getIncrement() {
        return this.increment;
    }

    public synchronized void setIncrement(long value) {
        if (value < -16384L || value > 16383L) {
            throw Error.error(5597);
        }
        this.increment = value;
    }

    public synchronized long getStartValue() {
        return this.startValue;
    }

    synchronized void setStartValue(long value) {
        if (value < this.minValue || value > this.maxValue) {
            throw Error.error(5597);
        }
        this.currValue = this.lastValue = (this.startValue = value);
    }

    public synchronized long getMinValue() {
        return this.minValue;
    }

    synchronized void setMinValue(long value) {
        this.checkInTypeRange(value);
        if (value >= this.maxValue || this.currValue < value) {
            throw Error.error(5597);
        }
        this.minValue = value;
    }

    public synchronized long getMaxValue() {
        return this.maxValue;
    }

    synchronized void setMaxValue(long value) {
        this.checkInTypeRange(value);
        if (value <= this.minValue || this.currValue > value) {
            throw Error.error(5597);
        }
        this.maxValue = value;
    }

    public synchronized boolean isCycle() {
        return this.isCycle;
    }

    public synchronized void setCycle(boolean value) {
        this.isCycle = value;
    }

    public synchronized boolean isAlways() {
        return this.isAlways;
    }

    public synchronized void setAlways(boolean value) {
        this.isAlways = value;
    }

    public synchronized boolean hasDefaultMinMax() {
        long min;
        long max;
        switch (this.dataType.typeCode) {
            case -6: {
                max = 127L;
                min = -128L;
                break;
            }
            case 5: {
                max = 32767L;
                min = -32768L;
                break;
            }
            case 4: {
                max = Integer.MAX_VALUE;
                min = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberSequence");
            }
        }
        return this.minValue == min && this.maxValue == max;
    }

    public synchronized void setDefaultMinValue() {
        this.minValue = this.getDefaultMinOrMax(false);
    }

    public synchronized void setDefaultMaxValue() {
        this.maxValue = this.getDefaultMinOrMax(true);
    }

    public synchronized void setCurrentValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.currValue = this.lastValue = value;
    }

    public synchronized void setStartValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.currValue = this.lastValue = (this.startValue = value);
    }

    public synchronized void setStartValueDefault() {
        this.restartValueDefault = true;
    }

    public synchronized void setMinValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.minValue = value;
    }

    public synchronized void setMaxValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.maxValue = value;
    }

    private long getDefaultMinOrMax(boolean isMax) {
        long min;
        long max;
        switch (this.dataType.typeCode) {
            case -6: {
                max = 127L;
                min = -128L;
                break;
            }
            case 5: {
                max = 32767L;
                min = -32768L;
                break;
            }
            case 4: {
                max = Integer.MAX_VALUE;
                min = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberSequence");
            }
        }
        return isMax ? max : min;
    }

    private void checkInTypeRange(long value) {
        long min;
        long max;
        switch (this.dataType.typeCode) {
            case -6: {
                max = 127L;
                min = -128L;
                break;
            }
            case 5: {
                max = 32767L;
                min = -32768L;
                break;
            }
            case 4: {
                max = Integer.MAX_VALUE;
                min = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberSequence");
            }
        }
        if (value < min || value > max) {
            throw Error.error(5597);
        }
    }

    public synchronized void checkValues() {
        if (this.restartValueDefault) {
            this.currValue = this.lastValue = this.startValue;
            this.restartValueDefault = false;
        }
        if (this.minValue >= this.maxValue || this.startValue < this.minValue || this.startValue > this.maxValue || this.currValue < this.minValue || this.currValue > this.maxValue) {
            throw Error.error(5597);
        }
    }

    public synchronized NumberSequence duplicate() {
        NumberSequence copy = new NumberSequence(this.name, this.dataType);
        copy.startValue = this.startValue;
        copy.currValue = this.currValue;
        copy.lastValue = this.lastValue;
        copy.increment = this.increment;
        copy.minValue = this.minValue;
        copy.maxValue = this.maxValue;
        copy.isCycle = this.isCycle;
        copy.isAlways = this.isAlways;
        return copy;
    }

    public synchronized void reset(NumberSequence other) {
        this.name = other.name;
        this.startValue = other.startValue;
        this.currValue = other.currValue;
        this.lastValue = other.lastValue;
        this.increment = other.increment;
        this.dataType = other.dataType;
        this.minValue = other.minValue;
        this.maxValue = other.maxValue;
        this.isCycle = other.isCycle;
        this.isAlways = other.isAlways;
    }

    public synchronized long userUpdate(long value) {
        if (value == this.currValue) {
            this.currValue += this.increment;
            return value;
        }
        if (this.increment > 0L) {
            if (value > this.currValue) {
                this.currValue += (value - this.currValue + this.increment) / this.increment * this.increment;
            }
        } else if (value < this.currValue) {
            this.currValue += (value - this.currValue + this.increment) / this.increment * this.increment;
        }
        return value;
    }

    public synchronized long systemUpdate(long value) {
        if (value == this.currValue) {
            this.currValue += this.increment;
            return value;
        }
        if (this.increment > 0L) {
            if (value > this.currValue) {
                this.currValue = value + this.increment;
            }
        } else if (value < this.currValue) {
            this.currValue = value + this.increment;
        }
        return value;
    }

    public synchronized Object getValueObject() {
        Number result;
        long value = this.getValue();
        switch (this.dataType.typeCode) {
            default: {
                result = ValuePool.getInt((int)value);
                break;
            }
            case 25: {
                result = ValuePool.getLong(value);
                break;
            }
            case 2: 
            case 3: {
                result = ValuePool.getBigDecimal(new BigDecimal(value));
            }
        }
        return result;
    }

    public synchronized long getValue() {
        long nextValue;
        if (this.limitReached) {
            throw Error.error(3416);
        }
        if (this.increment > 0L) {
            if (this.currValue > this.maxValue - this.increment) {
                if (this.isCycle) {
                    nextValue = this.minValue;
                } else {
                    this.limitReached = true;
                    nextValue = this.minValue;
                }
            } else {
                nextValue = this.currValue + this.increment;
            }
        } else if (this.currValue < this.minValue - this.increment) {
            if (this.isCycle) {
                nextValue = this.maxValue;
            } else {
                this.limitReached = true;
                nextValue = this.minValue;
            }
        } else {
            nextValue = this.currValue + this.increment;
        }
        long result = this.currValue;
        this.currValue = nextValue;
        return result;
    }

    public synchronized void reset() {
        this.lastValue = this.currValue = this.startValue;
    }

    public synchronized long peek() {
        return this.currValue;
    }

    synchronized boolean resetWasUsed() {
        boolean result = this.lastValue != this.currValue;
        this.lastValue = this.currValue;
        return result;
    }

    public synchronized void reset(long value) {
        if (value < this.minValue || value > this.maxValue) {
            throw Error.error(5597);
        }
        this.currValue = this.lastValue = value;
        this.startValue = this.lastValue;
    }
}

