/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.util;

import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class Mutex {
    protected boolean inuse = false;
    private String lockName = "noName";
    private Thread lockOwner;
    protected Log log;
    public static final AcquireCallback IGNORE_INTERRUPT_AND_NO_TIMEOUT = null;

    public Mutex(String string, Log log) {
        this.log = log;
        this.lockName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acquire(AcquireCallback acquireCallback) throws SQLException {
        boolean bl = false;
        try {
            long l;
            long l2 = acquireCallback != null ? (long)acquireCallback.getRemainingTime() : 0L;
            long l3 = l = l2 > 0L ? System.currentTimeMillis() + l2 : Long.MAX_VALUE;
            while (this.inuse) {
                long l4 = l - System.currentTimeMillis();
                if (l4 <= 0L) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Thread " + Thread.currentThread().getName() + " timed out while waiting for lock: " + this.lockName);
                    }
                    throw ErrorFactory.makeDriverJDBCException("TJ159", this.lockName + " after " + l2 + " ms");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Thread " + Thread.currentThread().getName() + " is waiting on lock: " + this.lockName);
                }
                try {
                    this.wait(l4);
                }
                catch (InterruptedException interruptedException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Thread " + Thread.currentThread().getName() + " was interrupted while waiting for lock: " + this.lockName);
                    }
                    if (acquireCallback != null) {
                        throw ErrorAnalyzer.analyzeInterrupt(acquireCallback.getState(), interruptedException);
                    }
                    bl = true;
                }
            }
            this.lockOwner = Thread.currentThread();
            this.inuse = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Thread " + this.lockOwner.getName() + " now owns lock: " + this.lockName);
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void release() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Thread " + Thread.currentThread().getName() + " attempt to unlock " + this.lockName);
            if (this.lockOwner != Thread.currentThread()) {
                this.log.debug("Thread doesn't own lock!!!!");
            }
        }
        if (this.lockOwner == Thread.currentThread()) {
            this.lockOwner = null;
            this.inuse = false;
            this.notify();
        }
    }

    public static interface AcquireCallback {
        public int getRemainingTime();

        public int getState();
    }
}

