# explainaboard-api-client
Backend APIs for ExplainaBoard

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.7
- Package version: 0.1.7
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import explainaboard_api_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import explainaboard_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import explainaboard_api_client
from pprint import pprint
from explainaboard_api_client.api import default_api
from explainaboard_api_client.model.api_error import APIError
from explainaboard_api_client.model.benchmark import Benchmark
from explainaboard_api_client.model.benchmark_config import BenchmarkConfig
from explainaboard_api_client.model.dataset_metadata import DatasetMetadata
from explainaboard_api_client.model.datasets_return import DatasetsReturn
from explainaboard_api_client.model.inline_object import InlineObject
from explainaboard_api_client.model.inline_response200 import InlineResponse200
from explainaboard_api_client.model.system import System
from explainaboard_api_client.model.system_analyses_return import SystemAnalysesReturn
from explainaboard_api_client.model.system_create_props import SystemCreateProps
from explainaboard_api_client.model.system_outputs_return import SystemOutputsReturn
from explainaboard_api_client.model.systems_return import SystemsReturn
from explainaboard_api_client.model.task_category import TaskCategory
from explainaboard_api_client.model.user import User
# Defining the host is optional and defaults to https://explainaboard.inspiredco.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = explainaboard_api_client.Configuration(
    host = "https://explainaboard.inspiredco.ai/api"
)



# Enter a context with an instance of the API client
with explainaboard_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    benchmark_id = "masakhaner" # str | 

    try:
        # Returns benchmark metadata by id
        api_response = api_instance.benchmark_benchmark_id_get(benchmark_id)
        pprint(api_response)
    except explainaboard_api_client.ApiException as e:
        print("Exception when calling DefaultApi->benchmark_benchmark_id_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://explainaboard.inspiredco.ai/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**benchmark_benchmark_id_get**](docs/DefaultApi.md#benchmark_benchmark_id_get) | **GET** /benchmark/{benchmark_id} | Returns benchmark metadata by id
*DefaultApi* | [**benchmarkconfigs_get**](docs/DefaultApi.md#benchmarkconfigs_get) | **GET** /benchmarkconfigs | Returns all benchmark configs
*DefaultApi* | [**datasets_dataset_id_get**](docs/DefaultApi.md#datasets_dataset_id_get) | **GET** /datasets/{dataset_id} | Returns dataset metadata by id
*DefaultApi* | [**datasets_get**](docs/DefaultApi.md#datasets_get) | **GET** /datasets | Returns a list of datasets
*DefaultApi* | [**info_get**](docs/DefaultApi.md#info_get) | **GET** /info | information for environment identifier, backend version, login URL, etc. (not intent for public users)
*DefaultApi* | [**systems_analyses_post**](docs/DefaultApi.md#systems_analyses_post) | **POST** /systems/analyses | Returns analysis result(s) of one or multiple systems
*DefaultApi* | [**systems_get**](docs/DefaultApi.md#systems_get) | **GET** /systems | Returns a list of systems
*DefaultApi* | [**systems_post**](docs/DefaultApi.md#systems_post) | **POST** /systems | Submits a system
*DefaultApi* | [**systems_system_id_delete**](docs/DefaultApi.md#systems_system_id_delete) | **DELETE** /systems/{system_id} | Deletes a system by id
*DefaultApi* | [**systems_system_id_get**](docs/DefaultApi.md#systems_system_id_get) | **GET** /systems/{system_id} | Returns system metadata info by id
*DefaultApi* | [**systems_system_id_outputs_get**](docs/DefaultApi.md#systems_system_id_outputs_get) | **GET** /systems/{system_id}/outputs | Returns a list of outputs of a particular system.
*DefaultApi* | [**tasks_get**](docs/DefaultApi.md#tasks_get) | **GET** /tasks | Returns all task categories and tasks
*DefaultApi* | [**user_get**](docs/DefaultApi.md#user_get) | **GET** /user | get user info


## Documentation For Models

 - [APIError](docs/APIError.md)
 - [AnyType](docs/AnyType.md)
 - [Benchmark](docs/Benchmark.md)
 - [BenchmarkConfig](docs/BenchmarkConfig.md)
 - [BenchmarkDatasetConfig](docs/BenchmarkDatasetConfig.md)
 - [BenchmarkMetric](docs/BenchmarkMetric.md)
 - [BenchmarkOperationConfig](docs/BenchmarkOperationConfig.md)
 - [BenchmarkTableData](docs/BenchmarkTableData.md)
 - [BenchmarkViewConfig](docs/BenchmarkViewConfig.md)
 - [BucketCase](docs/BucketCase.md)
 - [BucketPerformance](docs/BucketPerformance.md)
 - [ClassLabel](docs/ClassLabel.md)
 - [DatasetFeature](docs/DatasetFeature.md)
 - [DatasetMetadata](docs/DatasetMetadata.md)
 - [DatasetsReturn](docs/DatasetsReturn.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [Paper](docs/Paper.md)
 - [Performance](docs/Performance.md)
 - [SingleAnalysisReturn](docs/SingleAnalysisReturn.md)
 - [System](docs/System.md)
 - [SystemAllOf](docs/SystemAllOf.md)
 - [SystemAllOfDataset](docs/SystemAllOfDataset.md)
 - [SystemAnalysesReturn](docs/SystemAnalysesReturn.md)
 - [SystemCreateProps](docs/SystemCreateProps.md)
 - [SystemInfo](docs/SystemInfo.md)
 - [SystemInfoResults](docs/SystemInfoResults.md)
 - [SystemInfoSourceTokenizer](docs/SystemInfoSourceTokenizer.md)
 - [SystemMetadata](docs/SystemMetadata.md)
 - [SystemOutput](docs/SystemOutput.md)
 - [SystemOutputProps](docs/SystemOutputProps.md)
 - [SystemOutputsReturn](docs/SystemOutputsReturn.md)
 - [SystemsAnalysesFeatureToBucketInfo](docs/SystemsAnalysesFeatureToBucketInfo.md)
 - [SystemsReturn](docs/SystemsReturn.md)
 - [Task](docs/Task.md)
 - [TaskCategory](docs/TaskCategory.md)
 - [TaskMetadata](docs/TaskMetadata.md)
 - [TaskSupportedFormats](docs/TaskSupportedFormats.md)
 - [Time](docs/Time.md)
 - [User](docs/User.md)
 - [Value](docs/Value.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: HTTP basic authentication


## BearerAuth

- **Type**: Bearer authentication


## Author

explainaboard@gmail.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in explainaboard_api_client.apis and explainaboard_api_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from explainaboard_api_client.api.default_api import DefaultApi`
- `from explainaboard_api_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import explainaboard_api_client
from explainaboard_api_client.apis import *
from explainaboard_api_client.models import *
```

