/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.AuthMechParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoXParcel;
import com.teradata.jdbc.jdbc_4.parcel.ElicitDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.ElicitDataReceivedParcel;
import com.teradata.jdbc.jdbc_4.parcel.ElicitFileParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndMultiPartRecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndSLOBDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.GtwConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.parcel.MultiPartRecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.NopParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoXParcel;
import com.teradata.jdbc.jdbc_4.parcel.PromptParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetParcel;
import com.teradata.jdbc.jdbc_4.parcel.SLOBDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.SSOAuthResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SSOResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SessionStatusResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.StartSLOBDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementInfoEndParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementStatusParcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.parcel.UnknownParcel;
import com.teradata.jdbc.jdbc_4.parcel.UserNameRespParcel;
import java.sql.SQLException;

public class ParcelFactory {
    protected Log log;
    private GenericTeradataConnection m_con;
    private TDPacket packet;
    private int currentPosition;
    private int m_nReadLimit;
    private TDPacketStream buffer;
    private PrepInfoParcel prepInfo;
    private StatementStatusParcel m_stmtStatusParcel;
    private MultiPartRecordParcel initialMultiPartRecordParcel;

    public ParcelFactory(GenericTeradataConnection genericTeradataConnection) {
        this.m_con = genericTeradataConnection;
        this.log = genericTeradataConnection.getLog();
    }

    public void skipParcel(int n) {
        this.currentPosition += n;
    }

    public int nextParcelPeek() throws SQLException {
        if (this.currentPosition < this.m_nReadLimit) {
            return Parcel.trueFlavor(this.buffer.getShort(this.currentPosition));
        }
        return -1;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public Parcel scanForEndStatementParcel(boolean bl) throws SQLException {
        EndStatementParcel endStatementParcel = null;
        int n = this.currentPosition;
        if (this.packet != null) {
            if (bl) {
                this.clearMultiPartRecordParcel();
            }
            while (n < this.m_nReadLimit) {
                this.buffer.position(n);
                Parcel.ParcelHeader parcelHeader = Parcel.readParcelHeader(this.buffer, this.log);
                if (11 == parcelHeader.flavor) {
                    this.buffer.position(n);
                    endStatementParcel = new EndStatementParcel(this.buffer, this.m_con);
                    if (bl) {
                        this.currentPosition = n + endStatementParcel.getLength();
                        break;
                    }
                    this.buffer.position(this.currentPosition);
                    break;
                }
                n += parcelHeader.length;
            }
        }
        return endStatementParcel;
    }

    public Parcel nextParcel() throws SQLException {
        Parcel parcel = null;
        if (this.packet != null && this.currentPosition < this.m_nReadLimit) {
            short s = Parcel.trueFlavor(this.buffer.getShort(this.currentPosition));
            this.log.debug("ParcelFactory:nextParcel flavor value: " + s);
            switch (s) {
                case 29: {
                    this.log.debug("ParcelFactory: creating a PromptParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new PromptParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 89: {
                    this.log.debug("ParcelFactory: creating a LogonSequenceNumberParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new LogonSequenceNumberParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 101: {
                    this.log.debug("ParcelFactory: creating an AssignRspParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new AssignRspParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 43: {
                    this.log.debug("ParcelFactory: creating an ConfigRspParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ConfigRspParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 8: {
                    this.log.debug("ParcelFactory: creating a SuccessParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    this.m_stmtStatusParcel = new SuccessParcel(this.buffer, this.m_con);
                    parcel = this.m_stmtStatusParcel;
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcel factory success parcel create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 205: {
                    this.log.debug("ParcelFactory: creating a StatementStatusParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    this.m_stmtStatusParcel = new StatementStatusParcel(this.buffer, this.m_con);
                    parcel = this.m_stmtStatusParcel;
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcel factory StatementStatusParcel create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 9: {
                    this.log.debug("ParcelFactory: creating a FailureParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new FailureParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 10: {
                    this.log.debug("ParcelFactory: creating a RecordParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new RecordParcel(this.buffer, this.m_con, this.m_stmtStatusParcel, this.prepInfo != null ? this.prepInfo.getPrepInfoItemIterator() : null);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 11: {
                    this.log.debug("ParcelFactory: creating an EndStatementParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new EndStatementParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 12: {
                    this.log.debug("ParcelFactory: creating an EndRequestParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new EndRequestParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 49: {
                    this.log.debug("ParcelFactory: creating an ErrorParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ErrorParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 192: {
                    this.log.debug("ParcelFactory: creating a StatementErrorParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new StatementErrorParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 164: {
                    this.log.debug("ParcelFactory: creating an ErrorInfoParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ErrorInfoParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 71: {
                    this.log.debug("ParcelFactory: creating a DataInfoParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new DataInfoParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcel factory datainfo create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 86: {
                    this.log.debug("ParcelFactory: creating a PrepInfoParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new PrepInfoParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    this.prepInfo = (PrepInfoParcel)parcel;
                    this.log.debug("parcelfactory prepinfo create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 134: {
                    this.log.debug("ParcelFactory: creating an SSORespParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new SSOResponseParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory SSOResp create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 125: {
                    this.log.debug("ParcelFactory: creating a PrepInfoXParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new PrepInfoXParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    this.prepInfo = (PrepInfoXParcel)parcel;
                    this.log.debug("parcelfactory prepinfox create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 146: {
                    this.log.debug("ParcelFactory: creating a DataInfoX");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new DataInfoXParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory datainfox create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 144: {
                    this.log.debug("ParcelFactory: creating a MultipartRecordParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new MultiPartRecordParcel(this.buffer, this.m_con, this.prepInfo != null ? this.prepInfo.getPrepInfoItemIterator() : null);
                    this.initialMultiPartRecordParcel = (MultiPartRecordParcel)parcel;
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 145: {
                    this.log.debug("ParcelFactory: creating an EndMultiPartRecordParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new EndMultiPartRecordParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    this.clearMultiPartRecordParcel();
                    break;
                }
                case 32: {
                    this.log.debug("ParcelFactory: creating a NOPParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new NopParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 150: {
                    this.log.debug("ParcelFactory: creating a ElicitDataParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ElicitDataParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 152: {
                    this.log.debug("ParcelFactory: creating a ElicitDataReceivedParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ElicitDataReceivedParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 151: {
                    this.log.debug("ParcelFactory: creating an ELicitFileParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new ElicitFileParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory ElicitFile create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 165: {
                    this.log.debug("ParcelFactory: creating a GtwConfigParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new GtwConfigParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory GtwConfig create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 167: {
                    this.log.debug("ParcelFactory: creating an AuthMechParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new AuthMechParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory AuthMech create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 131: {
                    this.log.debug("ParcelFactory: creating an SSOAuthRespParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new SSOAuthResponseParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory SSOAuthResp create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 169: {
                    this.log.debug("ParcelFactory: creating a StatementInfoParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new StatementInfoParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory StatementInfoParcel create time: " + (System.currentTimeMillis() - l));
                    if (this.prepInfo != null && !((StatementInfoParcel)parcel).containsFullContentMetadata()) {
                        this.prepInfo.updateItems(((StatementInfoParcel)parcel).items);
                        break;
                    }
                    this.prepInfo = (StatementInfoParcel)parcel;
                    break;
                }
                case 170: {
                    this.log.debug("ParcelFactory: creating an StatementInfoEndParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new StatementInfoEndParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 172: {
                    this.log.debug("ParcelFactory: creating a ResultSetParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ResultSetParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 137: {
                    this.log.debug("ParcelFactory: creating a UserNameRespParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new UserNameRespParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 195: {
                    this.log.debug("ParcelFactory: creating a SessionStatusResponseParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new SessionStatusResponseParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 220: {
                    this.log.debug("ParcelFactory: creating a StartSLOBDataParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new StartSLOBDataParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 221: {
                    this.log.debug("ParcelFactory: creating a SLOBDataParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new SLOBDataParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 222: {
                    this.log.debug("ParcelFactory: creating a EndSLOBDataParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new EndSLOBDataParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                default: {
                    this.log.debug("ParcelFactory unknown parcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new UnknownParcel(this.buffer, this.m_con);
                    this.currentPosition += parcel.getLength();
                }
            }
            return parcel;
        }
        return null;
    }

    public void setTDPacket(TDPacket tDPacket) {
        this.packet = tDPacket;
        this.buffer = tDPacket.getBuffer();
        this.currentPosition = this.buffer.position();
        this.prepInfo = null;
        this.m_nReadLimit = this.buffer.limit() - tDPacket.getControlDataLength();
    }

    public PrepInfoParcel getPrepInfo() {
        return this.prepInfo;
    }

    public void setPrepInfo(PrepInfoParcel prepInfoParcel) {
        this.prepInfo = prepInfoParcel;
    }

    public void clearMultiPartRecordParcel() {
        this.initialMultiPartRecordParcel = null;
    }
}

