/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc;

import com.datapps.linkoopdb.jdbc.SqlInvariants;
import com.datapps.linkoopdb.jdbc.Tokens;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.lib.StringConverter;
import com.datapps.linkoopdb.jdbc.lib.StringUtil;
import com.datapps.linkoopdb.jdbc.rights.Grantee;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public final class LdbSqlNameManager
implements Serializable {
    public static final LdbSqlNameManager staticManager = new LdbSqlNameManager();
    private static final LdbSqlName[] autoColumnNames = new LdbSqlName[32];
    private static final String[] autoNoNameColumnNames = new String[32];
    public LdbSqlName subqueryTableName;
    private AtomicLong serialNumber = new AtomicLong(1L);
    private AtomicLong sysNumber = new AtomicLong(10000L);
    private LdbSqlName catalogName;
    private boolean sqlRegularNames;

    public LdbSqlNameManager() {
        this.sqlRegularNames = true;
    }

    public LdbSqlNameManager(boolean sqlRegularNames) {
        this.catalogName = new LdbSqlName(this, "PUBLIC", 1, false);
        this.sqlRegularNames = sqlRegularNames;
        this.subqueryTableName = new LdbSqlName(this, "SYSTEM_SUBQUERY", false, 3);
        this.subqueryTableName.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
    }

    public void setDefaultSysNumber(long number) {
        this.serialNumber.set(number);
        this.sysNumber.set(number);
    }

    public static LdbSqlName newSystemObjectName(String name, int type) {
        LdbSqlName ldbSqlName = new LdbSqlName(staticManager, name, type, false);
        ldbSqlName.setUuid(name);
        return ldbSqlName;
    }

    public static LdbSqlName newAnonymousStructuredTypeName() {
        LdbSqlName ldbSqlName = new LdbSqlName(staticManager, "_", 12, false);
        ldbSqlName.schema = SqlInvariants.MODULE_HSQLNAME;
        return ldbSqlName;
    }

    public static LdbSqlName newStructuredTypeFieldName(String name) {
        LdbSqlName ldbSqlName = new LdbSqlName(staticManager, name, 9, false);
        ldbSqlName.schema = SqlInvariants.MODULE_HSQLNAME;
        return ldbSqlName;
    }

    public static LdbSqlName newInfoSchemaColumnName(String name, LdbSqlName table) {
        LdbSqlName ldbSqlName = new LdbSqlName(staticManager, name, false, 9);
        ldbSqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        ldbSqlName.parent = table;
        return ldbSqlName;
    }

    public static LdbSqlName newInfoSchemaTableName(String name) {
        LdbSqlName ldbSqlName = new LdbSqlName(staticManager, name, 3, false);
        ldbSqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        ldbSqlName.setUuid(UUID.randomUUID().toString());
        return ldbSqlName;
    }

    public static LdbSqlName newInfoSchemaObjectName(String name, boolean isQuoted, int type) {
        LdbSqlName ldbSqlName = new LdbSqlName(staticManager, name, type, isQuoted);
        ldbSqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        return ldbSqlName;
    }

    public static LdbSqlName getAutoColumnName(int i) {
        if (i < autoColumnNames.length) {
            return autoColumnNames[i];
        }
        return new LdbSqlName(staticManager, "C_" + (i + 1), 9, false);
    }

    public static String getAutoNoNameColumnString(int i) {
        if (i < autoColumnNames.length) {
            return autoNoNameColumnNames[i];
        }
        return String.valueOf(i);
    }

    public static String getAutoSavepointNameString(long i, int j) {
        StringBuffer sb = new StringBuffer("S");
        sb.append(i).append('_').append(j);
        return sb.toString();
    }

    public static SimpleName getSimpleName(String name, boolean isNameQuoted) {
        return new SimpleName(name, isNameQuoted);
    }

    public LdbSqlName getCatalogName() {
        return this.catalogName;
    }

    public void setSqlRegularNames(boolean value) {
        this.sqlRegularNames = value;
    }

    public LdbSqlName newHsqlName(LdbSqlName schema, String name, int type) {
        LdbSqlName ldbSqlName = new LdbSqlName(this, name, type, false);
        ldbSqlName.schema = schema;
        return ldbSqlName;
    }

    public LdbSqlName newHsqlName(String name, boolean isquoted, int type) {
        return new LdbSqlName(this, name, isquoted, type);
    }

    public LdbSqlName newHsqlName(LdbSqlName schema, String name, boolean isquoted, int type) {
        LdbSqlName ldbSqlName = new LdbSqlName(this, name, isquoted, type);
        ldbSqlName.schema = schema;
        return ldbSqlName;
    }

    public LdbSqlName newHsqlName(LdbSqlName schema, String name, boolean isquoted, int type, LdbSqlName parent) {
        LdbSqlName ldbSqlName = new LdbSqlName(this, name, isquoted, type);
        ldbSqlName.schema = schema;
        ldbSqlName.parent = parent;
        return ldbSqlName;
    }

    public LdbSqlName newColumnSchemaHsqlName(LdbSqlName table, SimpleName name) {
        return this.newColumnHsqlName(table, name.name, name.isNameQuoted);
    }

    public LdbSqlName newColumnHsqlName(LdbSqlName table, String name, boolean isquoted) {
        LdbSqlName ldbSqlName = new LdbSqlName(this, name, isquoted, 9);
        ldbSqlName.schema = table.schema;
        ldbSqlName.parent = table;
        return ldbSqlName;
    }

    public LdbSqlName getSubqueryTableName() {
        return this.subqueryTableName;
    }

    public LdbSqlName newAutoName(String prefix, LdbSqlName schema, LdbSqlName parent, int type) {
        LdbSqlName name = this.newAutoName(prefix, null, schema, parent, type);
        return name;
    }

    public LdbSqlName newConstraintIndexName(LdbSqlName tableName, LdbSqlName constName, boolean useConstraint) {
        if (constName == null) {
            useConstraint = false;
        }
        if (useConstraint) {
            LdbSqlName name = new LdbSqlName(this, constName.name, 20, false);
            name.schema = tableName.schema;
            name.parent = tableName;
            return name;
        }
        String constNameString = constName == null ? null : constName.name;
        return this.newAutoName("IDX", constNameString, tableName.schema, tableName, 20);
    }

    public LdbSqlName newSpecificRoutineName(LdbSqlName name) {
        StringBuffer sb = new StringBuffer();
        sb.append(name.name).append('_').append(this.sysNumber.incrementAndGet());
        LdbSqlName ldbSqlName = new LdbSqlName(this, sb.toString(), 24, name.isNameQuoted);
        ldbSqlName.parent = name;
        ldbSqlName.schema = name.schema;
        return ldbSqlName;
    }

    public LdbSqlName newAutoName(String prefix, String namepart, LdbSqlName schema, LdbSqlName parent, int type) {
        StringBuffer sb = new StringBuffer();
        if (prefix != null) {
            if (prefix.length() != 0) {
                sb.append("SYS_");
                sb.append(prefix);
                sb.append('_');
                if (namepart != null) {
                    sb.append(namepart);
                    sb.append('_');
                }
                sb.append(this.sysNumber.incrementAndGet());
            }
        } else {
            sb.append(namepart);
        }
        LdbSqlName name = new LdbSqlName(this, sb.toString(), type, false);
        name.schema = schema;
        name.parent = parent;
        return name;
    }

    static {
        LdbSqlNameManager.staticManager.serialNumber.set(Long.MIN_VALUE);
        for (int i = 0; i < autoColumnNames.length; ++i) {
            LdbSqlNameManager.autoColumnNames[i] = new LdbSqlName(staticManager, "C" + (i + 1), 0, false);
            LdbSqlNameManager.autoNoNameColumnNames[i] = String.valueOf(i);
        }
    }

    public static final class LdbSqlName
    extends SimpleName {
        static final String[] sysPrefixes = new String[]{"SYS_IDX_", "SYS_PK_", "SYS_REF_", "SYS_CT_", "SYS_FK_", "SYS_CONS_PK_"};
        public static LdbSqlName[] emptyArray = new LdbSqlName[0];
        public final int type;
        private final long hashCode;
        public String statementName;
        public String comment;
        public LdbSqlName schema;
        public LdbSqlName parent;
        public transient Grantee owner;
        transient LdbSqlNameManager manager;
        private String uuid;

        public LdbSqlName(LdbSqlNameManager man, int type) {
            this.manager = man;
            this.type = type;
            this.hashCode = this.manager.serialNumber.getAndIncrement();
        }

        public LdbSqlName(LdbSqlNameManager man, String name, boolean isquoted, int type) {
            this(man, type);
            this.rename(name, isquoted);
        }

        private LdbSqlName(LdbSqlNameManager man, String name, int type, boolean isQuoted) {
            this(man, type);
            this.name = name;
            this.statementName = name;
            this.isNameQuoted = isQuoted;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(name, '\"', true);
            }
        }

        static int sysPrefixLength(String name) {
            for (int i = 0; i < sysPrefixes.length; ++i) {
                if (!name.startsWith(sysPrefixes[i])) continue;
                return sysPrefixes[i].length();
            }
            return 0;
        }

        static boolean isReservedName(String name) {
            return LdbSqlName.sysPrefixLength(name) > 0;
        }

        static boolean isRegularIdentifier(String name) {
            int length = name.length();
            for (int i = 0; i < length; ++i) {
                char c = name.charAt(i);
                if (c >= 'A' && c <= 'Z' || c == '_' && i > 0 || c >= '0' && c <= '9') continue;
                return false;
            }
            return !Tokens.isKeyword(name);
        }

        public LdbSqlNameManager getManager() {
            return this.manager;
        }

        public void setManager(LdbSqlNameManager manager) {
            this.manager = manager;
        }

        @Override
        public String getStatementName() {
            return this.statementName;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getSchemaQualifiedStatementName() {
            switch (this.type) {
                case 22: 
                case 23: {
                    return this.statementName;
                }
                case 9: {
                    if (this.parent == null || "SYSTEM_SUBQUERY".equals(this.parent.name)) {
                        return this.statementName;
                    }
                    StringBuffer sb = new StringBuffer();
                    if (this.schema != null) {
                        sb.append(this.schema.getStatementName());
                        sb.append('.');
                    }
                    sb.append(this.parent.getStatementName());
                    sb.append('.');
                    sb.append(this.statementName);
                    return sb.toString();
                }
            }
            if (this.schema == null || "SYSTEM_SCHEMA".equals(this.schema.name)) {
                return this.statementName;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(this.schema.getStatementName());
            sb.append('.');
            sb.append(this.statementName);
            return sb.toString();
        }

        public String getSchemaQualifiedStatementNameForGetSql() {
            switch (this.type) {
                case 22: 
                case 23: {
                    return this.statementName;
                }
                case 9: {
                    if (this.parent == null || "SYSTEM_SUBQUERY".equals(this.parent.name)) {
                        if (this.isNameQuoted) {
                            return StringConverter.toQuotedString(this.name, '`', true);
                        }
                        return this.statementName;
                    }
                    StringBuffer sb = new StringBuffer();
                    if (this.schema != null) {
                        sb.append(this.schema.getStatementName());
                        sb.append('$');
                    }
                    if (this.parent != null && !StringUtil.isEmpty(this.parent.name)) {
                        sb.append(this.parent.getNameString());
                        String s = StringConverter.toQuotedString(sb.toString(), '`', true);
                        sb.delete(0, sb.length());
                        sb.append(s);
                        sb.append('.');
                    }
                    if (this.isNameQuoted) {
                        sb.append(StringConverter.toQuotedString(this.name, '`', true));
                    } else {
                        sb.append(this.statementName);
                    }
                    return sb.toString();
                }
            }
            if (this.schema == null || "SYSTEM_SCHEMA".equals(this.schema.name)) {
                return this.statementName;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(this.schema.getStatementName());
            sb.append('$');
            sb.append(this.statementName);
            return sb.toString();
        }

        public void rename(LdbSqlName name) {
            this.rename(name.name, name.isNameQuoted);
        }

        public void rename(String name, boolean isquoted) {
            if (this.manager.sqlRegularNames && name.length() > 128) {
                throw Error.error(5501, name);
            }
            this.statementName = this.name = name;
            this.isNameQuoted = isquoted;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(name, '\"', true);
            }
            if (name.startsWith("SYS_")) {
                int length = name.lastIndexOf(95) + 1;
                try {
                    int temp = Integer.parseInt(name.substring(length));
                    if ((long)temp > this.manager.sysNumber.get()) {
                        this.manager.sysNumber.set(temp);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        void rename(String prefix, String name, boolean isquoted) {
            StringBuffer sbname = new StringBuffer(prefix);
            sbname.append('_');
            sbname.append(name);
            this.rename(sbname.toString(), isquoted);
        }

        public void setSchemaIfNull(LdbSqlName schema) {
            if (this.schema == null) {
                this.schema = schema;
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof LdbSqlName) {
                return this.hashCode == ((LdbSqlName)other).hashCode;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (int)(this.hashCode ^ this.hashCode >>> 32);
        }

        public boolean isReservedName() {
            return LdbSqlName.isReservedName(this.name);
        }

        public String getRetrievedPrefixNameString() {
            int inx = this.name.indexOf("#");
            return this.name.substring(0, inx);
        }

        public String getRetrievedSimpleNameString() {
            int inx = this.name.indexOf("#");
            return this.name.substring(inx + 1);
        }

        public String generateRetrievedNameString() {
            return this.schema.name + "#" + this.name;
        }

        public String toString() {
            return this.getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
        }
    }

    public static class SimpleName
    implements Serializable {
        public String name;
        public boolean isNameQuoted;

        private SimpleName() {
        }

        public SimpleName(String name, boolean isNameQuoted) {
            this.name = name;
            this.isNameQuoted = isNameQuoted;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof SimpleName) {
                return ((SimpleName)other).name.equals(this.name);
            }
            return false;
        }

        public String getStatementName() {
            return this.isNameQuoted ? StringConverter.toQuotedString(this.name, '\"', true) : this.name;
        }

        public String generateStatementName(char quote) {
            return this.isNameQuoted ? StringConverter.toQuotedString(this.name, quote, true) : this.name;
        }

        public String generateDBLinkStatementName() {
            if (this.isNameQuoted) {
                int quote = Type.dbLinkType.get() != null && (Type.dbLinkType.get() == 3 || Type.dbLinkType.get() == 5 || Type.dbLinkType.get() == 12) ? 96 : 34;
                return StringConverter.toQuotedString(this.name, (char)quote, true);
            }
            return this.name;
        }

        public String quotedBy(char quote) {
            return StringConverter.toQuotedString(this.name, quote, true);
        }

        public String getNameString() {
            return this.name;
        }
    }
}

