"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDeploymentConfig = void 0;
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom Lambda Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @stability stable
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class LambdaDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom lambda deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct.
     * @param _id the logical ID of this new Construct.
     * @param props the properties of the referenced custom Deployment Configuration.
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     * @stability stable
     */
    static import(_scope, _id, props) {
        return deploymentConfig(props.deploymentConfigName);
    }
}
exports.LambdaDeploymentConfig = LambdaDeploymentConfig;
/**
 * @stability stable
 */
LambdaDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.LambdaAllAtOnce');
/**
 * @stability stable
 */
LambdaDeploymentConfig.CANARY_10PERCENT_30MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent30Minutes');
/**
 * @stability stable
 */
LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent5Minutes');
/**
 * @stability stable
 */
LambdaDeploymentConfig.CANARY_10PERCENT_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent10Minutes');
/**
 * @stability stable
 */
LambdaDeploymentConfig.CANARY_10PERCENT_15MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent15Minutes');
/**
 * @stability stable
 */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery10Minutes');
/**
 * @stability stable
 */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery1Minute');
/**
 * @stability stable
 */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_2MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery2Minutes');
/**
 * @stability stable
 */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_3MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery3Minutes');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,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