import { Construct } from 'constructs';
/**
 * The Deployment Configuration of a Lambda Deployment Group.
 *
 * The default, pre-defined Configurations are available as constants on the {@link LambdaDeploymentConfig} class
 * (`LambdaDeploymentConfig.AllAtOnce`, `LambdaDeploymentConfig.Canary10Percent30Minutes`, etc.).
 *
 * Note: CloudFormation does not currently support creating custom lambda configs outside
 * of using a custom resource. You can import custom deployment config created outside the
 * CDK or via a custom resource with {@link LambdaDeploymentConfig#import}.
 *
 * @stability stable
 */
export interface ILambdaDeploymentConfig {
    /**
     * @stability stable
     */
    readonly deploymentConfigName: string;
    /**
     * @stability stable
     */
    readonly deploymentConfigArn: string;
}
/**
 * Properties of a reference to a CodeDeploy Lambda Deployment Configuration.
 *
 * @see LambdaDeploymentConfig#import
 * @stability stable
 */
export interface LambdaDeploymentConfigImportProps {
    /**
     * The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration that we are referencing.
     *
     * @stability stable
     */
    readonly deploymentConfigName: string;
}
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom Lambda Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @stability stable
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
export declare class LambdaDeploymentConfig {
    /**
     * @stability stable
     */
    static readonly ALL_AT_ONCE: ILambdaDeploymentConfig;
    /**
     * @stability stable
     */
    static readonly CANARY_10PERCENT_30MINUTES: ILambdaDeploymentConfig;
    /**
     * @stability stable
     */
    static readonly CANARY_10PERCENT_5MINUTES: ILambdaDeploymentConfig;
    /**
     * @stability stable
     */
    static readonly CANARY_10PERCENT_10MINUTES: ILambdaDeploymentConfig;
    /**
     * @stability stable
     */
    static readonly CANARY_10PERCENT_15MINUTES: ILambdaDeploymentConfig;
    /**
     * @stability stable
     */
    static readonly LINEAR_10PERCENT_EVERY_10MINUTES: ILambdaDeploymentConfig;
    /**
     * @stability stable
     */
    static readonly LINEAR_10PERCENT_EVERY_1MINUTE: ILambdaDeploymentConfig;
    /**
     * @stability stable
     */
    static readonly LINEAR_10PERCENT_EVERY_2MINUTES: ILambdaDeploymentConfig;
    /**
     * @stability stable
     */
    static readonly LINEAR_10PERCENT_EVERY_3MINUTES: ILambdaDeploymentConfig;
    /**
     * Import a custom Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct.
     * @param _id the logical ID of this new Construct.
     * @param props the properties of the referenced custom Deployment Configuration.
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     * @stability stable
     */
    static import(_scope: Construct, _id: string, props: LambdaDeploymentConfigImportProps): ILambdaDeploymentConfig;
    private constructor();
}
