import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { CfnDeploymentConfig } from '../codedeploy.generated';
/**
 * The Deployment Configuration of an EC2/on-premise Deployment Group.
 *
 * The default, pre-defined Configurations are available as constants on the {@link ServerDeploymentConfig} class
 * (`ServerDeploymentConfig.HALF_AT_A_TIME`, `ServerDeploymentConfig.ALL_AT_ONCE`, etc.).
 * To create a custom Deployment Configuration,
 * instantiate the {@link ServerDeploymentConfig} Construct.
 *
 * @stability stable
 */
export interface IServerDeploymentConfig {
    /**
     * @stability stable
     * @attribute true
     */
    readonly deploymentConfigName: string;
    /**
     * @stability stable
     * @attribute true
     */
    readonly deploymentConfigArn: string;
}
/**
 * Minimum number of healthy hosts for a server deployment.
 *
 * @stability stable
 */
export declare class MinimumHealthyHosts {
    private readonly json;
    /**
     * The minimum healhty hosts threshold expressed as an absolute number.
     *
     * @stability stable
     */
    static count(value: number): MinimumHealthyHosts;
    /**
     * The minmum healhty hosts threshold expressed as a percentage of the fleet.
     *
     * @stability stable
     */
    static percentage(value: number): MinimumHealthyHosts;
    private constructor();
    /**
     * @internal
     */
    get _json(): CfnDeploymentConfig.MinimumHealthyHostsProperty;
}
/**
 * Construction properties of {@link ServerDeploymentConfig}.
 *
 * @stability stable
 */
export interface ServerDeploymentConfigProps {
    /**
     * The physical, human-readable name of the Deployment Configuration.
     *
     * @default a name will be auto-generated
     * @stability stable
     */
    readonly deploymentConfigName?: string;
    /**
     * Minimum number of healthy hosts.
     *
     * @stability stable
     */
    readonly minimumHealthyHosts: MinimumHealthyHosts;
}
/**
 * A custom Deployment Configuration for an EC2/on-premise Deployment Group.
 *
 * @stability stable
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
export declare class ServerDeploymentConfig extends cdk.Resource implements IServerDeploymentConfig {
    /**
     * @stability stable
     */
    static readonly ONE_AT_A_TIME: IServerDeploymentConfig;
    /**
     * @stability stable
     */
    static readonly HALF_AT_A_TIME: IServerDeploymentConfig;
    /**
     * @stability stable
     */
    static readonly ALL_AT_ONCE: IServerDeploymentConfig;
    /**
     * Import a custom Deployment Configuration for an EC2/on-premise Deployment Group defined either outside the CDK app, or in a different region.
     *
     * @param scope the parent Construct for this new Construct.
     * @param id the logical ID of this new Construct.
     * @param serverDeploymentConfigName the properties of the referenced custom Deployment Configuration.
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     * @stability stable
     */
    static fromServerDeploymentConfigName(scope: Construct, id: string, serverDeploymentConfigName: string): IServerDeploymentConfig;
    /**
     * @stability stable
     */
    readonly deploymentConfigName: string;
    /**
     * @stability stable
     */
    readonly deploymentConfigArn: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ServerDeploymentConfigProps);
}
