# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Proxy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'backlog': 'int',
        'client_keepcnt': 'int',
        'client_keepidle': 'int',
        'client_keepintvl': 'int',
        'conns': 'int',
        'duration_usage_threshold': 'int',
        'dynamic_threads_scaling': 'bool',
        'ignore_bdb_cconn_limit': 'bool',
        'ignore_bdb_cconn_output_buff_limits': 'bool',
        'max_listeners': 'int',
        'max_servers': 'int',
        'max_threads': 'int',
        'max_worker_client_conns': 'int',
        'max_worker_server_conns': 'int',
        'max_worker_txns': 'int',
        'threads': 'int',
        'threads_usage_threshold': 'int',
        'uid': 'int'
    }

    attribute_map = {
        'backlog': 'backlog',
        'client_keepcnt': 'client_keepcnt',
        'client_keepidle': 'client_keepidle',
        'client_keepintvl': 'client_keepintvl',
        'conns': 'conns',
        'duration_usage_threshold': 'duration_usage_threshold',
        'dynamic_threads_scaling': 'dynamic_threads_scaling',
        'ignore_bdb_cconn_limit': 'ignore_bdb_cconn_limit',
        'ignore_bdb_cconn_output_buff_limits': 'ignore_bdb_cconn_output_buff_limits',
        'max_listeners': 'max_listeners',
        'max_servers': 'max_servers',
        'max_threads': 'max_threads',
        'max_worker_client_conns': 'max_worker_client_conns',
        'max_worker_server_conns': 'max_worker_server_conns',
        'max_worker_txns': 'max_worker_txns	',
        'threads': 'threads',
        'threads_usage_threshold': 'threads_usage_threshold',
        'uid': 'uid'
    }

    def __init__(self, backlog=None, client_keepcnt=None, client_keepidle=None, client_keepintvl=None, conns=None, duration_usage_threshold=None, dynamic_threads_scaling=None, ignore_bdb_cconn_limit=None, ignore_bdb_cconn_output_buff_limits=None, max_listeners=None, max_servers=None, max_threads=None, max_worker_client_conns=None, max_worker_server_conns=None, max_worker_txns=None, threads=None, threads_usage_threshold=None, uid=None):  # noqa: E501
        """Proxy - a model defined in Swagger"""  # noqa: E501
        self._backlog = None
        self._client_keepcnt = None
        self._client_keepidle = None
        self._client_keepintvl = None
        self._conns = None
        self._duration_usage_threshold = None
        self._dynamic_threads_scaling = None
        self._ignore_bdb_cconn_limit = None
        self._ignore_bdb_cconn_output_buff_limits = None
        self._max_listeners = None
        self._max_servers = None
        self._max_threads = None
        self._max_worker_client_conns = None
        self._max_worker_server_conns = None
        self._max_worker_txns = None
        self._threads = None
        self._threads_usage_threshold = None
        self._uid = None
        self.discriminator = None
        if backlog is not None:
            self.backlog = backlog
        if client_keepcnt is not None:
            self.client_keepcnt = client_keepcnt
        if client_keepidle is not None:
            self.client_keepidle = client_keepidle
        if client_keepintvl is not None:
            self.client_keepintvl = client_keepintvl
        if conns is not None:
            self.conns = conns
        if duration_usage_threshold is not None:
            self.duration_usage_threshold = duration_usage_threshold
        if dynamic_threads_scaling is not None:
            self.dynamic_threads_scaling = dynamic_threads_scaling
        if ignore_bdb_cconn_limit is not None:
            self.ignore_bdb_cconn_limit = ignore_bdb_cconn_limit
        if ignore_bdb_cconn_output_buff_limits is not None:
            self.ignore_bdb_cconn_output_buff_limits = ignore_bdb_cconn_output_buff_limits
        if max_listeners is not None:
            self.max_listeners = max_listeners
        if max_servers is not None:
            self.max_servers = max_servers
        if max_threads is not None:
            self.max_threads = max_threads
        if max_worker_client_conns is not None:
            self.max_worker_client_conns = max_worker_client_conns
        if max_worker_server_conns is not None:
            self.max_worker_server_conns = max_worker_server_conns
        if max_worker_txns is not None:
            self.max_worker_txns = max_worker_txns
        if threads is not None:
            self.threads = threads
        if threads_usage_threshold is not None:
            self.threads_usage_threshold = threads_usage_threshold
        if uid is not None:
            self.uid = uid

    @property
    def backlog(self):
        """Gets the backlog of this Proxy.  # noqa: E501

        tcp listen queue backlog.  # noqa: E501

        :return: The backlog of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._backlog

    @backlog.setter
    def backlog(self, backlog):
        """Sets the backlog of this Proxy.

        tcp listen queue backlog.  # noqa: E501

        :param backlog: The backlog of this Proxy.  # noqa: E501
        :type: int
        """

        self._backlog = backlog

    @property
    def client_keepcnt(self):
        """Gets the client_keepcnt of this Proxy.  # noqa: E501

        Client tcp keepalive count.  # noqa: E501

        :return: The client_keepcnt of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._client_keepcnt

    @client_keepcnt.setter
    def client_keepcnt(self, client_keepcnt):
        """Sets the client_keepcnt of this Proxy.

        Client tcp keepalive count.  # noqa: E501

        :param client_keepcnt: The client_keepcnt of this Proxy.  # noqa: E501
        :type: int
        """

        self._client_keepcnt = client_keepcnt

    @property
    def client_keepidle(self):
        """Gets the client_keepidle of this Proxy.  # noqa: E501

        Client tcp keepalive idle.  # noqa: E501

        :return: The client_keepidle of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._client_keepidle

    @client_keepidle.setter
    def client_keepidle(self, client_keepidle):
        """Sets the client_keepidle of this Proxy.

        Client tcp keepalive idle.  # noqa: E501

        :param client_keepidle: The client_keepidle of this Proxy.  # noqa: E501
        :type: int
        """

        self._client_keepidle = client_keepidle

    @property
    def client_keepintvl(self):
        """Gets the client_keepintvl of this Proxy.  # noqa: E501

        Client tcp keepalive interval.  # noqa: E501

        :return: The client_keepintvl of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._client_keepintvl

    @client_keepintvl.setter
    def client_keepintvl(self, client_keepintvl):
        """Sets the client_keepintvl of this Proxy.

        Client tcp keepalive interval.  # noqa: E501

        :param client_keepintvl: The client_keepintvl of this Proxy.  # noqa: E501
        :type: int
        """

        self._client_keepintvl = client_keepintvl

    @property
    def conns(self):
        """Gets the conns of this Proxy.  # noqa: E501

        Number of connections.  # noqa: E501

        :return: The conns of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._conns

    @conns.setter
    def conns(self, conns):
        """Sets the conns of this Proxy.

        Number of connections.  # noqa: E501

        :param conns: The conns of this Proxy.  # noqa: E501
        :type: int
        """

        self._conns = conns

    @property
    def duration_usage_threshold(self):
        """Gets the duration_usage_threshold of this Proxy.  # noqa: E501

        Max number of threads.  # noqa: E501

        :return: The duration_usage_threshold of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._duration_usage_threshold

    @duration_usage_threshold.setter
    def duration_usage_threshold(self, duration_usage_threshold):
        """Sets the duration_usage_threshold of this Proxy.

        Max number of threads.  # noqa: E501

        :param duration_usage_threshold: The duration_usage_threshold of this Proxy.  # noqa: E501
        :type: int
        """

        self._duration_usage_threshold = duration_usage_threshold

    @property
    def dynamic_threads_scaling(self):
        """Gets the dynamic_threads_scaling of this Proxy.  # noqa: E501


        :return: The dynamic_threads_scaling of this Proxy.  # noqa: E501
        :rtype: bool
        """
        return self._dynamic_threads_scaling

    @dynamic_threads_scaling.setter
    def dynamic_threads_scaling(self, dynamic_threads_scaling):
        """Sets the dynamic_threads_scaling of this Proxy.


        :param dynamic_threads_scaling: The dynamic_threads_scaling of this Proxy.  # noqa: E501
        :type: bool
        """

        self._dynamic_threads_scaling = dynamic_threads_scaling

    @property
    def ignore_bdb_cconn_limit(self):
        """Gets the ignore_bdb_cconn_limit of this Proxy.  # noqa: E501

        ignore client connection limits.  # noqa: E501

        :return: The ignore_bdb_cconn_limit of this Proxy.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_bdb_cconn_limit

    @ignore_bdb_cconn_limit.setter
    def ignore_bdb_cconn_limit(self, ignore_bdb_cconn_limit):
        """Sets the ignore_bdb_cconn_limit of this Proxy.

        ignore client connection limits.  # noqa: E501

        :param ignore_bdb_cconn_limit: The ignore_bdb_cconn_limit of this Proxy.  # noqa: E501
        :type: bool
        """

        self._ignore_bdb_cconn_limit = ignore_bdb_cconn_limit

    @property
    def ignore_bdb_cconn_output_buff_limits(self):
        """Gets the ignore_bdb_cconn_output_buff_limits of this Proxy.  # noqa: E501

        Ignore buffer limit.  # noqa: E501

        :return: The ignore_bdb_cconn_output_buff_limits of this Proxy.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_bdb_cconn_output_buff_limits

    @ignore_bdb_cconn_output_buff_limits.setter
    def ignore_bdb_cconn_output_buff_limits(self, ignore_bdb_cconn_output_buff_limits):
        """Sets the ignore_bdb_cconn_output_buff_limits of this Proxy.

        Ignore buffer limit.  # noqa: E501

        :param ignore_bdb_cconn_output_buff_limits: The ignore_bdb_cconn_output_buff_limits of this Proxy.  # noqa: E501
        :type: bool
        """

        self._ignore_bdb_cconn_output_buff_limits = ignore_bdb_cconn_output_buff_limits

    @property
    def max_listeners(self):
        """Gets the max_listeners of this Proxy.  # noqa: E501

        Max. number of listeners.  # noqa: E501

        :return: The max_listeners of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._max_listeners

    @max_listeners.setter
    def max_listeners(self, max_listeners):
        """Sets the max_listeners of this Proxy.

        Max. number of listeners.  # noqa: E501

        :param max_listeners: The max_listeners of this Proxy.  # noqa: E501
        :type: int
        """

        self._max_listeners = max_listeners

    @property
    def max_servers(self):
        """Gets the max_servers of this Proxy.  # noqa: E501

        Max. number of redis servers.  # noqa: E501

        :return: The max_servers of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._max_servers

    @max_servers.setter
    def max_servers(self, max_servers):
        """Sets the max_servers of this Proxy.

        Max. number of redis servers.  # noqa: E501

        :param max_servers: The max_servers of this Proxy.  # noqa: E501
        :type: int
        """

        self._max_servers = max_servers

    @property
    def max_threads(self):
        """Gets the max_threads of this Proxy.  # noqa: E501

        Max number of threads.  # noqa: E501

        :return: The max_threads of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._max_threads

    @max_threads.setter
    def max_threads(self, max_threads):
        """Sets the max_threads of this Proxy.

        Max number of threads.  # noqa: E501

        :param max_threads: The max_threads of this Proxy.  # noqa: E501
        :type: int
        """

        self._max_threads = max_threads

    @property
    def max_worker_client_conns(self):
        """Gets the max_worker_client_conns of this Proxy.  # noqa: E501

        Max. client conns per thread.  # noqa: E501

        :return: The max_worker_client_conns of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._max_worker_client_conns

    @max_worker_client_conns.setter
    def max_worker_client_conns(self, max_worker_client_conns):
        """Sets the max_worker_client_conns of this Proxy.

        Max. client conns per thread.  # noqa: E501

        :param max_worker_client_conns: The max_worker_client_conns of this Proxy.  # noqa: E501
        :type: int
        """

        self._max_worker_client_conns = max_worker_client_conns

    @property
    def max_worker_server_conns(self):
        """Gets the max_worker_server_conns of this Proxy.  # noqa: E501

        Max. server conns per thread.  # noqa: E501

        :return: The max_worker_server_conns of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._max_worker_server_conns

    @max_worker_server_conns.setter
    def max_worker_server_conns(self, max_worker_server_conns):
        """Sets the max_worker_server_conns of this Proxy.

        Max. server conns per thread.  # noqa: E501

        :param max_worker_server_conns: The max_worker_server_conns of this Proxy.  # noqa: E501
        :type: int
        """

        self._max_worker_server_conns = max_worker_server_conns

    @property
    def max_worker_txns(self):
        """Gets the max_worker_txns of this Proxy.  # noqa: E501

        Max. in-flight transactions per thread.  # noqa: E501

        :return: The max_worker_txns of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._max_worker_txns

    @max_worker_txns.setter
    def max_worker_txns(self, max_worker_txns):
        """Sets the max_worker_txns of this Proxy.

        Max. in-flight transactions per thread.  # noqa: E501

        :param max_worker_txns: The max_worker_txns of this Proxy.  # noqa: E501
        :type: int
        """

        self._max_worker_txns = max_worker_txns

    @property
    def threads(self):
        """Gets the threads of this Proxy.  # noqa: E501

        Number of threads.  # noqa: E501

        :return: The threads of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._threads

    @threads.setter
    def threads(self, threads):
        """Sets the threads of this Proxy.

        Number of threads.  # noqa: E501

        :param threads: The threads of this Proxy.  # noqa: E501
        :type: int
        """

        self._threads = threads

    @property
    def threads_usage_threshold(self):
        """Gets the threads_usage_threshold of this Proxy.  # noqa: E501

        Max number of threads.  # noqa: E501

        :return: The threads_usage_threshold of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._threads_usage_threshold

    @threads_usage_threshold.setter
    def threads_usage_threshold(self, threads_usage_threshold):
        """Sets the threads_usage_threshold of this Proxy.

        Max number of threads.  # noqa: E501

        :param threads_usage_threshold: The threads_usage_threshold of this Proxy.  # noqa: E501
        :type: int
        """

        self._threads_usage_threshold = threads_usage_threshold

    @property
    def uid(self):
        """Gets the uid of this Proxy.  # noqa: E501

        unique ID of proxy  # noqa: E501

        :return: The uid of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this Proxy.

        unique ID of proxy  # noqa: E501

        :param uid: The uid of this Proxy.  # noqa: E501
        :type: int
        """

        self._uid = uid

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Proxy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Proxy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
