# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Node(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'accept_servers': 'bool',
        'addr': 'str',
        'architecture': 'str',
        'bigredis_storage_path': 'str',
        'bigstore_driver': 'str',
        'bigstore_size': 'str',
        'cores': 'int',
        'ephemeral_storage_path': 'str',
        'ephemeral_storage_size': 'float',
        'external_addr': 'OneOfnodeExternalAddr',
        'max_listeners': 'int',
        'max_redis_servers': 'int',
        'os_name': 'str',
        'os_semantic_version': 'str',
        'os_version': 'str',
        'persistent_storage_path': 'str',
        'persistent_storage_size': 'float',
        'public_addr': 'str',
        'rack_id': 'str',
        'recovery_path': 'str',
        'shard_count': 'int',
        'shard_list': 'list[int]',
        'software_version': 'str',
        'status': 'str',
        'supported_database_versions': 'list[NodeSupportedDatabaseVersions]',
        'system_time': 'datetime',
        'total_memory': 'int',
        'uid': 'int',
        'uptime': 'int'
    }

    attribute_map = {
        'accept_servers': 'accept_servers',
        'addr': 'addr',
        'architecture': 'architecture',
        'bigredis_storage_path': 'bigredis_storage_path',
        'bigstore_driver': 'bigstore_driver',
        'bigstore_size': 'bigstore_size',
        'cores': 'cores',
        'ephemeral_storage_path': 'ephemeral_storage_path',
        'ephemeral_storage_size': 'ephemeral_storage_size',
        'external_addr': 'external_addr',
        'max_listeners': 'max_listeners',
        'max_redis_servers': 'max_redis_servers',
        'os_name': 'os_name',
        'os_semantic_version': 'os_semantic_version',
        'os_version': 'os_version',
        'persistent_storage_path': 'persistent_storage_path',
        'persistent_storage_size': 'persistent_storage_size',
        'public_addr': 'public_addr',
        'rack_id': 'rack_id',
        'recovery_path': 'recovery_path',
        'shard_count': 'shard_count',
        'shard_list': 'shard_list',
        'software_version': 'software_version',
        'status': 'status',
        'supported_database_versions': 'supported_database_versions',
        'system_time': 'system_time',
        'total_memory': 'total_memory',
        'uid': 'uid',
        'uptime': 'uptime'
    }

    def __init__(self, accept_servers=True, addr=None, architecture=None, bigredis_storage_path=None, bigstore_driver=None, bigstore_size=None, cores=None, ephemeral_storage_path=None, ephemeral_storage_size=None, external_addr=None, max_listeners=None, max_redis_servers=None, os_name=None, os_semantic_version=None, os_version=None, persistent_storage_path=None, persistent_storage_size=None, public_addr=None, rack_id=None, recovery_path=None, shard_count=None, shard_list=None, software_version=None, status=None, supported_database_versions=None, system_time=None, total_memory=None, uid=None, uptime=None):  # noqa: E501
        """Node - a model defined in Swagger"""  # noqa: E501
        self._accept_servers = None
        self._addr = None
        self._architecture = None
        self._bigredis_storage_path = None
        self._bigstore_driver = None
        self._bigstore_size = None
        self._cores = None
        self._ephemeral_storage_path = None
        self._ephemeral_storage_size = None
        self._external_addr = None
        self._max_listeners = None
        self._max_redis_servers = None
        self._os_name = None
        self._os_semantic_version = None
        self._os_version = None
        self._persistent_storage_path = None
        self._persistent_storage_size = None
        self._public_addr = None
        self._rack_id = None
        self._recovery_path = None
        self._shard_count = None
        self._shard_list = None
        self._software_version = None
        self._status = None
        self._supported_database_versions = None
        self._system_time = None
        self._total_memory = None
        self._uid = None
        self._uptime = None
        self.discriminator = None
        if accept_servers is not None:
            self.accept_servers = accept_servers
        if addr is not None:
            self.addr = addr
        if architecture is not None:
            self.architecture = architecture
        if bigredis_storage_path is not None:
            self.bigredis_storage_path = bigredis_storage_path
        if bigstore_driver is not None:
            self.bigstore_driver = bigstore_driver
        if bigstore_size is not None:
            self.bigstore_size = bigstore_size
        if cores is not None:
            self.cores = cores
        if ephemeral_storage_path is not None:
            self.ephemeral_storage_path = ephemeral_storage_path
        if ephemeral_storage_size is not None:
            self.ephemeral_storage_size = ephemeral_storage_size
        if external_addr is not None:
            self.external_addr = external_addr
        if max_listeners is not None:
            self.max_listeners = max_listeners
        if max_redis_servers is not None:
            self.max_redis_servers = max_redis_servers
        if os_name is not None:
            self.os_name = os_name
        if os_semantic_version is not None:
            self.os_semantic_version = os_semantic_version
        if os_version is not None:
            self.os_version = os_version
        if persistent_storage_path is not None:
            self.persistent_storage_path = persistent_storage_path
        if persistent_storage_size is not None:
            self.persistent_storage_size = persistent_storage_size
        if public_addr is not None:
            self.public_addr = public_addr
        if rack_id is not None:
            self.rack_id = rack_id
        if recovery_path is not None:
            self.recovery_path = recovery_path
        if shard_count is not None:
            self.shard_count = shard_count
        if shard_list is not None:
            self.shard_list = shard_list
        if software_version is not None:
            self.software_version = software_version
        if status is not None:
            self.status = status
        if supported_database_versions is not None:
            self.supported_database_versions = supported_database_versions
        if system_time is not None:
            self.system_time = system_time
        if total_memory is not None:
            self.total_memory = total_memory
        if uid is not None:
            self.uid = uid
        if uptime is not None:
            self.uptime = uptime

    @property
    def accept_servers(self):
        """Gets the accept_servers of this Node.  # noqa: E501

        If True no shards will be created on the node  # noqa: E501

        :return: The accept_servers of this Node.  # noqa: E501
        :rtype: bool
        """
        return self._accept_servers

    @accept_servers.setter
    def accept_servers(self, accept_servers):
        """Sets the accept_servers of this Node.

        If True no shards will be created on the node  # noqa: E501

        :param accept_servers: The accept_servers of this Node.  # noqa: E501
        :type: bool
        """

        self._accept_servers = accept_servers

    @property
    def addr(self):
        """Gets the addr of this Node.  # noqa: E501

        Internal IP address of node  # noqa: E501

        :return: The addr of this Node.  # noqa: E501
        :rtype: str
        """
        return self._addr

    @addr.setter
    def addr(self, addr):
        """Sets the addr of this Node.

        Internal IP address of node  # noqa: E501

        :param addr: The addr of this Node.  # noqa: E501
        :type: str
        """

        self._addr = addr

    @property
    def architecture(self):
        """Gets the architecture of this Node.  # noqa: E501

        Hardware architecture  # noqa: E501

        :return: The architecture of this Node.  # noqa: E501
        :rtype: str
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """Sets the architecture of this Node.

        Hardware architecture  # noqa: E501

        :param architecture: The architecture of this Node.  # noqa: E501
        :type: str
        """

        self._architecture = architecture

    @property
    def bigredis_storage_path(self):
        """Gets the bigredis_storage_path of this Node.  # noqa: E501

        Flash storage path  # noqa: E501

        :return: The bigredis_storage_path of this Node.  # noqa: E501
        :rtype: str
        """
        return self._bigredis_storage_path

    @bigredis_storage_path.setter
    def bigredis_storage_path(self, bigredis_storage_path):
        """Sets the bigredis_storage_path of this Node.

        Flash storage path  # noqa: E501

        :param bigredis_storage_path: The bigredis_storage_path of this Node.  # noqa: E501
        :type: str
        """

        self._bigredis_storage_path = bigredis_storage_path

    @property
    def bigstore_driver(self):
        """Gets the bigstore_driver of this Node.  # noqa: E501

        Bigstore driver name or none  # noqa: E501

        :return: The bigstore_driver of this Node.  # noqa: E501
        :rtype: str
        """
        return self._bigstore_driver

    @bigstore_driver.setter
    def bigstore_driver(self, bigstore_driver):
        """Sets the bigstore_driver of this Node.

        Bigstore driver name or none  # noqa: E501

        :param bigstore_driver: The bigstore_driver of this Node.  # noqa: E501
        :type: str
        """
        allowed_values = ["ibm-capi-ga1", "ibm-capi-ga2", "ibm-capi-ga4", "rocksdb"]  # noqa: E501
        if bigstore_driver not in allowed_values:
            raise ValueError(
                "Invalid value for `bigstore_driver` ({0}), must be one of {1}"  # noqa: E501
                .format(bigstore_driver, allowed_values)
            )

        self._bigstore_driver = bigstore_driver

    @property
    def bigstore_size(self):
        """Gets the bigstore_size of this Node.  # noqa: E501

        Storage size of bigstore storage  # noqa: E501

        :return: The bigstore_size of this Node.  # noqa: E501
        :rtype: str
        """
        return self._bigstore_size

    @bigstore_size.setter
    def bigstore_size(self, bigstore_size):
        """Sets the bigstore_size of this Node.

        Storage size of bigstore storage  # noqa: E501

        :param bigstore_size: The bigstore_size of this Node.  # noqa: E501
        :type: str
        """

        self._bigstore_size = bigstore_size

    @property
    def cores(self):
        """Gets the cores of this Node.  # noqa: E501

        Total number of CPU cores  # noqa: E501

        :return: The cores of this Node.  # noqa: E501
        :rtype: int
        """
        return self._cores

    @cores.setter
    def cores(self, cores):
        """Sets the cores of this Node.

        Total number of CPU cores  # noqa: E501

        :param cores: The cores of this Node.  # noqa: E501
        :type: int
        """

        self._cores = cores

    @property
    def ephemeral_storage_path(self):
        """Gets the ephemeral_storage_path of this Node.  # noqa: E501

        Ephemeral storage path  # noqa: E501

        :return: The ephemeral_storage_path of this Node.  # noqa: E501
        :rtype: str
        """
        return self._ephemeral_storage_path

    @ephemeral_storage_path.setter
    def ephemeral_storage_path(self, ephemeral_storage_path):
        """Sets the ephemeral_storage_path of this Node.

        Ephemeral storage path  # noqa: E501

        :param ephemeral_storage_path: The ephemeral_storage_path of this Node.  # noqa: E501
        :type: str
        """

        self._ephemeral_storage_path = ephemeral_storage_path

    @property
    def ephemeral_storage_size(self):
        """Gets the ephemeral_storage_size of this Node.  # noqa: E501

        Ephemeral storage size (bytes)  # noqa: E501

        :return: The ephemeral_storage_size of this Node.  # noqa: E501
        :rtype: float
        """
        return self._ephemeral_storage_size

    @ephemeral_storage_size.setter
    def ephemeral_storage_size(self, ephemeral_storage_size):
        """Sets the ephemeral_storage_size of this Node.

        Ephemeral storage size (bytes)  # noqa: E501

        :param ephemeral_storage_size: The ephemeral_storage_size of this Node.  # noqa: E501
        :type: float
        """

        self._ephemeral_storage_size = ephemeral_storage_size

    @property
    def external_addr(self):
        """Gets the external_addr of this Node.  # noqa: E501

        External IP addresses of node. GET /jsonschema to retrieve the object's structure.  # noqa: E501

        :return: The external_addr of this Node.  # noqa: E501
        :rtype: OneOfnodeExternalAddr
        """
        return self._external_addr

    @external_addr.setter
    def external_addr(self, external_addr):
        """Sets the external_addr of this Node.

        External IP addresses of node. GET /jsonschema to retrieve the object's structure.  # noqa: E501

        :param external_addr: The external_addr of this Node.  # noqa: E501
        :type: OneOfnodeExternalAddr
        """

        self._external_addr = external_addr

    @property
    def max_listeners(self):
        """Gets the max_listeners of this Node.  # noqa: E501

        Maximal number of listeners on the node  # noqa: E501

        :return: The max_listeners of this Node.  # noqa: E501
        :rtype: int
        """
        return self._max_listeners

    @max_listeners.setter
    def max_listeners(self, max_listeners):
        """Sets the max_listeners of this Node.

        Maximal number of listeners on the node  # noqa: E501

        :param max_listeners: The max_listeners of this Node.  # noqa: E501
        :type: int
        """

        self._max_listeners = max_listeners

    @property
    def max_redis_servers(self):
        """Gets the max_redis_servers of this Node.  # noqa: E501

        Maximal number of shards on the node  # noqa: E501

        :return: The max_redis_servers of this Node.  # noqa: E501
        :rtype: int
        """
        return self._max_redis_servers

    @max_redis_servers.setter
    def max_redis_servers(self, max_redis_servers):
        """Sets the max_redis_servers of this Node.

        Maximal number of shards on the node  # noqa: E501

        :param max_redis_servers: The max_redis_servers of this Node.  # noqa: E501
        :type: int
        """

        self._max_redis_servers = max_redis_servers

    @property
    def os_name(self):
        """Gets the os_name of this Node.  # noqa: E501

        OS name only  # noqa: E501

        :return: The os_name of this Node.  # noqa: E501
        :rtype: str
        """
        return self._os_name

    @os_name.setter
    def os_name(self, os_name):
        """Sets the os_name of this Node.

        OS name only  # noqa: E501

        :param os_name: The os_name of this Node.  # noqa: E501
        :type: str
        """

        self._os_name = os_name

    @property
    def os_semantic_version(self):
        """Gets the os_semantic_version of this Node.  # noqa: E501

        Full version number  # noqa: E501

        :return: The os_semantic_version of this Node.  # noqa: E501
        :rtype: str
        """
        return self._os_semantic_version

    @os_semantic_version.setter
    def os_semantic_version(self, os_semantic_version):
        """Sets the os_semantic_version of this Node.

        Full version number  # noqa: E501

        :param os_semantic_version: The os_semantic_version of this Node.  # noqa: E501
        :type: str
        """

        self._os_semantic_version = os_semantic_version

    @property
    def os_version(self):
        """Gets the os_version of this Node.  # noqa: E501

        Installed OS version (human readable)  # noqa: E501

        :return: The os_version of this Node.  # noqa: E501
        :rtype: str
        """
        return self._os_version

    @os_version.setter
    def os_version(self, os_version):
        """Sets the os_version of this Node.

        Installed OS version (human readable)  # noqa: E501

        :param os_version: The os_version of this Node.  # noqa: E501
        :type: str
        """

        self._os_version = os_version

    @property
    def persistent_storage_path(self):
        """Gets the persistent_storage_path of this Node.  # noqa: E501

        Persistent storage path  # noqa: E501

        :return: The persistent_storage_path of this Node.  # noqa: E501
        :rtype: str
        """
        return self._persistent_storage_path

    @persistent_storage_path.setter
    def persistent_storage_path(self, persistent_storage_path):
        """Sets the persistent_storage_path of this Node.

        Persistent storage path  # noqa: E501

        :param persistent_storage_path: The persistent_storage_path of this Node.  # noqa: E501
        :type: str
        """

        self._persistent_storage_path = persistent_storage_path

    @property
    def persistent_storage_size(self):
        """Gets the persistent_storage_size of this Node.  # noqa: E501

        Persistent storage size (bytes)  # noqa: E501

        :return: The persistent_storage_size of this Node.  # noqa: E501
        :rtype: float
        """
        return self._persistent_storage_size

    @persistent_storage_size.setter
    def persistent_storage_size(self, persistent_storage_size):
        """Sets the persistent_storage_size of this Node.

        Persistent storage size (bytes)  # noqa: E501

        :param persistent_storage_size: The persistent_storage_size of this Node.  # noqa: E501
        :type: float
        """

        self._persistent_storage_size = persistent_storage_size

    @property
    def public_addr(self):
        """Gets the public_addr of this Node.  # noqa: E501

        Public IP address of node  # noqa: E501

        :return: The public_addr of this Node.  # noqa: E501
        :rtype: str
        """
        return self._public_addr

    @public_addr.setter
    def public_addr(self, public_addr):
        """Sets the public_addr of this Node.

        Public IP address of node  # noqa: E501

        :param public_addr: The public_addr of this Node.  # noqa: E501
        :type: str
        """

        self._public_addr = public_addr

    @property
    def rack_id(self):
        """Gets the rack_id of this Node.  # noqa: E501

        Rack ID where node is installed  # noqa: E501

        :return: The rack_id of this Node.  # noqa: E501
        :rtype: str
        """
        return self._rack_id

    @rack_id.setter
    def rack_id(self, rack_id):
        """Sets the rack_id of this Node.

        Rack ID where node is installed  # noqa: E501

        :param rack_id: The rack_id of this Node.  # noqa: E501
        :type: str
        """

        self._rack_id = rack_id

    @property
    def recovery_path(self):
        """Gets the recovery_path of this Node.  # noqa: E501

        Recovery files path  # noqa: E501

        :return: The recovery_path of this Node.  # noqa: E501
        :rtype: str
        """
        return self._recovery_path

    @recovery_path.setter
    def recovery_path(self, recovery_path):
        """Sets the recovery_path of this Node.

        Recovery files path  # noqa: E501

        :param recovery_path: The recovery_path of this Node.  # noqa: E501
        :type: str
        """

        self._recovery_path = recovery_path

    @property
    def shard_count(self):
        """Gets the shard_count of this Node.  # noqa: E501

        Number of shards on the node  # noqa: E501

        :return: The shard_count of this Node.  # noqa: E501
        :rtype: int
        """
        return self._shard_count

    @shard_count.setter
    def shard_count(self, shard_count):
        """Sets the shard_count of this Node.

        Number of shards on the node  # noqa: E501

        :param shard_count: The shard_count of this Node.  # noqa: E501
        :type: int
        """

        self._shard_count = shard_count

    @property
    def shard_list(self):
        """Gets the shard_list of this Node.  # noqa: E501

        Cluster unique IDs of all node shards.  # noqa: E501

        :return: The shard_list of this Node.  # noqa: E501
        :rtype: list[int]
        """
        return self._shard_list

    @shard_list.setter
    def shard_list(self, shard_list):
        """Sets the shard_list of this Node.

        Cluster unique IDs of all node shards.  # noqa: E501

        :param shard_list: The shard_list of this Node.  # noqa: E501
        :type: list[int]
        """

        self._shard_list = shard_list

    @property
    def software_version(self):
        """Gets the software_version of this Node.  # noqa: E501

        Installed Redis Labs cluster software version  # noqa: E501

        :return: The software_version of this Node.  # noqa: E501
        :rtype: str
        """
        return self._software_version

    @software_version.setter
    def software_version(self, software_version):
        """Sets the software_version of this Node.

        Installed Redis Labs cluster software version  # noqa: E501

        :param software_version: The software_version of this Node.  # noqa: E501
        :type: str
        """

        self._software_version = software_version

    @property
    def status(self):
        """Gets the status of this Node.  # noqa: E501

        Node status  # noqa: E501

        :return: The status of this Node.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Node.

        Node status  # noqa: E501

        :param status: The status of this Node.  # noqa: E501
        :type: str
        """
        allowed_values = ["active", "provisioning", "decommissioning", "down"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def supported_database_versions(self):
        """Gets the supported_database_versions of this Node.  # noqa: E501

        Versions of open source databases supported by Redis Labs software on the node  # noqa: E501

        :return: The supported_database_versions of this Node.  # noqa: E501
        :rtype: list[NodeSupportedDatabaseVersions]
        """
        return self._supported_database_versions

    @supported_database_versions.setter
    def supported_database_versions(self, supported_database_versions):
        """Sets the supported_database_versions of this Node.

        Versions of open source databases supported by Redis Labs software on the node  # noqa: E501

        :param supported_database_versions: The supported_database_versions of this Node.  # noqa: E501
        :type: list[NodeSupportedDatabaseVersions]
        """

        self._supported_database_versions = supported_database_versions

    @property
    def system_time(self):
        """Gets the system_time of this Node.  # noqa: E501

        System time (UTC)  # noqa: E501

        :return: The system_time of this Node.  # noqa: E501
        :rtype: datetime
        """
        return self._system_time

    @system_time.setter
    def system_time(self, system_time):
        """Sets the system_time of this Node.

        System time (UTC)  # noqa: E501

        :param system_time: The system_time of this Node.  # noqa: E501
        :type: datetime
        """

        self._system_time = system_time

    @property
    def total_memory(self):
        """Gets the total_memory of this Node.  # noqa: E501

        Total memory of node (bytes)  # noqa: E501

        :return: The total_memory of this Node.  # noqa: E501
        :rtype: int
        """
        return self._total_memory

    @total_memory.setter
    def total_memory(self, total_memory):
        """Sets the total_memory of this Node.

        Total memory of node (bytes)  # noqa: E501

        :param total_memory: The total_memory of this Node.  # noqa: E501
        :type: int
        """

        self._total_memory = total_memory

    @property
    def uid(self):
        """Gets the uid of this Node.  # noqa: E501

        Cluster unique ID of node  # noqa: E501

        :return: The uid of this Node.  # noqa: E501
        :rtype: int
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this Node.

        Cluster unique ID of node  # noqa: E501

        :param uid: The uid of this Node.  # noqa: E501
        :type: int
        """

        self._uid = uid

    @property
    def uptime(self):
        """Gets the uptime of this Node.  # noqa: E501

        System uptime (seconds)   # noqa: E501

        :return: The uptime of this Node.  # noqa: E501
        :rtype: int
        """
        return self._uptime

    @uptime.setter
    def uptime(self, uptime):
        """Sets the uptime of this Node.

        System uptime (seconds)   # noqa: E501

        :param uptime: The uptime of this Node.  # noqa: E501
        :type: int
        """

        self._uptime = uptime

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Node, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Node):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
