# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Module(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'architecture': 'str',
        'author': 'str',
        'capabilities': 'list[str]',
        'command_line_args': 'str',
        'config_command': 'str',
        'module_dependencies': 'ModuleModuleDependencies',
        'description': 'str',
        'display_name': 'str',
        'email': 'str',
        'homepage': 'str',
        'is_bundled': 'bool',
        'license': 'str',
        'min_redis_pack_version': 'str',
        'min_redis_version': 'str',
        'module_file': 'str',
        'module_name': 'str',
        'os': 'str',
        'os_list': 'list[str]',
        'semantic_version': 'str',
        'sha256': 'str',
        'uid': 'str',
        'version': 'float'
    }

    attribute_map = {
        'architecture': 'architecture',
        'author': 'author',
        'capabilities': 'capabilities',
        'command_line_args': 'command_line_args',
        'config_command': 'config_command',
        'module_dependencies': 'module_dependencies',
        'description': 'description',
        'display_name': 'display_name',
        'email': 'email',
        'homepage': 'homepage',
        'is_bundled': 'is_bundled',
        'license': 'license',
        'min_redis_pack_version': 'min_redis_pack_version',
        'min_redis_version': 'min_redis_version',
        'module_file': 'module_file',
        'module_name': 'module_name',
        'os': 'os',
        'os_list': 'os_list',
        'semantic_version': 'semantic_version',
        'sha256': 'sha256',
        'uid': 'uid',
        'version': 'version'
    }

    def __init__(self, architecture=None, author=None, capabilities=None, command_line_args=None, config_command=None, module_dependencies=None, description=None, display_name=None, email=None, homepage=None, is_bundled=None, license=None, min_redis_pack_version=None, min_redis_version=None, module_file=None, module_name=None, os=None, os_list=None, semantic_version=None, sha256=None, uid=None, version=None):  # noqa: E501
        """Module - a model defined in Swagger"""  # noqa: E501
        self._architecture = None
        self._author = None
        self._capabilities = None
        self._command_line_args = None
        self._config_command = None
        self._module_dependencies = None
        self._description = None
        self._display_name = None
        self._email = None
        self._homepage = None
        self._is_bundled = None
        self._license = None
        self._min_redis_pack_version = None
        self._min_redis_version = None
        self._module_file = None
        self._module_name = None
        self._os = None
        self._os_list = None
        self._semantic_version = None
        self._sha256 = None
        self._uid = None
        self._version = None
        self.discriminator = None
        if architecture is not None:
            self.architecture = architecture
        if author is not None:
            self.author = author
        if capabilities is not None:
            self.capabilities = capabilities
        if command_line_args is not None:
            self.command_line_args = command_line_args
        if config_command is not None:
            self.config_command = config_command
        if module_dependencies is not None:
            self.module_dependencies = module_dependencies
        if description is not None:
            self.description = description
        if display_name is not None:
            self.display_name = display_name
        if email is not None:
            self.email = email
        if homepage is not None:
            self.homepage = homepage
        if is_bundled is not None:
            self.is_bundled = is_bundled
        if license is not None:
            self.license = license
        if min_redis_pack_version is not None:
            self.min_redis_pack_version = min_redis_pack_version
        if min_redis_version is not None:
            self.min_redis_version = min_redis_version
        if module_file is not None:
            self.module_file = module_file
        if module_name is not None:
            self.module_name = module_name
        if os is not None:
            self.os = os
        if os_list is not None:
            self.os_list = os_list
        if semantic_version is not None:
            self.semantic_version = semantic_version
        if sha256 is not None:
            self.sha256 = sha256
        if uid is not None:
            self.uid = uid
        if version is not None:
            self.version = version

    @property
    def architecture(self):
        """Gets the architecture of this Module.  # noqa: E501

        Module was compiled under this architecture  # noqa: E501

        :return: The architecture of this Module.  # noqa: E501
        :rtype: str
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """Sets the architecture of this Module.

        Module was compiled under this architecture  # noqa: E501

        :param architecture: The architecture of this Module.  # noqa: E501
        :type: str
        """

        self._architecture = architecture

    @property
    def author(self):
        """Gets the author of this Module.  # noqa: E501

        Who created this module  # noqa: E501

        :return: The author of this Module.  # noqa: E501
        :rtype: str
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this Module.

        Who created this module  # noqa: E501

        :param author: The author of this Module.  # noqa: E501
        :type: str
        """

        self._author = author

    @property
    def capabilities(self):
        """Gets the capabilities of this Module.  # noqa: E501

        List of capabilities supported by this module  # noqa: E501

        :return: The capabilities of this Module.  # noqa: E501
        :rtype: list[str]
        """
        return self._capabilities

    @capabilities.setter
    def capabilities(self, capabilities):
        """Sets the capabilities of this Module.

        List of capabilities supported by this module  # noqa: E501

        :param capabilities: The capabilities of this Module.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["types", "no_multi_key", "replica_of", "backup_restore", "eviction_expiry", "reshard_rebalance", "failover_migrate", "persistence_aof", "persistence_rdb", "hash_policy", "flash", "crdb", "clustering", "intershard_tls"]  # noqa: E501
        if not set(capabilities).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `capabilities` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(capabilities) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._capabilities = capabilities

    @property
    def command_line_args(self):
        """Gets the command_line_args of this Module.  # noqa: E501

        Command line arguments passed to the module  # noqa: E501

        :return: The command_line_args of this Module.  # noqa: E501
        :rtype: str
        """
        return self._command_line_args

    @command_line_args.setter
    def command_line_args(self, command_line_args):
        """Sets the command_line_args of this Module.

        Command line arguments passed to the module  # noqa: E501

        :param command_line_args: The command_line_args of this Module.  # noqa: E501
        :type: str
        """

        self._command_line_args = command_line_args

    @property
    def config_command(self):
        """Gets the config_command of this Module.  # noqa: E501

        Name of command to configure module arguments at runtime  # noqa: E501

        :return: The config_command of this Module.  # noqa: E501
        :rtype: str
        """
        return self._config_command

    @config_command.setter
    def config_command(self, config_command):
        """Sets the config_command of this Module.

        Name of command to configure module arguments at runtime  # noqa: E501

        :param config_command: The config_command of this Module.  # noqa: E501
        :type: str
        """

        self._config_command = config_command

    @property
    def module_dependencies(self):
        """Gets the module_dependencies of this Module.  # noqa: E501


        :return: The module_dependencies of this Module.  # noqa: E501
        :rtype: ModuleModuleDependencies
        """
        return self._module_dependencies

    @module_dependencies.setter
    def module_dependencies(self, module_dependencies):
        """Sets the module_dependencies of this Module.


        :param module_dependencies: The module_dependencies of this Module.  # noqa: E501
        :type: ModuleModuleDependencies
        """

        self._module_dependencies = module_dependencies

    @property
    def description(self):
        """Gets the description of this Module.  # noqa: E501

        Short description of the module  # noqa: E501

        :return: The description of this Module.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Module.

        Short description of the module  # noqa: E501

        :param description: The description of this Module.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def display_name(self):
        """Gets the display_name of this Module.  # noqa: E501

        Name of module for display purposes  # noqa: E501

        :return: The display_name of this Module.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this Module.

        Name of module for display purposes  # noqa: E501

        :param display_name: The display_name of this Module.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    @property
    def email(self):
        """Gets the email of this Module.  # noqa: E501

        Author's email address  # noqa: E501

        :return: The email of this Module.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Module.

        Author's email address  # noqa: E501

        :param email: The email of this Module.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def homepage(self):
        """Gets the homepage of this Module.  # noqa: E501

        Module's Homepage  # noqa: E501

        :return: The homepage of this Module.  # noqa: E501
        :rtype: str
        """
        return self._homepage

    @homepage.setter
    def homepage(self, homepage):
        """Sets the homepage of this Module.

        Module's Homepage  # noqa: E501

        :param homepage: The homepage of this Module.  # noqa: E501
        :type: str
        """

        self._homepage = homepage

    @property
    def is_bundled(self):
        """Gets the is_bundled of this Module.  # noqa: E501

        Whether module came bundled with a version of Redis Enterprise  # noqa: E501

        :return: The is_bundled of this Module.  # noqa: E501
        :rtype: bool
        """
        return self._is_bundled

    @is_bundled.setter
    def is_bundled(self, is_bundled):
        """Sets the is_bundled of this Module.

        Whether module came bundled with a version of Redis Enterprise  # noqa: E501

        :param is_bundled: The is_bundled of this Module.  # noqa: E501
        :type: bool
        """

        self._is_bundled = is_bundled

    @property
    def license(self):
        """Gets the license of this Module.  # noqa: E501

        Module is distributed under this license  # noqa: E501

        :return: The license of this Module.  # noqa: E501
        :rtype: str
        """
        return self._license

    @license.setter
    def license(self, license):
        """Sets the license of this Module.

        Module is distributed under this license  # noqa: E501

        :param license: The license of this Module.  # noqa: E501
        :type: str
        """

        self._license = license

    @property
    def min_redis_pack_version(self):
        """Gets the min_redis_pack_version of this Module.  # noqa: E501

        Minimum redis pack version required by this module  # noqa: E501

        :return: The min_redis_pack_version of this Module.  # noqa: E501
        :rtype: str
        """
        return self._min_redis_pack_version

    @min_redis_pack_version.setter
    def min_redis_pack_version(self, min_redis_pack_version):
        """Sets the min_redis_pack_version of this Module.

        Minimum redis pack version required by this module  # noqa: E501

        :param min_redis_pack_version: The min_redis_pack_version of this Module.  # noqa: E501
        :type: str
        """

        self._min_redis_pack_version = min_redis_pack_version

    @property
    def min_redis_version(self):
        """Gets the min_redis_version of this Module.  # noqa: E501

        Minimum Redis version required by this module  # noqa: E501

        :return: The min_redis_version of this Module.  # noqa: E501
        :rtype: str
        """
        return self._min_redis_version

    @min_redis_version.setter
    def min_redis_version(self, min_redis_version):
        """Sets the min_redis_version of this Module.

        Minimum Redis version required by this module  # noqa: E501

        :param min_redis_version: The min_redis_version of this Module.  # noqa: E501
        :type: str
        """

        self._min_redis_version = min_redis_version

    @property
    def module_file(self):
        """Gets the module_file of this Module.  # noqa: E501

        Module file name  # noqa: E501

        :return: The module_file of this Module.  # noqa: E501
        :rtype: str
        """
        return self._module_file

    @module_file.setter
    def module_file(self, module_file):
        """Sets the module_file of this Module.

        Module file name  # noqa: E501

        :param module_file: The module_file of this Module.  # noqa: E501
        :type: str
        """

        self._module_file = module_file

    @property
    def module_name(self):
        """Gets the module_name of this Module.  # noqa: E501

        Module's name  # noqa: E501

        :return: The module_name of this Module.  # noqa: E501
        :rtype: str
        """
        return self._module_name

    @module_name.setter
    def module_name(self, module_name):
        """Sets the module_name of this Module.

        Module's name  # noqa: E501

        :param module_name: The module_name of this Module.  # noqa: E501
        :type: str
        """

        self._module_name = module_name

    @property
    def os(self):
        """Gets the os of this Module.  # noqa: E501

        OS on which this module was compiled on  # noqa: E501

        :return: The os of this Module.  # noqa: E501
        :rtype: str
        """
        return self._os

    @os.setter
    def os(self, os):
        """Sets the os of this Module.

        OS on which this module was compiled on  # noqa: E501

        :param os: The os of this Module.  # noqa: E501
        :type: str
        """

        self._os = os

    @property
    def os_list(self):
        """Gets the os_list of this Module.  # noqa: E501

        List of OSes the module supports  # noqa: E501

        :return: The os_list of this Module.  # noqa: E501
        :rtype: list[str]
        """
        return self._os_list

    @os_list.setter
    def os_list(self, os_list):
        """Sets the os_list of this Module.

        List of OSes the module supports  # noqa: E501

        :param os_list: The os_list of this Module.  # noqa: E501
        :type: list[str]
        """

        self._os_list = os_list

    @property
    def semantic_version(self):
        """Gets the semantic_version of this Module.  # noqa: E501

        Module's semantic version  # noqa: E501

        :return: The semantic_version of this Module.  # noqa: E501
        :rtype: str
        """
        return self._semantic_version

    @semantic_version.setter
    def semantic_version(self, semantic_version):
        """Sets the semantic_version of this Module.

        Module's semantic version  # noqa: E501

        :param semantic_version: The semantic_version of this Module.  # noqa: E501
        :type: str
        """

        self._semantic_version = semantic_version

    @property
    def sha256(self):
        """Gets the sha256 of this Module.  # noqa: E501

        SHA256 of module binary  # noqa: E501

        :return: The sha256 of this Module.  # noqa: E501
        :rtype: str
        """
        return self._sha256

    @sha256.setter
    def sha256(self, sha256):
        """Sets the sha256 of this Module.

        SHA256 of module binary  # noqa: E501

        :param sha256: The sha256 of this Module.  # noqa: E501
        :type: str
        """

        self._sha256 = sha256

    @property
    def uid(self):
        """Gets the uid of this Module.  # noqa: E501

        Cluster unique ID of module  # noqa: E501

        :return: The uid of this Module.  # noqa: E501
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this Module.

        Cluster unique ID of module  # noqa: E501

        :param uid: The uid of this Module.  # noqa: E501
        :type: str
        """

        self._uid = uid

    @property
    def version(self):
        """Gets the version of this Module.  # noqa: E501

        Module's version  # noqa: E501

        :return: The version of this Module.  # noqa: E501
        :rtype: float
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Module.

        Module's version  # noqa: E501

        :param version: The version of this Module.  # noqa: E501
        :type: float
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Module, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Module):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
