# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Ldap(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bind_dn': 'str',
        'bind_pass': 'str',
        'ca_cert': 'str',
        'cache_ttl': 'int',
        'control_plane': 'bool',
        'data_plane': 'bool',
        'dn_group_attr': 'str',
        'dn_group_query': 'LdapQuery',
        'starttls': 'bool',
        'uris': 'list[str]',
        'user_dn_query': 'LdapQuery',
        'user_dn_template': 'str'
    }

    attribute_map = {
        'bind_dn': 'bind_dn',
        'bind_pass': 'bind_pass',
        'ca_cert': 'ca_cert',
        'cache_ttl': 'cache_ttl',
        'control_plane': 'control_plane',
        'data_plane': 'data_plane',
        'dn_group_attr': 'dn_group_attr',
        'dn_group_query': 'dn_group_query',
        'starttls': 'starttls',
        'uris': 'uris',
        'user_dn_query': 'user_dn_query',
        'user_dn_template': 'user_dn_template'
    }

    def __init__(self, bind_dn=None, bind_pass=None, ca_cert=None, cache_ttl=300, control_plane=False, data_plane=False, dn_group_attr=None, dn_group_query=None, starttls=False, uris=None, user_dn_query=None, user_dn_template=None):  # noqa: E501
        """Ldap - a model defined in Swagger"""  # noqa: E501
        self._bind_dn = None
        self._bind_pass = None
        self._ca_cert = None
        self._cache_ttl = None
        self._control_plane = None
        self._data_plane = None
        self._dn_group_attr = None
        self._dn_group_query = None
        self._starttls = None
        self._uris = None
        self._user_dn_query = None
        self._user_dn_template = None
        self.discriminator = None
        if bind_dn is not None:
            self.bind_dn = bind_dn
        if bind_pass is not None:
            self.bind_pass = bind_pass
        if ca_cert is not None:
            self.ca_cert = ca_cert
        if cache_ttl is not None:
            self.cache_ttl = cache_ttl
        if control_plane is not None:
            self.control_plane = control_plane
        if data_plane is not None:
            self.data_plane = data_plane
        if dn_group_attr is not None:
            self.dn_group_attr = dn_group_attr
        if dn_group_query is not None:
            self.dn_group_query = dn_group_query
        if starttls is not None:
            self.starttls = starttls
        if uris is not None:
            self.uris = uris
        if user_dn_query is not None:
            self.user_dn_query = user_dn_query
        if user_dn_template is not None:
            self.user_dn_template = user_dn_template

    @property
    def bind_dn(self):
        """Gets the bind_dn of this Ldap.  # noqa: E501

        A DN to use when binding with the LDAP server to run queries  # noqa: E501

        :return: The bind_dn of this Ldap.  # noqa: E501
        :rtype: str
        """
        return self._bind_dn

    @bind_dn.setter
    def bind_dn(self, bind_dn):
        """Sets the bind_dn of this Ldap.

        A DN to use when binding with the LDAP server to run queries  # noqa: E501

        :param bind_dn: The bind_dn of this Ldap.  # noqa: E501
        :type: str
        """

        self._bind_dn = bind_dn

    @property
    def bind_pass(self):
        """Gets the bind_pass of this Ldap.  # noqa: E501

        A password to use when binding with the LDAP server to run queries  # noqa: E501

        :return: The bind_pass of this Ldap.  # noqa: E501
        :rtype: str
        """
        return self._bind_pass

    @bind_pass.setter
    def bind_pass(self, bind_pass):
        """Sets the bind_pass of this Ldap.

        A password to use when binding with the LDAP server to run queries  # noqa: E501

        :param bind_pass: The bind_pass of this Ldap.  # noqa: E501
        :type: str
        """

        self._bind_pass = bind_pass

    @property
    def ca_cert(self):
        """Gets the ca_cert of this Ldap.  # noqa: E501

        A PEM-encoded CA certificate(s) to use for validating TLS connections to the LDAP server  # noqa: E501

        :return: The ca_cert of this Ldap.  # noqa: E501
        :rtype: str
        """
        return self._ca_cert

    @ca_cert.setter
    def ca_cert(self, ca_cert):
        """Sets the ca_cert of this Ldap.

        A PEM-encoded CA certificate(s) to use for validating TLS connections to the LDAP server  # noqa: E501

        :param ca_cert: The ca_cert of this Ldap.  # noqa: E501
        :type: str
        """

        self._ca_cert = ca_cert

    @property
    def cache_ttl(self):
        """Gets the cache_ttl of this Ldap.  # noqa: E501

        Maximum TTL of cached entries, in seconds  # noqa: E501

        :return: The cache_ttl of this Ldap.  # noqa: E501
        :rtype: int
        """
        return self._cache_ttl

    @cache_ttl.setter
    def cache_ttl(self, cache_ttl):
        """Sets the cache_ttl of this Ldap.

        Maximum TTL of cached entries, in seconds  # noqa: E501

        :param cache_ttl: The cache_ttl of this Ldap.  # noqa: E501
        :type: int
        """

        self._cache_ttl = cache_ttl

    @property
    def control_plane(self):
        """Gets the control_plane of this Ldap.  # noqa: E501

        Whether to use LDAP for user authentication/authorization in the control-plane  # noqa: E501

        :return: The control_plane of this Ldap.  # noqa: E501
        :rtype: bool
        """
        return self._control_plane

    @control_plane.setter
    def control_plane(self, control_plane):
        """Sets the control_plane of this Ldap.

        Whether to use LDAP for user authentication/authorization in the control-plane  # noqa: E501

        :param control_plane: The control_plane of this Ldap.  # noqa: E501
        :type: bool
        """

        self._control_plane = control_plane

    @property
    def data_plane(self):
        """Gets the data_plane of this Ldap.  # noqa: E501

        Whether to use LDAP for user authentication/authorization in the data-plane  # noqa: E501

        :return: The data_plane of this Ldap.  # noqa: E501
        :rtype: bool
        """
        return self._data_plane

    @data_plane.setter
    def data_plane(self, data_plane):
        """Sets the data_plane of this Ldap.

        Whether to use LDAP for user authentication/authorization in the data-plane  # noqa: E501

        :param data_plane: The data_plane of this Ldap.  # noqa: E501
        :type: bool
        """

        self._data_plane = data_plane

    @property
    def dn_group_attr(self):
        """Gets the dn_group_attr of this Ldap.  # noqa: E501

        The name of an attribute of the LDAP user entity that contains a list of the groups that user belongs to. (Mutually exclusive with \\\"dn_group_query\\\")  # noqa: E501

        :return: The dn_group_attr of this Ldap.  # noqa: E501
        :rtype: str
        """
        return self._dn_group_attr

    @dn_group_attr.setter
    def dn_group_attr(self, dn_group_attr):
        """Sets the dn_group_attr of this Ldap.

        The name of an attribute of the LDAP user entity that contains a list of the groups that user belongs to. (Mutually exclusive with \\\"dn_group_query\\\")  # noqa: E501

        :param dn_group_attr: The dn_group_attr of this Ldap.  # noqa: E501
        :type: str
        """

        self._dn_group_attr = dn_group_attr

    @property
    def dn_group_query(self):
        """Gets the dn_group_query of this Ldap.  # noqa: E501


        :return: The dn_group_query of this Ldap.  # noqa: E501
        :rtype: LdapQuery
        """
        return self._dn_group_query

    @dn_group_query.setter
    def dn_group_query(self, dn_group_query):
        """Sets the dn_group_query of this Ldap.


        :param dn_group_query: The dn_group_query of this Ldap.  # noqa: E501
        :type: LdapQuery
        """

        self._dn_group_query = dn_group_query

    @property
    def starttls(self):
        """Gets the starttls of this Ldap.  # noqa: E501

        Whether to use StartTLS negotiation for the LDAP connection  # noqa: E501

        :return: The starttls of this Ldap.  # noqa: E501
        :rtype: bool
        """
        return self._starttls

    @starttls.setter
    def starttls(self, starttls):
        """Sets the starttls of this Ldap.

        Whether to use StartTLS negotiation for the LDAP connection  # noqa: E501

        :param starttls: The starttls of this Ldap.  # noqa: E501
        :type: bool
        """

        self._starttls = starttls

    @property
    def uris(self):
        """Gets the uris of this Ldap.  # noqa: E501

        URIs of LDAP servers containing only the schema, the host, and the port  # noqa: E501

        :return: The uris of this Ldap.  # noqa: E501
        :rtype: list[str]
        """
        return self._uris

    @uris.setter
    def uris(self, uris):
        """Sets the uris of this Ldap.

        URIs of LDAP servers containing only the schema, the host, and the port  # noqa: E501

        :param uris: The uris of this Ldap.  # noqa: E501
        :type: list[str]
        """

        self._uris = uris

    @property
    def user_dn_query(self):
        """Gets the user_dn_query of this Ldap.  # noqa: E501


        :return: The user_dn_query of this Ldap.  # noqa: E501
        :rtype: LdapQuery
        """
        return self._user_dn_query

    @user_dn_query.setter
    def user_dn_query(self, user_dn_query):
        """Sets the user_dn_query of this Ldap.


        :param user_dn_query: The user_dn_query of this Ldap.  # noqa: E501
        :type: LdapQuery
        """

        self._user_dn_query = user_dn_query

    @property
    def user_dn_template(self):
        """Gets the user_dn_template of this Ldap.  # noqa: E501

        A string template that maps between the username provided to the cluster for authentication, and the LDAP DN. The special substring \"%u\" shall be replaced with the username. (Mutually exclusive with \"user_dn_query\")  # noqa: E501

        :return: The user_dn_template of this Ldap.  # noqa: E501
        :rtype: str
        """
        return self._user_dn_template

    @user_dn_template.setter
    def user_dn_template(self, user_dn_template):
        """Sets the user_dn_template of this Ldap.

        A string template that maps between the username provided to the cluster for authentication, and the LDAP DN. The special substring \"%u\" shall be replaced with the username. (Mutually exclusive with \"user_dn_query\")  # noqa: E501

        :param user_dn_template: The user_dn_template of this Ldap.  # noqa: E501
        :type: str
        """

        self._user_dn_template = user_dn_template

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Ldap, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Ldap):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
