# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ClusterInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'url': 'str',
        'replication_endpoint': 'str',
        'replication_tls_sni': 'str',
        'credentials': 'Credentials'
    }

    attribute_map = {
        'name': 'name',
        'url': 'url',
        'replication_endpoint': 'replication_endpoint',
        'replication_tls_sni': 'replication_tls_sni',
        'credentials': 'credentials'
    }

    def __init__(self, name=None, url=None, replication_endpoint=None, replication_tls_sni=None, credentials=None):  # noqa: E501
        """ClusterInfo - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._url = None
        self._replication_endpoint = None
        self._replication_tls_sni = None
        self._credentials = None
        self.discriminator = None
        if name is not None:
            self.name = name
        if url is not None:
            self.url = url
        if replication_endpoint is not None:
            self.replication_endpoint = replication_endpoint
        if replication_tls_sni is not None:
            self.replication_tls_sni = replication_tls_sni
        if credentials is not None:
            self.credentials = credentials

    @property
    def name(self):
        """Gets the name of this ClusterInfo.  # noqa: E501

        Cluster fully qualified name, used to unique identify the cluster.  Typically this is the same as the hostname used in the URL, although in some configruations the URL may point to a different name/address.  # noqa: E501

        :return: The name of this ClusterInfo.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ClusterInfo.

        Cluster fully qualified name, used to unique identify the cluster.  Typically this is the same as the hostname used in the URL, although in some configruations the URL may point to a different name/address.  # noqa: E501

        :param name: The name of this ClusterInfo.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def url(self):
        """Gets the url of this ClusterInfo.  # noqa: E501

        Cluster access URL.  # noqa: E501

        :return: The url of this ClusterInfo.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ClusterInfo.

        Cluster access URL.  # noqa: E501

        :param url: The url of this ClusterInfo.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def replication_endpoint(self):
        """Gets the replication_endpoint of this ClusterInfo.  # noqa: E501

        Address to use for peer replication.  If not specified, it is assumed that standard cluster naming conventions apply.  # noqa: E501

        :return: The replication_endpoint of this ClusterInfo.  # noqa: E501
        :rtype: str
        """
        return self._replication_endpoint

    @replication_endpoint.setter
    def replication_endpoint(self, replication_endpoint):
        """Sets the replication_endpoint of this ClusterInfo.

        Address to use for peer replication.  If not specified, it is assumed that standard cluster naming conventions apply.  # noqa: E501

        :param replication_endpoint: The replication_endpoint of this ClusterInfo.  # noqa: E501
        :type: str
        """

        self._replication_endpoint = replication_endpoint

    @property
    def replication_tls_sni(self):
        """Gets the replication_tls_sni of this ClusterInfo.  # noqa: E501

        Cluster SNI for TLS connections.  # noqa: E501

        :return: The replication_tls_sni of this ClusterInfo.  # noqa: E501
        :rtype: str
        """
        return self._replication_tls_sni

    @replication_tls_sni.setter
    def replication_tls_sni(self, replication_tls_sni):
        """Sets the replication_tls_sni of this ClusterInfo.

        Cluster SNI for TLS connections.  # noqa: E501

        :param replication_tls_sni: The replication_tls_sni of this ClusterInfo.  # noqa: E501
        :type: str
        """

        self._replication_tls_sni = replication_tls_sni

    @property
    def credentials(self):
        """Gets the credentials of this ClusterInfo.  # noqa: E501


        :return: The credentials of this ClusterInfo.  # noqa: E501
        :rtype: Credentials
        """
        return self._credentials

    @credentials.setter
    def credentials(self, credentials):
        """Sets the credentials of this ClusterInfo.


        :param credentials: The credentials of this ClusterInfo.  # noqa: E501
        :type: Credentials
        """

        self._credentials = credentials

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ClusterInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
