# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Cluster(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alert_settings': 'ClusterAlertSettings',
        'cluster_ssh_public_key': 'str',
        'cm_port': 'int',
        'cm_session_timeout_minutes': 'int',
        'cnm_http_port': 'int',
        'cnm_https_port': 'int',
        'control_cipher_suites': 'str',
        'crdt_rest_client_retries': 'int',
        'crdt_rest_client_timeout': 'int',
        'created_time': 'datetime',
        'data_cipher_list': 'str',
        'debuginfo_path': 'str',
        'default_non_sharded_proxy_policy': 'str',
        'default_sharded_proxy_policy': 'str',
        'email_alerts': 'bool',
        'email_from': 'str',
        'envoy_max_downstream_connections': 'int',
        'handle_redirects': 'bool',
        'http_support': 'bool',
        'min_control_tls_version': 'str',
        'min_data_tls_version': 'str',
        'min_sentinel_tls_version': 'str',
        'name': 'str',
        'password_complexity': 'bool',
        'password_expiration_duration': 'int',
        'proxy_certificate': 'str',
        'proxy_max_ccs_disconnection_time': 'int',
        'rack_aware': 'bool',
        's3_url': 'str',
        'saslauthd_ldap_conf': 'str',
        'sentinel_cipher_suites': 'list[str]',
        'sentinel_ssl_policy': 'str',
        'slave_ha': 'bool',
        'slave_ha_bdb_cooldown_period': 'int',
        'slave_ha_cooldown_period': 'int',
        'slave_ha_grace_period': 'int',
        'slowlog_in_sanitized_support': 'bool',
        'smtp_host': 'str',
        'smtp_password': 'str',
        'smtp_port': 'int',
        'smtp_tls_mode': 'str',
        'smtp_use_tls': 'bool',
        'smtp_username': 'str',
        'syncer_certificate': 'str',
        'upgrade_mode': 'bool',
        'use_ipv6': 'bool',
        'wait_command': 'bool'
    }

    attribute_map = {
        'alert_settings': 'alert_settings',
        'cluster_ssh_public_key': 'cluster_ssh_public_key',
        'cm_port': 'cm_port',
        'cm_session_timeout_minutes': 'cm_session_timeout_minutes',
        'cnm_http_port': 'cnm_http_port',
        'cnm_https_port': 'cnm_https_port',
        'control_cipher_suites': 'control_cipher_suites',
        'crdt_rest_client_retries': 'crdt_rest_client_retries',
        'crdt_rest_client_timeout': 'crdt_rest_client_timeout',
        'created_time': 'created_time',
        'data_cipher_list': 'data_cipher_list',
        'debuginfo_path': 'debuginfo_path',
        'default_non_sharded_proxy_policy': 'default_non_sharded_proxy_policy',
        'default_sharded_proxy_policy': 'default_sharded_proxy_policy',
        'email_alerts': 'email_alerts',
        'email_from': 'email_from',
        'envoy_max_downstream_connections': 'envoy_max_downstream_connections',
        'handle_redirects': 'handle_redirects',
        'http_support': 'http_support',
        'min_control_tls_version': 'min_control_TLS_version',
        'min_data_tls_version': 'min_data_TLS_version',
        'min_sentinel_tls_version': 'min_sentinel_TLS_version',
        'name': 'name',
        'password_complexity': 'password_complexity',
        'password_expiration_duration': 'password_expiration_duration',
        'proxy_certificate': 'proxy_certificate',
        'proxy_max_ccs_disconnection_time': 'proxy_max_ccs_disconnection_time',
        'rack_aware': 'rack_aware',
        's3_url': 's3_url',
        'saslauthd_ldap_conf': 'saslauthd_ldap_conf',
        'sentinel_cipher_suites': 'sentinel_cipher_suites',
        'sentinel_ssl_policy': 'sentinel_ssl_policy',
        'slave_ha': 'slave_ha',
        'slave_ha_bdb_cooldown_period': 'slave_ha_bdb_cooldown_period',
        'slave_ha_cooldown_period': 'slave_ha_cooldown_period',
        'slave_ha_grace_period': 'slave_ha_grace_period',
        'slowlog_in_sanitized_support': 'slowlog_in_sanitized_support',
        'smtp_host': 'smtp_host',
        'smtp_password': 'smtp_password',
        'smtp_port': 'smtp_port',
        'smtp_tls_mode': 'smtp_tls_mode',
        'smtp_use_tls': 'smtp_use_tls',
        'smtp_username': 'smtp_username',
        'syncer_certificate': 'syncer_certificate',
        'upgrade_mode': 'upgrade_mode',
        'use_ipv6': 'use_ipv6',
        'wait_command': 'wait_command'
    }

    def __init__(self, alert_settings=None, cluster_ssh_public_key=None, cm_port=None, cm_session_timeout_minutes=None, cnm_http_port=None, cnm_https_port=None, control_cipher_suites=None, crdt_rest_client_retries=None, crdt_rest_client_timeout=None, created_time=None, data_cipher_list=None, debuginfo_path=None, default_non_sharded_proxy_policy='single', default_sharded_proxy_policy='all-master-shards', email_alerts=False, email_from=None, envoy_max_downstream_connections=None, handle_redirects=False, http_support=False, min_control_tls_version=None, min_data_tls_version=None, min_sentinel_tls_version=None, name=None, password_complexity=False, password_expiration_duration=None, proxy_certificate=None, proxy_max_ccs_disconnection_time=None, rack_aware=None, s3_url=None, saslauthd_ldap_conf=None, sentinel_cipher_suites=None, sentinel_ssl_policy=None, slave_ha=False, slave_ha_bdb_cooldown_period=86400, slave_ha_cooldown_period=3600, slave_ha_grace_period=900, slowlog_in_sanitized_support=None, smtp_host=None, smtp_password=None, smtp_port=None, smtp_tls_mode=None, smtp_use_tls=False, smtp_username=None, syncer_certificate=None, upgrade_mode=False, use_ipv6=True, wait_command=True):  # noqa: E501
        """Cluster - a model defined in Swagger"""  # noqa: E501
        self._alert_settings = None
        self._cluster_ssh_public_key = None
        self._cm_port = None
        self._cm_session_timeout_minutes = None
        self._cnm_http_port = None
        self._cnm_https_port = None
        self._control_cipher_suites = None
        self._crdt_rest_client_retries = None
        self._crdt_rest_client_timeout = None
        self._created_time = None
        self._data_cipher_list = None
        self._debuginfo_path = None
        self._default_non_sharded_proxy_policy = None
        self._default_sharded_proxy_policy = None
        self._email_alerts = None
        self._email_from = None
        self._envoy_max_downstream_connections = None
        self._handle_redirects = None
        self._http_support = None
        self._min_control_tls_version = None
        self._min_data_tls_version = None
        self._min_sentinel_tls_version = None
        self._name = None
        self._password_complexity = None
        self._password_expiration_duration = None
        self._proxy_certificate = None
        self._proxy_max_ccs_disconnection_time = None
        self._rack_aware = None
        self._s3_url = None
        self._saslauthd_ldap_conf = None
        self._sentinel_cipher_suites = None
        self._sentinel_ssl_policy = None
        self._slave_ha = None
        self._slave_ha_bdb_cooldown_period = None
        self._slave_ha_cooldown_period = None
        self._slave_ha_grace_period = None
        self._slowlog_in_sanitized_support = None
        self._smtp_host = None
        self._smtp_password = None
        self._smtp_port = None
        self._smtp_tls_mode = None
        self._smtp_use_tls = None
        self._smtp_username = None
        self._syncer_certificate = None
        self._upgrade_mode = None
        self._use_ipv6 = None
        self._wait_command = None
        self.discriminator = None
        if alert_settings is not None:
            self.alert_settings = alert_settings
        if cluster_ssh_public_key is not None:
            self.cluster_ssh_public_key = cluster_ssh_public_key
        if cm_port is not None:
            self.cm_port = cm_port
        if cm_session_timeout_minutes is not None:
            self.cm_session_timeout_minutes = cm_session_timeout_minutes
        if cnm_http_port is not None:
            self.cnm_http_port = cnm_http_port
        if cnm_https_port is not None:
            self.cnm_https_port = cnm_https_port
        if control_cipher_suites is not None:
            self.control_cipher_suites = control_cipher_suites
        if crdt_rest_client_retries is not None:
            self.crdt_rest_client_retries = crdt_rest_client_retries
        if crdt_rest_client_timeout is not None:
            self.crdt_rest_client_timeout = crdt_rest_client_timeout
        if created_time is not None:
            self.created_time = created_time
        if data_cipher_list is not None:
            self.data_cipher_list = data_cipher_list
        if debuginfo_path is not None:
            self.debuginfo_path = debuginfo_path
        if default_non_sharded_proxy_policy is not None:
            self.default_non_sharded_proxy_policy = default_non_sharded_proxy_policy
        if default_sharded_proxy_policy is not None:
            self.default_sharded_proxy_policy = default_sharded_proxy_policy
        if email_alerts is not None:
            self.email_alerts = email_alerts
        if email_from is not None:
            self.email_from = email_from
        if envoy_max_downstream_connections is not None:
            self.envoy_max_downstream_connections = envoy_max_downstream_connections
        if handle_redirects is not None:
            self.handle_redirects = handle_redirects
        if http_support is not None:
            self.http_support = http_support
        if min_control_tls_version is not None:
            self.min_control_tls_version = min_control_tls_version
        if min_data_tls_version is not None:
            self.min_data_tls_version = min_data_tls_version
        if min_sentinel_tls_version is not None:
            self.min_sentinel_tls_version = min_sentinel_tls_version
        if name is not None:
            self.name = name
        if password_complexity is not None:
            self.password_complexity = password_complexity
        if password_expiration_duration is not None:
            self.password_expiration_duration = password_expiration_duration
        if proxy_certificate is not None:
            self.proxy_certificate = proxy_certificate
        if proxy_max_ccs_disconnection_time is not None:
            self.proxy_max_ccs_disconnection_time = proxy_max_ccs_disconnection_time
        if rack_aware is not None:
            self.rack_aware = rack_aware
        if s3_url is not None:
            self.s3_url = s3_url
        if saslauthd_ldap_conf is not None:
            self.saslauthd_ldap_conf = saslauthd_ldap_conf
        if sentinel_cipher_suites is not None:
            self.sentinel_cipher_suites = sentinel_cipher_suites
        if sentinel_ssl_policy is not None:
            self.sentinel_ssl_policy = sentinel_ssl_policy
        if slave_ha is not None:
            self.slave_ha = slave_ha
        if slave_ha_bdb_cooldown_period is not None:
            self.slave_ha_bdb_cooldown_period = slave_ha_bdb_cooldown_period
        if slave_ha_cooldown_period is not None:
            self.slave_ha_cooldown_period = slave_ha_cooldown_period
        if slave_ha_grace_period is not None:
            self.slave_ha_grace_period = slave_ha_grace_period
        if slowlog_in_sanitized_support is not None:
            self.slowlog_in_sanitized_support = slowlog_in_sanitized_support
        if smtp_host is not None:
            self.smtp_host = smtp_host
        if smtp_password is not None:
            self.smtp_password = smtp_password
        if smtp_port is not None:
            self.smtp_port = smtp_port
        if smtp_tls_mode is not None:
            self.smtp_tls_mode = smtp_tls_mode
        if smtp_use_tls is not None:
            self.smtp_use_tls = smtp_use_tls
        if smtp_username is not None:
            self.smtp_username = smtp_username
        if syncer_certificate is not None:
            self.syncer_certificate = syncer_certificate
        if upgrade_mode is not None:
            self.upgrade_mode = upgrade_mode
        if use_ipv6 is not None:
            self.use_ipv6 = use_ipv6
        if wait_command is not None:
            self.wait_command = wait_command

    @property
    def alert_settings(self):
        """Gets the alert_settings of this Cluster.  # noqa: E501


        :return: The alert_settings of this Cluster.  # noqa: E501
        :rtype: ClusterAlertSettings
        """
        return self._alert_settings

    @alert_settings.setter
    def alert_settings(self, alert_settings):
        """Sets the alert_settings of this Cluster.


        :param alert_settings: The alert_settings of this Cluster.  # noqa: E501
        :type: ClusterAlertSettings
        """

        self._alert_settings = alert_settings

    @property
    def cluster_ssh_public_key(self):
        """Gets the cluster_ssh_public_key of this Cluster.  # noqa: E501

        Cluster's auto-generated ssh public key  # noqa: E501

        :return: The cluster_ssh_public_key of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._cluster_ssh_public_key

    @cluster_ssh_public_key.setter
    def cluster_ssh_public_key(self, cluster_ssh_public_key):
        """Sets the cluster_ssh_public_key of this Cluster.

        Cluster's auto-generated ssh public key  # noqa: E501

        :param cluster_ssh_public_key: The cluster_ssh_public_key of this Cluster.  # noqa: E501
        :type: str
        """

        self._cluster_ssh_public_key = cluster_ssh_public_key

    @property
    def cm_port(self):
        """Gets the cm_port of this Cluster.  # noqa: E501

        UI HTTPS listening port.  # noqa: E501

        :return: The cm_port of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._cm_port

    @cm_port.setter
    def cm_port(self, cm_port):
        """Sets the cm_port of this Cluster.

        UI HTTPS listening port.  # noqa: E501

        :param cm_port: The cm_port of this Cluster.  # noqa: E501
        :type: int
        """

        self._cm_port = cm_port

    @property
    def cm_session_timeout_minutes(self):
        """Gets the cm_session_timeout_minutes of this Cluster.  # noqa: E501

        The timeout (in minutes) for the session to the CM  # noqa: E501

        :return: The cm_session_timeout_minutes of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._cm_session_timeout_minutes

    @cm_session_timeout_minutes.setter
    def cm_session_timeout_minutes(self, cm_session_timeout_minutes):
        """Sets the cm_session_timeout_minutes of this Cluster.

        The timeout (in minutes) for the session to the CM  # noqa: E501

        :param cm_session_timeout_minutes: The cm_session_timeout_minutes of this Cluster.  # noqa: E501
        :type: int
        """

        self._cm_session_timeout_minutes = cm_session_timeout_minutes

    @property
    def cnm_http_port(self):
        """Gets the cnm_http_port of this Cluster.  # noqa: E501

        API HTTP listening port.  # noqa: E501

        :return: The cnm_http_port of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._cnm_http_port

    @cnm_http_port.setter
    def cnm_http_port(self, cnm_http_port):
        """Sets the cnm_http_port of this Cluster.

        API HTTP listening port.  # noqa: E501

        :param cnm_http_port: The cnm_http_port of this Cluster.  # noqa: E501
        :type: int
        """

        self._cnm_http_port = cnm_http_port

    @property
    def cnm_https_port(self):
        """Gets the cnm_https_port of this Cluster.  # noqa: E501

        API HTTPS listening port.  # noqa: E501

        :return: The cnm_https_port of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._cnm_https_port

    @cnm_https_port.setter
    def cnm_https_port(self, cnm_https_port):
        """Sets the cnm_https_port of this Cluster.

        API HTTPS listening port.  # noqa: E501

        :param cnm_https_port: The cnm_https_port of this Cluster.  # noqa: E501
        :type: int
        """

        self._cnm_https_port = cnm_https_port

    @property
    def control_cipher_suites(self):
        """Gets the control_cipher_suites of this Cluster.  # noqa: E501

        Specifies the enabled ciphers for the control plane. The ciphers are specified in the format understood by the BoringSSL library.  # noqa: E501

        :return: The control_cipher_suites of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._control_cipher_suites

    @control_cipher_suites.setter
    def control_cipher_suites(self, control_cipher_suites):
        """Sets the control_cipher_suites of this Cluster.

        Specifies the enabled ciphers for the control plane. The ciphers are specified in the format understood by the BoringSSL library.  # noqa: E501

        :param control_cipher_suites: The control_cipher_suites of this Cluster.  # noqa: E501
        :type: str
        """

        self._control_cipher_suites = control_cipher_suites

    @property
    def crdt_rest_client_retries(self):
        """Gets the crdt_rest_client_retries of this Cluster.  # noqa: E501

        Maximum number of retries for REST client used by the Active-Active management API.  # noqa: E501

        :return: The crdt_rest_client_retries of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._crdt_rest_client_retries

    @crdt_rest_client_retries.setter
    def crdt_rest_client_retries(self, crdt_rest_client_retries):
        """Sets the crdt_rest_client_retries of this Cluster.

        Maximum number of retries for REST client used by the Active-Active management API.  # noqa: E501

        :param crdt_rest_client_retries: The crdt_rest_client_retries of this Cluster.  # noqa: E501
        :type: int
        """

        self._crdt_rest_client_retries = crdt_rest_client_retries

    @property
    def crdt_rest_client_timeout(self):
        """Gets the crdt_rest_client_timeout of this Cluster.  # noqa: E501

        Timeout for REST client used by the Active-Active management API.  # noqa: E501

        :return: The crdt_rest_client_timeout of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._crdt_rest_client_timeout

    @crdt_rest_client_timeout.setter
    def crdt_rest_client_timeout(self, crdt_rest_client_timeout):
        """Sets the crdt_rest_client_timeout of this Cluster.

        Timeout for REST client used by the Active-Active management API.  # noqa: E501

        :param crdt_rest_client_timeout: The crdt_rest_client_timeout of this Cluster.  # noqa: E501
        :type: int
        """

        self._crdt_rest_client_timeout = crdt_rest_client_timeout

    @property
    def created_time(self):
        """Gets the created_time of this Cluster.  # noqa: E501

        Cluster creation date  # noqa: E501

        :return: The created_time of this Cluster.  # noqa: E501
        :rtype: datetime
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """Sets the created_time of this Cluster.

        Cluster creation date  # noqa: E501

        :param created_time: The created_time of this Cluster.  # noqa: E501
        :type: datetime
        """

        self._created_time = created_time

    @property
    def data_cipher_list(self):
        """Gets the data_cipher_list of this Cluster.  # noqa: E501

        Specifies the enabled ciphers for the data plane. The ciphers are specified in the format understood by the OpenSSL library.  # noqa: E501

        :return: The data_cipher_list of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._data_cipher_list

    @data_cipher_list.setter
    def data_cipher_list(self, data_cipher_list):
        """Sets the data_cipher_list of this Cluster.

        Specifies the enabled ciphers for the data plane. The ciphers are specified in the format understood by the OpenSSL library.  # noqa: E501

        :param data_cipher_list: The data_cipher_list of this Cluster.  # noqa: E501
        :type: str
        """

        self._data_cipher_list = data_cipher_list

    @property
    def debuginfo_path(self):
        """Gets the debuginfo_path of this Cluster.  # noqa: E501

        Path to a local directory used when generating support packages.  # noqa: E501

        :return: The debuginfo_path of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._debuginfo_path

    @debuginfo_path.setter
    def debuginfo_path(self, debuginfo_path):
        """Sets the debuginfo_path of this Cluster.

        Path to a local directory used when generating support packages.  # noqa: E501

        :param debuginfo_path: The debuginfo_path of this Cluster.  # noqa: E501
        :type: str
        """

        self._debuginfo_path = debuginfo_path

    @property
    def default_non_sharded_proxy_policy(self):
        """Gets the default_non_sharded_proxy_policy of this Cluster.  # noqa: E501

        Default proxy_policy for newly-create non sharded databases' endpoints  # noqa: E501

        :return: The default_non_sharded_proxy_policy of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._default_non_sharded_proxy_policy

    @default_non_sharded_proxy_policy.setter
    def default_non_sharded_proxy_policy(self, default_non_sharded_proxy_policy):
        """Sets the default_non_sharded_proxy_policy of this Cluster.

        Default proxy_policy for newly-create non sharded databases' endpoints  # noqa: E501

        :param default_non_sharded_proxy_policy: The default_non_sharded_proxy_policy of this Cluster.  # noqa: E501
        :type: str
        """

        self._default_non_sharded_proxy_policy = default_non_sharded_proxy_policy

    @property
    def default_sharded_proxy_policy(self):
        """Gets the default_sharded_proxy_policy of this Cluster.  # noqa: E501

        Default proxy_policy for newly-create sharded databases' endpoints  # noqa: E501

        :return: The default_sharded_proxy_policy of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._default_sharded_proxy_policy

    @default_sharded_proxy_policy.setter
    def default_sharded_proxy_policy(self, default_sharded_proxy_policy):
        """Sets the default_sharded_proxy_policy of this Cluster.

        Default proxy_policy for newly-create sharded databases' endpoints  # noqa: E501

        :param default_sharded_proxy_policy: The default_sharded_proxy_policy of this Cluster.  # noqa: E501
        :type: str
        """

        self._default_sharded_proxy_policy = default_sharded_proxy_policy

    @property
    def email_alerts(self):
        """Gets the email_alerts of this Cluster.  # noqa: E501

        Send node/clsuter email alerts. Requires valid SMTP and email_from settings.  # noqa: E501

        :return: The email_alerts of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._email_alerts

    @email_alerts.setter
    def email_alerts(self, email_alerts):
        """Sets the email_alerts of this Cluster.

        Send node/clsuter email alerts. Requires valid SMTP and email_from settings.  # noqa: E501

        :param email_alerts: The email_alerts of this Cluster.  # noqa: E501
        :type: bool
        """

        self._email_alerts = email_alerts

    @property
    def email_from(self):
        """Gets the email_from of this Cluster.  # noqa: E501

        Sender email for automated emails  # noqa: E501

        :return: The email_from of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._email_from

    @email_from.setter
    def email_from(self, email_from):
        """Sets the email_from of this Cluster.

        Sender email for automated emails  # noqa: E501

        :param email_from: The email_from of this Cluster.  # noqa: E501
        :type: str
        """

        self._email_from = email_from

    @property
    def envoy_max_downstream_connections(self):
        """Gets the envoy_max_downstream_connections of this Cluster.  # noqa: E501

        The max downstream connections envoy is allowed to open  # noqa: E501

        :return: The envoy_max_downstream_connections of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._envoy_max_downstream_connections

    @envoy_max_downstream_connections.setter
    def envoy_max_downstream_connections(self, envoy_max_downstream_connections):
        """Sets the envoy_max_downstream_connections of this Cluster.

        The max downstream connections envoy is allowed to open  # noqa: E501

        :param envoy_max_downstream_connections: The envoy_max_downstream_connections of this Cluster.  # noqa: E501
        :type: int
        """

        self._envoy_max_downstream_connections = envoy_max_downstream_connections

    @property
    def handle_redirects(self):
        """Gets the handle_redirects of this Cluster.  # noqa: E501

        Handle API HTTPS requests redirect to master node internally.  # noqa: E501

        :return: The handle_redirects of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._handle_redirects

    @handle_redirects.setter
    def handle_redirects(self, handle_redirects):
        """Sets the handle_redirects of this Cluster.

        Handle API HTTPS requests redirect to master node internally.  # noqa: E501

        :param handle_redirects: The handle_redirects of this Cluster.  # noqa: E501
        :type: bool
        """

        self._handle_redirects = handle_redirects

    @property
    def http_support(self):
        """Gets the http_support of this Cluster.  # noqa: E501

        Decide whether to enable or disable HTTP support  # noqa: E501

        :return: The http_support of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._http_support

    @http_support.setter
    def http_support(self, http_support):
        """Sets the http_support of this Cluster.

        Decide whether to enable or disable HTTP support  # noqa: E501

        :param http_support: The http_support of this Cluster.  # noqa: E501
        :type: bool
        """

        self._http_support = http_support

    @property
    def min_control_tls_version(self):
        """Gets the min_control_tls_version of this Cluster.  # noqa: E501

        The minimum version of TLS protocol which is supported at the control path  # noqa: E501

        :return: The min_control_tls_version of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._min_control_tls_version

    @min_control_tls_version.setter
    def min_control_tls_version(self, min_control_tls_version):
        """Sets the min_control_tls_version of this Cluster.

        The minimum version of TLS protocol which is supported at the control path  # noqa: E501

        :param min_control_tls_version: The min_control_tls_version of this Cluster.  # noqa: E501
        :type: str
        """
        allowed_values = ["1", "1.1", "1.2", "1.3"]  # noqa: E501
        if min_control_tls_version not in allowed_values:
            raise ValueError(
                "Invalid value for `min_control_tls_version` ({0}), must be one of {1}"  # noqa: E501
                .format(min_control_tls_version, allowed_values)
            )

        self._min_control_tls_version = min_control_tls_version

    @property
    def min_data_tls_version(self):
        """Gets the min_data_tls_version of this Cluster.  # noqa: E501

        The minimum version of TLS protocol which is supported at the data path.  # noqa: E501

        :return: The min_data_tls_version of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._min_data_tls_version

    @min_data_tls_version.setter
    def min_data_tls_version(self, min_data_tls_version):
        """Sets the min_data_tls_version of this Cluster.

        The minimum version of TLS protocol which is supported at the data path.  # noqa: E501

        :param min_data_tls_version: The min_data_tls_version of this Cluster.  # noqa: E501
        :type: str
        """
        allowed_values = ["1", "1.1", "1.2"]  # noqa: E501
        if min_data_tls_version not in allowed_values:
            raise ValueError(
                "Invalid value for `min_data_tls_version` ({0}), must be one of {1}"  # noqa: E501
                .format(min_data_tls_version, allowed_values)
            )

        self._min_data_tls_version = min_data_tls_version

    @property
    def min_sentinel_tls_version(self):
        """Gets the min_sentinel_tls_version of this Cluster.  # noqa: E501

        The minimum version of TLS protocol which is supported at the data path.  # noqa: E501

        :return: The min_sentinel_tls_version of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._min_sentinel_tls_version

    @min_sentinel_tls_version.setter
    def min_sentinel_tls_version(self, min_sentinel_tls_version):
        """Sets the min_sentinel_tls_version of this Cluster.

        The minimum version of TLS protocol which is supported at the data path.  # noqa: E501

        :param min_sentinel_tls_version: The min_sentinel_tls_version of this Cluster.  # noqa: E501
        :type: str
        """
        allowed_values = ["1", "1.1", "1.2"]  # noqa: E501
        if min_sentinel_tls_version not in allowed_values:
            raise ValueError(
                "Invalid value for `min_sentinel_tls_version` ({0}), must be one of {1}"  # noqa: E501
                .format(min_sentinel_tls_version, allowed_values)
            )

        self._min_sentinel_tls_version = min_sentinel_tls_version

    @property
    def name(self):
        """Gets the name of this Cluster.  # noqa: E501

        Cluster's fully qualified domain name  # noqa: E501

        :return: The name of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Cluster.

        Cluster's fully qualified domain name  # noqa: E501

        :param name: The name of this Cluster.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def password_complexity(self):
        """Gets the password_complexity of this Cluster.  # noqa: E501

        Enforce password complexity policy.  # noqa: E501

        :return: The password_complexity of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._password_complexity

    @password_complexity.setter
    def password_complexity(self, password_complexity):
        """Sets the password_complexity of this Cluster.

        Enforce password complexity policy.  # noqa: E501

        :param password_complexity: The password_complexity of this Cluster.  # noqa: E501
        :type: bool
        """

        self._password_complexity = password_complexity

    @property
    def password_expiration_duration(self):
        """Gets the password_expiration_duration of this Cluster.  # noqa: E501

        The number of days a password is valid until the user is required to replace it.  # noqa: E501

        :return: The password_expiration_duration of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._password_expiration_duration

    @password_expiration_duration.setter
    def password_expiration_duration(self, password_expiration_duration):
        """Sets the password_expiration_duration of this Cluster.

        The number of days a password is valid until the user is required to replace it.  # noqa: E501

        :param password_expiration_duration: The password_expiration_duration of this Cluster.  # noqa: E501
        :type: int
        """

        self._password_expiration_duration = password_expiration_duration

    @property
    def proxy_certificate(self):
        """Gets the proxy_certificate of this Cluster.  # noqa: E501

        Cluster's proxy certificate.  # noqa: E501

        :return: The proxy_certificate of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._proxy_certificate

    @proxy_certificate.setter
    def proxy_certificate(self, proxy_certificate):
        """Sets the proxy_certificate of this Cluster.

        Cluster's proxy certificate.  # noqa: E501

        :param proxy_certificate: The proxy_certificate of this Cluster.  # noqa: E501
        :type: str
        """

        self._proxy_certificate = proxy_certificate

    @property
    def proxy_max_ccs_disconnection_time(self):
        """Gets the proxy_max_ccs_disconnection_time of this Cluster.  # noqa: E501

        Cluster-wide proxy timeout policy between proxy and CCS  # noqa: E501

        :return: The proxy_max_ccs_disconnection_time of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._proxy_max_ccs_disconnection_time

    @proxy_max_ccs_disconnection_time.setter
    def proxy_max_ccs_disconnection_time(self, proxy_max_ccs_disconnection_time):
        """Sets the proxy_max_ccs_disconnection_time of this Cluster.

        Cluster-wide proxy timeout policy between proxy and CCS  # noqa: E501

        :param proxy_max_ccs_disconnection_time: The proxy_max_ccs_disconnection_time of this Cluster.  # noqa: E501
        :type: int
        """

        self._proxy_max_ccs_disconnection_time = proxy_max_ccs_disconnection_time

    @property
    def rack_aware(self):
        """Gets the rack_aware of this Cluster.  # noqa: E501

        Cluster operates in a rack-aware mode  # noqa: E501

        :return: The rack_aware of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._rack_aware

    @rack_aware.setter
    def rack_aware(self, rack_aware):
        """Sets the rack_aware of this Cluster.

        Cluster operates in a rack-aware mode  # noqa: E501

        :param rack_aware: The rack_aware of this Cluster.  # noqa: E501
        :type: bool
        """

        self._rack_aware = rack_aware

    @property
    def s3_url(self):
        """Gets the s3_url of this Cluster.  # noqa: E501

        Specifies the URL for S3 export and import  # noqa: E501

        :return: The s3_url of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._s3_url

    @s3_url.setter
    def s3_url(self, s3_url):
        """Sets the s3_url of this Cluster.

        Specifies the URL for S3 export and import  # noqa: E501

        :param s3_url: The s3_url of this Cluster.  # noqa: E501
        :type: str
        """

        self._s3_url = s3_url

    @property
    def saslauthd_ldap_conf(self):
        """Gets the saslauthd_ldap_conf of this Cluster.  # noqa: E501

        saslauthd ldap configuration.  # noqa: E501

        :return: The saslauthd_ldap_conf of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._saslauthd_ldap_conf

    @saslauthd_ldap_conf.setter
    def saslauthd_ldap_conf(self, saslauthd_ldap_conf):
        """Sets the saslauthd_ldap_conf of this Cluster.

        saslauthd ldap configuration.  # noqa: E501

        :param saslauthd_ldap_conf: The saslauthd_ldap_conf of this Cluster.  # noqa: E501
        :type: str
        """

        self._saslauthd_ldap_conf = saslauthd_ldap_conf

    @property
    def sentinel_cipher_suites(self):
        """Gets the sentinel_cipher_suites of this Cluster.  # noqa: E501

        Specifies the list of enabled ciphers for the sentinel service. The supported ciphers are ones that were implemented by the https://golang.org/src/crypto/tls/cipher_suites.go package.  # noqa: E501

        :return: The sentinel_cipher_suites of this Cluster.  # noqa: E501
        :rtype: list[str]
        """
        return self._sentinel_cipher_suites

    @sentinel_cipher_suites.setter
    def sentinel_cipher_suites(self, sentinel_cipher_suites):
        """Sets the sentinel_cipher_suites of this Cluster.

        Specifies the list of enabled ciphers for the sentinel service. The supported ciphers are ones that were implemented by the https://golang.org/src/crypto/tls/cipher_suites.go package.  # noqa: E501

        :param sentinel_cipher_suites: The sentinel_cipher_suites of this Cluster.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["TLS_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305", "TLS_FALLBACK_SCSV"]  # noqa: E501
        if not set(sentinel_cipher_suites).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `sentinel_cipher_suites` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(sentinel_cipher_suites) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._sentinel_cipher_suites = sentinel_cipher_suites

    @property
    def sentinel_ssl_policy(self):
        """Gets the sentinel_ssl_policy of this Cluster.  # noqa: E501

        Is ssl for the Discovery Service required/disabled/allowed  # noqa: E501

        :return: The sentinel_ssl_policy of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._sentinel_ssl_policy

    @sentinel_ssl_policy.setter
    def sentinel_ssl_policy(self, sentinel_ssl_policy):
        """Sets the sentinel_ssl_policy of this Cluster.

        Is ssl for the Discovery Service required/disabled/allowed  # noqa: E501

        :param sentinel_ssl_policy: The sentinel_ssl_policy of this Cluster.  # noqa: E501
        :type: str
        """
        allowed_values = ["required", "disabled", "allowed"]  # noqa: E501
        if sentinel_ssl_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `sentinel_ssl_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(sentinel_ssl_policy, allowed_values)
            )

        self._sentinel_ssl_policy = sentinel_ssl_policy

    @property
    def slave_ha(self):
        """Gets the slave_ha of this Cluster.  # noqa: E501

        Enable slave high availability mechanism.  # noqa: E501

        :return: The slave_ha of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._slave_ha

    @slave_ha.setter
    def slave_ha(self, slave_ha):
        """Sets the slave_ha of this Cluster.

        Enable slave high availability mechanism.  # noqa: E501

        :param slave_ha: The slave_ha of this Cluster.  # noqa: E501
        :type: bool
        """

        self._slave_ha = slave_ha

    @property
    def slave_ha_bdb_cooldown_period(self):
        """Gets the slave_ha_bdb_cooldown_period of this Cluster.  # noqa: E501

        Time in seconds between runs of slave high availability mechanism, on different nodes, on the same database.  # noqa: E501

        :return: The slave_ha_bdb_cooldown_period of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._slave_ha_bdb_cooldown_period

    @slave_ha_bdb_cooldown_period.setter
    def slave_ha_bdb_cooldown_period(self, slave_ha_bdb_cooldown_period):
        """Sets the slave_ha_bdb_cooldown_period of this Cluster.

        Time in seconds between runs of slave high availability mechanism, on different nodes, on the same database.  # noqa: E501

        :param slave_ha_bdb_cooldown_period: The slave_ha_bdb_cooldown_period of this Cluster.  # noqa: E501
        :type: int
        """

        self._slave_ha_bdb_cooldown_period = slave_ha_bdb_cooldown_period

    @property
    def slave_ha_cooldown_period(self):
        """Gets the slave_ha_cooldown_period of this Cluster.  # noqa: E501

        Time in seconds between runs of slave high availability mechanism, on different nodes.  # noqa: E501

        :return: The slave_ha_cooldown_period of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._slave_ha_cooldown_period

    @slave_ha_cooldown_period.setter
    def slave_ha_cooldown_period(self, slave_ha_cooldown_period):
        """Sets the slave_ha_cooldown_period of this Cluster.

        Time in seconds between runs of slave high availability mechanism, on different nodes.  # noqa: E501

        :param slave_ha_cooldown_period: The slave_ha_cooldown_period of this Cluster.  # noqa: E501
        :type: int
        """

        self._slave_ha_cooldown_period = slave_ha_cooldown_period

    @property
    def slave_ha_grace_period(self):
        """Gets the slave_ha_grace_period of this Cluster.  # noqa: E501

        Time in seconds between when a node fails, and when slave high availability mechanism starts relocating shards.  # noqa: E501

        :return: The slave_ha_grace_period of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._slave_ha_grace_period

    @slave_ha_grace_period.setter
    def slave_ha_grace_period(self, slave_ha_grace_period):
        """Sets the slave_ha_grace_period of this Cluster.

        Time in seconds between when a node fails, and when slave high availability mechanism starts relocating shards.  # noqa: E501

        :param slave_ha_grace_period: The slave_ha_grace_period of this Cluster.  # noqa: E501
        :type: int
        """

        self._slave_ha_grace_period = slave_ha_grace_period

    @property
    def slowlog_in_sanitized_support(self):
        """Gets the slowlog_in_sanitized_support of this Cluster.  # noqa: E501

        Whether to include slowlogs in the sanitized support package  # noqa: E501

        :return: The slowlog_in_sanitized_support of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._slowlog_in_sanitized_support

    @slowlog_in_sanitized_support.setter
    def slowlog_in_sanitized_support(self, slowlog_in_sanitized_support):
        """Sets the slowlog_in_sanitized_support of this Cluster.

        Whether to include slowlogs in the sanitized support package  # noqa: E501

        :param slowlog_in_sanitized_support: The slowlog_in_sanitized_support of this Cluster.  # noqa: E501
        :type: bool
        """

        self._slowlog_in_sanitized_support = slowlog_in_sanitized_support

    @property
    def smtp_host(self):
        """Gets the smtp_host of this Cluster.  # noqa: E501

        SMTP server to use for automated emails  # noqa: E501

        :return: The smtp_host of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._smtp_host

    @smtp_host.setter
    def smtp_host(self, smtp_host):
        """Sets the smtp_host of this Cluster.

        SMTP server to use for automated emails  # noqa: E501

        :param smtp_host: The smtp_host of this Cluster.  # noqa: E501
        :type: str
        """

        self._smtp_host = smtp_host

    @property
    def smtp_password(self):
        """Gets the smtp_password of this Cluster.  # noqa: E501

        SMTP server password  # noqa: E501

        :return: The smtp_password of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._smtp_password

    @smtp_password.setter
    def smtp_password(self, smtp_password):
        """Sets the smtp_password of this Cluster.

        SMTP server password  # noqa: E501

        :param smtp_password: The smtp_password of this Cluster.  # noqa: E501
        :type: str
        """

        self._smtp_password = smtp_password

    @property
    def smtp_port(self):
        """Gets the smtp_port of this Cluster.  # noqa: E501

        SMTP server port for automated emails  # noqa: E501

        :return: The smtp_port of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._smtp_port

    @smtp_port.setter
    def smtp_port(self, smtp_port):
        """Sets the smtp_port of this Cluster.

        SMTP server port for automated emails  # noqa: E501

        :param smtp_port: The smtp_port of this Cluster.  # noqa: E501
        :type: int
        """

        self._smtp_port = smtp_port

    @property
    def smtp_tls_mode(self):
        """Gets the smtp_tls_mode of this Cluster.  # noqa: E501

        Specifcies if and what TLS mode to use for SMTP access  # noqa: E501

        :return: The smtp_tls_mode of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._smtp_tls_mode

    @smtp_tls_mode.setter
    def smtp_tls_mode(self, smtp_tls_mode):
        """Sets the smtp_tls_mode of this Cluster.

        Specifcies if and what TLS mode to use for SMTP access  # noqa: E501

        :param smtp_tls_mode: The smtp_tls_mode of this Cluster.  # noqa: E501
        :type: str
        """

        self._smtp_tls_mode = smtp_tls_mode

    @property
    def smtp_use_tls(self):
        """Gets the smtp_use_tls of this Cluster.  # noqa: E501

        Deprecated, please use smtp_tls_mode field instead. Use TLS for SMTP access  # noqa: E501

        :return: The smtp_use_tls of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._smtp_use_tls

    @smtp_use_tls.setter
    def smtp_use_tls(self, smtp_use_tls):
        """Sets the smtp_use_tls of this Cluster.

        Deprecated, please use smtp_tls_mode field instead. Use TLS for SMTP access  # noqa: E501

        :param smtp_use_tls: The smtp_use_tls of this Cluster.  # noqa: E501
        :type: bool
        """

        self._smtp_use_tls = smtp_use_tls

    @property
    def smtp_username(self):
        """Gets the smtp_username of this Cluster.  # noqa: E501

        SMTP server username (pattern does not allow special characters &,<,>,\\\")  # noqa: E501

        :return: The smtp_username of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._smtp_username

    @smtp_username.setter
    def smtp_username(self, smtp_username):
        """Sets the smtp_username of this Cluster.

        SMTP server username (pattern does not allow special characters &,<,>,\\\")  # noqa: E501

        :param smtp_username: The smtp_username of this Cluster.  # noqa: E501
        :type: str
        """

        self._smtp_username = smtp_username

    @property
    def syncer_certificate(self):
        """Gets the syncer_certificate of this Cluster.  # noqa: E501

        Cluster's syncer certificate.  # noqa: E501

        :return: The syncer_certificate of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._syncer_certificate

    @syncer_certificate.setter
    def syncer_certificate(self, syncer_certificate):
        """Sets the syncer_certificate of this Cluster.

        Cluster's syncer certificate.  # noqa: E501

        :param syncer_certificate: The syncer_certificate of this Cluster.  # noqa: E501
        :type: str
        """

        self._syncer_certificate = syncer_certificate

    @property
    def upgrade_mode(self):
        """Gets the upgrade_mode of this Cluster.  # noqa: E501

        Is cluster currently in upgrade mode.  # noqa: E501

        :return: The upgrade_mode of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._upgrade_mode

    @upgrade_mode.setter
    def upgrade_mode(self, upgrade_mode):
        """Sets the upgrade_mode of this Cluster.

        Is cluster currently in upgrade mode.  # noqa: E501

        :param upgrade_mode: The upgrade_mode of this Cluster.  # noqa: E501
        :type: bool
        """

        self._upgrade_mode = upgrade_mode

    @property
    def use_ipv6(self):
        """Gets the use_ipv6 of this Cluster.  # noqa: E501

        Should redislabs services listen on ipv6.  # noqa: E501

        :return: The use_ipv6 of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._use_ipv6

    @use_ipv6.setter
    def use_ipv6(self, use_ipv6):
        """Sets the use_ipv6 of this Cluster.

        Should redislabs services listen on ipv6.  # noqa: E501

        :param use_ipv6: The use_ipv6 of this Cluster.  # noqa: E501
        :type: bool
        """

        self._use_ipv6 = use_ipv6

    @property
    def wait_command(self):
        """Gets the wait_command of this Cluster.  # noqa: E501

        Support Redis wait command  # noqa: E501

        :return: The wait_command of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._wait_command

    @wait_command.setter
    def wait_command(self, wait_command):
        """Sets the wait_command of this Cluster.

        Support Redis wait command  # noqa: E501

        :param wait_command: The wait_command of this Cluster.  # noqa: E501
        :type: bool
        """

        self._wait_command = wait_command

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Cluster, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Cluster):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
