# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class BdbSyncSources(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'compression': 'int',
        'lag': 'int',
        'last_error': 'str',
        'last_update': 'datetime',
        'rdb_size': 'int',
        'rdb_transferred': 'int',
        'status': 'str',
        'uid': 'int',
        'uri': 'str'
    }

    attribute_map = {
        'compression': 'compression',
        'lag': 'lag',
        'last_error': 'last_error',
        'last_update': 'last_update',
        'rdb_size': 'rdb_size',
        'rdb_transferred': 'rdb_transferred',
        'status': 'status',
        'uid': 'uid',
        'uri': 'uri'
    }

    def __init__(self, compression=None, lag=None, last_error=None, last_update=None, rdb_size=None, rdb_transferred=None, status=None, uid=None, uri=None):  # noqa: E501
        """BdbSyncSources - a model defined in Swagger"""  # noqa: E501
        self._compression = None
        self._lag = None
        self._last_error = None
        self._last_update = None
        self._rdb_size = None
        self._rdb_transferred = None
        self._status = None
        self._uid = None
        self._uri = None
        self.discriminator = None
        if compression is not None:
            self.compression = compression
        if lag is not None:
            self.lag = lag
        if last_error is not None:
            self.last_error = last_error
        if last_update is not None:
            self.last_update = last_update
        if rdb_size is not None:
            self.rdb_size = rdb_size
        if rdb_transferred is not None:
            self.rdb_transferred = rdb_transferred
        if status is not None:
            self.status = status
        if uid is not None:
            self.uid = uid
        if uri is not None:
            self.uri = uri

    @property
    def compression(self):
        """Gets the compression of this BdbSyncSources.  # noqa: E501

        Compression level for the replication link  # noqa: E501

        :return: The compression of this BdbSyncSources.  # noqa: E501
        :rtype: int
        """
        return self._compression

    @compression.setter
    def compression(self, compression):
        """Sets the compression of this BdbSyncSources.

        Compression level for the replication link  # noqa: E501

        :param compression: The compression of this BdbSyncSources.  # noqa: E501
        :type: int
        """

        self._compression = compression

    @property
    def lag(self):
        """Gets the lag of this BdbSyncSources.  # noqa: E501

        Lag in millisec between source and destination (while synced).  # noqa: E501

        :return: The lag of this BdbSyncSources.  # noqa: E501
        :rtype: int
        """
        return self._lag

    @lag.setter
    def lag(self, lag):
        """Sets the lag of this BdbSyncSources.

        Lag in millisec between source and destination (while synced).  # noqa: E501

        :param lag: The lag of this BdbSyncSources.  # noqa: E501
        :type: int
        """

        self._lag = lag

    @property
    def last_error(self):
        """Gets the last_error of this BdbSyncSources.  # noqa: E501

        Last error encountered when syncing from the source.  # noqa: E501

        :return: The last_error of this BdbSyncSources.  # noqa: E501
        :rtype: str
        """
        return self._last_error

    @last_error.setter
    def last_error(self, last_error):
        """Sets the last_error of this BdbSyncSources.

        Last error encountered when syncing from the source.  # noqa: E501

        :param last_error: The last_error of this BdbSyncSources.  # noqa: E501
        :type: str
        """

        self._last_error = last_error

    @property
    def last_update(self):
        """Gets the last_update of this BdbSyncSources.  # noqa: E501

        Time when we last receive an update from the source.  # noqa: E501

        :return: The last_update of this BdbSyncSources.  # noqa: E501
        :rtype: datetime
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        """Sets the last_update of this BdbSyncSources.

        Time when we last receive an update from the source.  # noqa: E501

        :param last_update: The last_update of this BdbSyncSources.  # noqa: E501
        :type: datetime
        """

        self._last_update = last_update

    @property
    def rdb_size(self):
        """Gets the rdb_size of this BdbSyncSources.  # noqa: E501

        The source's RDB size to be transferred during the syncing phase.  # noqa: E501

        :return: The rdb_size of this BdbSyncSources.  # noqa: E501
        :rtype: int
        """
        return self._rdb_size

    @rdb_size.setter
    def rdb_size(self, rdb_size):
        """Sets the rdb_size of this BdbSyncSources.

        The source's RDB size to be transferred during the syncing phase.  # noqa: E501

        :param rdb_size: The rdb_size of this BdbSyncSources.  # noqa: E501
        :type: int
        """

        self._rdb_size = rdb_size

    @property
    def rdb_transferred(self):
        """Gets the rdb_transferred of this BdbSyncSources.  # noqa: E501

        Number of bytes transferred from the source's RDB during the syncing phase.  # noqa: E501

        :return: The rdb_transferred of this BdbSyncSources.  # noqa: E501
        :rtype: int
        """
        return self._rdb_transferred

    @rdb_transferred.setter
    def rdb_transferred(self, rdb_transferred):
        """Sets the rdb_transferred of this BdbSyncSources.

        Number of bytes transferred from the source's RDB during the syncing phase.  # noqa: E501

        :param rdb_transferred: The rdb_transferred of this BdbSyncSources.  # noqa: E501
        :type: int
        """

        self._rdb_transferred = rdb_transferred

    @property
    def status(self):
        """Gets the status of this BdbSyncSources.  # noqa: E501

        Sync status of this source  # noqa: E501

        :return: The status of this BdbSyncSources.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BdbSyncSources.

        Sync status of this source  # noqa: E501

        :param status: The status of this BdbSyncSources.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def uid(self):
        """Gets the uid of this BdbSyncSources.  # noqa: E501

        Numeric unique identification of this source  # noqa: E501

        :return: The uid of this BdbSyncSources.  # noqa: E501
        :rtype: int
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this BdbSyncSources.

        Numeric unique identification of this source  # noqa: E501

        :param uid: The uid of this BdbSyncSources.  # noqa: E501
        :type: int
        """

        self._uid = uid

    @property
    def uri(self):
        """Gets the uri of this BdbSyncSources.  # noqa: E501

        Source redis URI  # noqa: E501

        :return: The uri of this BdbSyncSources.  # noqa: E501
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """Sets the uri of this BdbSyncSources.

        Source redis URI  # noqa: E501

        :param uri: The uri of this BdbSyncSources.  # noqa: E501
        :type: str
        """

        self._uri = uri

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BdbSyncSources, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BdbSyncSources):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
