# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class BdbEndpoints(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'addr': 'list[OneOfbdbEndpointsAddrItems]',
        'addr_type': 'str',
        'dns_name': 'str',
        'exclude_proxies': 'list[str]',
        'include_proxies': 'list[str]',
        'oss_cluster_api_preferred_ip_type': 'str',
        'port': 'int',
        'proxy_policy': 'str',
        'uid': 'str'
    }

    attribute_map = {
        'addr': 'addr',
        'addr_type': 'addr_type',
        'dns_name': 'dns_name',
        'exclude_proxies': 'exclude_proxies',
        'include_proxies': 'include_proxies',
        'oss_cluster_api_preferred_ip_type': 'oss_cluster_api_preferred_ip_type',
        'port': 'port',
        'proxy_policy': 'proxy_policy',
        'uid': 'uid'
    }

    def __init__(self, addr=None, addr_type=None, dns_name=None, exclude_proxies=None, include_proxies=None, oss_cluster_api_preferred_ip_type='internal', port=None, proxy_policy=None, uid=None):  # noqa: E501
        """BdbEndpoints - a model defined in Swagger"""  # noqa: E501
        self._addr = None
        self._addr_type = None
        self._dns_name = None
        self._exclude_proxies = None
        self._include_proxies = None
        self._oss_cluster_api_preferred_ip_type = None
        self._port = None
        self._proxy_policy = None
        self._uid = None
        self.discriminator = None
        if addr is not None:
            self.addr = addr
        if addr_type is not None:
            self.addr_type = addr_type
        if dns_name is not None:
            self.dns_name = dns_name
        if exclude_proxies is not None:
            self.exclude_proxies = exclude_proxies
        if include_proxies is not None:
            self.include_proxies = include_proxies
        if oss_cluster_api_preferred_ip_type is not None:
            self.oss_cluster_api_preferred_ip_type = oss_cluster_api_preferred_ip_type
        if port is not None:
            self.port = port
        if proxy_policy is not None:
            self.proxy_policy = proxy_policy
        if uid is not None:
            self.uid = uid

    @property
    def addr(self):
        """Gets the addr of this BdbEndpoints.  # noqa: E501

        Endpoint's accessible addresses  # noqa: E501

        :return: The addr of this BdbEndpoints.  # noqa: E501
        :rtype: list[OneOfbdbEndpointsAddrItems]
        """
        return self._addr

    @addr.setter
    def addr(self, addr):
        """Sets the addr of this BdbEndpoints.

        Endpoint's accessible addresses  # noqa: E501

        :param addr: The addr of this BdbEndpoints.  # noqa: E501
        :type: list[OneOfbdbEndpointsAddrItems]
        """

        self._addr = addr

    @property
    def addr_type(self):
        """Gets the addr_type of this BdbEndpoints.  # noqa: E501

        Indicates if the endpoint is based on internal or external IPs  # noqa: E501

        :return: The addr_type of this BdbEndpoints.  # noqa: E501
        :rtype: str
        """
        return self._addr_type

    @addr_type.setter
    def addr_type(self, addr_type):
        """Sets the addr_type of this BdbEndpoints.

        Indicates if the endpoint is based on internal or external IPs  # noqa: E501

        :param addr_type: The addr_type of this BdbEndpoints.  # noqa: E501
        :type: str
        """
        allowed_values = ["internal", "external"]  # noqa: E501
        if addr_type not in allowed_values:
            raise ValueError(
                "Invalid value for `addr_type` ({0}), must be one of {1}"  # noqa: E501
                .format(addr_type, allowed_values)
            )

        self._addr_type = addr_type

    @property
    def dns_name(self):
        """Gets the dns_name of this BdbEndpoints.  # noqa: E501

        Endpoint's DNS name  # noqa: E501

        :return: The dns_name of this BdbEndpoints.  # noqa: E501
        :rtype: str
        """
        return self._dns_name

    @dns_name.setter
    def dns_name(self, dns_name):
        """Sets the dns_name of this BdbEndpoints.

        Endpoint's DNS name  # noqa: E501

        :param dns_name: The dns_name of this BdbEndpoints.  # noqa: E501
        :type: str
        """

        self._dns_name = dns_name

    @property
    def exclude_proxies(self):
        """Gets the exclude_proxies of this BdbEndpoints.  # noqa: E501

        List of proxies to exclude  # noqa: E501

        :return: The exclude_proxies of this BdbEndpoints.  # noqa: E501
        :rtype: list[str]
        """
        return self._exclude_proxies

    @exclude_proxies.setter
    def exclude_proxies(self, exclude_proxies):
        """Sets the exclude_proxies of this BdbEndpoints.

        List of proxies to exclude  # noqa: E501

        :param exclude_proxies: The exclude_proxies of this BdbEndpoints.  # noqa: E501
        :type: list[str]
        """

        self._exclude_proxies = exclude_proxies

    @property
    def include_proxies(self):
        """Gets the include_proxies of this BdbEndpoints.  # noqa: E501

        List of proxies to include  # noqa: E501

        :return: The include_proxies of this BdbEndpoints.  # noqa: E501
        :rtype: list[str]
        """
        return self._include_proxies

    @include_proxies.setter
    def include_proxies(self, include_proxies):
        """Sets the include_proxies of this BdbEndpoints.

        List of proxies to include  # noqa: E501

        :param include_proxies: The include_proxies of this BdbEndpoints.  # noqa: E501
        :type: list[str]
        """

        self._include_proxies = include_proxies

    @property
    def oss_cluster_api_preferred_ip_type(self):
        """Gets the oss_cluster_api_preferred_ip_type of this BdbEndpoints.  # noqa: E501

        Indicates preferred ip type in oss cluster API: internal/external  # noqa: E501

        :return: The oss_cluster_api_preferred_ip_type of this BdbEndpoints.  # noqa: E501
        :rtype: str
        """
        return self._oss_cluster_api_preferred_ip_type

    @oss_cluster_api_preferred_ip_type.setter
    def oss_cluster_api_preferred_ip_type(self, oss_cluster_api_preferred_ip_type):
        """Sets the oss_cluster_api_preferred_ip_type of this BdbEndpoints.

        Indicates preferred ip type in oss cluster API: internal/external  # noqa: E501

        :param oss_cluster_api_preferred_ip_type: The oss_cluster_api_preferred_ip_type of this BdbEndpoints.  # noqa: E501
        :type: str
        """
        allowed_values = ["internal", "external"]  # noqa: E501
        if oss_cluster_api_preferred_ip_type not in allowed_values:
            raise ValueError(
                "Invalid value for `oss_cluster_api_preferred_ip_type` ({0}), must be one of {1}"  # noqa: E501
                .format(oss_cluster_api_preferred_ip_type, allowed_values)
            )

        self._oss_cluster_api_preferred_ip_type = oss_cluster_api_preferred_ip_type

    @property
    def port(self):
        """Gets the port of this BdbEndpoints.  # noqa: E501

        Endpoint's TCP port number  # noqa: E501

        :return: The port of this BdbEndpoints.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this BdbEndpoints.

        Endpoint's TCP port number  # noqa: E501

        :param port: The port of this BdbEndpoints.  # noqa: E501
        :type: int
        """

        self._port = port

    @property
    def proxy_policy(self):
        """Gets the proxy_policy of this BdbEndpoints.  # noqa: E501

        The policy used for proxy binding to the endpoint  # noqa: E501

        :return: The proxy_policy of this BdbEndpoints.  # noqa: E501
        :rtype: str
        """
        return self._proxy_policy

    @proxy_policy.setter
    def proxy_policy(self, proxy_policy):
        """Sets the proxy_policy of this BdbEndpoints.

        The policy used for proxy binding to the endpoint  # noqa: E501

        :param proxy_policy: The proxy_policy of this BdbEndpoints.  # noqa: E501
        :type: str
        """
        allowed_values = ["single", "all-master-shards", "all-nodes"]  # noqa: E501
        if proxy_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `proxy_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(proxy_policy, allowed_values)
            )

        self._proxy_policy = proxy_policy

    @property
    def uid(self):
        """Gets the uid of this BdbEndpoints.  # noqa: E501

        Unique identification of this source  # noqa: E501

        :return: The uid of this BdbEndpoints.  # noqa: E501
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this BdbEndpoints.

        Unique identification of this source  # noqa: E501

        :param uid: The uid of this BdbEndpoints.  # noqa: E501
        :type: str
        """

        self._uid = uid

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BdbEndpoints, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BdbEndpoints):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
