/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { Project } from "projen";
import { PythonProject, PythonProjectOptions } from "projen/lib/python";
import { OpenApiGatewayProjectOptions } from "./types";
/**
 * Configuration for the OpenApiGatewayPythonProject
 */
export interface OpenApiGatewayPythonProjectOptions extends PythonProjectOptions, OpenApiGatewayProjectOptions {
}
/**
 * Synthesizes a Python Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid open-api-gateway-py
 */
export declare class OpenApiGatewayPythonProject extends PythonProject {
    /**
     * A reference to the generated python client
     */
    readonly generatedPythonClient: PythonProject;
    /**
     * References to the client projects that were generated, keyed by language
     */
    readonly generatedClients: {
        [language: string]: Project;
    };
    /**
     * The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir
     */
    readonly specDir: string;
    /**
     * The directory in which the api generated code will reside, relative to the project srcdir
     */
    readonly apiSrcDir: string;
    /**
     * The name of the spec file
     */
    readonly specFileName: string;
    /**
     * The directory in which generated client code will be generated, relative to the outdir of this project
     */
    readonly generatedCodeDir: string;
    /**
     * Force to generate code and docs even if there were no changes in spec
     */
    readonly forceGenerateCodeAndDocs?: boolean;
    private readonly hasParent;
    constructor(options: OpenApiGatewayPythonProjectOptions);
}
