"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParsedSpec = void 0;
const path = require("path");
const projen_1 = require("projen");
const util_1 = require("projen/lib/util");
/**
 * Component for parsing the yaml OpenAPI spec as a single json object, resolving references etc.
 */
class ParsedSpec extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    static parse(specPath, outputPath) {
        // Parse the spec and write to the target output path
        util_1.exec(`./parse-openapi-spec --specPath=${specPath} --outputPath=${outputPath}`, {
            cwd: path.resolve(__dirname, "..", "..", "..", "..", "scripts", "parser"),
        });
    }
    synthesize() {
        super.synthesize();
        ParsedSpec.parse(this.options.specPath, this.options.outputPath);
    }
}
exports.ParsedSpec = ParsedSpec;
//# sourceMappingURL=data:application/json;base64,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