// Adapted from https://gist.github.com/magican/5574556 by minrk
// https://github.com/minrk/ipython_extensions See the history of contributions
// in README.md
// joan test

define([
    'require'
    , 'jquery'
    , 'base/js/namespace'
    , 'base/js/events'
    , 'notebook/js/codecell'
    , 'nbextensions/visualpython/src/vp'
    , 'nbextensions/visualpython/src/common/vpCommon'
    , 'nbextensions/visualpython/src/common/StringBuilder'
    , 'nbextensions/visualpython/src/common/constant'
], function (requirejs, $, Jupyter, events, codecell, vp, vpCommon, sb, vpConst) {
    "use strict";

    /* 전역 변수 영역 */
    const origin = window.location.origin;
    const connectorAddress = `${origin}` + vpConst.PATH_SEPARATOR + vpConst.BASE_PATH;

    // imports
    var IPython = Jupyter;

    /* 함수 영역 */
    /**
     * 익스텐션 로드(시작점)
     */
    var load_ipython_extension = function () {
        load_css();

        // Wait for the notebook to be fully loaded
        // 쥬피터 노트북 로딩되지 않았으면 로딩후 호출되도록 이벤트에 바인딩
        if (Jupyter.notebook !== undefined && Jupyter.notebook._fully_loaded) {
            // this tests if the notebook is fully loaded
            console.log("[vp] Notebook fully loaded -- vp initialized ")
            vp_init();
        } else {
            console.log("[vp] Waiting for notebook availability")
            events.on("notebook_loaded.Notebook", function () {
                console.log("[vp] vp initialized (via notebook_loaded)")
                vp_init();
            })
        }
    };

    /**
     * 메인 style 로드
     */
    var load_css = function () {
        var link = document.createElement("link");
        link.type = "text/css";
        link.rel = "stylesheet";
        link.href = requirejs.toUrl(connectorAddress + vpConst.STYLE_PATH + vpConst.MAIN_CSS_URL);
        document.getElementsByTagName("head")[0].appendChild(link);
    };

    /**
     * 비주얼 파이선 초기화
     */
    var vp_init = function () {
        // read configuration, then call vp
        IPython.notebook.config.loaded.then(function () {
            var cfg = vp.readConfig();
            // // create highlights style section in document
            // create_additional_css(cfg);
            // // add vp toggle button (now that cfg has loaded)
            // addToolBarVpButton(cfg);
            // call main function with newly loaded config
            vp.vpInit(cfg);
            // event: render vp for each markdown cell modification
            // events.on("rendered.MarkdownCell", function (evt, data) {
            //     table_of_contents(cfg); // recompute the vp
            //     //rehighlight_running_cells() // re-highlight running cells
            //     //highlight_vp_item(evt, data); // and of course the one currently rendered
            // });
        });
    };

    return { load_ipython_extension: load_ipython_extension };

});
