define([
    'jquery'

], function ( $) {
    //FIXME: 추후 소스 전체 리펙토링

    var init = function(){
        // commonApi
        var getUUID = function() {
            return ([1e7]+-1e3+-4e3+-8e3+-1e11).replace(/[018]/g, c =>
                (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)
            );
        }

        // stateApi
        /** findStateValue 함수
        *  state를 while루프로 돌면서 돌면서 keyName과 일치하는 state의 value값을 찾아 리턴한다
        *  없으면 null을 리턴한다.
        *  @param {object} state 
        *  @param {string} keyName 
        *  @returns {any | null} returnValueOrNull
        */           
        var findStateValue = function(state, keyName) {
            var result = [];
            var stack = [{ context: result
                        , key: 0
                            , value: state }];
            var currContext;
            var returnValueOrNull = null; 
            while (currContext = stack.pop()) {
                var { context, key, value } = currContext;

                if (!value || typeof value != 'object') {
                    if (key === keyName) {
                        returnValueOrNull = value;
                        break;
                    }
                    
                    context[key] = value; 
                }
                else if (Array.isArray(value)) {
                    if (key === keyName) {
                        returnValueOrNull = value;
                        break;
                    }
            
                } else {
                    if (key === keyName) {
                        returnValueOrNull = value;
                        break;
                    }
                    context = context[key] = Object.create(null);
                    Object.entries(value).forEach(([ key,value ]) => {
                        stack.push({ context, key, value });
                    });
                }
            };
            return returnValueOrNull;
        };

        /** changeOldToNewState 함수
        *  oldState(이전 state 데이터)와 newState(새로운 state 데이터)를 비교해서
            newState로 들어온 새로운 값을 oldState에 덮어 씌운다.
        *  @param {Object} oldState 
        *  @param {Object} newState 
        *  @returns {Object}
        */
        var changeOldToNewState = function(oldState, newState) {
            var result = [];
            var stack = [{ context: result
                            , key: 0
                            , value: oldState }];
            var currContext;
            while (currContext = stack.pop()) {
                var { context, key, value } = currContext;

                if (!value || typeof value != 'object') {
                    var newValue = findStateValue(newState, key);
                    if ( newValue === "") {
                        context[key] = "";
                    }
                    else if (newValue === false) {
                        context[key] = false;
                    }
                    else {
                        context[key] = newValue || value;
                    }
                }
                else if (Array.isArray(value)) {
                    var newValue = findStateValue(newState, key);
                    context[key] = newValue || value;
                } 
                else {
                    context = context[key] = Object.create(null);
                    Object.entries(value).forEach(([ key, value ]) => {
                        stack.push({context, key, value});
                    });
                }
            };
            return result[0];
        };    
        /** updateOneArrayIndexValueAndGetNewArray
            *  배열의 특정 인덱스 값을 업데이트하고 업데이트된 새로운 배열을 리턴한다
            *  @param {Array} array 
            *  @param {number} index
            *  @param {number | string} newValue 
            *  @returns {Array} New array
            */
        var updateOneArrayIndexValueAndGetNewArray = function(array, index, newValue) {
            return [ ...array.slice(0, index), newValue,
                    ...array.slice(index+1, array.length) ]
        }

        /** deleteOneArrayIndexValueAndGetNewArray
        *  배열의 특정 인덱스 값을 삭제하고 삭제된 새로운 배열을 리턴한다
        *  @param {Array} array 
        *  @param {number} index 
        *  @returns {Array} New array
        */
        var deleteOneArrayIndexValueAndGetNewArray = function(array, index) {
            return [ ...array.slice(0, index), 
                    ...array.slice(index+1, array.length) ]
        }

        /** updateTwoArrayIndexValueAndGetNewArray
        *  2차원 배열의 특정 인덱스 값을 업데이트하고 업데이트된 새로운 배열을 리턴한다
        *  @param {Array} array 
        *  @param {number} row
        *  @param {number} col
        *  @param {number | string} newValue 
        *  @returns {Array} New array
        */
        var updateTwoArrayIndexValueAndGetNewArray = function(twoarray, row, col, newValue) {
            var newArray = [...twoarray[row].slice(0, col),newValue,
                            ...twoarray[row].slice(col + 1, twoarray[row].length)]
            return [ ...twoarray.slice(0, row), newArray,
                    ...twoarray.slice(row+1, twoarray.length) ]
        }
        /** deleteTwoArrayIndexValueAndGetNewArray
        *  2차원 배열의 특정 인덱스 값을 삭제하고 삭제된 새로운 배열을 리턴한다
        *  @param {Array} array 
        *  @param {number} row 
        *  @param {number} col
        *  @returns {Array} New array
        */
        var deleteTwoArrayIndexValueAndGetNewArray = function(twoarray, row, col) {
            var newArray = [...twoarray[row].slice(0, col),
                            ...twoarray[row].slice(col + 1, twoarray[row].length)]
            return [ ...twoarray.slice(0, row), newArray,
                    ...twoarray.slice(row+1, twoarray.length) ]
        }

        var mapTypeToName = function(type) {
            var name = ``;
            switch (type) {
                case 1: {
                    name = 'class';
                    break;
                }
                case 2: {
                    name = 'def';
                    break;
                }
                case 3: {
                    name = 'if';
                    break;
                }
                case 4: {
                    name = 'for';
                    break;
                }
                case 5: {
                    name = 'while';
                    break;
                }
                case 6: {
                    name = 'import';
                    break;
                }
                case 7: {
                    name = 'api';
                    break;
                }
                case 8: {
                    name = 'try';
                    break;
                }
                case 9: {
                    name = 'return';
                    break;
                }
                case 10: {
                    name = 'break';
                    break;
                }
                case 11: {
                    name = 'continue';
                    break;
                }
                case 12: {
                    name = 'pass';
                    break;
                }
                case 100: {
                    name = 'elif';
                    break;
                }
                case 200: {
                    name = 'else';
                    break;
                }
                case 201: {
                    name = 'else';
                    break;
                }
                case 300: {
                    name = '__init__';
                    break;
                }
                case 400: {
                    name = '__del__';
                    break;
                }
                case 500: {
                    name = 'except';
                    break;
                }
                case 600: {
                    name = 'finally';
                    break;
                }
                case 999: {
                    name = 'code';
                    break;
                }
                case 1000: {
                    name = '';
                    break;
                }
                default: {
                    break;
                }
            }
            return name;
            // return name.toUpperCase();
        }

        

        const BLOCK_CODE_BTN_TYPE = {
            CLASS: 1
            , DEF: 2
            , IF: 3
            , FOR: 4
            , WHILE: 5
            , IMPORT: 6
            , API: 7
            , TRY: 8
    
            , RETURN: 9
            , BREAK: 10
            , CONTINUE: 11
            , PASS: 12
    
            , CODE: 999
        }
    
        const BLOCK_CODE_TYPE = {
            CLASS: 1
            , DEF: 2
            , IF: 3
            , FOR: 4
            , WHILE: 5
            , IMPORT: 6
            , API: 7
            , TRY: 8
            , RETURN: 9
            , BREAK: 10
            , CONTINUE: 11
            , PASS: 12
        
            , ELIF: 100
            , ELSE: 200
            , FOR_ELSE: 201
            , INIT: 300
            , DEL: 400
            , EXCEPT: 500
            , FINALLY: 600
            , CODE: 999
            , HOLDER: 1000
            , NULL: 10000
        }
    
        const BLOCK_DIRECTION  = {
            ROOT: -1
            , DOWN: 1
            , INDENT: 2
            , BOTTOM_DOWN: 3
        }
    
        const BLOCK_TYPE = {
            BLOCK: 1
            , SHADOW_BLOCK: 2
        }
       
        const MAKE_CHILD_BLOCK = {
            MOVE: 1
            ,SHADOW: 2
        }
        const INDENT_DEPTH_PX = 20;
    
        var BlockContainer = function() {
            // this.state = {
            //     blockList : []
            //     , blockStackList : []
            // }
            this.blockList = [];
            this.blockStackList = [];
        }
        BlockContainer.prototype.init = function() {
    
        }
        BlockContainer.prototype.execute = function() {
    
        }
        BlockContainer.prototype.traverseBlockList = function() {
            var blockList = this.blockList;
            var rootBlockList = [];
            // root block 묶음 별로 분리
            blockList.forEach(block => {
                var rootBlock = block.getRootBlock();
                if (rootBlockList.includes(rootBlock)) {
    
                } else {
                    rootBlockList.push(rootBlock);
                }
            });
    
            // root block 묶음 별로 순서대로 travelBlockList array에 담는다
            rootBlockList.forEach(rootBlock => {
                /**  */
                var nextBlockList = rootBlock.getNextBlockList();
                var stack = [];
    
                if (nextBlockList.length !== 0) {
                    stack.push(nextBlockList);
                }
    
                var travelBlockList = [rootBlock];
    
                var iteration = 0;
                var current;
                while (stack.length !== 0) {
                    current = stack.shift();
                    iteration++;
                    /** 배열 일 때 */
                    if (Array.isArray(current)) {
                        var currBlockList = current;
                        var temp = [];
                        currBlockList.forEach(block => {
                            temp.push(block);
                        });
                        
                        temp = temp.sort((a,b) => {
                            if (a.getDirection() === BLOCK_DIRECTION.INDENT) {
                                return 1;
                            } else {
                                return -1;
                            }
                        });
                        temp.forEach(el => {
                            stack.unshift(el);
                        });
          
    
                    } else {
                        var currBlock = current;
                        // var direction = current.getDirection();
                        // var newData = {
                        //     currBlock
                        //     , direction
                        // }
                        travelBlockList.push(currBlock);
    
                        var nextBlockList = currBlock.getNextBlockList();
                        stack.unshift(nextBlockList);
                    }
                }
    
                // console.log('travelBlockList', travelBlockList);
                // console.log('------------------------');
                travelBlockList.forEach((block, index) => {
                    var depth = 0;
                    var currBlock = block;
                    var blockName = block.getName();
                    var direction = block.getDirection();
    
                    if (direction === BLOCK_DIRECTION.INDENT) {
                        var prevBlock = currBlock;
                        while (prevBlock.getPrevBlock() !== null) {
                            prevBlock = prevBlock.getPrevBlock();
                            if (prevBlock.getDirection() === BLOCK_DIRECTION.DOWN ) {
                    
                            } else {
                                depth++;
                            }
                        }
                    } 
                    else {
                        var prevBlock = currBlock;
                        while (prevBlock.getPrevBlock() !== null) {
                            prevBlock = prevBlock.getPrevBlock();
                            if (prevBlock.getDirection() === BLOCK_DIRECTION.INDENT) {
                                depth++;
                            } else {
                           
                            }
                        }
                    }
    
                    /** depth 계산 */
                    var _depth = depth;
                    var indentString = ``;
                    while (_depth-- !== 0) {
                        indentString += `    `;
                    }
                    
                    var codeLine = ``;
                    codeLine += indentString;
                    console.log(index, `${codeLine}${blockName}`);
                });
            });
    
        }
    
        BlockContainer.prototype.addBlock = function(block) {
            this.blockList = [...this.blockList, block];
        }
        BlockContainer.prototype.getBlockList = function() {
            return this.blockList;
        }
    
        BlockContainer.prototype.addBlockStack = function(blockStack) {
            this.blockStackList = [...this.blockStackList, blockStack];
        }
        BlockContainer.prototype.getBlockStackList = function() {
            return this.blockStackList;
        }

        BlockContainer.prototype.deleteDisappearedBlock = function() {
            var blockList = this.getBlockList();
            var disappearedBlockList = [];

            blockList.forEach(block => {
                var containerDom = block.getContainerDom();
                var top = $(containerDom).css('top');
                var left = $(containerDom).css('left');

                if (top === undefined || left === undefined) {
                    // this.deleteBlock(block.getUUID());
                    disappearedBlockList.push(block);
                    return;
                }

                var topIndex = top.indexOf('px');
                var topNum = parseInt(top.slice(0,topIndex));
                var leftIndex = left.indexOf('px');
                var leftNum = parseInt(left.slice(0,leftIndex));

                var mainTopNum = $('.vp-nodeeditor-main').offset().top; 
                var mainLeftNum = $('.vp-nodeeditor-main').offset().left;

                if (topNum <= 0 || leftNum <= 0 || topNum > mainTopNum|| leftNum >mainLeftNum ) {
        
                    var type = block.getType();
                    if(type === BLOCK_CODE_TYPE.HOLDER 
                        || type === BLOCK_CODE_TYPE.NULL) {

                    } else {
                        disappearedBlockList.push(block);
                    }
                  
                }

            });
    
            return disappearedBlockList;
        }

        BlockContainer.prototype.renderBlockLeftHolderListHeight = function() {
            var blockList = this.getBlockList();
            var _blockList = [];
    
            blockList.forEach(block => {
                var type = block.getType();
                if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                    type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY ||
                    type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF || type === BLOCK_CODE_TYPE.FOR_ELSE || 
                    type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY ) {
                    _blockList.push(block);
                }
            });
            _blockList.forEach(block => {
                var mainDom = block.getMainDom();
                // var mainDomClientRect = $(mainDom)[0].getBoundingClientRect();
                // console.log('mainDomClientRect', mainDomClientRect);
    
                if ($(mainDom).find('.vp-block-left-holder')[0]) {
                    var leftHolderClientRect = $(mainDom).find('.vp-block-left-holder')[0].getBoundingClientRect();
                    // console.log('leftHolderClientRect', leftHolderClientRect.y);
        
                    var holderBlock = block.getHolderBlock();
                    var holderBlockClientRect = $(holderBlock.getMainDom())[0].getBoundingClientRect();
                    // console.log('holderBlockClientRect', holderBlockClientRect.y);
        
                    var distance = holderBlockClientRect.y - leftHolderClientRect.y;
                    // console.log('distance', distance, $(mainDom).find('.vp-block-left-holder'));
                    $(mainDom).find('.vp-block-left-holder').css('height',`${distance}px`);
                    block.setTempBlockLeftHolderHeight(distance);
                }
        
     
            });
        }
    
        BlockContainer.prototype.deleteBlock = function(blockUUID) {
            var selectedIndex = -1;
    
            var isBlock = this.blockList.some((block, index) => {
                if (block.getUUID() === blockUUID) {
                    selectedIndex = index;
                    return true;
                } else {
                    return false;
                }
            });
    
            if (isBlock) {
                this.blockList.splice(selectedIndex,1);
            } 
        }
        BlockContainer.prototype.makeCode = function() {
            // this.deleteDisappearedBlock();

            var that = this;
            var blockList = this.blockList;
            var rootBlockList = [];
            blockList.forEach(block => {
                var rootBlock = block.getRootBlock();
                if (rootBlockList.includes(rootBlock)) {
    
                } else {
                    rootBlockList.push(rootBlock);
                }
            });
    
            // console.log('rootBlockList', rootBlockList);
            var codeLineStrDataList = [];
            var codeLineStr = ``;
            rootBlockList.forEach(rootBlock => {
                
                /**  */
                var thisNextBlockDataList = rootBlock.getNextBlockList();
                var stack = [];
    
                if (thisNextBlockDataList.length !== 0) {
                    stack.push(thisNextBlockDataList);
                }
    
                var travelBlockDataList = [rootBlock];
    
                var iteration = 0;
                var current;
                while (stack.length !== 0) {
                    current = stack.shift();
                    iteration++;
                    /** 배열 일 때 */
                    if (Array.isArray(current)) {
                        var temp = [];
                        current.forEach(element => {
                            temp.push(element);
                        });
                        
                        temp = temp.sort((a,b) => {
                            if (a.getDirection() === BLOCK_DIRECTION.INDENT) {
                                return 1;
                            } else {
                                return -1;
                            }
                        });
                        temp.forEach(el => {
                            stack.unshift(el);
                        });
          
    
                    } else {
                        var currBlock = current;
                        var direction = current.getDirection();
                        var newData = {
                            currBlock
                            , direction
                        }
                        if (currBlock.getType() === BLOCK_CODE_TYPE.HOLDER || currBlock.getType()  === BLOCK_CODE_TYPE.NULL) {
                            // return false;
                        } else {
                            travelBlockDataList.push(newData);
                        }
                        // travelBlockDataList.push(newData);
    
                        var nextBlockDataList = current.getNextBlockList();
                        stack.unshift(nextBlockDataList);
                    }
                }
    
      
                // var alreadyTravelDataList = [];
                travelBlockDataList.some((travelBlockData, index) => {

                    var depth = 0;
           
                    var blockName = ``;
                    var direction = ``;
         
                    var currBlock;
                    // root 블럭일 경우
                    if (index === 0) {

                        currBlock = travelBlockData;
                        blockName = travelBlockData.getName();
            
                        travelBlockData.setDirection(BLOCK_DIRECTION.ROOT);
              
                    } else {


                        currBlock = travelBlockData.currBlock;
                        blockName = travelBlockData.currBlock.getName();
     
                        direction = travelBlockData.direction;
    
                        travelBlockData.currBlock.getDirection(direction);
                        // FIXME: 추후 매직 스트링 제거
                        if (direction === BLOCK_DIRECTION.INDENT) {
                       
                            var prevBlock = travelBlockData.currBlock;
                  
                            while (prevBlock.getPrevBlock() !== null) {
                          
                                prevBlock = prevBlock.getPrevBlock();
                    
                                if (prevBlock.getDirection() === BLOCK_DIRECTION.DOWN ) {
                        
                                } else {
                                    depth++;
                                }
                            }
                     
                        } else {
                            var prevBlock = travelBlockData.currBlock;
                            while (prevBlock.getPrevBlock() !== null) {
                                prevBlock = prevBlock.getPrevBlock();
                                if (prevBlock.getDirection() === BLOCK_DIRECTION.INDENT) {
                                    depth++;
                                } else {
                               
                                }
                            }
                        }
                    }
        
                    /*  */

    
                    /** depth 계산 */
                    var _depth = depth;
                    var indentString = ``;
                    while (_depth-- !== 0) {
                        indentString += `    `;
                    }
    
                    var codeLine = ``;
                    codeLine += indentString;
    
                    var type = currBlock.getType();
                    switch (type) {
                        case 1: {
                            codeLine += `${blockName.toLowerCase()} `;
                            codeLine += currBlock.getState('className');
    
                            if (currBlock.getState(`classInParamList`).length === 0) {
                                codeLine +=  `()`;
                                codeLine += `:`;
                            } else {
                                codeLine += `(`;
                                currBlock.getState(`classInParamList`).forEach((defInParam, index ) => {
                                    codeLine += `${defInParam}`;
                                    if (currBlock.getState(`classInParamList`).length - 1 !== index ) {
                                        codeLine += `, `;
                                    }
                                });
                                codeLine += `)`;
                                codeLine += `:`;
                            }
    
                            break;
                        }
                        case 2: {
                            codeLine += `${blockName.toLowerCase()} `;
                            codeLine += currBlock.getState('defName');
    
                            if (currBlock.getState(`defInParamList`).length === 0) {
                                codeLine +=  `()`;
                                codeLine += `:`;
                            } else {
                                codeLine += `(`;
                                currBlock.getState(`defInParamList`).forEach((defInParam, index ) => {
                                    codeLine += `${defInParam}`;
                                    if (currBlock.getState(`defInParamList`).length - 1 !== index ) {
                                        codeLine += `, `;
                                    }
                                });
                                codeLine += `)`;
                                codeLine += `:`;
                            }
                
                        
                            break;
                        }
                        case 3: {
                            codeLine += `${blockName.toLowerCase()} `;
                            codeLine += currBlock.getState('ifCodeLine');
                            codeLine += `:`;
                            break;
                        }
                        case 4: {
                            codeLine += `${blockName.toLowerCase()} `;
                            codeLine += currBlock.getState('forCodeLine');
                            codeLine += `:`;
                            break;
                        }
                        case 5: {
                            codeLine += `${blockName.toLowerCase()} `;
                            codeLine += currBlock.getState('whileCodeLine');
                            codeLine += `:`;
                            break;
                        }
                        /** import */
                        case 6: {
                            var baseImportList = currBlock.getState('baseImportList').filter(baseImport => {
                                if ( baseImport.isImport === true) {
                                    return true;
                                } else {
                                    return false;
                                }
                            });
                            var customImportList = currBlock.getState('customImportList').filter(customImport => {
                                if ( customImport.isImport === true) {
                                    return true;
                                } else {
                                    return false;
                                }
                            });
                            baseImportList.forEach((baseImport,index) => {
                                if (index > 0 ) {
                                    var _depth = depth;
                                    var indentString = ``;
                                    while (_depth-- !== 0) {
                                        indentString += `    `;
                                    }
                                    codeLine += indentString;
                                }
    
                                codeLine += `${blockName.toLowerCase()} ${baseImport.baseImportName} as ${baseImport.baseAcronyms}\n`;
                            });
                            customImportList.forEach((baseImport,index ) => {
                                if (index > 0 ) {
                                    var _depth = depth;
                                    var indentString = ``;
                                    while (_depth-- !== 0) {
                                        indentString += `    `;
                                    }
                                    codeLine += indentString;
                                }
                                codeLine += `${blockName.toLowerCase()} ${baseImport.baseImportName} as ${baseImport.baseAcronyms}\n`;
                            });
                            break;
                        }
                        /** api */
                        case 7: {
                            break;
                        }
                        /** try */
                        case 8: {
                            codeLine += `${blockName.toLowerCase()}:`;
                            break;
                        }
                        /** return */
                        case 9: {
                            codeLine += `${blockName.toLowerCase()} `;
                            if (currBlock.getState(`returnOutParamList`).length === 0) {
                    
                            } else {
                                codeLine += ``;
                                currBlock.getState(`returnOutParamList`).forEach((defInParam, index ) => {
                                    codeLine += `${defInParam}`;
                                    if (currBlock.getState(`returnOutParamList`).length - 1 !== index ) {
                                        codeLine += `, `;
                                    }
                                });
                                codeLine += ``;
                            }
    
                            break;
                        }
                        /** break */
                        case 10: {
                            codeLine += `${blockName.toLowerCase()} `;
                            break;
                        }
                        /** continue */
                        case 11: {
                            codeLine += `${blockName.toLowerCase()} `;
                            break;
                        }
                        /** pass */
                        case 12: {
                            codeLine += `${blockName.toLowerCase()} `;
                            break;
                        }
                        /** elif */
                        case 100: {
                            codeLine += `${blockName.toLowerCase()} `;
                            codeLine += currBlock.getState('elifCodeLine');
                            codeLine += `:`;
                            break;
                        }
                        /** else */
                        case 200: {
                            codeLine += `${blockName.toLowerCase()}:`;
                            break;
                        }
                        /** for else */
                        case 201: {
                            codeLine += `${blockName.toLowerCase()}:`;
                            break;
                        }
                        /** init */
                        case 300: {
                            codeLine += `${blockName.toLowerCase()} `;
                            break;
                        }
                        /** del */
                        case 400: {
                            codeLine += `${blockName.toLowerCase()} `;
                            break;
                        }
                        /** except */
                        case 500: {
                            codeLine += `${blockName.toLowerCase()}`;
                            codeLine += currBlock.getState('exceptCodeLine');
                            codeLine += `:`;
                            break;
                        }
                        /** finally */
                        case 600: {
                            codeLine += `${blockName.toLowerCase()}:`;
                            break;
                        }
                        /** code */
                        case 999: {
                            codeLine += currBlock.getState('customCodeLine');
                            break;
                        }
                    }
                    codeLine += `\n`;
                    codeLineStr += codeLine;
                });
    
                codeLineStrDataList.push({
                    pointY: rootBlock.getContainerPointY()
                    , codeLineStr
                });
                codeLineStr = ``;
            });
    
            codeLineStrDataList = codeLineStrDataList.sort((a,b) => {
                if (a.pointY - b.pointY > 0) {
                    return 1;
                } else {
                    return -1;
                }
            });
        
            var returnCodeLineStr = ``;
            codeLineStrDataList.forEach((codeLineStrData,index) => {
                returnCodeLineStr += codeLineStrData.codeLineStr;
            });
            return returnCodeLineStr;
        }
    
        var Block = function(blockContainerThis, type, pointObj) {
            this.state = {
                type
                , blockType: 1
                , name: ''
                , pointX: pointObj.pointX 
                , pointY: pointObj.pointY
                , containerPointX: 0
                , containerPointY: 0
                , opacity: 1
                , isRootBlock: false
                , uuid: getUUID()
                , direction: BLOCK_DIRECTION.ROOT
                , tempDepth: 0
                , tempBlockLeftHolderHeight: 0
                , optionState: {
                    classState: {
                        className: ''
                        , classInParamList: []
                        , selfVariableList: []
                        , methodList: []
                        , init: {
                            isClassInit: false
                            , initParamList: []
                        }
                        , del: {
                            isClassDel: false
                            , delParamList: []
                        }
                    }
                    , defState: {
                        defName: ''
                        , defInParamList: []
                        , defOutParamList: []
                    }
                    , ifState: {
                        if: {
                            ifCodeLine: ''
                        }
                        , elifList: []
                        , ifElse: {
                            isIfElse: false
                            , ifElseBlock: null
                        }
                        
                    }
                    , forState: {
                        for: {
                            forCodeLine: ''
                        }
                        , forElse: {
                            isForElse: false
                        }
                    }
                    , whileState: {
                        while: {
                            whileCodeLine: ''
                        }
                    }
                    , tryState: {
                        try: {
                
                        }
                        , exceptList: []
                        , finally: {
                            isFinally: false
                        }
                    }
                    , importState: {
                        baseImportList: [
                            baseImportNumpy = {
                                isImport: false
                                , baseImportName: 'numpy' 
                                , baseAcronyms: 'np' 
                            }   
                            , baseImportPandas = {
                                isImport: false
                                , baseImportName: 'pandas' 
                                , baseAcronyms: 'pd' 
                            }
                            , baseImportMatplotlib = {
                                isImport: false
                                , baseImportName: 'matplotlib.pyplot' 
                                , baseAcronyms: 'plt' 
                            }
                            , baseImportSeaborn= {
                                isImport: false
                                , baseImportName: 'seaborn' 
                                , baseAcronyms: 'sns' 
                            }
                            , baseImportOs= {
                                isImport: false
                                , baseImportName: 'os' 
                                , baseAcronyms: 'os' 
                            }
                            , baseImportSys= {
                                isImport: false
                                , baseImportName: 'sys' 
                                , baseAcronyms: 'sys' 
                            }
                            , baseImportTime= {
                                isImport: false
                                , baseImportName: 'time' 
                                , baseAcronyms: 'time' 
                            }
                            , baseImportDatetime= {
                                isImport: false
                                , baseImportName: 'datetime' 
                                , baseAcronyms: 'datetime' 
                            }
                            , baseImportRandom= {
                                isImport: false
                                , baseImportName: 'random' 
                                , baseAcronyms: 'random' 
                            }
                            , baseImportMath= {
                                isImport: false
                                , baseImportName: 'math' 
                                , baseAcronyms: 'math' 
                            }
                        ]
                        , customImportList: []
                    }
                    , elifState: {
                        elifCodeLine: ''
                    }
                    , exceptState :{
                        exceptCodeLine: ''
                    }
                    , returnState: {
                        returnOutParamList: []
                    }
                    , codeState: {
                        customCodeLine: ''
                    }
                }
            }
            this.nextBlockList = [];
            this.blockStackList = [];
            this.tempChildBlockList = [];
            this.blockContainerThis = blockContainerThis;
            this.rootDom = null;
            this.stackDom = null;
            this.containerDom = null;
            this.prevBlock = null;
            this.shadowBlock = null;
    
            this.nullBlock = null;
            this.holderBlock = null;
            this.supportingBlock = null;
            this.blockLeftHolder = null;
    
            var name = mapTypeToName(type);
            this.setName(name);
    
            this.init();
            var type = this.getType();
            if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY ||
                type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF || type === BLOCK_CODE_TYPE.FOR_ELSE || 
                type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY ) {
                var nullBlock = mapTypeToBlock(blockContainer, BLOCK_CODE_TYPE.NULL, {pointX: 0, pointY: 0});
                var holderBlock = mapTypeToBlock(blockContainer, BLOCK_CODE_TYPE.HOLDER, {pointX: 0, pointY: 0});
                
                this.setHolderBlock(holderBlock);
                this.setNullBlock(nullBlock);
                holderBlock.setSupportingBlock(this);
    
                this.appendBlock(holderBlock, BLOCK_DIRECTION.DOWN);
                this.appendBlock(nullBlock, BLOCK_DIRECTION.INDENT);
      
         
            }
            this.blockContainerThis.addBlock(this);
        }
    
        Block.prototype.setHolderBlock = function(holderBlock) {
            this.holderBlock = holderBlock;
        }
        Block.prototype.getHolderBlock = function() {
            return this.holderBlock;
        }
        Block.prototype.setSupportingBlock = function(supportingBlock) {
            this.supportingBlock = supportingBlock;
        }
        Block.prototype.getSupportingBlock = function() {
            return this.supportingBlock;
        }
        Block.prototype.setNullBlock = function(nullBlock) {
            this.nullBlock = nullBlock;
        }
        Block.prototype.getNullBlock = function() {
            return this.nullBlock;
        }
        Block.prototype.setBlockLeftHolder = function(blockLeftHolder) {
            this.blockLeftHolder = blockLeftHolder;
        }
        Block.prototype.getBlockLeftHolder = function() {
            return this.blockLeftHolder;
        }
        Block.prototype.renderBlockLeftHolderHeight = function(px) {
            $( this.getBlockLeftHolder() ).css('height',`${px}px`);
            // return this.blockLeftHolder;
        }
        Block.prototype.resetBlockLeftHolderHeight = function() {
            $( this.getBlockLeftHolder() ).css('height',`42px`);
            // return this.blockLeftHolder;
        }
        Block.prototype.getTempBlockLeftHolderHeight = function() {
            return this.state.tempBlockLeftHolderHeight;
        }
        Block.prototype.setTempBlockLeftHolderHeight = function(tempBlockLeftHolderHeight) {
            this.setState({
                tempBlockLeftHolderHeight
            })
        }
        Block.prototype.init = function() {
            var rootDomElement = this.getMainDom();
            $(rootDomElement).remove();
            $(rootDomElement).empty();
    
            /** root dom 생성 */
            var rootDomElement = document.createElement('div');
            rootDomElement.classList.add('vp-block');
    
            /** 클래스 이름 */
            var className = this.getState(`className`);
            /** 클래스 파라미터 */
            var classInParamList = this.getState(`classInParamList`);
            var classInParamStr = `(`;
            classInParamList.forEach((classInParam, index ) => {
                classInParamStr += `${classInParam}`;
                if (this.getState(`classInParamList`).length - 1 !== index ) {
                    classInParamStr += `, `;
                }
            });
    
            /** 함수 이름 */
            var defName = this.getState(`defName`);
            
            /** 함수 파라미터 */
            var defInParamList = this.getState(`defInParamList`);
            var defInParamStr = `(`;
            defInParamList.forEach((defInParam, index ) => {
                defInParamStr += `${defInParam}`;
                if (this.getState(`defInParamList`).length - 1 !== index ) {
                    defInParamStr += `, `;
                }
            });
            defInParamStr += `) : `;
            /** return */
            var returnOutParamList = this.getState(`returnOutParamList`);
            var returnOutParamStr = ` `;
            returnOutParamList.forEach((defInParam, index ) => {
                returnOutParamStr += `${defInParam}`;
                if (this.getState(`returnOutParamList`).length - 1 !== index ) {
                    returnOutParamStr += `, `;
                }
            });
            returnOutParamStr += ``;
    
            var type = this.getType()
            if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF) {
                rootDomElement.classList.add('vp-block-class-def');
            }
            if (type === BLOCK_CODE_TYPE.IF || type === BLOCK_CODE_TYPE.FOR
                || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                || type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF
                || type === BLOCK_CODE_TYPE.FOR_ELSE || type  === BLOCK_CODE_TYPE.EXCEPT 
                || type === BLOCK_CODE_TYPE.FINALLY) {
                rootDomElement.classList.add('vp-block-if');
            }
    
            if (type === BLOCK_CODE_TYPE.HOLDER) {
                rootDomElement.classList.add('vp-block-bottom-holder');
            }
    
            rootDomElement.style.top = `${this.getPointY()}` + 'px';
            rootDomElement.style.left = `${this.getPointX()}` + 'px';
            var rootInnerDomElement = $(`<div class='vp-block-inner'></div>`);
    
            var nameDom = $(`<div class='vp-block-header'>
                                <strong class="vp-style-flex-column-center ${this.getType() !== BLOCK_CODE_TYPE.HOLDER ? 'vp-block-name' : ''}" 
                                    style="margin-right:10px; font-size:12px; color:#252525;">
                                    ${this.getName()}
                                </strong>
                                    <div class='vp-nodeeditor-codeline-ellipsis vp-nodeeditor-codeline-container-box'>
                                    <div class='vp-style-flex-row'>
                                        <div class='vp-block-header-class-name-${this.getUUID()}'
                                            style='font-size:12px;'>
                                            ${className}
                            
                                        </div>
                                        <div class='vp-block-header-class-param-${this.getUUID()}
                                                  '
                                            style='font-size:12px;'>
                                            ${classInParamList.length === 0 
                                                ? ''
                                                : classInParamStr}
                                        </div>
                                    </div>
                                    <div class='vp-style-flex-row'>
                                        <div class='vp-block-header-def-name-${this.getUUID()}
                                                   '
                                            style='font-size:12px;'>
                                            ${defName}
                                            
                                        </div>
                                        <div class='vp-block-header-def-param-${this.getUUID()}
                                                    '
                                                style='font-size:12px;'>
                                                ${defInParamList.length === 0 
                                                    ? ''
                                                    : defInParamStr}
                                        </div>
                                    </div>
                                    <div class='vp-block-header-if-code-${this.getUUID()}
                                               '
                                        style='font-size:12px;'>
                                        ${this.getState("ifCodeLine")}
                                    </div>
                                    <div class='vp-block-header-for-code-${this.getUUID()}
                                               '
                                        style='font-size:12px;'>
                                        ${this.getState("forCodeLine")}
                                    </div>
                                    <div class='vp-block-header-while-code-${this.getUUID()}
                                          '
                                        style='font-size:12px;'>
                                        ${this.getState("whileCodeLine")}
                                    </div>
                                    <div class='vp-block-header-elif-code-${this.getUUID()}
                                        '
                                        style='font-size:12px;'>
                                        ${this.getState("elifCodeLine")}
                                    </div>
                                    <div class='vp-block-header-except-code-${this.getUUID()}
                                            '
                                        style='font-size:12px;'>
                                        ${this.getState("exceptCodeLine")}
                                    </div>
        
    
                                    <div class='vp-block-header-custom-code-${this.getUUID()}
                                                '
                                        style='font-size:12px;'>
                                        ${this.getState('customCodeLine')}
                                    </div>
                               
                       
                                    <div class='vp-block-header-return-param-${this.getUUID()}
                                                '
                                            style='font-size:12px;'>
                                        ${returnOutParamList.length === 0 
                                                ? ''
                                                : returnOutParamStr}
                                    </div>
                                </div>
                           
                            </div>`);
            var stackDom = $(`<div class='vp-block-stack'>
                              </div>`);
    
            this.setStackDom(stackDom);
            $(rootInnerDomElement).append(nameDom);          
            $(rootDomElement).append(rootInnerDomElement);
            $(rootDomElement).append(stackDom);
            this.setMainDom(rootDomElement);
    
            if (this.getType() === BLOCK_CODE_TYPE.NULL) {
                $(rootDomElement).css('opacity','0');
                $(rootDomElement).addClass('vp-block-nullblock');
                $(rootDomElement).attr('data-num-id',`-10000`);
            }
    
            if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY || 
                type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF || type === BLOCK_CODE_TYPE.FOR_ELSE || 
                type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
                var blockLeftHolder = $('<div class="vp-block-left-holder"></div>');
                this.setBlockLeftHolder(blockLeftHolder);
                $(rootDomElement).append(blockLeftHolder);
            }
    
            $('.vp-nodeeditor-left').append(rootDomElement);
            // console.log('init');
    
            this.bindEventAll();
        }
    
        Block.prototype.bindEventAll = function() {
            if (this.getType() === BLOCK_CODE_TYPE.HOLDER || this.getType() === BLOCK_CODE_TYPE.ELSE
                || this.getType() === BLOCK_CODE_TYPE.ELIF || this.getType() === BLOCK_CODE_TYPE.EXCEPT
                || this.getType() === BLOCK_CODE_TYPE.FOR_ELSE || this.getType() === BLOCK_CODE_TYPE.FINALLY) {
    
            } else {
                this.bindDragEvent();
                this.bindClickEvent();
            }
        }
        Block.prototype.render = function() {
    
        }
        Block.prototype.getMainDom = function() {
            return this.rootDom;
        }
        Block.prototype.setMainDom = function(rootDom) {
            this.rootDom = rootDom;
        }
        Block.prototype.getStackDom = function() {
            return this.stackDom;
        }
        Block.prototype.setStackDom = function(stackDom) {
            this.stackDom = stackDom;
        }
        
        Block.prototype.getContainerDom = function() {
            return this.containerDom;
        }
        Block.prototype.setContainerDom = function(containerDom) {
            this.containerDom = containerDom;
        }
    
        Block.prototype.setPointX = function(pointX) {
            this.setState({
                pointX
            });
        }
        Block.prototype.setPointY = function(pointY) {
            this.setState({
                pointY
            });
        }
    
        Block.prototype.getPointX = function() {
            return this.state.pointX;
        }
        Block.prototype.getPointY = function() {
            return this.state.pointY;
        }
    
        Block.prototype.setContainerPointX = function(containerPointX) {
            this.setState({
                containerPointX
            });
        }
        Block.prototype.setContainerPointY = function(containerPointY) {
            this.setState({
                containerPointY
            });
        }
    
        Block.prototype.getContainerPointX = function() {
            return this.state.containerPointX;
        }
        Block.prototype.getContainerPointY = function() {
            return this.state.containerPointY;
        }
    
    
        Block.prototype.getType = function() {
            return this.state.type;
        }
        Block.prototype.setType = function(type) {
            this.setState({
                type
            });
        }
        Block.prototype.getBlockType = function() {
            return this.state.blockType;
        }
        Block.prototype.setBlockType = function(blockType) {
            this.setState({
                blockType
            });
        }
        Block.prototype.getName = function() {
            return this.state.name;
        }
        Block.prototype.setName = function(name) {
            this.setState({
                name
            });
        }
    
        Block.prototype.getOpacity = function() {
            return this.state.opacity;
        }
        Block.prototype.setOpacity = function(opacity) {
            this.setState({
                opacity
            });
        }
    
        Block.prototype.getUUID = function() {
            return this.state.uuid;
        }
    
        Block.prototype.getTempDepth = function() {
            return this.state.tempDepth;
        }
        Block.prototype.setTempDepth = function(tempDepth) {
            this.setState({
                tempDepth
            });
        }
    
    
        Block.prototype.getShadowBlock = function() {
            return this.shadowBlock;
        }
        Block.prototype.setShadowBlock = function(shadowBlock) {
            this.shadowBlock = shadowBlock;
        }
    
        // ** Block state 관련 메소드들 */
        Block.prototype.setState = function(newState) {
            this.state = changeOldToNewState(this.state, newState);
            this.consoleState();
        }
    
        /**
            특정 state Name 값을 가져오는 함수
            @param {string} stateKeyName
        */
        Block.prototype.getState = function(stateKeyName) {
            return findStateValue(this.state, stateKeyName);
        }
        Block.prototype.getStateAll = function() {
            return this.state;
        }
        Block.prototype.consoleState = function() {
            // console.log(this.state);
        }
        Block.prototype.getBlockContainerThis = function() {
            return this.blockContainerThis;
        }
        Block.prototype.getMainDomPosition = function() {
            var rootDom = this.getMainDom();
            var clientRect = $(rootDom)[0].getBoundingClientRect();
            return clientRect;
        }
    
        Block.prototype.getBlockStackList = function() {
            return this.blockStackList;
        }
        Block.prototype.setBlockStackList = function(blockStackList) {
            this.blockStackList = blockStackList;
        }
    
        Block.prototype.getTempChildBlockList = function() {
            return this.tempChildBlockList;
        }
        Block.prototype.setTempChildBlockList = function(tempChildBlockList) {
            this.tempChildBlockList = tempChildBlockList;
        }
        Block.prototype.resetTempChildBlockList = function() {
            this.tempChildBlockList = [];
        }
        Block.prototype.getRootBlockList = function() {
            var blockContainerThis = this.getBlockContainerThis();
            var blockList = blockContainerThis.getBlockList();
    
            var rootBlockList = [];
            // root block 묶음 별로 분리
            blockList.forEach(block => {
                var rootBlock = block.getRootBlock();
                if (rootBlockList.includes(rootBlock)) {
                } else {
                    rootBlockList.push(rootBlock);
                }
            });
            return rootBlockList;
        }
    
        Block.prototype.resembleRootBlockStack = function() {
            
            var rootBlock = this.getRootBlock();
            var _containerDom = rootBlock.getContainerDom();
            $(_containerDom).empty();
            $(_containerDom).remove();
    
            var containerDom = document.createElement('div');
            containerDom.classList.add('vp-block-container');
            // var containerDom = $(`<div class='vp-block-container'></div>`);
    
            rootBlock.setContainerDom(containerDom);
            $(containerDom).css('top',`${rootBlock.getContainerPointY()}` + 'px');
            $(containerDom).css('left',`${rootBlock.getContainerPointX()}` + 'px');
    
            var blockStackList = rootBlock.resembleBlockStack();
            this.setBlockStackList(blockStackList);
            blockStackList.forEach((block, index) => {
                var mainDom = block.getMainDom();
                $(mainDom).css('top',`${0}` + 'px');
                $(mainDom).css('left',`${0}` + 'px');
                $(mainDom).attr('data-num-id',`${index}`);
                $(containerDom).append(mainDom);
                block.bindEventAll();
            });
            $('.vp-nodeeditor-left').append(containerDom);
        }
    
        Block.prototype.resembleBlockStack = function() {
            var selectChildBlockList = this.selectChildBlockList();
            var rootDepth = 0;
            // console.log('selectChildBlockList', selectChildBlockList);
    
            selectChildBlockList.forEach((block, index) => {
                /** index 0은 rootDom이니 건너뛴다 */
                // if (index === 0) {
                //     return;
                // }
    
                var depth = 0;
                var currBlock = block;
                var blockName = block.getName();
                var direction = block.getDirection();
    
                if (direction === BLOCK_DIRECTION.INDENT) {
                    var prevBlock = currBlock;
                    while (prevBlock.getPrevBlock() !== null) {
                        prevBlock = prevBlock.getPrevBlock();
                        if (prevBlock.getDirection() === BLOCK_DIRECTION.DOWN ) {
                
                        } else {
                            depth++;
                        }
                    }
                } 
                else {
                    var prevBlock = currBlock;
                    while (prevBlock.getPrevBlock() !== null) {
                        prevBlock = prevBlock.getPrevBlock();
                        if (prevBlock.getDirection() === BLOCK_DIRECTION.INDENT) {
                            depth++;
                        } else {
                       
                        }
                    }
                }
                /** depth 계산 */
             
                var _depth = depth;
                var indentPxNum = 0;
    
                {
                    // var prevBlock = currBlock.getPrevBlock();
                    // if (prevBlock !== null && prevBlock.getType() === BLOCK_CODE_TYPE.IF
                    //     && currBlock.getType() !== BLOCK_CODE_TYPE.HOLDER) {
                    //     indentPxNum += 15;
                    // }
                }
            
                while (_depth-- !== 0) {
                    indentPxNum += INDENT_DEPTH_PX;
                }
                // console.log('rootDepth',rootDepth);
                indentPxNum -= rootDepth * INDENT_DEPTH_PX;
                // console.log('indentPxNum',indentPxNum);
    
                /** index 0은 건너뛴다 */
                if (index === 0) {
                    rootDepth = depth;
                     return;
                }
    
        
                // if (block.getType() === BLOCK_CODE_TYPE.HOLDER) {
                //     indentPxNum = block.getSupportingBlock().getTempDepth()
                //     block.setTempDepth(indentPxNum );
                // } else {
                //     block.setTempDepth(indentPxNum);
                // }
    
                var rootDom = block.getMainDom();
     
                // console.log(block.getName(), 'indentPxNum',indentPxNum);
                // $(rootDom).css('position', `static`);
                $(rootDom).css('margin-left', `${indentPxNum}px`);
                $(rootDom).attr('data-depth-id', depth);
                var rect = block.getMainDomPosition();
                block.setPointX(rect.x);
                block.setPointY(rect.y);
                var x = block.getPointX();
                var y = block.getPointY();
    
                $(rootDom).css('top',`${y}` + 'px');
                $(rootDom).css('left',`${x}` + 'px');
    
                // $(rootStackDom).append(rootDom);
            });
            return selectChildBlockList;
        }
    
        Block.prototype.reArrangeChildBlockDomList = function(arrangedBlock, rootBlockChildBlockListExceptChildBlock, direction) {
    
            var rootBlock = this.getRootBlock();
    
            var blockList = [];
            if (rootBlockChildBlockListExceptChildBlock === undefined) {
                blockList = rootBlock.selectChildBlockList();
            } else {
                blockList = rootBlockChildBlockListExceptChildBlock;
            }
    
            if (arrangedBlock === undefined) {
                blockList.forEach(childBlock => {
                    // $(childBlock.getMainDom()).removeClass('vp-nodeCodeLine-selected');
                });    
                return;
            }
            
            var containerDom = rootBlock.getContainerDom();
            var childDomList = containerDom.childNodes;
            var shadowDom;
    
            // var shadowIndex = 0;
            childDomList.forEach(( childDom,index) => {
                if ( parseInt( $(childDom).attr('data-num-id') ) === -1) {
                    shadowDom = childDom;
                    return true;
                }
            });
            blockList.forEach(childBlock => {
                // $(childBlock.getMainDom()).removeClass('vp-nodeCodeLine-selected');
            });
    
            blockList.some((childBlock, index) => {
                if (childBlock.getUUID() === arrangedBlock.getUUID()) {
                    if ( parseInt( $(childBlock.getMainDom().nextSibling).attr('data-num-id') )  === -1 ){
                        return true;
                    }
    
                    var indentPxNum = 0;
                    var depth = parseInt( $(childBlock.getMainDom()).attr('data-depth-id') );
                    if (isNaN(depth)){
    
                    } else {
                        while (depth-- !== 0) {
                            indentPxNum += INDENT_DEPTH_PX;
                        }
                    }
    
                    // console.log('direction', direction, 'BLOCK_DIRECTION.INDENT', BLOCK_DIRECTION.INDENT);
                    if (direction === BLOCK_DIRECTION.INDENT) {
                        indentPxNum += INDENT_DEPTH_PX;
                    }
                    // console.log('depth', depth);
                    $(shadowDom).css('margin-left', `${indentPxNum}px`);
                    // console.log('index',index,'childBlock.getMainDom().nextSibling', childBlock.getMainDom().nextSibling);
                    containerDom.insertBefore(shadowDom, childBlock.getMainDom().nextSibling);
                    return true;
                }
            });
            
        }
    
        Block.prototype.makeChildBlockDomList = function(enumData) {
       
            var selectChildBlockList = this.selectChildBlockList();
    
            var childBlockDomList = [];
            var rootDepth = 0;
            selectChildBlockList.forEach((block, index) => {
    
                var depth = 0;
                var currBlock = block;
                var blockName = block.getName();
                var direction = block.getDirection();
    
                if (direction === BLOCK_DIRECTION.INDENT) {
                    var prevBlock = currBlock;
                    while (prevBlock.getPrevBlock() !== null) {
                        prevBlock = prevBlock.getPrevBlock();
                        if (prevBlock.getDirection() === BLOCK_DIRECTION.DOWN ) {
                
                        } else {
                            depth++;
                        }
                    }
                } 
                else {
                    var prevBlock = currBlock;
                    while (prevBlock.getPrevBlock() !== null) {
                        prevBlock = prevBlock.getPrevBlock();
                        if (prevBlock.getDirection() === BLOCK_DIRECTION.INDENT) {
                            depth++;
                        } else {
                       
                        }
                    }
                }
                /** depth 계산 */
                var _depth = depth;
                // console.log(index,'depth',depth);
                var indentPxNum = 0;
                while (_depth-- !== 0) {
                    indentPxNum += INDENT_DEPTH_PX;
              
                }
                indentPxNum -= rootDepth * INDENT_DEPTH_PX;
                // console.log('indentPxNum',indentPxNum);
    
                /** index 0은 건너뛴다 */
                if (index === 0) {
                    rootDepth = depth;
                     return;
                } else {
                    // margin-top: 2.5px;
                    // margin-bottom: 2.5px;
                    var color;
    
                    if (enumData === MAKE_CHILD_BLOCK.MOVE) {
                        if (currBlock.getType() === BLOCK_CODE_TYPE.CLASS || currBlock.getType() === BLOCK_CODE_TYPE.DEF) {
                            color = `#2240c5`;
                        }
                        if (currBlock.getType() === BLOCK_CODE_TYPE.IF || currBlock.getType() === BLOCK_CODE_TYPE.FOR
                            || currBlock.getType() === BLOCK_CODE_TYPE.WHILE || currBlock.getType() === BLOCK_CODE_TYPE.TRY
                            || currBlock.getType() === BLOCK_CODE_TYPE.ELSE || currBlock.getType() === BLOCK_CODE_TYPE.ELIF
                            || currBlock.getType() === BLOCK_CODE_TYPE.FOR_ELSE || currBlock.getType() === BLOCK_CODE_TYPE.EXCEPT 
                            || currBlock.getType() === BLOCK_CODE_TYPE.FINALLY) {
                            color = `#cc1f1f`;
                        }
                       
                    } else {
                        color = `#757575`;
                    }
                            /** 클래스 이름 */
                    var className = currBlock.getState(`className`);
                    /** 클래스 파라미터 */
                    var classInParamList = currBlock.getState(`classInParamList`);
                    var classInParamStr = `(`;
                    classInParamList.forEach((classInParam, index ) => {
                        classInParamStr += `${classInParam}`;
                        if (currBlock.getState(`classInParamList`).length - 1 !== index ) {
                            classInParamStr += `, `;
                        }
                    });
    
                    /** 함수 이름 */
                    var defName = currBlock.getState(`defName`);
                    
                    /** 함수 파라미터 */
                    var defInParamList = currBlock.getState(`defInParamList`);
                    var defInParamStr = `(`;
                    defInParamList.forEach((defInParam, index ) => {
                        defInParamStr += `${defInParam}`;
                        if (currBlock.getState(`defInParamList`).length - 1 !== index ) {
                            defInParamStr += `, `;
                        }
                    });
                    defInParamStr += `) : `;
                    /** return */
                    var returnOutParamList = currBlock.getState(`returnOutParamList`);
                    var returnOutParamStr = ` `;
                    returnOutParamList.forEach((defInParam, index ) => {
                        returnOutParamStr += `${defInParam}`;
                        if (currBlock.getState(`returnOutParamList`).length - 1 !== index ) {
                            returnOutParamStr += `, `;
                        }
                    });
                    returnOutParamStr += ``;
    
                    // var codeLineBoxClassStr = ``;
                    // var type = this.getType();
                    // if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF
                    //     || type === BLOCK_CODE_TYPE.IF || type === BLOCK_CODE_TYPE.FOR
                    //     || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                    //     || type === BLOCK_CODE_TYPE.RETURN  || type === BLOCK_CODE_TYPE.ELIF
                    //     || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.CODE) {
                    //      codeLineBoxClassStr = `vp-nodeeditor-codeline-container-box`;
                    // } 
                    var mainDom = $(`<div class="vp-block" 
                                    style="margin-top:5px; margin-bottom:5px; position: relative;">
                                    <div class="vp-block-inner">
                                        <div class="vp-block-header">
                                            <strong class="vp-style-flex-column-center ${currBlock.getType() !== BLOCK_CODE_TYPE.HOLDER ? 'vp-block-name' : ''}" 
                                                    style="margin-right:10px; font-size:12px; color:#252525;">
                                                    ${blockName}
                                            </strong>
                                            <div class='vp-nodeeditor-codeline-ellipsis vp-nodeeditor-codeline-container-box'>
                                                <div class='vp-style-flex-row'>
                                                    <div class='vp-block-header-class-name-${currBlock.getUUID()}
                                                                vp-nodeeditor-codeline-ellipsis'
                                                        style='font-size:12px;'>
                                                        ${className}
                                                    
                                                    </div>
                                                    <div class='vp-block-header-class-param-${currBlock.getUUID()}
                                                            vp-nodeeditor-codeline-ellipsis'
                                                        style='font-size:12px;'>
                                                        ${classInParamList.length === 0 
                                                            ? ''
                                                            : classInParamStr}
                                                    </div>
                                                </div>
                                                <div class='vp-style-flex-row'>
                                                    <div class='vp-block-header-def-name-${currBlock.getUUID()}
                                                                vp-nodeeditor-codeline-ellipsis'
                                                        style='font-size:12px;'>
                                                        ${defName}
                                                        
                                                    </div>
                                                    <div class='vp-block-header-def-param-${currBlock.getUUID()}
                                                                    vp-nodeeditor-codeline-ellipsis'
                                                            style='font-size:12px;'>
                                                            ${defInParamList.length === 0 
                                                                ? ''
                                                                : defInParamStr}
                                                    </div>
                                                </div>
                                                <div class='vp-block-header-if-code-${currBlock.getUUID()}
                                                            vp-nodeeditor-codeline-ellipsis'
                                                    style='font-size:12px;'>
                                                    ${currBlock.getState("ifCodeLine")}
                                                </div>
                                                <div class='vp-block-header-for-code-${currBlock.getUUID()}
                                                            vp-nodeeditor-codeline-ellipsis'
                                                    style='font-size:12px;'>
                                                    ${currBlock.getState("forCodeLine")}
                                                </div>
                                                <div class='vp-block-header-while-code-${currBlock.getUUID()}
                                                            vp-nodeeditor-codeline-ellipsis'
                                                    style='font-size:12px;'>
                                                    ${currBlock.getState("whileCodeLine")}
                                                </div>
                                                <div class='vp-block-header-elif-code-${currBlock.getUUID()}
                                                            vp-nodeeditor-codeline-ellipsis'
                                                    style='font-size:12px;'>
                                                    ${currBlock.getState("elifCodeLine")}
                                                </div>
                                                <div class='vp-block-header-except-code-${currBlock.getUUID()}
                                                            vp-nodeeditor-codeline-ellipsis'
                                                    style='font-size:12px;'>
                                                    ${currBlock.getState("exceptCodeLine")}
                                                </div>
                    
                                                <div class='vp-block-header-custom-code-${currBlock.getUUID()}
                                                            vp-nodeeditor-codeline-ellipsis'
                                                    style='font-size:12px;'>
                                                    ${currBlock.getState('customCodeLine')}
                                                </div>
    
                                              
                                        
                                                <div class='vp-block-header-return-param-${currBlock.getUUID()}
                                                            vp-nodeeditor-codeline-ellipsis'
                                                        style='font-size:12px;'>
                                                    ${returnOutParamList.length === 0 
                                                            ? ''
                                                            : returnOutParamStr}
                                                </div>
                                            </div>
    
                                        </div>
                                    </div>
                                </div>`);
                    if (currBlock.getType() === BLOCK_CODE_TYPE.CLASS || currBlock.getType() === BLOCK_CODE_TYPE.DEF) {
                        var blockLeftHolder = $('<div class="vp-block-left-holder"></div>');
                        var blockLeftHolderHeight = currBlock.getTempBlockLeftHolderHeight();
                        blockLeftHolder.css('height',`${blockLeftHolderHeight}px`);
    
                        $(mainDom).addClass('vp-block-class-def');
                        $(blockLeftHolder).css('background-color',`${color}`);
                        $(mainDom).append(blockLeftHolder);
                    }         
                    if (currBlock.getType() === BLOCK_CODE_TYPE.IF || currBlock.getType() === BLOCK_CODE_TYPE.FOR
                        || currBlock.getType() === BLOCK_CODE_TYPE.WHILE || currBlock.getType() === BLOCK_CODE_TYPE.TRY
                        || currBlock.getType() === BLOCK_CODE_TYPE.ELSE || currBlock.getType() === BLOCK_CODE_TYPE.ELIF
                        || currBlock.getType() === BLOCK_CODE_TYPE.FOR_ELSE || currBlock.getType() === BLOCK_CODE_TYPE.EXCEPT 
                        || currBlock.getType() === BLOCK_CODE_TYPE.FINALLY) {
                        var blockLeftHolder = $('<div class="vp-block-left-holder"></div>');
                        var blockLeftHolderHeight = currBlock.getTempBlockLeftHolderHeight();
                        blockLeftHolder.css('height',`${blockLeftHolderHeight}px`);
              
                        $(mainDom).addClass('vp-block-if');
                        $(blockLeftHolder).css('background-color',`${color}`);
                        $(mainDom).append(blockLeftHolder);
                    }
                    if (currBlock.getType() === BLOCK_CODE_TYPE.HOLDER) {
                        $(mainDom).addClass('vp-block-bottom-holder');
                        $(mainDom).css('margin-top', `0px`);
                        $(mainDom).css('opacity','10');
                        if (currBlock.getSupportingBlock().getType() === BLOCK_CODE_TYPE.CLASS
                            || currBlock.getSupportingBlock().getType() === BLOCK_CODE_TYPE.DEF) {
                            $(mainDom).css('background-color','#2240c5');
                        } else {
                            $(mainDom).css('background-color','#cc1f1f');
                        }
                    }
                    if (currBlock.getType() === BLOCK_CODE_TYPE.NULL) {
                        $(mainDom).css('opacity','0');
                    }
                    // $(rootDom).css('position', `static`);
                    $(mainDom).css('margin-left', `${indentPxNum}px`);
           
                    // console.log('indentPxNum',indentPxNum);
                    childBlockDomList.push(mainDom);
                }
            });
            // console.log('rootDepth',rootDepth);
            return childBlockDomList;
        }
    
        Block.prototype.splitBlockStack = function() {
            var rootBlock = this.getRootBlock();
            var currBlock = this;
            var travelBlockList = this.selectRootToChildBlockList();
            var splitBlockStackIndex = 0;
    
            travelBlockList.some((block, index) => {
                if (block.getUUID() === currBlock.getUUID()) {
                    splitBlockStackIndex = index;
                    return true;
                }
            });
            
            var beforeBlockList = travelBlockList.slice(0, splitBlockStackIndex);
            var afterBlockList = travelBlockList.slice(splitBlockStackIndex, travelBlockList.length);
    
            return {
                beforeBlockList
                , afterBlockList
                , splitBlockStackIndex
            };
        }
    
        Block.prototype.deleteBlock = function() {
            /** 렌더링된 rootDomElement 삭제 제거 */
            var rootDomElement = this.getMainDom();
            $(rootDomElement).remove();
            $(rootDomElement).empty();
    
            /** 부모 에서 this를 제거  */
            var prevBlock = this.getPrevBlock();
    
            if ( prevBlock ) {
                var nextBlockDataList = prevBlock.getNextBlockList();
                nextBlockDataList.some(( nextBlock, index) => {
                    if (nextBlock.getUUID() === this.getUUID()) {
                        nextBlockDataList.splice(index, 1);
                        return true;
                    }
                });
            }
    
            /**  */
            var thisNextBlockDataList = this.getNextBlockList();
            var stack = [];
            
            if (thisNextBlockDataList.length !== 0) {
                stack.push(thisNextBlockDataList);
            }
    
            var current;
            while (stack.length !== 0) {
                current = stack.pop();
                /** 배열 일 때 */
                if (Array.isArray(current)) {
                    current.forEach(element => {
                        stack.push(element);
                    });
                } else {
                    current.deleteBlock();
                }
            }
            if ( prevBlock ) {
                var type = prevBlock.getType();
                if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                    type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                    || type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF || type === BLOCK_CODE_TYPE.FOR_ELSE 
                    || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
    
                    var nullBlock = mapTypeToBlock(blockContainer, BLOCK_CODE_TYPE.NULL, {pointX: 0, pointY: 0});
                    prevBlock.setNullBlock(nullBlock);
                    prevBlock.appendBlock(nullBlock, BLOCK_DIRECTION.INDENT);
            
                    $(prevBlock.getRootBlock().getContainerDom()).append(prevBlock.getNullBlock().getMainDom());
                    $(prevBlock.getRootBlock().getContainerDom()).append(prevBlock.getHolderBlock().getMainDom());
                }
            }
            /** containerDom 삭제 */
            var containerDom = this.getContainerDom();
            $(containerDom).remove();
            $(containerDom).empty();
    
            /** blockContainer에서 block 데이터 삭제 제거 */
            var blockUuid = this.getUUID(); 
            var blockContainerThis = this.getBlockContainerThis();
            blockContainerThis.deleteBlock(blockUuid);
    
            this.resembleRootBlockStack();
            blockContainerThis.renderBlockLeftHolderListHeight();
            // this.resembleRootBlockStack();
        }
    
        Block.prototype.deleteBlock_v2 = function() {
            /** 렌더링된 rootDomElement 삭제 제거 */
            var rootDomElement = this.getMainDom();
            $(rootDomElement).remove();
            $(rootDomElement).empty();
    
            /** 부모 에서 this를 제거  */
            var prevBlock = this.getPrevBlock();
    
            if ( prevBlock ) {
                var nextBlockDataList = prevBlock.getNextBlockList();
                nextBlockDataList.some(( nextBlock, index) => {
                    if (nextBlock.getUUID() === this.getUUID()) {
                        nextBlockDataList.splice(index, 1);
                        return true;
                    }
                });
            }
    
            /**  */
            var thisNextBlockDataList = this.getNextBlockList();
            var stack = [];
            
            /** 나의 첫번째 자식 중의 indent블럭 아래로만 삭제 */
            thisNextBlockDataList.forEach(nextBlock => {
                if (nextBlock.getDirection() === BLOCK_DIRECTION.INDENT) {
                    stack.push(nextBlock);
            
                    /** DONW일 경우 */
                } else {
                    nextBlock.deleteBlockOne();
                 
                }
            })
    
            var current;
            while (stack.length !== 0) {
                current = stack.pop();
                /** 배열 일 때 */
                if (Array.isArray(current)) {
                    current.forEach(element => {
                        stack.push(element);
                    });
                } else {
                    current.deleteBlockOne();
                }
            }
    
            /** containerDom 삭제 */
            var containerDom = this.getContainerDom();
            $(containerDom).remove();
            $(containerDom).empty();
    
            /** blockContainer에서 block 데이터 삭제 제거 */
            var blockUuid = this.getUUID(); 
            var blockContainerThis = this.getBlockContainerThis();
            blockContainerThis.deleteBlock(blockUuid);
    
            if ( prevBlock ) {
                var type = prevBlock.getType();
                if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                    type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                    || type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF || type === BLOCK_CODE_TYPE.FOR_ELSE 
                    || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
    
                    var nullBlock = mapTypeToBlock(blockContainer, BLOCK_CODE_TYPE.NULL, {pointX: 0, pointY: 0});
                    prevBlock.setNullBlock(nullBlock);
                    prevBlock.appendBlock(nullBlock, BLOCK_DIRECTION.INDENT);
            
                    $(prevBlock.getRootBlock().getContainerDom()).append(prevBlock.getNullBlock().getMainDom());
                    $(prevBlock.getRootBlock().getContainerDom()).append(prevBlock.getHolderBlock().getMainDom());
                }
            }
    
            // this.resembleRootBlockStack();
            blockContainerThis.renderBlockLeftHolderListHeight();
        }
    
        Block.prototype.deleteBlockOne = function() {
          
            /** 렌더링된 rootDomElement 삭제 제거 */
            /** 부모 에서 this를 제거  */
            var prevBlock = this.getPrevBlock();
            
            if ( prevBlock ) {
                var nextBlockDataList = prevBlock.getNextBlockList();
                nextBlockDataList.some(( nextBlockBlock, index) => {
                    if (nextBlockBlock.getUUID() === this.getUUID()) {
                        nextBlockDataList.splice(index, 1)
                        return true;
                    }
                });
            }
            
            /**  */
    
            var thisNextBlockList = this.getNextBlockList();
            thisNextBlockList.forEach((block,index) => {
                if (block.getDirection() === this.getDirection()) {
    
    
                    if (prevBlock) {
                        block.setPrevBlock(prevBlock);
                        prevBlock.appendBlock(block, block.getDirection());
                        prevBlock = block;
                    }
                 
                } else {
      
                    if (prevBlock) {
                        block.setPrevBlock(prevBlock);
                        prevBlock.appendBlock(block, block.getDirection());
                        prevBlock = block;
                    }
                }   
            });
            
            this.setNextBlockList([]);
            var rootDomElement = this.getMainDom();
            $(rootDomElement).remove();
            $(rootDomElement).empty();
    
            /** containerDom 삭제 */
            var containerDom = this.getContainerDom();
            $(containerDom).remove();
            $(containerDom).empty();
    
            /** blockContainer에서 block 데이터 삭제 제거 */
            var blockUuid = this.getUUID(); 
            var blockContainerThis = this.getBlockContainerThis();
            blockContainerThis.deleteBlock(blockUuid);
        }
    
        /** 이벤트 함수 바인딩 */
        Block.prototype.bindDragEvent = function() {
            var that = this;
            var blockContainerThis = this.getBlockContainerThis();
            var type = this.getType();
            var pointX = this.getPointX();
            var pointY = this.getPointY();
            var rootDomElement = this.getMainDom();
            // var rect = that.getMainDomPosition();
    
            var x;
            var y;
            var pos1 = 0;
            var pos2 = 0;
            var pos3 = 0;
            var pos4 = 0;
            var newMainDom;
            var tempChildListDom;
    
            var shadowBlock;
            var shadowBlockList = [];
            var rootBlockChildBlockListExceptChildBlock = [];
            var selectedBlock = null;
            var selectedBlockDirection = null;
    
            var thisBlockHeightPx = 0;
            var isParentCollicion = false;
            var beforeBlockList = [];
            var afterBlockList = [];
            var childBlockList = [];
    
            $(rootDomElement).draggable({ 
                revert: 'invalid',
                revertDuration: 200,
                appendTo: '.vp-nodeeditor-left',
        
                cursor: 'move', 
                
                start: function(event, ui) {
                    // console.log('start');
                    // console.log('name', that.getName());
      
                    newMainDom = document.createElement('div');
                    newMainDom.classList.add('vp-block');
                    $(newMainDom).css('position', 'static');
                    // $(newMainDom).css('position', 'fixed');
                    $(newMainDom).css('position', 'absolute');
                    // $(newMainDom).css('position', 'relative');
    
                    var rootInnerDomElement = $(`<div class='vp-block-inner'></div>`);
         
                    /** 클래스 이름 */
                    var className = that.getState(`className`);
                    /** 클래스 파라미터 */
                    var classInParamList = that.getState(`classInParamList`);
                    var classInParamStr = `(`;
                    classInParamList.forEach((classInParam, index ) => {
                        classInParamStr += `${classInParam}`;
                        if (that.getState(`classInParamList`).length - 1 !== index ) {
                            classInParamStr += `, `;
                        }
                    });
    
                    /** 함수 이름 */
                    var defName = that.getState(`defName`);
                    
                    /** 함수 파라미터 */
                    var defInParamList = that.getState(`defInParamList`);
                    var defInParamStr = `(`;
                    defInParamList.forEach((defInParam, index ) => {
                        defInParamStr += `${defInParam}`;
                        if (that.getState(`defInParamList`).length - 1 !== index ) {
                            defInParamStr += `, `;
                        }
                    });
                    defInParamStr += `) : `;
                    /** return */
                    var returnOutParamList = that.getState(`returnOutParamList`);
                    var returnOutParamStr = ` `;
                    returnOutParamList.forEach((defInParam, index ) => {
                        returnOutParamStr += `${defInParam}`;
                        if (that.getState(`returnOutParamList`).length - 1 !== index ) {
                            returnOutParamStr += `, `;
                        }
                    });
                    returnOutParamStr += ``;
    
                    // var codeLineBoxClassStr = ``;
                    // if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF
                    //     || type === BLOCK_CODE_TYPE.IF || type === BLOCK_CODE_TYPE.FOR
                    //     || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                    //     || type === BLOCK_CODE_TYPE.RETURN  || type === BLOCK_CODE_TYPE.ELIF
                    //     || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.CODE) {
                    //      codeLineBoxClassStr = `vp-nodeeditor-codeline-container-box`;
                    // } 
    
                    var nameDom = $(`<div class='vp-block-header'>
                                        <strong class="vp-style-flex-column-center ${that.getType() !== BLOCK_CODE_TYPE.HOLDER ? 'vp-block-name' : ''}" 
                                            style="margin-right:10px; font-size:12px; color:#252525;">
                                            ${that.getName()} 
                                        </strong>
                                            <div class='vp-nodeeditor-codeline-ellipsis vp-nodeeditor-codeline-container-box'>
                                            <div class='vp-style-flex-row'>
                                                <div class='vp-block-header-class-name-${that.getUUID()}
                                                            vp-nodeeditor-codeline-ellipsis'
                                                    style='font-size:12px;'>
                                                    ${className}
                                                    
                                                </div>
                                                <div class='vp-block-header-class-param-${that.getUUID()}
                                                                vp-nodeeditor-codeline-ellipsis'
                                                        style='font-size:12px;'>
                                                        ${classInParamList.length === 0 
                                                            ? ''
                                                            : classInParamStr}
                                                </div>
                                            </div>
                                            <div class='vp-style-flex-row'>
                                                <div class='vp-block-header-def-name-${that.getUUID()}
                                                            vp-nodeeditor-codeline-ellipsis'
                                                    style='font-size:12px;'>
                                                    ${defName}
                                                    
                                                </div>
                                                <div class='vp-block-header-def-param-${that.getUUID()}
                                                            vp-nodeeditor-codeline-ellipsis'
                                                    style='font-size:12px;'>
                                                    ${defInParamList.length === 0 
                                                            ? ''
                                                            : defInParamStr}
                                                </div>
                                            </div>
                                            <div class='vp-block-header-if-code-${that.getUUID()}
                                                        vp-nodeeditor-codeline-ellipsis'
                                                style='font-size:12px;'>
                                                ${that.getState("ifCodeLine")}
                                            </div>
                                            <div class='vp-block-header-for-code-${that.getUUID()}
                                                        vp-nodeeditor-codeline-ellipsis'
                                                style='font-size:12px;'>
                                                ${that.getState("forCodeLine")}
                                            </div>
                                            <div class='vp-block-header-while-code-${that.getUUID()}
                                                        vp-nodeeditor-codeline-ellipsis'
                                                style='font-size:12px;'>
                                                ${that.getState("whileCodeLine")}
                                            </div>
                                            <div class='vp-block-header-elif-code-${that.getUUID()}
                                                        vp-nodeeditor-codeline-ellipsis'
                                                style='font-size:12px;'>
                                                ${that.getState("elifCodeLine")}
                                            </div>
                                            <div class='vp-block-header-except-code-${that.getUUID()}
                                                        vp-nodeeditor-codeline-ellipsis'
                                                style='font-size:12px;'>
                                                ${that.getState("exceptCodeLine")}
                                            </div>
                
                                            <div class='vp-block-header-custom-code-${that.getUUID()}
                                                        vp-nodeeditor-codeline-ellipsis'
                                                style='font-size:12px;'>
                                                ${that.getState('customCodeLine')}
                                            </div>
                                
                               
                                            
                                            <div class='vp-block-header-return-param-${that.getUUID()}
                                                        vp-nodeeditor-codeline-ellipsis'
                                                 style='font-size:12px;'>
                                                ${returnOutParamList.length === 0 
                                                        ? ''
                                                        : returnOutParamStr}
                                            </div>
                                        </div>
    
                                    </div>`);
                    tempChildListDom = $(`<div class='vp-block-stack'><div>`);
                    var childBlockDomList = that.makeChildBlockDomList(MAKE_CHILD_BLOCK.MOVE);
                    childBlockDomList.forEach(childDom => {
                        tempChildListDom.append(childDom);
                    });
    
                    $(rootInnerDomElement).append(nameDom);
                    $(newMainDom).append(rootInnerDomElement);
                    $(newMainDom).append(tempChildListDom);
    
                    if (that.getType() === BLOCK_CODE_TYPE.CLASS || that.getType() === BLOCK_CODE_TYPE.DEF) {
                        var blockLeftHolder = $('<div class="vp-block-left-holder"></div>');
                        var blockLeftHolderHeight = that.getTempBlockLeftHolderHeight();
                        blockLeftHolder.css('height',`${blockLeftHolderHeight}px`);
            
                        $(newMainDom).append(blockLeftHolder);
                        $(newMainDom).addClass('vp-block-class-def');
                    }         
                    if (that.getType() === BLOCK_CODE_TYPE.IF || that.getType() === BLOCK_CODE_TYPE.FOR
                        || that.getType() === BLOCK_CODE_TYPE.WHILE || that.getType() === BLOCK_CODE_TYPE.TRY
                        || that.getType() === BLOCK_CODE_TYPE.ELSE || that.getType() === BLOCK_CODE_TYPE.ELIF
                        || that.getType() === BLOCK_CODE_TYPE.FOR_ELSE || that.getType()  === BLOCK_CODE_TYPE.EXCEPT 
                        || that.getType() === BLOCK_CODE_TYPE.FINALLY) {
                        var blockLeftHolder = $('<div class="vp-block-left-holder"></div>');
                        var blockLeftHolderHeight = that.getTempBlockLeftHolderHeight();
                        blockLeftHolder.css('height',`${blockLeftHolderHeight}px`);
    
                        $(newMainDom).append(blockLeftHolder);
                        $(newMainDom).addClass('vp-block-if');
                    }
    
                    $('.vp-nodeeditor-left').append(newMainDom);
    
                    ({ beforeBlockList, afterBlockList } = that.splitBlockStack());
                    // console.log('beforeBlockList', beforeBlockList);
    
                    var childBlockList = that.selectChildBlockList();
    
    
                    childBlockList.forEach(block => {
                        var mainDom = block.getMainDom();
                        $(mainDom).css('opacity', '0');
                        thisBlockHeightPx += 26;
                    });
                    
         
                    var blockList = blockContainerThis.getBlockList();
    
                    var rootBlockList = [];
                    // root block 묶음 별로 분리
                    blockList.forEach(block => {
                        var rootBlock = block.getRootBlock();
                        if (rootBlockList.includes(rootBlock)) {
                        } else {
                            rootBlockList.push(rootBlock);
                        }
                    });
    
        
                    rootBlockList.forEach((rootBlock, index) => {
                        var shadowChildBlockDomList = that.makeChildBlockDomList(MAKE_CHILD_BLOCK.SHADOW);
                        shadowBlock = new ShadowBlock(blockContainerThis, type, {pointX: 0, pointY: 0}, shadowChildBlockDomList,  BLOCK_TYPE.BLOCK, that);
                        shadowBlock.setRootBlockUUID(rootBlock.getUUID());
                        shadowBlockList.push(shadowBlock);
    
                        var containerDom = rootBlock.getContainerDom();
                        $(shadowBlock.getMainDom()).css('display','none');
                        $(shadowBlock.getMainDom()).removeClass('selected-shadowblock');
                        $(containerDom).append(shadowBlock.getMainDom());
                    });
                    that.setShadowBlock(shadowBlockList);
    
                    blockContainerThis.renderBlockLeftHolderListHeight();
                },
                drag: (event, ui) => {
                    // console.log('drag');
                    blockContainerThis.renderBlockLeftHolderListHeight();
    
                    var rect = that.getMainDomPosition();
               
                    that.setPointX(rect.x);
                    that.setPointY(rect.y);
       
                    buttonX = event.clientX; 
                    buttonY = event.clientY; 
    
                    pos1 = pos3 - buttonX;
                    pos2 = pos4 - buttonY;
                    pos3 = buttonX;
                    pos4 = buttonY;
    
                    x = buttonX - pos2 - $('.vp-nodeeditor-left').offset().left  - rect.width / 2;
                    y = buttonY - pos1 - $('.vp-nodeeditor-left').offset().top;
                    $(newMainDom).css('top',`${y}` + 'px');
                    $(newMainDom).css('left',`${x }` + 'px');
                    var blockList = blockContainerThis.getBlockList();
                    // console.log('blockList', blockList);
                    var { x: thisX, y: thisY, width: thisBlockWidth, height: thisBlockHeight} = that.getMainDomPosition();
                    buttonX = thisX; 
                    buttonY = thisY; 
    
                    blockList.forEach(block => {
      
                        if (that.getUUID() === block.getUUID()) {
                            return;
                        }
    
                        var mainDom = block.getMainDom();
                        var { x, y, width: blockWidth, height: blockHeight} = block.getMainDomPosition();
                        var rootBlock = block.getRootBlock();
    
                        var rootBlockChildBlockList = rootBlock.selectChildBlockList();
                        var childBlockList = that.selectChildBlockList();
                        // console.log('childBlockList', childBlockList);
        
                        rootBlockChildBlockList.forEach((rootBlockChildBlock, rootBlockIndex) => {
                            var is = childBlockList.some((childBlock, childBlockIndex) => {
                                if ( rootBlockChildBlock.getUUID() === childBlock.getUUID() ) {
                                    return true;
                                } else {
        
                                }
                            });
        
                            if (is) {
        
                            } else {
                                rootBlockChildBlockListExceptChildBlock.push(rootBlockChildBlock);
                            }
                        });
                        
                        var is = shadowBlockList.some(shadowBlock => {
                            if ( $(shadowBlock.getMainDom()).hasClass('selected-shadowblock') ) {
                                return true;
                            }
                        });
                        if (is === false) {
                            $(rootDomElement).css('transform', `translate(0px, 0px)`); 
                        }
    
                        /** down */
                        if ( x < buttonX
                             && buttonX < (x + blockWidth + blockWidth)
                             && y  < buttonY
                             && buttonY < (y + blockHeight) ) {     
                            // console.log('down colision', thisBlockHeightPx);
                            if (block.getType() === BLOCK_CODE_TYPE.NULL) {
                                return;
                            }
    
                            var blockList = blockContainerThis.getBlockList();
                            var rootBlockList = [];
                            blockList.forEach(block => {
                                var rootBlock = block.getRootBlock();
                                if (rootBlockList.includes(rootBlock)) {
                                } else {
                                    rootBlockList.push(rootBlock);
                                }
                            });
    
    
                            isParentCollicion = beforeBlockList.some((beforeBlock,index) => {
                                if (beforeBlock.getUUID() === block.getUUID()) {
                                    $(rootDomElement).css('transform', `translate(0px, -${thisBlockHeightPx}px)`); 
                                    return true;
                                }
                            });
    
                            if (isParentCollicion === false) {
                                $(rootDomElement).css('transform', `translate(0px, 0px)`); 
                            }
    
                            shadowBlockList.some(shadowBlock => {
                                if (shadowBlock.getRootBlockUUID() === rootBlock.getUUID()) {
                                    var isChild = childBlockList.some(childBlock => {
                                        if (childBlock.getUUID() === block.getUUID()) {
                                            return true;
                                        }
                                    });
                                    if (isChild === true) {
                                        return true;
                                    }
    
                                    /** 내가 이동한 블럭이 루트 블럭일 경우 쉐도우 블록을 생성하지 않는다 */
                                    if (that.getUUID() !== rootBlock.getUUID() ) {
                                      
                                        // console.log('block', block.getName());
                                        $(shadowBlock.getMainDom()).css('display','block');
                                        $(shadowBlock.getMainDom()).addClass('selected-shadowblock');
                                        shadowBlock.setSelectBlock(block);
                                        var type = block.getType();
                                        if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                                            type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY ||
                                            type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF || type === BLOCK_CODE_TYPE.FOR_ELSE || 
                                            type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
                 
                                            var is = block.getNextBlockList().some(nextBlock => {
                                                if ( nextBlock.getType() === BLOCK_CODE_TYPE.NULL ) {
                                                 
                                                    var holderBlock = block.getHolderBlock();
                                                    var blockLeftHolderHeight = block.getTempBlockLeftHolderHeight();
                                                    block.getBlockLeftHolder().css('height',`${blockLeftHolderHeight}px`);
                                                    $(holderBlock.getMainDom()).css('transform', `translate(0px, -34px)`); 
                                    
                                                    return true;
                                                }
                                            });
                                        }
    
                                        if (block.getType() === BLOCK_CODE_TYPE.HOLDER) {
                                            $(block.getMainDom()).css('transform', `translate(0px, 0px)`); 
                                        }
                                    }
                            
                                    return true;
                                }    
                            });
                            // selectedBlock = block;
                            var type = block.getType();
                            if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                                type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY ||
                                type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF || type === BLOCK_CODE_TYPE.FOR_ELSE || 
                                type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
                                selectedBlockDirection = BLOCK_DIRECTION.INDENT;
                       
    
                            } else if (block.getType() === BLOCK_CODE_TYPE.HOLDER) {
                                selectedBlockDirection = BLOCK_DIRECTION.DOWN; 
                            } else {
                                selectedBlockDirection = BLOCK_DIRECTION.DOWN; 
                            }
                            rootBlock.reArrangeChildBlockDomList(block, rootBlockChildBlockListExceptChildBlock, selectedBlockDirection);
               
                        }  else {
                            if (block.getType() === BLOCK_CODE_TYPE.HOLDER) {
                                $(block.getMainDom()).css('transform', `translate(0px, 0px)`); 
                            }
                            var type = block.getType();
                            if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                                type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY ||
                                type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF || type === BLOCK_CODE_TYPE.FOR_ELSE || 
                                type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
                                var is = shadowBlockList.some(shadowBlock => {
                                    if ( $(shadowBlock.getMainDom()).hasClass('selected-shadowblock') ) {
                                        selectedBlock = shadowBlock.getSelectBlock();
                                        return true;
                                    }
                                });
                            }
    
                            var rootBlockList = that.getRootBlockList();
    
                            rootBlockList.some(_rootBlock => {
                                var containerDom = _rootBlock.getContainerDom();
                    
                                var containerDomRect = $(containerDom)[0].getBoundingClientRect();
                                var { x, y, width: containerDomWidth, height: containerDomHeight} = containerDomRect;
        
                                if ( x < event.clientX
                                    && event.clientX < (x + containerDomWidth)
                                    && y  < event.clientY
                                    && event.clientY < (y + containerDomHeight) ) {  
                                    // console.log('in colision');
                
                                } else {
                                    shadowBlockList.forEach(shadowBlock => {
                                        if (shadowBlock.getRootBlockUUID() === _rootBlock.getUUID()) {
                                            
                                            $(shadowBlock.getMainDom()).css('display','none');
                                            $(shadowBlock.getMainDom()).removeClass('selected-shadowblock');
                                            shadowBlock.setSelectBlock(null);
                                        }    
                                    });
                                    // console.log('not colision');
                                }
                            });
                        }
    
                        rootBlockChildBlockListExceptChildBlock = [];
                    });
                },
                stop: function(event, ui) {
                   
    
                    $(rootDomElement).css('transform', `translate(0px, 0px)`); 
                    /** shadow block list 삭제 */
                    var rootBlockList = [];
                    var blockList = blockContainerThis.getBlockList();
                    blockList.forEach(block => {
                        $(block.getMainDom()).css('transform', `translate(0px, 0px)`); 
                        var rootBlock = block.getRootBlock();
                        if (rootBlockList.includes(rootBlock)) {
                        } else {
                            rootBlockList.push(rootBlock);
                        }
                    });
    
                    shadowBlockList.forEach(shadowBlock => {
                        if ( $(shadowBlock.getMainDom()).hasClass('selected-shadowblock') ) {
            
                            selectedBlock = shadowBlock.getSelectBlock();
                        } else {
        
                        };
                    })
       
                    rootBlockList.forEach(rootBlock => {
                        var rootBlockContainerDom = rootBlock.getContainerDom();
                        $(rootBlockContainerDom).find('.vp-block-shadowblock').remove();
                    });
    
                    // console.log('stop');
                    // console.log('selectedBlock', selectedBlock);
                    if (selectedBlock !== null) {
                        $(rootDomElement).remove();
                        // $(rootDomElement).empty();
        
                        $(tempChildListDom).remove();
                        $(tempChildListDom).empty();
                        
                        var childBlockList = that.selectChildBlockList();
                        childBlockList.forEach(block => {
                            var mainDom = block.getMainDom();
                            if (block.getType() === BLOCK_CODE_TYPE.NULL) {
                                $(mainDom).css('opacity', '0');
                            } else {
                                $(mainDom).css('opacity', '1');
                            }
                        });
    
                        if ((selectedBlock.getType() === BLOCK_CODE_TYPE.CLASS || selectedBlock.getType() === BLOCK_CODE_TYPE.DEF
                            || selectedBlock.getType() === BLOCK_CODE_TYPE.IF || selectedBlock.getType() === BLOCK_CODE_TYPE.FOR
                            || selectedBlock.getType() === BLOCK_CODE_TYPE.WHILE || selectedBlock.getType() === BLOCK_CODE_TYPE.TRY
                            || selectedBlock.getType() === BLOCK_CODE_TYPE.ELSE || selectedBlock.getType() === BLOCK_CODE_TYPE.ELIF
                            || selectedBlock.getType() === BLOCK_CODE_TYPE.FOR_ELSE || selectedBlock.getType() === BLOCK_CODE_TYPE.EXCEPT 
                            || selectedBlock.getType() === BLOCK_CODE_TYPE.FINALLY)
                            && selectedBlock.getNullBlock() !== null) {
                            selectedBlock.getNullBlock().deleteBlockOne();
                            selectedBlock.setNullBlock(null);
                        } 
    
                        selectedBlock.appendBlock(that, selectedBlockDirection);
                  
                        var myContainerDom = that.getContainerDom();
                        $(myContainerDom).remove();
                        $(myContainerDom).empty();
    
                        var _containerDom = selectedBlock.getRootBlock().getContainerDom();
    
                        var rootBlock = selectedBlock.getRootBlock();
                        var rootBlockStackList = rootBlock.resembleBlockStack();
    
    
                        var containerDom = document.createElement('div');
                        containerDom.classList.add('vp-block-container');
                        $(containerDom).css('top',`${rootBlock.getContainerPointY()}` + 'px');
                        $(containerDom).css('left',`${rootBlock.getContainerPointX()}` + 'px');
                        rootBlock.setContainerDom(containerDom);
    
                        rootBlockStackList.forEach((block,index) => {
                            if (block.getUUID() === that.getUUID()) {
                                $(newMainDom).css('position',`relative`);
                                $(newMainDom).css('top',`${0}` + 'px');
                                $(newMainDom).css('left',`${0}` + 'px');
    
                                $(containerDom).append(newMainDom);
    
                                if (( type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                                      type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                                      || type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF || type === BLOCK_CODE_TYPE.FOR_ELSE 
                                      || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY)
                                    && block.getNullBlock() === null) {
         
                                    var is = block.getNextBlockList().some(nextBlock => {
                                        if (nextBlock.getDirection() === BLOCK_DIRECTION.INDENT) {
                                            return true;
                                        }
                                    });
                                    if (is === false) {
                                        var nullBlock = mapTypeToBlock(blockContainer, BLOCK_CODE_TYPE.NULL, {pointX: 0, pointY: 0});
                                        block.setNullBlock(nullBlock);
                                        block.appendBlock(nullBlock, BLOCK_DIRECTION.INDENT);
                                        $(containerDom).append(block.getNullBlock().getMainDom());
                                        $(containerDom).append(block.getHolderBlock().getMainDom());
                                    }
                                }
    
                                that.setMainDom(newMainDom);
                                that.bindEventAll();
                                return;
                            }
    
                            var mainDom = block.getMainDom();
                            $(mainDom).css('top',`${0}` + 'px');
                            $(mainDom).css('left',`${0}` + 'px');
                            $(containerDom).append(mainDom);
                            var type = block.getType();
                            
                            if ((type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                                type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                                || type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF || type === BLOCK_CODE_TYPE.FOR_ELSE 
                                || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY)
                                && block.getNullBlock() === null) {
             
                                var is = block.getNextBlockList().some(nextBlock => {
                                    if (nextBlock.getDirection() === BLOCK_DIRECTION.INDENT) {
                                        return true;
                                    }
                                });
                                if (is === false) {
                                    var nullBlock = mapTypeToBlock(blockContainer, BLOCK_CODE_TYPE.NULL, {pointX: 0, pointY: 0});
                                    block.setNullBlock(nullBlock);
                                    block.appendBlock(nullBlock, BLOCK_DIRECTION.INDENT);
                                    $(containerDom).append(block.getNullBlock().getMainDom());
                                    $(containerDom).append(block.getHolderBlock().getMainDom());
                                }
                            }
    
                            block.bindEventAll();
               
                        });
    
                        $('.vp-nodeeditor-left').append(containerDom);
    
                        $(_containerDom).remove();
                        $(_containerDom).empty();
    
                        that.bindEventAll();
    
                        that.resembleRootBlockStack();
                        // that.renderMyColor();
                    } else {
                        // $(newMainDom).css('transform', `translate(0px, 0px)`); 
                        /** stack dom x,y 정리 */
        
                        $(rootDomElement).remove();
                        $(rootDomElement).empty();
        
                        $(tempChildListDom).remove();
                        $(tempChildListDom).empty();
    
                        var _containerDom = that.getContainerDom();
                        $(_containerDom).empty();
                        $(_containerDom).remove();
                
                        var containerDom = document.createElement('div');
                        containerDom.classList.add('vp-block-container');
                
                        that.setContainerDom(containerDom);
                
                        var blockStackList = that.resembleBlockStack();
        
                        that.setBlockStackList(blockStackList);
                        blockStackList.forEach((block,index) => {
                    
        
                            /** FIXME: */
                            if (index === 0) {
                                $(containerDom).css('top',`${y}` + 'px');
                                $(containerDom).css('left',`${x}` + 'px');
                                $(newMainDom).css('position', `static`);
                                $(newMainDom).css('top',`${0}` + 'px');
                                $(newMainDom).css('left',`${0}` + 'px');
                                $(containerDom).append(newMainDom);
    
      
                                that.setMainDom(newMainDom);
                                that.bindEventAll();
          
                                return;
                            }
        
                            var mainDom = block.getMainDom();
                            $(mainDom).css('top',`${0}` + 'px');
                            $(mainDom).css('left',`${0}` + 'px');
                
                            $(containerDom).append(mainDom);
                            block.bindEventAll();
            
                        });
        
                        var childBlockList = that.selectChildBlockList();
                        childBlockList.forEach(block => {
                            var mainDom = block.getMainDom();
                            if (block.getType() === BLOCK_CODE_TYPE.NULL) {
                                $(mainDom).css('opacity', '0');
                            } else {
                                $(mainDom).css('opacity', '1');
                            }
                        });
                        
                        that.setContainerPointX(x);
                        that.setContainerPointY(y);
    
                        $('.vp-nodeeditor-left').append(containerDom);
                        that.untactBlock(x,y);
                    }
    
    
                    blockContainerThis.renderBlockLeftHolderListHeight();
    
                    that.renderResetColor();
                    that.renderWhiteColor();
                }
            });
        }
        
        Block.prototype.selectRootToChildBlockList = function() {
            var rootBlock = this.getRootBlock();
            return rootBlock.selectChildBlockList();
        }
    
        Block.prototype.selectChildBlockList = function() {
            // var rootBlock = block.getRootBlock();
            var nextBlockList = this.getNextBlockList();
            var stack = [];
    
            if (nextBlockList.length !== 0) {
                stack.push(nextBlockList);
            }
    
            var travelBlockList = [this];

            var iteration = 0;
            var current;
            while (stack.length !== 0) {
                current = stack.shift();
                // if (iteration > 100) {
                //     console.log('무한루프');
                //     break;
                // }
                iteration++;
                /** 배열 일 때 */
                if (Array.isArray(current)) {
                    var currBlockList = current;
                    var temp = [];
                    currBlockList.forEach(block => {
                        temp.push(block);
                    });
                    
                    temp = temp.sort((a,b) => {
                        if (a.getDirection() === BLOCK_DIRECTION.INDENT) {
                            return 1;
                        } else {
                            return -1;
                        }
                    });
                    temp.forEach(el => {
                        stack.unshift(el);
                    });
      
    
                } else {
                    var currBlock = current;
                    var is = travelBlockList.some(travelBlock => {
                        if (current.getUUID() === travelBlock.getUUID()) {
                            return true;
                        }
                    });
                    if(is === false) {
                        travelBlockList.push(currBlock);
                        var nextBlockList = currBlock.getNextBlockList();
                        stack.unshift(nextBlockList);
                    }
                }
            }
    
            return travelBlockList;
        }
    
        Block.prototype.bindClickEvent = function() {
            var that = this;
            var blockContainerThis = that.getBlockContainerThis();
            var mainDom = that.getMainDom();
            // var childList = that.selectChildBlockList();
            // console.log('childList',childList);
            var deleteBtn = $(`<div class='vp-block-delete-btn'>x</div>`);
            $(mainDom).click(function(event){
                // that.renderClickBlock();
                that.renderResetColor();
                that.renderWhiteColor();
                that.renderBottomOption();
                var blockList = blockContainerThis.getBlockList();
                blockList.forEach(block => {
                    var mainDom = block.getMainDom();
                    $(mainDom).find('.vp-block-delete-btn').remove();
                });
                $(mainDom).append(deleteBtn);
            });
    
            $(deleteBtn).click(function(event) {
            
                that.deleteBlock();
                $(that.getContainerDom()).remove();
          
            });
        }
    
        Block.prototype.renderMyColor = function() {
            var type = this.getType();
            if (type === BLOCK_CODE_TYPE.HOLDER || type === BLOCK_CODE_TYPE.NULL) {
                return;
            }
            // console.log('type', type);
            if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF) {
                $(this.getMainDom()).css('background-color', `#2240c5`);
                $(this.getMainDom()).find('.vp-block-left-holder').css('background-color', `#2240c5`);
                $(this.getHolderBlock().getMainDom()).css('background-color', `#2240c5`);
            } else if (type === BLOCK_CODE_TYPE.IF || type === BLOCK_CODE_TYPE.FOR
                || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                || type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF
                || type === BLOCK_CODE_TYPE.FOR_ELSE || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
                $(this.getMainDom()).css('background-color', `#cc1f1f`);
                $(this.getMainDom()).find('.vp-block-left-holder').css('background-color', `#cc1f1f`);
                $(this.getHolderBlock().getMainDom()).css('background-color', `#cc1f1f`);
            } else {
                $(this.getMainDom()).css('background-color', `#14c51d`); 
                $(this.getMainDom()).find('.vp-block-left-holder').css('background-color', `#14c51d`);
            }
        }
    
        Block.prototype.renderWhiteColor = function() {
            var type = this.getType();
            if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF) {
                $(this.getMainDom()).css('background-color', `#757575`);
                $(this.getMainDom()).find('.vp-block-left-holder').css('background-color', `#757575`);
                $(this.getHolderBlock().getMainDom()).css('background-color', `#757575`);
            } else if (type === BLOCK_CODE_TYPE.IF || type === BLOCK_CODE_TYPE.FOR
                || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                || type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF || type === BLOCK_CODE_TYPE.FOR_ELSE 
                || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
                $(this.getMainDom()).css('background-color', `#757575`);
                $(this.getMainDom()).find('.vp-block-left-holder').css('background-color', `#757575`);
                $(this.getHolderBlock().getMainDom()).css('background-color', `#757575`);
            } else {
                $(this.getMainDom()).css('background-color', `#757575`); 
                $(this.getMainDom()).find('.vp-block-left-holder').css('background-color', `#757575`);
            }
        }
    
        Block.prototype.renderMyChildBlockColor = function() {
            this.renderClickBlock();
        }
        Block.prototype.renderResetColor = function() {
            var that = this;
            var blockContainerThis = that.getBlockContainerThis();
            var blockList = blockContainerThis.getBlockList();
            blockList.forEach(block => {
                var type = block.getType();
    
                if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF) {
                    $(block.getMainDom()).css('background-color', `#2240c5`);
                    $(block.getMainDom()).find('.vp-block-left-holder').css('background-color', `#2240c5`);
                    $(block.getHolderBlock().getMainDom()).css('background-color', `#2240c5`);
                } else if (type === BLOCK_CODE_TYPE.IF || type === BLOCK_CODE_TYPE.FOR
                    || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                    || type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF 
                    || type === BLOCK_CODE_TYPE.FOR_ELSE || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
                    $(block.getMainDom()).css('background-color', `#cc1f1f`);
                    $(block.getMainDom()).find('.vp-block-left-holder').css('background-color', `#cc1f1f`);
                    $(block.getHolderBlock().getMainDom()).css('background-color', `#cc1f1f`);
                } else {
                    $(block.getMainDom()).css('background-color', `#14c51d`); 
                    $(block.getMainDom()).find('.vp-block-left-holder').css('background-color', `#14c51d`);
                }
            });
            var blockList = blockContainerThis.getBlockList();
            blockList.forEach(block => {
                var mainDom = block.getMainDom();
                $(mainDom).find('.vp-block-delete-btn').remove();
            });
        }
        Block.prototype.renderClickBlock = function() {
            var that = this;
            that.renderResetColor();
    
            var childList = that.selectChildBlockList();
            // console.log('childList', childList);
            childList.forEach(block => {
                $(block.getMainDom()).css('background-color', `#757575`);
                $(block.getMainDom()).find('.vp-block-left-holder').css('background-color', `#757575`);
            });
        }
    
        Block.prototype.getPrevBlock = function() {
            return this.prevBlock
        }
        Block.prototype.setPrevBlock = function(prevBlock) {
            this.prevBlock = prevBlock;
        }
    
        Block.prototype.addNextBlockList = function(nextBlock) {
            this.nextBlockList = [ ...this.nextBlockList, nextBlock]
        }
        Block.prototype.setNextBlockList = function(nextBlockList) {
            this.nextBlockList = nextBlockList;
        }
        Block.prototype.getNextBlockList = function() {
            return this.nextBlockList;
        }
    
        Block.prototype.setDirection = function(direction) {
            this.setState({
                direction
            })
        }
        Block.prototype.getDirection = function() {
            return this.state.direction;
        }
    
        Block.prototype.appendBlock = function(appendedBlock, direction) {
            appendedBlock.setDirection(direction);
            // 새로 들어온 block의 이전 블록이 있다면 데이터 상에서 삭제한다
            var prevBlock = appendedBlock.getPrevBlock();
            if ( prevBlock ) {
                // console.log('prevBlock',prevBlock);
                var nextBlockList = prevBlock.getNextBlockList();
                nextBlockList.some(( nextBlock, index) => {
                    if (nextBlock.getUUID() === appendedBlock.getUUID()) {
                        nextBlockList.splice(index, 1);
                        return true;
                    }
                });
            }
    
            // 새로 들어온 block의 이전 블록을 현재 this블록으로 정함
            appendedBlock.setPrevBlock(this);
    
            // nextBlock 위치 및 관계 재 조정
            //   var direction = blockData.direction;
            var nextBlockList = this.getNextBlockList();
    
            if (direction === BLOCK_DIRECTION.DOWN) {
                // console.log('name',appendedBlock.getName(), nextBlockList);
                if (nextBlockList.length !== 0) {
                    // appendedBlock.setNextBlockList([...nextBlockList]);
                    var selectChildBlockList = appendedBlock.selectChildBlockList();
                    selectChildBlockList[selectChildBlockList.length - 1].setNextBlockList([...nextBlockList]);
                }
           
                nextBlockList.forEach(block => {
                    if (block.getDirection() === BLOCK_DIRECTION.INDENT) {
                        // console.log('name',appendedBlock.getName(), nextBlockList);
                        block.setPrevBlock(appendedBlock);
                        return true;
                    }
                    if (block.getDirection() === BLOCK_DIRECTION.BOTTOM_DOWN) {
                        // console.log('name',appendedBlock.getName());
                        block.setPrevBlock(appendedBlock);
                        return true;
                    }
                    if (block.getDirection() === BLOCK_DIRECTION.DOWN) {
                        // console.log('name',appendedBlock.getName(), nextBlockList);
                        block.setPrevBlock(appendedBlock);
                        return true;
                    }            
                });
                this.setNextBlockList([appendedBlock]);  
            } else if (direction === BLOCK_DIRECTION.INDENT) {
                // console.log('name',appendedBlock.getName(), nextBlockList);
                nextBlockList.some((nextBlock, index ) => {
                    if (nextBlock.getDirection() === direction) {
                        // console.log('name',appendedBlock.getName());
                        // 새로 들어온 block이 기존에 자리잡고 있던 블록을 자식으로 append
                        nextBlock.setDirection(BLOCK_DIRECTION.DOWN);
                        appendedBlock.addNextBlockList(nextBlock);
                        // 기존에 자리잡고 있던 블록이 새로 들어온 block에 밀려남
                        nextBlock.setPrevBlock(appendedBlock);
                        nextBlockList.splice(index, 1);
                        return true;
                    }
                    // if (nextBlock.getDirection() === BLOCK_DIRECTION.DOWN) {
                    //     appendedBlock.setPrevBlock(nextBlock);
                    // }
                });
                this.addNextBlockList(appendedBlock);  
            } else {
                // console.log('name',appendedBlock.getName());
                var currBlock = this.getRootBlock();
                var nextBlockList = currBlock.getNextBlockList();
                // var iter = 0;
                while (nextBlockList.length !== 0) {
                    // if (iter > 100) {
                    //     console.log('무한루프');
                    //     break;
                    // }
                    // iter++;
    
                    var is = nextBlockList.some(block => {
                        if (block.getDirection() === BLOCK_DIRECTION.DOWN) {
                            currBlock = block;
                            return true;
                        } else {
                            return false;
                        }
               
                    });
    
                    if (is === true) {
                        nextBlockList = currBlock.getNextBlockList();
                    } else {
                        break;
                    }
                }
                currBlock.addNextBlockList(appendedBlock);  
                appendedBlock.setPrevBlock(currBlock);
            }
    
            this.resembleRootBlockStack();
        }
    
        Block.prototype.untactBlock = function(x,y) {
            // console.log('언텍트');
            // this블록의 이전 블록이 있다면 데이터 상에서 삭제한다
            var prevBlock = this.getPrevBlock();
            if ( prevBlock ) {
                // console.log('prevBlock',prevBlock);
                var nextBlockList = prevBlock.getNextBlockList();
                // console.log('nextBlockList', nextBlockList);
                nextBlockList.some(( block, index) => {
                    if (block.getUUID() === this.getUUID()) {
                        // console.log('삭제 됨?');
                        nextBlockList.splice(index, 1);
                        this.setPrevBlock(null);
                        return true;
                    }
                });
                prevBlock.setNextBlockList(nextBlockList);
                // console.log('nextBlockList', nextBlockList);
            }
            this.setPrevBlock(null);
            this.setDirection(BLOCK_DIRECTION.ROOT);
    
            this.resembleRootBlockStack();
    
    
            var rootBlockList = [];
            // root block 묶음 별로 분리
            var blockContainerThis = this.getBlockContainerThis();
            var blockList = blockContainerThis.getBlockList();
            blockList.forEach(block => {
                var rootBlock = block.getRootBlock();
                if (rootBlockList.includes(rootBlock)) {
                } else {
                    rootBlockList.push(rootBlock);
                }
            });
    
            var rootBlock = this.getRootBlock();
            var containerDom = rootBlock.getContainerDom();
            $(containerDom).css('top',`${y}` + 'px');
            $(containerDom).css('left',`${x}` + 'px');
            $(containerDom).empty();
    
    
            rootBlock.setContainerDom(containerDom);
    
            var blockStackList = rootBlock.resembleBlockStack();
            this.setBlockStackList(blockStackList);
            blockStackList.forEach((block, index) => {
                var mainDom = block.getMainDom();
                $(mainDom).css('top',`${0}` + 'px');
                $(mainDom).css('left',`${0}` + 'px');
                $(mainDom).attr('data-num-id',`${index}`);
                $(containerDom).append(mainDom);
    
                block.bindEventAll();
            });
        }
    
        /** 트리 구조속의 최상위 루트 block 가져오기 */
        Block.prototype.getRootBlock = function() {
            var rootBlock = null;
            var prevBlock = this.getPrevBlock();
    
            var _iteration = 0;
            while (prevBlock !== null) {
                if (_iteration > 100) {
                    // console.log('무한루프');
                    break;
                }
                _iteration++;
                var _prevBlock = prevBlock.getPrevBlock();
                if (_prevBlock === null) {
                    rootBlock = prevBlock;
                    break;
                }
                prevBlock = _prevBlock;
            }
    
            if (_iteration === 0) {
                // this.render();
                rootBlock = this;
            }
            return rootBlock;
        }
        
        Block.prototype.getMainDomPosition = function() {
            var mainDom = this.getMainDom();
            var clientRect = $(mainDom)[0].getBoundingClientRect();
            return clientRect;
        }
    
        Block.prototype.renderBottomOption = function() {
            // console.log('renderBottomOption');
            var that = this;
            var name = that.getName();
       
            $('.vp-nodeeditor-tab-navigation-node-option-title span').html(`${name.charAt(0).toUpperCase() + name.slice(1)} Option`);
            $('.vp-nodeeditor-bottom-tab-view').empty();
            
            var type = that.getType();
            switch(type) {
                /** class */
                case 1: {
                    var flexRow = $(`<div class='vp-style-flex-row-center' style='padding: 0.5rem;'></div>`);
                    var classBlockOption = $(`<div class='vp-nodeeditor-classoption'
                                                          style='width: 95%;'></div>`);
                    /** class name */
                    var className = that.getState(`className`);
                    var classContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                    <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                        <span class='vp-block-optiontab-name'>name</span>
                                            <div class='vp-style-flex-row-center'>
                                            <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                    </div>
                                    </div>
                                </div>`);
                    var classNameDom = $(`<div class='vp-block-blockoption-else 
                                            vp-nodeeditor-blockoption-block 
                                            vp-nodeeditor-blockoption-inner vp-style-flex-row' 
                                        style='position:relative;'>
                                        <div class='vp-nodeeditor-blockoption-header'>
    
                                            <div class='vp-nodeeditor-blockoption-codeline'>
                                            <input class='vp-nodeeditor-blockoption-input
                                                        vp-nodeeditor-input-class-name' 
                                                value='${className}' 
                                                placeholder='input class name' ></input>
                                            </div>
                                        </div>                                                          
                                    </div>`);
                    classContainer.append( classNameDom );
                    classBlockOption.append(classContainer);
    
                    /** class parameter list */
                    /** */
                    var classInParamList = that.getState(`classInParamList`);
       
    
                    var classInParamContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                                    <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                        <span class='vp-block-optiontab-name'>in param</span>
                                                        <div class='vp-style-flex-row-center' >
                                                            <span class='vp-nodeeditor-elif-number'
                                                                style='margin-right:5px;'>
                                                                ${classInParamList.length} Param
                                                            </span>
                                                            <button class='vp-block-btn vp-nodeeditor-class-inparam-plus-btn'
                                                                    style='margin-right:5px;'>
                                                                + param
                                                            </button>
                                                            <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                        </div>
                                                    </div>
                                                </div>`);
    
                    // defInParam 갯수만큼 bottom block 옵션에 렌더링
                    var classInParamBody = $(`<div class='vp-nodeeditor-elifbody'>
                                            </div>`);
    
                    classInParamList.forEach((classInParam, index ) => {
                        // console.log('defInParam', defInParam);
    
                        var classInParamDom = $(`<div class='vp-style-flex-row'>
                                                    <div class='vp-style-flex-column-center'
                                                        style='margin:0 0.5rem; '>
                                                        ${index+1}
                                                    </div>
                                                    <div class='vp-nodeeditor-blockoption-block
                                                                vp-nodeeditor-blockoption-inner vp-style-flex-row' 
                                                        style='position:relative'>
                                                        <div class='vp-nodeeditor-blockoption-header'>
                                            
                                                            <div class='vp-nodeeditor-blockoption-codeline'>
                                                                <input placeholder='input param' 
                                                                        class='vp-nodeeditor-blockoption-input
                                                                               vp-nodeeditor-input-class-inparam-${index}' 
                                                                        value='${classInParam}'>
                                                            </div>
                                                        </div>                                                          
                                                    </div>
                                                </div>`);
                        var deleteButton = $(`<button class='vp-block-btn'>x</button>`);
                        $(deleteButton).click(function() {
                            that.setState({
                                classInParamList:  [ ...that.getState(`classInParamList`).slice(0, index), 
                                                     ...that.getState(`classInParamList`).slice(index+1, that.getState(`classInParamList`).length) ]
                            });
    
                            var classInParamStr = `(`;
                            that.getState(`classInParamList`).forEach((classInParam, index ) => {
                                classInParamStr += `${classInParam}`;
                                if (that.getState(`classInParamList`).length - 1 !== index ) {
                                    classInParamStr += `, `;
                                }
                            });
                            classInParamStr += `) : `;
                            $(`.vp-block-header-class-param-${that.getUUID()}`).html(classInParamStr);
    
                            that.renderBottomOption();
                        });
                        classInParamDom.append(deleteButton);
                        classInParamBody.append(classInParamDom);
                    });
                    classInParamContainer.append(classInParamBody);
                    classBlockOption.append(classInParamContainer);
    
                  
    
    
                    /** */
                    flexRow.append(classBlockOption);
    
                    /** option 탭에 렌더링된 dom객체 생성 */
                    $('.vp-nodeeditor-bottom-tab-view').append(flexRow);
    
                    /** class 파라미터 변경 이벤트 함수 바인딩 */
                    classInParamList.forEach((classInParam, index ) => {
                        $(`.vp-nodeeditor-input-class-inparam-${index}`).on('change keyup paste', function() {
                            var newParam = $(this).val();
                            // console.log('newParam', newParam);
                            that.setState({
                                classInParamList:  [ ...that.getState(`classInParamList`).slice(0, index), newParam,
                                                    ...that.getState(`classInParamList`).slice(index+1, that.getState(`classInParamList`).length) ]
                            });
                            var classInParamStr = `(`;
                            that.getState(`classInParamList`).forEach((classInParam, index ) => {
                                classInParamStr += `${classInParam}`;
                                if (that.getState(`classInParamList`).length - 1 !== index ) {
                                    classInParamStr += `, `;
                                }
                            });
                            classInParamStr += `) : `;
                            $(`.vp-block-header-class-param-${that.getUUID()}`).html(classInParamStr);
                        });
                    });
    
                    /** 함수 파라미터 생성 이벤트 함수 바인딩 */
                    $(`.vp-nodeeditor-class-inparam-plus-btn`).click(function() {
                        // console.log('def in param plus');
    
                        var newData = '';
    
                        that.setState({
                            classInParamList: [ ...that.getState(`classInParamList`), newData ]
                        });
                        that.renderBottomOption();
                    });
    
                    /** class 이름 변경 함수 바인딩 */
                    $(`.vp-nodeeditor-input-class-name`).on('change keyup paste', function() {
                        that.setState({
                            optionState: {
                                classState: {
                                    className: $(this).val()
                                }
                            }
                        });

                        $(`.vp-block-header-class-name-${that.getUUID()}`).html($(this).val());
                    });
    
                    break;
                }
                 /** def */
                 case 2: {
                    var flexRow = $(`<div class='vp-style-flex-row-center' 
                                          style='padding: 0.5rem;'></div>`);
                    var defBlockOption  = $(`<div class='vp-nodeeditor-defoption'
                                                  style='width: 95%;'></div>`);
                    
                    /** 함수 이름 function name */
                    var defName = that.getState(`defName`);
    
    
                    var defContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                    <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                        <span class='vp-block-optiontab-name'>name</span>
                                            <div class='vp-style-flex-row-center'>
                                            <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                    </div>
                                    </div>
                                </div>`);
                    var defNameDom = $(`<div class='vp-block-blockoption-else 
                                            vp-nodeeditor-blockoption-block 
                                            vp-nodeeditor-blockoption-inner vp-style-flex-row' 
                                        style='position:relative;'>
                                        <div class='vp-nodeeditor-blockoption-header'>
    
                                            <div class='vp-nodeeditor-blockoption-codeline'>
                                            <input class='vp-nodeeditor-blockoption-input
                                                    vp-nodeeditor-input-def-name' 
                                                value='${defName}' 
                                                placeholder='input function name' ></input>
                                            </div>
                                        </div>                                                          
                                    </div>`);
                    defContainer.append( defNameDom );
                    defBlockOption.append(defContainer);
    
                    /** 함수 파라미터 */
                    var defInParamList = that.getState(`defInParamList`);
       
    
                    var defInParamContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                                <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                    <span class='vp-block-optiontab-name'>in param</span>
                                                    <div class='vp-style-flex-row-center' >
                                                        <span class='vp-nodeeditor-elif-number'
                                                              style='margin-right:5px;'>
                                                            ${defInParamList.length} Param
                                                        </span>
                                                        <button class='vp-block-btn vp-nodeeditor-def-inparam-plus-btn'
                                                                style='margin-right:5px;'>
                                                            + param
                                                        </button>
                                                        <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                    </div>
                                                </div>
                                            </div>`);
    
                    // defInParam 갯수만큼 bottom block 옵션에 렌더링
                    var defInParamBody = $(`<div class='vp-nodeeditor-elifbody'>
                                            </div>`);
    
                    defInParamList.forEach((defInParam, index ) => {
                        // console.log('defInParam', defInParam);
    
                        var defInParamDom = $(`<div class='vp-style-flex-row'>
                                                    <div class='vp-style-flex-column-center'
                                                        style='margin:0 0.5rem; '>
                                                        ${index+1}
                                                    </div>
                                                    <div class='vp-nodeeditor-blockoption-block
                                                                vp-nodeeditor-blockoption-inner vp-style-flex-row' 
                                                        style='position:relative'>
                                                        <div class='vp-nodeeditor-blockoption-header'>
                                            
                                                            <div class='vp-nodeeditor-blockoption-codeline'>
                                                                <input placeholder='input param' 
                                                                        class='vp-nodeeditor-blockoption-input
                                                                               vp-nodeeditor-input-def-inparam-${index}' 
                                                                        value='${defInParam}'>
                                                            </div>
                                                        </div>                                                          
                                                    </div>
                                                </div>`);
                        var deleteButton = $(`<button class='vp-block-btn'>x</button>`);
                        $(deleteButton).click(function() {
                            that.setState({
                                defInParamList:  [ ...that.getState(`defInParamList`).slice(0, index), 
                                                    ...that.getState(`defInParamList`).slice(index+1, that.getState(`defInParamList`).length) ]
                            });
    
                            var defInParamStr = `(`;
                            that.getState(`defInParamList`).forEach((defInParam, index ) => {
                                defInParamStr += `${defInParam}`;
                                if (that.getState(`defInParamList`).length - 1 !== index ) {
                                    defInParamStr += `, `;
                                }
                            });
                            defInParamStr += `) : `;
                            $(`.vp-block-header-def-param-${that.getUUID()}`).html(defInParamStr);
    
                            that.renderBottomOption();
                        });
                        defInParamDom.append(deleteButton);
                        defInParamBody.append(defInParamDom);
                    });
                    defInParamContainer.append(defInParamBody);
                    defBlockOption.append(defInParamContainer);
    
                    /** */
    
                    flexRow.append(defBlockOption);
         
                    /** bottom block option 탭에 렌더링된 dom객체 생성 */
                    $('.vp-nodeeditor-bottom-tab-view').append(flexRow);
    
                     /** 함수 파라미터 변경 이벤트 함수 바인딩 */
                    defInParamList.forEach((defInParam, index ) => {
                        $(`.vp-nodeeditor-input-def-inparam-${index}`).on('change keyup paste', function() {
                            var newParam = $(this).val();
                            // console.log('newParam', newParam);
                            that.setState({
                                defInParamList:  [ ...that.getState(`defInParamList`).slice(0, index), newParam,
                                                    ...that.getState(`defInParamList`).slice(index+1, that.getState(`defInParamList`).length) ]
                            });
                            var defInParamStr = `(`;
                            that.getState(`defInParamList`).forEach((defInParam, index ) => {
                                defInParamStr += `${defInParam}`;
                                if (that.getState(`defInParamList`).length - 1 !== index ) {
                                    defInParamStr += `, `;
                                }
                            });
                            defInParamStr += `) : `;
                            $(`.vp-block-header-def-param-${that.getUUID()}`).html(defInParamStr);
                        });
                    });
    
                    /** 함수 파라미터 생성 이벤트 함수 바인딩 */
                    $(`.vp-nodeeditor-def-inparam-plus-btn`).click(function() {
                        // console.log('def in param plus');
    
                        var newData = '';
    
                        that.setState({
                            optionState: {
                                defState: {
                                    defInParamList: [ ...that.state.optionState.defState.defInParamList, newData ]
                                }
                            }
                        });
                        that.renderBottomOption();
                    });
    
                    /** 함수 이름 변경 */
                    $(`.vp-nodeeditor-input-def-name`).on('change keyup paste', function() {
                        that.setState({
                            optionState: {
                                defState: {
                                    defName: $(this).val()
                                }
                            }
                        });
                        $(`.vp-block-header-def-name-${that.getUUID()}`).html($(this).val());
                    });
    
                    break;
                }
                /** if */
                case 3: {
                    var flexRow = $(`<div class='vp-style-flex-row-center' 
                                          style='padding: 0.5rem;'></div>`);
                    var ifBlockOption  = $(`<div class='vp-nodeeditor-ifoption'
                                                 style='width: 95%;'>
                                               
                                            </div>`);
    
                    /* ------------- if ------------- */
                    var ifContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                                <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                    <span class='vp-block-optiontab-name'>if</span>
                                                        <div class='vp-style-flex-row-center'>
                                                        <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                 </div>
                                                </div>
                                            </div>`);
                    var ifDom = $(`<div class='vp-block-blockoption-else 
                                               vp-nodeeditor-blockoption-block 
                                               vp-nodeeditor-blockoption-inner vp-style-flex-row' 
                                        style='position:relative;'>
                                        <div class='vp-nodeeditor-blockoption-header'>
    
                                            <div class='vp-nodeeditor-blockoption-codeline'>
                                                <input placeholder='input code' 
                                                    class='vp-nodeeditor-blockoption-input
                                                           vp-nodeeditor-if-input' 
                                                    value='${this.getState("ifCodeLine")}'>
                                            </div>
                                        </div>                                                          
                                    </div>`);
                                 
                    ifContainer.append( ifDom );
                    ifBlockOption.append(ifContainer);
                    /* -------------elif -------------* */
             
                    var elifList = [];
                    var nextBlockDataList = that.getNextBlockList();
                    var stack = [];
                    if (nextBlockDataList.length !== 0) {
                        stack.push(nextBlockDataList);
                    }
           
                    var isBreak = false;
                    var current;
                    while (stack.length !== 0) {
                        current = stack.shift();
                        /** 배열 일 때 */
                        if (Array.isArray(current)) {
                            current.forEach(element => {
                                if ( element.getDirection() === BLOCK_DIRECTION.DOWN && element.getType() === BLOCK_CODE_TYPE.IF) {
                                    isBreak = true;
                                }
                                if (element.getDirection() === BLOCK_DIRECTION.DOWN ) {
    
                                    stack.push(element);
                                    if ( element.getType() === 100) {
                                        elifList.push(element);
                                    }
                                }
                            });
                        
            
                        } else {
                            var currBlock = current;
                            var nextBlockDataList = currBlock.getNextBlockList();
                            stack.unshift(nextBlockDataList);
                        }
    
                        if (isBreak) {
                            break;
                        }
                    }
    
    
                    var elifContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                                <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                    <span class='vp-block-optiontab-name'>elif</span>
                                                    <div class='vp-style-flex-row-center' >
                                                        <span class='vp-nodeeditor-elif-number'
                                                              style='margin-right:5px;'>
                                                            ${elifList.length} Block
                                                        </span>
                                                        <button class='vp-block-btn vp-nodeeditor-elif-plus-btn'
                                                                style='margin-right:5px;'>
                                                            + elif
                                                        </button>
                                                        <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                    </div>
                                                </div>
                                            </div>`);
    
                    // elif 갯수만큼 bottom block 옵션에 렌더링
                    var elifBody = $(`<div class='vp-nodeeditor-elifbody'>
                                      </div>`);
    
                    elifList.forEach((elifData, index ) => {
                        var elifDom = $(`<div class='vp-style-flex-row'>
                                            <div class='vp-style-flex-column-center'
                                                 style='margin:0 0.5rem;'>
                                                ${index+1}
                                            </div>
                                            <div class='vp-nodeeditor-blockoption-block
                                                        vp-nodeeditor-blockoption-inner vp-style-flex-row' 
                                                style='position:relative'>
                                                <div class='vp-nodeeditor-blockoption-header'>
                                      
                                                    <div class='vp-nodeeditor-blockoption-codeline'>
                                                        <input placeholder='input code' 
                                                               class='vp-nodeeditor-blockoption-input
                                                                   vp-nodeeditor-elif-input-${index}' 
                                                                value='${elifData.getState('elifCodeLine')}'>
                                                    </div>
                                                </div>                                                          
                                            </div>
                                        </div>`);
                        var deleteButton = $(`<button class='vp-block-btn'>x</button>`);
                        $(deleteButton).click(function() {
                            /** 부모 에서 this를 제거  */
                            var prevBlock = elifData.getPrevBlock();
    
                            if ( prevBlock ) {
                                var nextBlockDataList = prevBlock.getNextBlockList();
                                nextBlockDataList.some(( nextBlock, index) => {
                                    if (nextBlock.getUUID() === elifData.getUUID()) {
                                        nextBlockDataList.splice(index, 1);
                                        return true;
                                    }
                                });
                            }
                            elifData.setPrevBlock(null);
                            elifData.getNullBlock().deleteBlockOne();
                            elifData.getHolderBlock().deleteBlockOne();
    
                            $(elifData.getMainDom()).remove();
                            $(elifData.getContainerDom()).remove();
    
                            that.renderBottomOption();
                            
                            var blockContainerThis = that.getBlockContainerThis();
                            blockContainerThis.renderBlockLeftHolderListHeight();

                            blockContainerThis.deleteBlock(elifData.getUUID());
                        });
                        elifDom.append(deleteButton);
                        elifBody.append(elifDom);
                    });
                    elifContainer.append(elifBody);
                    ifBlockOption.append(elifContainer);
    
                    /* ------------- else ------------- */
                    var elseContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                                <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                    <span class='vp-block-optiontab-name'>else</span>
                                                    <div class='vp-style-flex-row-center'>
                                                        <select class='vp-nodeeditor-blockoption-select'
                                                                style='margin-right:5px;'>
                                                            <option value='no' ${this.getState('isIfElse') === false ? 'selected': ''}>No</option>
                                                            <option value='yes' ${this.getState('isIfElse') === true ? 'selected': ''}>Yes</option>
                                                        </select>
                                                        <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                    </div>
                                                </div>
                                            </div>`);
    
                    ifBlockOption.append(elseContainer);
    
                    flexRow.append(ifBlockOption);
         
                    /** bottom block option 탭에 렌더링된 dom객체 생성 */
                    $('.vp-nodeeditor-bottom-tab-view').append(flexRow);
    
         
                    /** else select 이벤트 함수 바인딩 */
                    $('.vp-nodeeditor-blockoption-select').change(function() {
                        var isElse = $(':selected', this).val();
                        if (isElse === 'yes') {
                            
                            // console.log(that.getType(), that.getName())
                            /** else 생성 */
                            var nextBlockDataList = that.getNextBlockList();
                            var stack = [];
                
                            if (nextBlockDataList.length !== 0) {
                                stack.push(nextBlockDataList);
                                var beforeElseBlock = null;
                                var current;
                                var isBreak = false;
                                var prevBlock = null;
                                while (stack.length !== 0) {
                                    if (isBreak) {
                                        break;
                                    }
                                    current = stack.shift();
                                
                                  
                                    /** 배열 일 때 */
                                    if (Array.isArray(current)) {
                                        current.some(element => {
                                            if (element.getDirection() === BLOCK_DIRECTION.DOWN) {
    
                                                prevBlock = element.getPrevBlock();
                                                if ( element.getType() === BLOCK_CODE_TYPE.IF) {
                                                    isBreak = true;
                                                    beforeElseBlock = prevBlock;
                                                    return true;
                                                }
    
                                
                                                if ( ( prevBlock.getType() === BLOCK_CODE_TYPE.IF
                                                          || prevBlock.getType() === BLOCK_CODE_TYPE.ELIF ) ) {
        
                                                    if ( element.getNextBlockList().length === 0 ) {
                                                        // console.log('0')
                                                        isBreak = true;
    
                                                        if ( element.getType() === BLOCK_CODE_TYPE.ELIF ) {
                                                            beforeElseBlock = element;
                                                        } else {
                                                            beforeElseBlock = prevBlock;
                                                        }
                                                    
        
                                                        return true;
                                                    } 
       
                                                    else {
                                               
                                                        element.getNextBlockList().some(el2 => {
                                                            if (el2.getDirection() === BLOCK_DIRECTION.DOWN 
                                                                && el2.getType() !== BLOCK_CODE_TYPE.ELIF) {
                                                                // console.log('2');   
                                                                isBreak = true;
                                                                beforeElseBlock = element;
                                                                
                                                                return true;
                                                            }
                                                        });
                                                    }
                                                } else {
                                               
                                                }
                                                
                                                stack.push(element);
                                            } else {
                                           
                                                /** direction indent 이면서*/
                                                prevBlock = element.getPrevBlock();
                                                if ( prevBlock.getNextBlockList().length === 1 ) {
                                              
                                                    isBreak = true;
                                                    beforeElseBlock = prevBlock;
                                                }
                                            }
                                        });
                        
                                    } else {
                                        var currBlock = current;
                                        var nextBlockDataList = currBlock.getNextBlockList();
                                        stack.unshift(nextBlockDataList);
                                    }
                                }
                              
                                var blockContainerThis = that.getBlockContainerThis();
                                var newBlock = mapTypeToBlock(blockContainerThis, BLOCK_CODE_TYPE.ELSE, {pointX: 0, pointY: 0})
                                that.setState({
                                    isIfElse: true
                      
                                });
        
    
                                beforeElseBlock.getHolderBlock().appendBlock(newBlock, BLOCK_DIRECTION.DOWN );
                            
                            } else {
                                var blockContainerThis = that.getBlockContainerThis();
                                var newBlock = mapTypeToBlock(blockContainerThis, BLOCK_CODE_TYPE.ELSE, {pointX: 0, pointY: 0})
                                that.setState({
                                    isIfElse: true
                                });
        
                            
                                that.getHolderBlock().appendBlock(newBlock, BLOCK_DIRECTION.DOWN);
                            }
                   
                           
                      
                        } else {
                        /** else 삭제 */
                            var nextBlockDataList = that.getNextBlockList();
                            var stack = [];
                
                            if (nextBlockDataList.length !== 0) {
                                stack.push(nextBlockDataList);
                            }
    
                            var isBreak = false;
                            var current;
                            while (stack.length !== 0) {
                                current = stack.shift();
                                // var isBreak = false;
                                /** 배열 일 때 */
                                if (Array.isArray(current)) {
                                    current.forEach(element => {
                                        if (element.getDirection() === BLOCK_DIRECTION.DOWN) {
                              
                                            stack.push(element);
                                            if ( element.getType() === BLOCK_CODE_TYPE.ELSE ) {
                                                isBreak = true;
                                                element.deleteBlockOne();
                                         
                                                element.getNullBlock().deleteBlockOne();
                                                element.getHolderBlock().deleteBlockOne();
                                                element.getNextBlockList().some(el => {
                                                    if (el.getDirection() === BLOCK_DIRECTION.INDENT) {
                                                        el.deleteBlock();
                                                        return true;
                                                    }
                                                });
                                            }
                                        }
                                    });
                    
                                } else {
                                    var currBlock = current;
                                    var nextBlockDataList = currBlock.getNextBlockList();
                                    stack.unshift(nextBlockDataList);
                                }
    
                                if (isBreak) {
                                    break;
                                }
                            }
                          
                            that.setState({
                                isIfElse: false
                            });
                    
                        }
                        var blockContainerThis = that.getBlockContainerThis();
                        blockContainerThis.renderBlockLeftHolderListHeight();
                    });
    
                    /** elif 생성 이벤트 함수 바인딩 */
                    $(`.vp-nodeeditor-elif-plus-btn`).click(function() {
                        var elifCodeLine = '';
    
                        that.setState({
                            optionState: {
                                ifState: {
                                    elifList: [ ...that.state.optionState.ifState.elifList, elifCodeLine ]
                                }
                            }
                        });
    
                        /** ++ elif */
                         
                        var blockContainerThis = that.getBlockContainerThis();
                        var newBlock = mapTypeToBlock(blockContainerThis, BLOCK_CODE_TYPE.ELIF, {pointX: 0, pointY: 0})
       
                        that.getHolderBlock().appendBlock(newBlock, BLOCK_DIRECTION.DOWN);
    
                        that.renderBottomOption();
    
                        blockContainerThis.renderBlockLeftHolderListHeight();
       
                    });
    
                    /** if code 변경 */
                    $(`.vp-nodeeditor-if-input`).on("change keyup paste", function() {
                        that.setState({
                            ifCodeLine: $(this).val()
                        });
                        $(`.vp-block-header-if-code-${that.getUUID()}`).html(that.getState('ifCodeLine'));
                    });
    
                    /** elif code 변경 */
                    elifList.forEach((elifData, index) => {
                        $(`.vp-nodeeditor-elif-input-${index}`).on("change keyup paste", function() {
                            var updatedData = $(this).val();
                            elifData.setState({
                                elifCodeLine: updatedData
                            });
    
                            $(`.vp-block-header-elif-code-${elifData.getUUID()}`).html(updatedData);
                        });
                    });
    
                    break;
                }       
                /** for */
                case 4: {
                    var flexRow = $(`<div class='vp-style-flex-row-center' 
                                          style='padding: 0.5rem;'></div>`);
                    var forBlockOption  = $(`<div class='vp-nodeeditor-foroption'
                                                style='width: 95%;'>
                                                
                                            </div>`);
         
                    /* ------------- for -------------- */
                    var forContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                                <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                    <span class='vp-block-optiontab-name'>for</span>
                                                    <div class='vp-style-flex-row-center'>
       
                                                        <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                    </div>
                                                </div>
                                            </div>`);
                    var forDom = $(`<div class='vp-block-blockoption-else 
                                                vp-nodeeditor-blockoption-block 
                                                vp-nodeeditor-blockoption-inner vp-style-flex-row' 
                                            style='position:relative;'>
                                        <div class='vp-nodeeditor-blockoption-header'>
    
                                            <div class='vp-nodeeditor-blockoption-codeline'>
                                                <input placeholder='input code' 
                                                    class='vp-nodeeditor-blockoption-input
                                                           vp-nodeeditor-for-input' value='${that.getState('forCodeLine')}'>
                                            </div>
                                        </div>                                                          
                                    </div>`);
    
            
                    forContainer.append(forDom );
                    forBlockOption.append(forContainer);
                    flexRow.append(forBlockOption);
                    /* ------------- else ------------- */
                    var elseContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                                <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                    <span class='vp-block-optiontab-name'>else</span>
                                                    <div class='vp-style-flex-row-center'>
                                                        <select class='vp-nodeeditor-select
                                                                        vp-nodeeditor-blockoption-forelse-select'
                                                                style='margin-right:5px;'>
                                                            <option value='no' ${this.getState('isForElse') === false ? 'selected': ''}>No</option>
                                                            <option value='yes' ${this.getState('isForElse') === true ? 'selected': ''}>Yes</option>
                                                        </select>
                                                        <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                    </div>
                                                </div>
                                            </div>`);
    
                    forBlockOption.append(elseContainer);
                    flexRow.append(forBlockOption);
    
                    /** bottom block option 탭에 렌더링된 dom객체 생성 */
                    $('.vp-nodeeditor-bottom-tab-view').append(flexRow);
    
                    /** if code 변경 */
                    $(`.vp-nodeeditor-for-input`).on("change keyup paste", function() {
                        that.setState({
                            forCodeLine: $(this).val()
                        });
                        $(`.vp-block-header-for-code-${that.getUUID()}`).html(that.getState('forCodeLine'));
                    });
    
                    $(`.vp-block-header-if-code-${that.getUUID()}`).html(that.getState('ifCodeLine'));
    
                    /** else select 이벤트 함수 바인딩 */
                    $('.vp-nodeeditor-blockoption-forelse-select').change(function() {
                        var isElse = $(':selected', this).val();
                        if (isElse === 'yes') {
             
                            /** else 생성 */
                            var blockContainerThis = that.getBlockContainerThis();
                            var newBlock = mapTypeToBlock(blockContainerThis, 201, {pointX: 0, pointY: 0})
                            that.setState({
                                isForElse: true
    
                            });
    
                            that.getHolderBlock().appendBlock(newBlock, BLOCK_DIRECTION.DOWN);
    
                        } else {
                            
                            var nextBlockDataList = that.getNextBlockList();
                            var stack = [];
                
                            if (nextBlockDataList.length !== 0) {
                                stack.push(nextBlockDataList);
                            }
                   
                            var current;
                            while (stack.length !== 0) {
                                current = stack.shift();
                                var isIf = false;
                                /** 배열 일 때 */
                                if (Array.isArray(current)) {
                                    current.forEach(element => {
                                        if (element.getDirection() === BLOCK_DIRECTION.DOWN) {
                                      
                                            stack.push(element);
                                            if ( element.getType() === 201) {
                                                isIf = true;
                                                element.deleteBlock();
                                            }
                                        }
                                    });
                    
                                } else {
                                    var currBlock = current;
                                    var nextBlockDataList = currBlock.getNextBlockList();
                                    stack.unshift(nextBlockDataList);
                                }
    
                                if (isIf) {
                                    break;
                                }
                            }
    
                            that.setState({
                                isForElse: false
                            });
                       
                        }
                        that.resembleRootBlockStack();
                        var blockContainerThis = that.getBlockContainerThis();
                        blockContainerThis.renderBlockLeftHolderListHeight();
                    });
                    break;
                }
                /** while */
                case 5: {
                    var flexRow = $(`<div class='vp-style-flex-row-center' 
                                          style='padding: 0.5rem;'></div>`);
                    var whileBlockOption  = $(`<div class='vp-nodeeditor-foroption'
                                        style='width: 95%;'>
                                        
                                    </div>`);
    
                    /* ------------- while -------------- */
                    var whileContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                        <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                            <span class='vp-block-optiontab-name'>while</span>
                                            <div class='vp-style-flex-row-center'>
    
                                                <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                            </div>
                                        </div>
                                    </div>`);
                    var whileDom = $(`<div class='vp-block-blockoption-else 
                                                vp-nodeeditor-blockoption-block 
                                                vp-nodeeditor-blockoption-inner vp-style-flex-row' 
                                            style='position:relative;'>
                                        <div class='vp-nodeeditor-blockoption-header'>
    
                                            <div class='vp-nodeeditor-blockoption-codeline'>
                                                <input placeholder='input code' 
                                                    class='vp-nodeeditor-blockoption-input
                                                           vp-nodeeditor-while-input' value='${that.getState('whileCodeLine')}'>
                                            </div>
                                        </div>                                                          
                                    </div>`);
    
                    whileContainer.append(whileDom );
                    whileBlockOption.append(whileContainer);
                    flexRow.append(whileBlockOption);
    
                    /** bottom block option 탭에 렌더링된 dom객체 생성 */
                    $('.vp-nodeeditor-bottom-tab-view').append(flexRow);
    
                    /** if code 변경 */
                    $(`.vp-nodeeditor-while-input`).on("change keyup paste", function() {
                        that.setState({
                            whileCodeLine: $(this).val()
                        });
                        $(`.vp-block-header-while-code-${that.getUUID()}`).html(that.getState('whileCodeLine'));
                    });
                    break;
                }
                /** import */
                case 6: {
                    var baseImportList = that.getState('baseImportList');
                    // console.log('baseImport', Object.values(baseImport));
    
                    var flexRow = $(`<div class='vp-style-flex-row-center' 
                                          style='padding: 0.5rem;'></div>`);
                    var importBlockOption  = $(`<div class='vp-nodeeditor-ifoption'
                                                     style='width: 95%;'>
                                                    
                                                </div>`);
                    /* ------------- import -------------- */
                    var countisImport = 0;
                    baseImportList.forEach(baseImportData => {
                        if (baseImportData.isImport === true ) {
                            countisImport += 1;
                        };
                    });
                    var defaultImportContainer = $(`<div class='vp-nodeeditor-blockoption-default-import-container'>
                                                        <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                            <span class='vp-block-optiontab-name'>default</span>
                                                            <div class='vp-style-flex-row-center'>
                                                                <span class='vp-nodeeditor-default-import-number'
                                                                        style='margin-right:5px;'>
                                                                    ${countisImport} Selected
                                                                </span>
                                                                <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                            </div>
                                                        </div>
                                                    </div>`);
                    var defaultImportBody = $('<div><div>');
                    baseImportList.forEach((baseImportData,index) => {
                        const { isImport, baseImportName, baseAcronyms } = baseImportData;
    
                        var defaultImportDom = $(`<div class='vp-style-flex-row-between'
                                                       style='padding: 0.1rem 0;'>
                                                        <div class='vp-style-flex-column-center'>
                                                            <input class='vp-nodeeditor-blockoption-default-import-input-${index}' 
                                                                    type='checkbox' 
                                                                    ${isImport === true ? 'checked': ''}>
                                                            </input>
                                                        </div>
                                                        <div class='vp-style-flex-column-center'>
                                                            <span style='font-size:12px; font-weight:700;'> ${baseImportName}</span>
                                                        </div>
                                                        <div class='vp-style-flex-column-center'
                                                             style='width: 50%;     text-align: center;'>
                                                             <span class=''>${baseAcronyms}</span>
                                                 
                                                        </div>
                                                </div>`);
                        defaultImportBody.append(defaultImportDom);                        
                    });
                    defaultImportContainer.append(defaultImportBody);
                    importBlockOption.append(defaultImportContainer);
    
                    /** -------------custom import ------------------ */
                    var customImportList = that.getState(`customImportList`);
                    var countIsCustomImport = 0;
                    customImportList.forEach(baseImportData => {
                        if (baseImportData.isImport === true ) {
                            countIsCustomImport += 1;
                        };
                    });
                    // customImport 갯수만큼 bottom block 옵션에 렌더링
                    var customImportContainer = $(`<div class='vp-nodeeditor-blockoption-custom-import-container'>
                                                        <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                            <span class='vp-block-optiontab-name'>custom</span>
                                                            <div class='vp-style-flex-row-center'>
    
                                                                <span class='vp-nodeeditor-elif-number'
                                                                        style='margin-right:5px;'>
                                                                    ${countIsCustomImport} Selected
                                                                </span>
                                                                <button class='vp-block-btn vp-nodeeditor-custom-import-plus-btn'
                                                                        style='margin-right:5px;'>
                                                                    + import
                                                                </button>
                                                                <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                            </div>
                                                        </div>
                                                    </div>`);
    
                    var customImportBody = $(`<div class='vp-nodeeditor-customimport-body'>
                                              </div>`);
                    customImportList.forEach((customImportData, index ) => {
                        const { isImport, baseImportName, baseAcronyms } = customImportData;
                      
                        var customImportDom = $(`<div class='vp-style-flex-row-between'>
                                                        <div class='vp-style-flex-column-center'>
                                                            <input class='vp-nodeeditor-blockoption-custom-import-input
                                                                          vp-nodeeditor-blockoption-custom-import-input-${index}' 
                                                                    type='checkbox' 
                                                                    ${isImport === true ? 'checked': ''}>
                                                            </input>
                                                        </div>
                                                        <select class='vp-nodeeditor-select
                                                                        vp-nodeeditor-blockoption-custom-import-select
                                                                        vp-nodeeditor-blockoption-custom-import-select-${index}'
                                                                style='margin-right:5px;'>
                                                            <option value='numpy' ${baseImportName === 'numpy' ? 'selected': ''}>
                                                                numpy
                                                            </option>
                                                            <option value='pandas' ${baseImportName === 'pandas' ? 'selected': ''}>
                                                                pandas
                                                            </option>
                                                            <option value='matplotlib' ${baseImportName === 'matplotlib' ? 'selected': ''}>
                                                                matplotlib
                                                            </option>
                                                            <option value='seaborn' ${baseImportName === 'seaborn' ? 'selected': ''}>
                                                                seaborn
                                                            </option>
                                                            <option value='os' ${baseImportName === 'os' ? 'selected': ''}>
                                                                os
                                                            </option>
                                                            <option value='pandas' ${baseImportName === 'sys' ? 'selected': ''}>
                                                                sys
                                                            </option>
                                                            <option value='time' ${baseImportName === 'time' ? 'selected': ''}>
                                                                time
                                                            </option>
                                                            <option value='datetime' ${baseImportName === 'datetime' ? 'selected': ''}>
                                                                datetime
                                                            </option>
                                                            <option value='random' ${baseImportName === 'random' ? 'selected': ''}>
                                                                random
                                                            </option>
                                                            <option value='math' ${baseImportName === 'math' ? 'selected': ''}>
                                                                math
                                                            </option>
                                                        </select>
                                                        <div class='vp-style-flex-column-center'>
                                                            <input class='vp-nodeeditor-blockoption-custom-import-textinput
                                                                          vp-nodeeditor-blockoption-custom-import-textinput-${index}'
                                                                   style='' 
                                                                    type='text' 
                                                                    placeholder='input import'
                                                                    value='${baseAcronyms}'></input>
                                                        </div>
                                                </div>`);
                        var deleteButton = $(`<button class='vp-block-btn'>x</button>`);
                        $(deleteButton).click(function() {
                            that.setState({
                                customImportList:  [ ...that.getState(`customImportList`).slice(0, index), 
                                                     ...that.getState(`customImportList`).slice(index+1, that.getState(`customImportList`).length) ]
                            });
                            that.renderBottomOption();
                        });
                        customImportDom.append(deleteButton);
                        customImportBody.append(customImportDom);
                    });
                    customImportContainer.append(customImportBody);
                    importBlockOption.append(customImportContainer);
    
                    flexRow.append(importBlockOption);
               
                    $('.vp-nodeeditor-bottom-tab-view').append(flexRow);
    
                    $('.vp-nodeeditor-custom-import-plus-btn').click(function() {
                        var newData = {
                            baseAcronyms : ''
                            , baseImportName : 'numpy'
                            , isImport : false
                        }
                        that.setState({
                            optionState: {
                                importState: {
                                    customImportList: [ ...that.getState(`customImportList`), newData ]
                                }
                            }
                        });
                        that.renderBottomOption();
                    });
    
                    customImportList.forEach((customImportData, index) => {
                        const { isImport, baseImportName, baseAcronyms } = customImportData;
                        $(`.vp-nodeeditor-blockoption-custom-import-input-${index}`).click(function() {
                            if (isImport === true) {
                                var updatedData = {
                                    baseAcronyms: that.getState(`customImportList`)[index].baseAcronyms
                                    , baseImportName
                                    , isImport: false
                                }
                                that.setState({
                                    optionState: {
                                        importState: {
                                            customImportList: [ ...that.getState(`customImportList`).slice(0, index), updatedData
                                                                , ...that.getState(`customImportList`).slice(index+1, that.getState(`customImportList`).length) ]
                                        }
                                    }
                                });
                            } else {
                                var updatedData = {
                                    baseAcronyms
                                    , baseImportName
                                    , isImport: true
                                }
                                that.setState({
                                    optionState: {
                                        importState: {
                                            customImportList: [ ...that.getState(`customImportList`).slice(0, index), updatedData
                                                                , ...that.getState(`customImportList`).slice(index+1, that.getState(`customImportList`).length) ]
                                        }
                                    }
                                });
                            }
                            that.renderBottomOption();
                        })
                        $(`.vp-nodeeditor-blockoption-custom-import-select-${index}`).change(function()  {
                            var updatedData = {
                                baseAcronyms: that.getState(`customImportList`)[index].baseAcronyms
                                , baseImportName : $(':selected', this).val()
                                , isImport
                            }
                            that.setState({
                                optionState: {
                                    importState: {
                                        customImportList: [ ...that.getState(`customImportList`).slice(0, index), updatedData
                                                            , ...that.getState(`customImportList`).slice(index+1, that.getState(`customImportList`).length) ]
                                    }
                                }
                            });
                            that.renderBottomOption();
                        });
                        $(`.vp-nodeeditor-blockoption-custom-import-textinput-${index}`).on("change keyup paste", function() {
                            var updatedData = {
                                baseAcronyms : $(this).val()
                                , baseImportName 
                                , isImport
                            }
                            that.setState({
                                optionState: {
                                    importState: {
                                        customImportList: [ ...that.getState(`customImportList`).slice(0, index), updatedData
                                                            , ...that.getState(`customImportList`).slice(index+1, that.getState(`customImportList`).length) ]
                                    }
                                }
                            });
        
                        });
                    });
                    
                    baseImportList.forEach((_, index) => {
                        $(`.vp-nodeeditor-blockoption-default-import-input-${index}`).click(function() {
    
                            var isImport = that.getState(`baseImportList`)[index].isImport;
                            var baseImportName = that.getState(`baseImportList`)[index].baseImportName;
                            var baseAcronyms = that.getState(`baseImportList`)[index].baseAcronyms;
    
                            if (isImport === true) {
                                var updatedData = {
                                    isImport: false
                                    , baseImportName
                                    , baseAcronyms
                                }
                          
                                that.setState({
                                    optionState: {
                                        importState: {
                                            baseImportList: [ ...that.getState(`baseImportList`).slice(0, index), updatedData
                                                              , ...that.getState(`baseImportList`).slice(index+1, that.getState(`baseImportList`).length) ]
                                        }
                                    }
                                });
                            } 
                            else  {
                                var updatedData = {
                                    isImport: true
                                    , baseImportName
                                    , baseAcronyms
                                    
                                }
                            
                                that.setState({
                                    optionState: {
                                        importState: {
                                            baseImportList: [ ...that.getState(`baseImportList`).slice(0, index), updatedData
                                                              , ...that.getState(`baseImportList`).slice(index+1, that.getState(`baseImportList`).length) ]
                                        }
                                    }
                                });
                            }
                            that.renderBottomOption();
                        }); 
                    });
                    break;
                }
                /** api */
                case 7: {
                    var flexRow = $(`<div class='vp-style-flex-row-center' 
                                          style='padding: 0.5rem;'></div>`);
                    var apiBlockOption  = $(`<div class='vp-nodeeditor-blockoption vp-nodeeditor-ifoption'
                                                style='width: 95%;'>
                                            </div>`);
                    /* ---------------- Api --------------- */
                    var apiContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                            <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                <span class='vp-block-optiontab-name'>navigator</span>
                                                <div class='vp-style-flex-row-center'>
                                                    <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                </div>
                                            </div>
                                        </div>`);
                    var apiDom = $(`<div class="vp-nodeeditor-tab-navigation-node-body
                                                vp-nodeeditor-tab-navigation-node-block-body
                                                vp-style-flex-row-between-wrap">
                                                <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                    <span>NUMPY</span>
                                                </div>
                                                <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                    <span>PANDAS</span>
                                                </div>
                                                <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                    <span>OS</span>
                                                </div>
                                                <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                    <span>SYS</span>
                                                </div>
                                                <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                    <span>DATE</span>
                                                </div>
                                                <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                    <span>DATETIME</span>
                                                </div>
                                                <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                    <span>MATH</span>
                                                </div>
                                                <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                    <span>RANDOM</span>
                                                </div>
                                            </div>`);
                                            apiContainer.append(apiDom);
                    apiBlockOption.append(apiContainer);                      
                    flexRow.append(apiBlockOption);
                    /** bottom block option 탭에 렌더링된 dom객체 생성 */
                    $('.vp-nodeeditor-bottom-tab-view').append(flexRow);
                    break;
                }
    
                /** try */
                case 8: {
                    var flexRow = $(`<div class='vp-style-flex-row-center' 
                                          style='padding: 0.5rem;'></div>`);
                    var tryBlockOption  = $(`<div class='vp-nodeeditor-blockoption vp-nodeeditor-ifoption'
                                                style='width: 95%;'>
                                            </div>`);
    
                    /* ---------------- Try --------------- */
                    var tryContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                                <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                    <span class='vp-block-optiontab-name'>try</span>
                                                    <div class='vp-style-flex-row-center'>
                                                        <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                    </div>
                                                </div>
                                            </div>`);
    
    
                    tryBlockOption.append(tryContainer);
    
                    /* ---------------- except ------------- */
    
                    var exceptList = [];
                    var nextBlockDataList = that.getNextBlockList();
                    var stack = [];
                    if (nextBlockDataList.length !== 0) {
                        stack.push(nextBlockDataList);
                    }
           
                    var current;
                    while (stack.length !== 0) {
                        current = stack.shift();
                        /** 배열 일 때 */
                        if (Array.isArray(current)) {
                            current.forEach(element => {
                                if (element.getDirection() === BLOCK_DIRECTION.DOWN) {
                                
                                    stack.push(element);
                                    if ( element.getType() === BLOCK_CODE_TYPE.EXCEPT) {
                                        exceptList.push(element);
                                    }
                                }
                            });
                        
            
                        } else {
                            var currBlock = current;
                            var nextBlockDataList = currBlock.getNextBlockList();
                            stack.unshift(nextBlockDataList);
                        }
                    }
    
    
                    var exceptContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                                <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                    <span class='vp-block-optiontab-name'>except</span>
                                                    <div class='vp-style-flex-row-center' >
                                                        <span class='vp-nodeeditor-elif-number'
                                                              style='margin-right:5px;'>
                                                            ${exceptList.length} Block
                                                        </span>
                                                        <button class='vp-block-btn vp-nodeeditor-except-plus-btn'
                                                                style='margin-right:5px;'>
                                                            + except
                                                        </button>
                                                        <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                    </div>
                                                </div>
                                            </div>`);
    
                    // except 갯수만큼 bottom block 옵션에 렌더링
                    var exceptBody = $(`<div class='vp-nodeeditor-elifbody'>
                                      </div>`);
    
                    exceptList.forEach((exceptData, index ) => {
                        var exceptDom = $(`<div class='vp-style-flex-row'>
                                                <div class='vp-style-flex-column-center'
                                                    style='margin:0 0.5rem; '>
                                                ${index+1}
                                                </div>
                                                <div class='vp-nodeeditor-blockoption-block 
                                                            vp-nodeeditor-blockoption-inner vp-style-flex-row' 
                                                    style='position:relative'>
                                                    <div class='vp-nodeeditor-blockoption-header'>
                                            
                                                        <div class='vp-nodeeditor-blockoption-codeline'>
                                                            <input placeholder='input code' 
                                                                    class='vp-nodeeditor-blockoption-input
                                                                            vp-nodeeditor-except-input-${index}' 
                                                                    value='${exceptData.getState('exceptCodeLine')}'>
                                                        </div>
                                                    </div>                                                          
                                                </div>
                                            </div>`);
                        var deleteButton = $(`<button class='vp-block-btn'>x</button>`);
                        $(deleteButton).click(function() {
                 
                            // /** 부모 에서 this를 제거  */
                            var prevBlock = exceptData.getPrevBlock();
    
                            if ( prevBlock ) {
                                var nextBlockDataList = prevBlock.getNextBlockList();
                                nextBlockDataList.some(( nextBlock, index) => {
                                    if (nextBlock.getUUID() === exceptData.getUUID()) {
                                        nextBlockDataList.splice(index, 1);
                                        return true;
                                    }
                                });
                            }
                            exceptData.setPrevBlock(null);
                            exceptData.getNullBlock().deleteBlockOne();
                            exceptData.getHolderBlock().deleteBlockOne();
    
                            $(exceptData.getMainDom()).remove();
                            $(exceptData.getContainerDom()).remove();
    
                            that.renderBottomOption();
         
                            var blockContainerThis = that.getBlockContainerThis();
                            blockContainerThis.renderBlockLeftHolderListHeight();

                            blockContainerThis.deleteBlock(exceptData.getUUID());
                        });
                        exceptDom.append(deleteButton);
                        exceptBody.append(exceptDom);
                    });
                    exceptContainer.append(exceptBody);
                    tryBlockOption.append(exceptContainer);
    
                    /* ---------------- Finally ----------- */
                    var finallyContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                                <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                    <span class='vp-block-optiontab-name'>finally</span>
                                                    <div class='vp-style-flex-row-center'>
                                                        <select class='vp-nodeeditor-blockoption-finally-select'
                                                                style='margin-right:5px;'>
                                                            <option value='no' ${this.getState('isFinally') === false ? 'selected': ''}>No</option>
                                                            <option value='yes' ${this.getState('isFinally') === true ? 'selected': ''}>Yes</option>
                                                        </select>
                                                        <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                    </div>
                                                </div>
                                            </div>`);
    
                    tryBlockOption.append(finallyContainer);
        
                    flexRow.append(tryBlockOption);
                    /** bottom block option 탭에 렌더링된 dom객체 생성 */
                    $('.vp-nodeeditor-bottom-tab-view').append(flexRow);
    
    
                    /** except 생성 이벤트 함수 바인딩 */
                    $(`.vp-nodeeditor-except-plus-btn`).click(function() {
                        // console.log('except 생성');
                        var exceptCodeLine = '';
    
                        that.setState({
                            optionState: {
                                tryState: {
                                    exceptList: [ ...that.getState('exceptList'), exceptCodeLine ]
                                }
                            }
                        });
    
                        /** ++ except */
                        
                        var blockContainerThis = that.getBlockContainerThis();
                        var newBlock = mapTypeToBlock(blockContainerThis, 500, {pointX: 0, pointY: 0})
                            
                 
                        that.getHolderBlock().appendBlock(newBlock, BLOCK_DIRECTION.DOWN);
                
                        //
                        that.renderBottomOption();
                        that.resembleRootBlockStack();
                        var blockContainerThis = that.getBlockContainerThis();
                        blockContainerThis.renderBlockLeftHolderListHeight();
                    });
    
                    /** except code 변경 */
                    exceptList.forEach((exceptData, index ) => {
                        $(`.vp-nodeeditor-except-input-${index}`).on("change keyup paste", function() {
                            var updatedData = $(this).val();
                            exceptData.setState({
                                exceptCodeLine: updatedData
                            });
    
                            $(`.vp-block-header-except-code-${exceptData.getUUID()}`).html(updatedData);
                        });
                    });
    
                    /** finally select 이벤트 함수 바인딩 */
                    $('.vp-nodeeditor-blockoption-finally-select').change(function() {
             
                        var isFinally = $(':selected', this).val();
                        if (isFinally === 'yes') {
                            
                     
                            /** else 생성 */
                            var nextBlockDataList = that.getNextBlockList();
                            var stack = [];
                
                            if (nextBlockDataList.length !== 0) {
                                stack.push(nextBlockDataList);
                                var beforeElseBlock = null;
                                var current;
                                var isBreak = false;
                                var prevBlock = null;
                                while (stack.length !== 0) {
                                    if (isBreak) {
                                        break;
                                    }
                                    current = stack.shift();
                                
                                  
                                    /** 배열 일 때 */
                                    if (Array.isArray(current)) {
                                        current.some(element => {
                                            if (element.getDirection() === BLOCK_DIRECTION.DOWN) {
                        
    
                                                prevBlock = element.getPrevBlock();
                                                if ( element.getType() === 8) {
                                                    isBreak = true;
                                                    beforeElseBlock = prevBlock;
                                                    return true;
                                                }
    
                                
                                                if ( ( prevBlock.getType() === 8
                                                          || prevBlock.getType() === 500 ) ) {
        
                                                    if ( element.getNextBlockList().length === 0 ) {
                                                        // console.log('0')
                                                        isBreak = true;
    
                                                        if ( element.getType() === 500 ) {
                                                            beforeElseBlock = element;
                                                        } else {
                                                            beforeElseBlock = prevBlock;
                                                        }
                                                    
        
                                                        return true;
                                                    } 
       
                                                    else {
                                               
                                                        element.getNextBlockList().some(el2 => {
                                                            if (el2.getDirection() === BLOCK_DIRECTION.DOWN && el2.getType() !== 500) {
                                         
                                                                isBreak = true;
                                                                beforeElseBlock = element;
                                                                
                                                                return true;
                                                            }
                                                        });
                                                    }
                                                } else {
                                         
                                                }
                                                
                                                stack.push(element);
                                            } else {
                                           
                                                /** direction indent 이면서*/
                                                prevBlock = element.getPrevBlock();
                                                if ( prevBlock.getNextBlockList().length === 1 ) {
                                        
                                                    isBreak = true;
                                                    beforeElseBlock = prevBlock;
                                                }
                                            }
                                        });
                        
                                    } else {
                                        var currBlock = current;
                                        var nextBlockDataList = currBlock.getNextBlockList();
                                        stack.unshift(nextBlockDataList);
                                    }
                                }
                              
                                var blockContainerThis = that.getBlockContainerThis();
                                var newBlock = mapTypeToBlock(blockContainerThis, 600, {pointX: 0, pointY: 0})
                                that.setState({
                                    isFinally: true
                      
                                });
        
                                beforeElseBlock.getHolderBlock().appendBlock(newBlock, BLOCK_DIRECTION.DOWN);
                  
                            } else {
                                var blockContainerThis = that.getBlockContainerThis();
                                var newBlock = mapTypeToBlock(blockContainerThis, 600, {pointX: 0, pointY: 0})
                                that.setState({
                                    isFinally: true
                                });
        
                                that.getHolderBlock().appendBlock(newBlock, BLOCK_DIRECTION.DOWN);
                            }
                   
                           
                      
                        } else {
                        /** else 삭제 */
                            var nextBlockDataList = that.getNextBlockList();
                            var stack = [];
                
                            if (nextBlockDataList.length !== 0) {
                                stack.push(nextBlockDataList);
                            }
    
                            var isBreak = false;
                            var current;
                            while (stack.length !== 0) {
                                current = stack.shift();
                         
                                /** 배열 일 때 */
                                if (Array.isArray(current)) {
                                    current.forEach(element => {
                                        if (element.getDirection() === BLOCK_DIRECTION.DOWN) {
                      
                                            stack.push(element);
                                            if ( element.getType() === 600 ) {
                                                isBreak = true;
                                                element.deleteBlockOne();
    
                                                element.getNullBlock().deleteBlockOne();
                                                element.getHolderBlock().deleteBlockOne();
    
                                                element.getNextBlockList().some(el => {
                                                    if (el.getDirection() === BLOCK_DIRECTION.INDENT) {
                                                        el.deleteBlock();
                                                        return true;
                                                    }
                                                });
                                            }
                                        }
                                    });
                    
                                } else {
                                    var currBlock = current;
                                    var nextBlockDataList = currBlock.getNextBlockList();
                                    stack.unshift(nextBlockDataList);
                                }
    
                                if (isBreak) {
                                    break;
                                }
                            }
                          
                            that.setState({
                                isFinally: false
                            });
                    
                        }
    
                        that.resembleRootBlockStack();
                        var blockContainerThis = that.getBlockContainerThis();
                        blockContainerThis.renderBlockLeftHolderListHeight();
                    });
                    break;
                }
    
                /** return */
                case 9: {
                    var flexRow = $(`<div class='vp-style-flex-row-center' 
                                          style='padding: 0.5rem;'></div>`);
                    var returnBlockOption  = $(`<div class='vp-nodeeditor-blockoption vp-nodeeditor-ifoption'
                                                style='width: 95%;'>
                                            </div>`);
       
                    var returnOutParamList = that.getState(`returnOutParamList`);
                    
    
                    var returnOutParamContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                                        <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                            <span class='vp-block-optiontab-name'>out param</span>
                                                            <div class='vp-style-flex-row-center' >
                                                                <span class='vp-nodeeditor-elif-number'
                                                                    style='margin-right:5px;'>
                                                                    ${returnOutParamList.length} Param
                                                                </span>
                                                                <button class='vp-block-btn vp-nodeeditor-return-outparam-plus-btn'
                                                                        style='margin-right:5px;'>
                                                                    + param
                                                                </button>
                                                                <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                            </div>
                                                        </div>
                                                    </div>`);
    
                    // defInParam 갯수만큼 bottom block 옵션에 렌더링
                    var returnOutParamBody = $(`<div class='vp-nodeeditor-returnbody'>
                                                </div>`);
    
                    returnOutParamList.forEach((returnOutParam, index ) => {
                        // console.log('defInParam', defInParam);
    
                        var returnOutParamDom = $(`<div class='vp-style-flex-row'>
                                                    <div class='vp-style-flex-column-center'
                                                            style='margin:0 0.5rem; '>
                                                        ${index+1}
                                                    </div>
                                                    <div class='vp-nodeeditor-blockoption-block 
                                                                vp-nodeeditor-blockoption-inner vp-style-flex-row' 
                                                        style='position:relative'>
                                                        <div class='vp-nodeeditor-blockoption-header'>
                                            
                                                            <div class='vp-nodeeditor-blockoption-codeline'>
                                                                <input placeholder='input param' 
                                                                        class='vp-nodeeditor-blockoption-input
                                                                                vp-nodeeditor-return-outparam-${index}' 
                                                                        value='${returnOutParam}'>
                                                            </div>
                                                        </div>                                                          
                                                    </div>
                                                </div>`);
                        var deleteButton = $(`<button class='vp-block-btn'>x</button>`);
                        $(deleteButton).click(function() {
                            that.setState({
                                returnOutParamList:  [ ...that.getState(`returnOutParamList`).slice(0, index), 
                                                       ...that.getState(`returnOutParamList`).slice(index+1, that.getState(`returnOutParamList`).length) ]
                            });
    
                            var returnOutParamStr = ` `;
                            that.getState(`returnOutParamList`).forEach((returnOutParam, index ) => {
                                returnOutParamStr += `${returnOutParam}`;
                                if (that.getState(`returnOutParamList`).length - 1 !== index ) {
                                    returnOutParamStr += `, `;
                                }
                            });
                            returnOutParamStr += ``;
                            $(`.vp-block-header-return-param-${that.getUUID()}`).html(returnOutParamStr);
    
                            that.renderBottomOption();
                        });
                        returnOutParamDom.append(deleteButton);
                        returnOutParamBody.append(returnOutParamDom);
                    });
                    returnOutParamContainer.append(returnOutParamBody);
                    returnBlockOption.append(returnOutParamContainer);
    
                    /** */
    
                    flexRow.append(returnBlockOption);
    
                    /** bottom block option 탭에 렌더링된 dom객체 생성 */
                    $('.vp-nodeeditor-bottom-tab-view').append(flexRow);
    
                    /** 함수 파라미터 변경 이벤트 함수 바인딩 */
                    returnOutParamList.forEach((_, index ) => {
                        $(`.vp-nodeeditor-return-outparam-${index}`).on('change keyup paste', function() {
                            var newParam = $(this).val();
            
                            that.setState({
                                returnOutParamList:  [ ...that.getState(`returnOutParamList`).slice(0, index), newParam,
                                                       ...that.getState(`returnOutParamList`).slice(index+1, that.getState(`returnOutParamList`).length) ]
                            });
                            var returnOutParamStr = ` `;
                            that.getState(`returnOutParamList`).forEach((returnOutParam, index ) => {
                                returnOutParamStr += `${returnOutParam}`;
                                if (that.getState(`returnOutParamList`).length - 1 !== index ) {
                                    returnOutParamStr += `, `;
                                }
                            });
                            returnOutParamStr += ``;
                            $(`.vp-block-header-return-param-${that.getUUID()}`).html(returnOutParamStr);
                        });
                    });
    
                    /** 함수 파라미터 생성 이벤트 함수 바인딩 */
                    $(`.vp-nodeeditor-return-outparam-plus-btn`).click(function() {
                        // console.log('def in param plus');
    
                        var newData = '';
    
                        that.setState({
                            optionState: {
                                returnState: {
                                    returnOutParamList: [ ...that.state.optionState.returnState.returnOutParamList, newData ]
                                }
                            }
                        });
                        that.renderBottomOption();
                    });
    
                    break;
                }
                case 999: {
                    // customCodeLine
                    var flexRow = $(`<div class='vp-style-flex-row-center' 
                                            style='padding: 0.5rem;'></div>`);
                    var codeBlockOption  = $(`<div class='vp-nodeeditor-foroption'
                                        style='width: 95%;'>
                                        
                                    </div>`);
    
                    /* ------------- code -------------- */
                    var codeContainer = $(`<div class='vp-nodeeditor-ifoption-container'>
                                            <div class='vp-nodeeditor-tab-navigation-node-block-title'>
                                                <span class='vp-block-optiontab-name'>code</span>
                                                <div class='vp-style-flex-row-center'>
    
                                                    <div class='vp-nodeeditor-option-vertical-btn'>▼</div>
                                                </div>
                                            </div>
                                        </div>`);
                    var codeDom = $(`<div class='vp-block-blockoption-else 
                                                 vp-nodeeditor-blockoption-block
                                                 vp-nodeeditor-blockoption-inner vp-style-flex-row' 
                                        style='position:relative;'>
                                    <div class='vp-nodeeditor-blockoption-header'>
    
                                        <div class='vp-nodeeditor-blockoption-codeline'>
                                            <input placeholder='input code' 
                                                class='vp-nodeeditor-blockoption-input
                                                        vp-nodeeditor-code-input' value='${that.getState('customCodeLine')}'>
                                        </div>
                                    </div>                                                          
                                </div>`);
    
    
                    codeContainer.append(codeDom );
                    codeBlockOption.append(codeContainer);
                    flexRow.append(codeBlockOption);
                    /** bottom block option 탭에 렌더링된 dom객체 생성 */
                    $('.vp-nodeeditor-bottom-tab-view').append(flexRow);
    
                    /** code 변경 */
                    $(`.vp-nodeeditor-code-input`).on("change keyup paste", function() {
                        that.setState({
                            customCodeLine: $(this).val()
                        });
                        $(`.vp-block-header-custom-code-${that.getUUID()}`).html(that.getState('customCodeLine'));
                    });
                    break;
                }
            }
            $('.vp-nodeeditor-option-vertical-btn').click(function() {
                if ($(this).hasClass(`vp-nodeeditor-arrow-down`)) {
                    $(this).removeClass(`vp-nodeeditor-arrow-down`);
                    $(this).addClass(`vp-nodeeditor-arrow-up`);
                    $(this).html(`▲`);
                    $(this).parent().parent().parent().removeClass(`vp-nodeeditor-minimize`);
                } else {
                    $(this).removeClass(`vp-nodeeditor-arrow-up`);
                    $(this).addClass(`vp-nodeeditor-arrow-down`);
                    $(this).html(`▼`);
                    $(this).parent().parent().parent().addClass(`vp-nodeeditor-minimize`);
                }
            });
        }
    
        Block.prototype.renderClickedAllBlock = function() {
            var blockContainerThis = this.getBlockContainerThis();
            var that = this;
            /** 기존에 존재하는 모든 블럭의 버튼들 삭제 */
            var blockList = blockContainerThis.getBlockList();
            blockList.forEach(block => {
                var rootDom = block.getMainDom();
                $(rootDom).find('.vp-block-info-delete-btn-container').remove();

                block.setIsClicked(false);
            });
            
            var type = that.getType();
            /** if */
            switch (type) {
                case 3: {
                    var nextBlockDataList = that.getNextBlockDataList();
                    var stack = [];
    
                    if (nextBlockDataList.length !== 0) {
                        stack.push(nextBlockDataList);
                    }
    
                    var current;
                    var isBreak = false;
                    while (stack.length !== 0) {
                        current = stack.shift();
                
                        /** 배열 일 때 */
                        if (Array.isArray(current)) {
                            current.forEach(element => {
                                if (element.getDirection() === BLOCK_DIRECTION.DOWN) {
                   
                                    stack.push(element);
                                    if ( element.getType() === 3 ) {
                                        isBreak = true;
                                    }
                                    if ( element.getType() === 100 || element.getType() === 200 ) {
                                        element.setIsClicked(true);
                                    }
                                }
                            });
                        
            
                        } else {
                            var currBlock = current;
                            var nextBlockDataList = currBlock.getNextBlockDataList();
                            stack.unshift(nextBlockDataList);
                        }
    
                        if (isBreak) {
                            break;
                        }
                    }
                    that.renderBottomOption();
                    break;
                }
                case 100: {
    
                }
                case 200: {
                    var prevBlock = that.getPrevBlock();
                    while (prevBlock !== null) {
                        var type = prevBlock.getType();
                        if ( type === 3 || type === 100 || type === 200 ) {
                            if (type === 3) {
                                prevBlock.renderBottomOption();
                                prevBlock.setIsClicked(true);
                                break;
                            }
                            prevBlock.setIsClicked(true);
                        }
                        prevBlock = prevBlock.getPrevBlock();
                    }  
                
                    /** */
                    var nextBlockDataList = that.getNextBlockList();
                    var stack = [];
    
                    if (nextBlockDataList.length !== 0) {
                        stack.push(nextBlockDataList);
                    }
    
                    var current;
                    while (stack.length !== 0) {
                        current = stack.shift();
                        var isBreak = false;
                        /** 배열 일 때 */
                        if (Array.isArray(current)) {
                            current.forEach(element => {
                                if (element.direction === 'down') {
                                    var newElement = {
                                        block: element.block
                                        , direction: element.direction
                                    }
                                    stack.push(newElement);
                                    if ( element.block.getType() === 3 ) {
                                        isBreak = true;
                                    }
                                    if ( element.block.getType() === 100 || element.block.getType() === 200 ) {
                                        element.block.setIsClicked(true);
                                    }
                                }
                            });
                        
            
                        } else {
                            var currBlock = current.block;
                            var nextBlockDataList = currBlock.getNextBlockDataList();
                            stack.unshift(nextBlockDataList);
                        }
    
                        if (isBreak) {
                            break;
                        }
                    }
                    break;
                }
                /** for */
                case 4: {
                    var nextBlockDataList = that.getNextBlockDataList();
                    that.setIsClicked(true);
                    nextBlockDataList.forEach(element => {
                        if (element.direction === 'down' && element.block.getType() === 201 ) {
                            element.block.setIsClicked(true);
                        }
                    });
                    that.renderBottomOption();
                    break;
                }
                case 201: {
                    var prevBlock = that.getPrevBlock();
                    if ( prevBlock.getType() === 4 ) {
                        var nextBlockDataList = prevBlock.getNextBlockDataList();
                        prevBlock.setIsClicked(true);
                        nextBlockDataList.forEach(element => {
                            if (element.direction === 'down' && element.block.getType() === 201 ) {
                                element.block.setIsClicked(true);
                            }
                        });
                        prevBlock.renderBottomOption();
                    }
                    break;
                }
                /** try except */
                case 8: {
                    var nextBlockDataList = that.getNextBlockDataList();
                    var stack = [];
    
                    if (nextBlockDataList.length !== 0) {
                        stack.push(nextBlockDataList);
                    }
    
                    var current;
                    var isBreak = false;
                    while (stack.length !== 0) {
                        current = stack.shift();
                
                        /** 배열 일 때 */
                        if (Array.isArray(current)) {
                            current.forEach(element => {
                                if (element.direction === 'down') {
                                    var newElement = {
                                        block: element.block
                                        , direction: element.direction
                                    }
                                    stack.push(newElement);
                                    if ( element.block.getType() === 8 ) {
                                        isBreak = true;
                                    }
                                    if ( element.block.getType() === 500 || element.block.getType() === 600 ) {
                        
                                        element.block.setIsClicked(true);
                                    }
                                }
                            });
                        
            
                        } else {
                            var currBlock = current.block;
                            var nextBlockDataList = currBlock.getNextBlockDataList();
                            stack.unshift(nextBlockDataList);
                        }
    
                        if (isBreak) {
                            break;
                        }
                    }
                    that.renderBottomOption();
                    break;
                }
                case 500: {
    
                }
                case 600: {
                    var prevBlock = that.getPrevBlock();
                    while (prevBlock !== null) {
                        var type = prevBlock.getType();
                        if ( type === 8 || type === 500 || type === 600 ) {
                            if (type === 8) {
                                prevBlock.renderBottomOption();
                                prevBlock.setIsClicked(true);
    
                                break;
                            }
                            prevBlock.setIsClicked(true);
                        }
                        prevBlock = prevBlock.getPrevBlock();
                    }  
                
                    /** */
                    var nextBlockDataList = that.getNextBlockDataList();
                    var stack = [];
    
                    if (nextBlockDataList.length !== 0) {
                        stack.push(nextBlockDataList);
                    }
    
                    var current;
                    while (stack.length !== 0) {
                        current = stack.shift();
                        var isBreak = false;
                        /** 배열 일 때 */
                        if (Array.isArray(current)) {
                            current.forEach(element => {
                                if (element.direction === 'down') {
                                    var newElement = {
                                        block: element.block
                                        , direction: element.direction
                                    }
                                    stack.push(newElement);
                                    if ( element.block.getType() === 8) {
                                        isBreak = true;
                                    }
                                    if ( element.block.getType() === 500 || element.block.getType() === 600 ) {
                                        element.block.setIsClicked(true);
                                    }
                                }
                            });
                        
            
                        } else {
                            var currBlock = current.block;
                            var nextBlockDataList = currBlock.getNextBlockDataList();
                            stack.unshift(nextBlockDataList);
                        }
                        if (isBreak) {
                            break;
                        }
                    }
                    break;
                }
                default: {
                    that.setIsClicked(true);
                    that.renderBottomOption();
                }
            }
        };
    
        var ShadowBlock = function(blockContainerThis, type, pointObj, childListDom, blockType, realBlock) {
            this.state = {
                type
                , blockType: 2
                , name: ''
                , direction: -1
                , rootBlockUuid: ''
                , pointX: pointObj.pointX 
                , pointY: pointObj.pointY
            }
            this.blockContainerThis = blockContainerThis;
    
            var name = mapTypeToName(type);
            this.setName(name);
            this.realBlock = realBlock;
            this.rootDom = null;
            this.selectBlock = null;
            this.tempChildListDom = null;
            this.init(childListDom, blockType);
        }
    
        ShadowBlock.prototype.init = function(childListDom, blockType) {
            var childNum = 0;
            var rootDomElement = this.getMainDom();
            $(rootDomElement).remove();
            $(rootDomElement).empty();
    
            /** root container 생성 */
            var containerDom = document.createElement('div');
            containerDom.classList.add('vp-block-shadowblock-container');
            $(containerDom).addClass('vp-block-shadowblock');
            $(containerDom).attr('data-num-id', '-1');
    
            /** root dom 생성 */
            var rootDomElement = document.createElement('div');
            rootDomElement.classList.add('vp-block');
    
            $(rootDomElement).css('background-color', '#757575');
            $(rootDomElement).css('position', 'relative');
    
            rootDomElement.style.top = `${this.getPointY()}` + 'px';
            rootDomElement.style.left = `${this.getPointX()}` + 'px';
    
            var rootInnerDomElement = $(`<div class='vp-block-inner'></div>`);
            var nameDom = $(`<div class='vp-block-header'>
                                <strong class="vp-style-flex-column-center 
                                        ${this.getType() !== BLOCK_CODE_TYPE.HOLDER ? 'vp-block-name' : ''}" 
                                    style="margin-right:10px; font-size:12px; color: #252525;">
                                    ${this.getName()}
                                </strong>    
                            </div>`);
    
            $(rootInnerDomElement).append(nameDom); 
            $(rootDomElement).append(rootInnerDomElement);
            var type = this.getType();
    
            if (blockType === BLOCK_TYPE.BLOCK) {
                if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF) {
                
                    var blockLeftHolder = $('<div class="vp-block-left-holder"></div>');
                    var blockLeftHolderHeight = this.realBlock.getTempBlockLeftHolderHeight();
                    blockLeftHolder.css('height',`${blockLeftHolderHeight}px`);
                    $(blockLeftHolder).css('background-color',`#757575`);
                    $(rootDomElement).append(blockLeftHolder);
               
                } else if (type === BLOCK_CODE_TYPE.IF || type === BLOCK_CODE_TYPE.ELSE || type === BLOCK_CODE_TYPE.ELIF
                        || type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                        || type === BLOCK_CODE_TYPE.FOR_ELSE || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY
                        ) {
                            
                    var blockLeftHolder = $('<div class="vp-block-left-holder"></div>');
                    var blockLeftHolderHeight = this.realBlock.getTempBlockLeftHolderHeight();
                    blockLeftHolder.css('height',`${blockLeftHolderHeight}px`);
                    $(blockLeftHolder).css('background-color',`#757575`);
                    $(rootDomElement).append(blockLeftHolder);
          
                } else {
        
                }
            }
          
    
    
    
    
            $(containerDom).append(rootDomElement);
            childNum++;
       
            childListDom.forEach(childDom => {
                $(childDom).css('background-color', '#757575');
                $(containerDom).append(childDom);
                childNum++;
            });
            
    
            this.setMainDom(containerDom);
        }
    
        ShadowBlock.prototype.render = function() {
            var rootDomElement = this.getMainDom();
            $('.vp-nodeeditor-left').append(rootDomElement);
        }
        ShadowBlock.prototype.getMainDom = function() {
            return this.rootDom;
        }
        ShadowBlock.prototype.setMainDom = function(rootDom) {
            this.rootDom = rootDom;
        }
        ShadowBlock.prototype.setPointX = function(pointX) {
            this.setState({
                pointX
            });
        }
        ShadowBlock.prototype.setPointY = function(pointY) {
            this.setState({
                pointY
            });
        }
        ShadowBlock.prototype.getPointX = function() {
            return this.state.pointX;
        }
        ShadowBlock.prototype.getPointY = function() {
            return this.state.pointY;
        }
        ShadowBlock.prototype.getName = function() {
            return this.state.name;
        }
        ShadowBlock.prototype.setName = function(name) {
            this.setState({
                name
            });
        }
        ShadowBlock.prototype.getType = function() {
            return this.state.type;
        }
        ShadowBlock.prototype.setType = function(type) {
            this.setState({
                type
            });
        }
        ShadowBlock.prototype.getBlockType = function() {
            return this.state.blockType;
        }
        ShadowBlock.prototype.setBlockType = function(blockType) {
            this.setState({
                blockType
            });
        }
    
        ShadowBlock.prototype.setSelectBlock = function(selectBlock) {
            this.selectBlock = selectBlock;
        }
        ShadowBlock.prototype.getSelectBlock = function() {
            return this.selectBlock;
        }
    
        ShadowBlock.prototype.setRootBlockUUID = function(rootBlockUuid) {
            this.setState({
                rootBlockUuid
            });
        }
        ShadowBlock.prototype.getRootBlockUUID = function() {
            return this.state.rootBlockUuid;
        }
    
        ShadowBlock.prototype.deleteShadowBlock = function() {
            var rootDomElement = this.getMainDom();
            $(rootDomElement).remove();
            $(rootDomElement).empty();
        }
    
        
        // ** Block state 관련 메소드들 */
        ShadowBlock.prototype.setState = function(newState) {
            this.state = changeOldToNewState(this.state, newState);
            this.consoleState();
        }
    
        /**
            특정 state Name 값을 가져오는 함수
            @param {string} stateKeyName
        */
        ShadowBlock.prototype.getState = function(stateKeyName) {
            return findStateValue(this.state, stateKeyName);
        }
        ShadowBlock.prototype.getStateAll = function() {
            return this.state;
        }
        ShadowBlock.prototype.consoleState = function() {
            // console.log(this.state);
        }
        ShadowBlock.prototype.getBlockContainerThis = function() {
            return this.blockContainerThis;
        }
    
        ShadowBlock.prototype.getTempChildListDom = function() {
            return this.tempChildListDom;
        }
        ShadowBlock.prototype.setTempChildListDom = function(tempChildListDom) {
            this.tempChildListDom = tempChildListDom;
        }
    
        ShadowBlock.prototype.getDirection = function() {
            return this.state.direction;
        }
        ShadowBlock.prototype.setDirection = function(direction) {
            this.setState({
                direction
            });
        }
    
        var CreateBlockBtn = function(blockContainerThis, type) { 
            this.blockContainerThis = blockContainerThis;
            this.state = {
                identityNum: 100
                , type
                , name: ''
                , isStart: false
                , isDroped: false
            }
            this.rootDomElement = null;
    
            this.mapTypeToName(type);
            this.render();
            this.bindDragEvent();
        }
        CreateBlockBtn.prototype.getBlockContainerThis = function() {
            return this.blockContainerThis;
        }
    
        CreateBlockBtn.prototype.setIsStart = function(isStart) {
            this.setState({
                isStart
            });
        }
        CreateBlockBtn.prototype.getIsStart = function() {
            return this.state.isStart;
        }
        CreateBlockBtn.prototype.setIsDroped = function(isDroped) {
            this.setState({
                isDroped
            });
        }
        CreateBlockBtn.prototype.getIsDroped  = function() {
            return this.state.isDroped;
        }
    
        CreateBlockBtn.prototype.getMainDom = function() {
            return this.rootDomElement;
        }
        
        CreateBlockBtn.prototype.setMainDom = function(rootDomElement) {
            this.rootDomElement = rootDomElement;
        }
        CreateBlockBtn.prototype.getName = function() {
            return this.state.name;
        }
        
        CreateBlockBtn.prototype.setName = function(name) {
            this.setState({
                name
            });
        }
        CreateBlockBtn.prototype.getType = function() {
            return this.state.type;
        }
        CreateBlockBtn.prototype.getIdentityNum = function() {
            return this.state.identityNum;
        }
    
        CreateBlockBtn.prototype.mapTypeToName = function(type) {
            var name = ``;
            switch (type) {
                case 1: {
                    name = 'class';
                    break;
                }
                case 2: {
                    name = 'def';
                    break;
                }
                case 3: {
                    name = 'if';
                    break;
                }
                case 4: {
                    name = 'for';
                    break;
                }
                case 5: {
                    name = 'while';
                    break;
                }
                case 6: {
                    name = 'import';
                    break;
                }
                case 7: {
                    name = 'api';
                    break;
                }
                case 8: {
                    name = 'try';
                    break;
                }
                case 9: {
                    name = 'return';
                    break;
                }
                case 10: {
                    name = 'break';
                    break;
                }
                case 11: {
                    name = 'continue';
                    break;
                }
                case 12: {
                    name = 'pass';
                    break;
                }
                case 999: {
                    name = 'code';
                    break;
                }
      
                default: {
                    break;
                }
            }
    
            this.setState({
                name
            });
        }
    
        /** routrMapApi */
        var BLOCK_MAP = new Map();
        BLOCK_MAP.set(BLOCK_CODE_TYPE.CLASS, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.DEF, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.IF, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.FOR, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.WHILE, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.IMPORT, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.TRY, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.API, Block);
        // BLOCK_MAP.set(BLOCK_CODE_TYPE.DB, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.RETURN, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.BREAK, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.CONTINUE, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.PASS, Block);
    
        BLOCK_MAP.set(BLOCK_CODE_TYPE.ELIF, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.ELSE, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.FOR_ELSE, Block);
     
        BLOCK_MAP.set(BLOCK_CODE_TYPE.INIT, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.DEL, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.EXCEPT, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.FINALLY, Block);
    
        BLOCK_MAP.set(BLOCK_CODE_TYPE.CODE, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.HOLDER, Block);
        BLOCK_MAP.set(BLOCK_CODE_TYPE.NULL, Block);
        var mapTypeToBlock = function(blockContainerThis, enumData, pointObj) {
            // console.log('enumData',enumData);
            if (BLOCK_MAP.has(enumData)) {
                var blockConstructor = BLOCK_MAP.get(enumData);
                return new blockConstructor(blockContainerThis, enumData, pointObj)
            } else {
                alert('존재하지 않는 BLOCK ENUM 입니다');
            }
        }
    
        // ** Block state 관련 메소드들 */
        CreateBlockBtn.prototype.setState = function(newState) {
            this.state = changeOldToNewState(this.state, newState);
            this.consoleState();
        }
        /**
            특정 state Name 값을 가져오는 함수
            @param {string} stateKeyName
        */
        CreateBlockBtn.prototype.getState = function(stateKeyName) {
            return findStateValue(this.state, stateKeyName);
        }
        CreateBlockBtn.prototype.getStateAll = function() {
            return this.state;
        }
        CreateBlockBtn.prototype.consoleState = function() {
            // console.log(this.state);
        }
    
        CreateBlockBtn.prototype.render = function() {
            var blockContainer;
            var rootDomElement = $(`<div class='vp-nodeeditor-tab-navigation-node-block-body-btn'>
                                        <span class='vp-block-name'>${this.getName()}</span>
                                    </div>`);
            this.setMainDom(rootDomElement);
            if (this.getType() === BLOCK_CODE_TYPE.CLASS || this.getType() === BLOCK_CODE_TYPE.DEF) {
                blockContainer = $(`.vp-nodeeditor-tab-navigation-node-subblock-1-body-inner`);
                $(rootDomElement).addClass('vp-block-class-def');
            } else if (this.getType() === BLOCK_CODE_TYPE.IF || this.getType() === BLOCK_CODE_TYPE.FOR
                || this.getType() === BLOCK_CODE_TYPE.WHILE || this.getType() === BLOCK_CODE_TYPE.TRY
                || this.getType() === BLOCK_CODE_TYPE.ELSE || this.getType() === BLOCK_CODE_TYPE.ELIF
                || this.getType() === BLOCK_CODE_TYPE.FOR_ELSE || this.getType() === BLOCK_CODE_TYPE.EXCEPT 
                || this.getType() === BLOCK_CODE_TYPE.FINALLY) {
                blockContainer = $(`.vp-nodeeditor-tab-navigation-node-subblock-2-body-inner`);
                $(rootDomElement).addClass('vp-block-if');
      
            } else {
                blockContainer = $(`.vp-nodeeditor-tab-navigation-node-subblock-3-body-inner`);
                $(rootDomElement).css('background-color', '#14c51d');
         
            }
    
            blockContainer.append(rootDomElement);
        }
    
        CreateBlockBtn.prototype.getMainDomPosition = function() {
            var rootDom = this.getMainDom();
            var clientRect = $(rootDom)[0].getBoundingClientRect();
            return clientRect;
        }
    
        CreateBlockBtn.prototype.bindDragEvent = function() {
            var blockContainerThis = this.getBlockContainerThis();
            var that = this;
            var type = this.getType();
            var isDownDropBlockDom = false;
            var isIndentDropBlockDom = false;
    
            var pos1 = 0;
            var pos2 = 0; 
            var pos3 = 0; 
            var pos4 = 0;
            var buttonX;
            var buttonY;
            var shadowBlock;
            var shadowBlockList = [];
    
            var newPointX;
            var newPointY;
            var selectedBlockDirection;
            $(this).addClass(`vp-nodeeditor-draggable`);
    
            this.getMainDom().draggable({ 
                // revert: 'invalid',
                // revertDuration: 200,
                appendTo: '.vp-nodeeditor-left',
        
                cursor: 'move', 
                helper: 'clone',
                
                start: function(event, ui) {
                    // console.log('start');
               
                    var blockList = blockContainerThis.getBlockList();
    
                    var rootBlockList = [];
                    // root block 묶음 별로 분리
                    blockList.forEach(block => {
                        var rootBlock = block.getRootBlock();
                        if (rootBlockList.includes(rootBlock)) {
                        } else {
                            rootBlockList.push(rootBlock);
                        }
    
                        /** 본래의 색깔 칠하기 */
                        block.renderMyColor();
                    });
    
                    rootBlockList.forEach((rootBlock, index) => {
      
                        var shadowBlock = new ShadowBlock(blockContainerThis, type, {pointX: 0, pointY: 0}, [],  BLOCK_TYPE.SHADOW_BLOCK);
                        shadowBlock.setRootBlockUUID(rootBlock.getUUID());
                        shadowBlockList.push(shadowBlock);
    
                        var containerDom = rootBlock.getContainerDom();
                        $(shadowBlock.getMainDom()).css('display','none');
                        $(shadowBlock.getMainDom()).removeClass('selected-shadowblock');
                        $(containerDom).append(shadowBlock.getMainDom());
                    });
    
                    that.setIsStart(true);
                    blockContainerThis.renderBlockLeftHolderListHeight();
                },
                drag: (event, ui) => {
                    blockContainerThis.renderBlockLeftHolderListHeight();
                    buttonX = event.clientX; 
                    buttonY = event.clientY; 
    
                    pos1 = pos3 - buttonX;
                    pos2 = pos4 - buttonY;
                    pos3 = buttonX;
                    pos4 = buttonY;
    
                    newPointX = buttonX - pos2 - $('.vp-nodeeditor-left').offset().left;
                    newPointY = buttonY - pos1 - $('.vp-nodeeditor-left').offset().top;
    
                    var blockList = blockContainerThis.getBlockList();
    
                    blockList.forEach(block => {
                        var mainDom = block.getMainDom();
                        var { x, y, width: blockWidth, height: blockHeight} = block.getMainDomPosition();
                        var rootBlock = block.getRootBlock();
                        /** down */
                        if ( x < buttonX
                             && buttonX < (x + blockWidth)
                             && y - blockHeight/2 < buttonY
                             && buttonY < (y + blockHeight + blockHeight) ) {     
                            // console.log('down colision');
                            
                            if (block.getType() === BLOCK_CODE_TYPE.NULL) {
                                return;
                            }
                            shadowBlockList.some(shadowBlock => {
                                if (shadowBlock.getRootBlockUUID() === rootBlock.getUUID()) {
                         
                                    $(shadowBlock.getMainDom()).css('display','block');
                                    $(shadowBlock.getMainDom()).addClass('selected-shadowblock');
                                    shadowBlock.setSelectBlock(block);
                                    var type = block.getType();
                                    if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                                        type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY || 
                                        type === BLOCK_CODE_TYPE.FOR_ELSE || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
             
                                        var is = block.getNextBlockList().some(nextBlock => {
                                            if ( nextBlock.getType() === BLOCK_CODE_TYPE.NULL ) {
                                             
                                                var holderBlock = block.getHolderBlock();
                                                var blockLeftHolderHeight = block.getTempBlockLeftHolderHeight();
                                                block.getBlockLeftHolder().css('height',`${blockLeftHolderHeight}px`);
                                                $(holderBlock.getMainDom()).css('transform', `translate(0px, -34px)`); 
                                
                                                return true;
                                            }
                                        });
                                    }
    
                                    if (block.getType() === BLOCK_CODE_TYPE.HOLDER) {
                                        $(block.getMainDom()).css('transform', `translate(0px, 0px)`); 
                                    }
                            
                                    return true;
                                }    
                            });
                            // selectedBlock = block;
                            var type = block.getType();
                            if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                                type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                                || type === BLOCK_CODE_TYPE.FOR_ELSE || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
                                selectedBlockDirection = BLOCK_DIRECTION.INDENT;
                            } else if (block.getType() === BLOCK_CODE_TYPE.HOLDER) {
                                selectedBlockDirection = BLOCK_DIRECTION.DOWN; 
                            } else {
                                selectedBlockDirection = BLOCK_DIRECTION.DOWN; 
                            }
                            rootBlock.reArrangeChildBlockDomList(block, undefined, selectedBlockDirection);
           
                   
                        } else {
     
                            if (block.getType() === BLOCK_CODE_TYPE.HOLDER) {
                                $(block.getMainDom()).css('transform', `translate(0px, 0px)`); 
                            }
    
                            var rootBlockList = block.getRootBlockList();
                            rootBlockList.some(_rootBlock => {
                                var containerDom = _rootBlock.getContainerDom();
                    
                                var containerDomRect = $(containerDom)[0].getBoundingClientRect();
                                var { x, y, width: containerDomWidth, height: containerDomHeight} = containerDomRect;
        
                                if ( x < buttonX
                                    && buttonX < (x + containerDomWidth)
                                    && y  < buttonY
                                    && buttonY < (y + containerDomHeight) ) {  
                                    // console.log('in colision');
                                } else {
                                    shadowBlockList.forEach(shadowBlock => {
                                        if (shadowBlock.getRootBlockUUID() === _rootBlock.getUUID()) {
                                         
                                            $(shadowBlock.getMainDom()).removeClass('selected-shadowblock');
                                            shadowBlock.setSelectBlock(null);
                                        }    
                                    });
                                    // console.log('not colision');
                                }
                            });
                        }
                    });
                },
                stop: function() {
                    var selectedBlock = null;
                    /** shadow block list 삭제 */
                    var rootBlockList = [];
                    var blockList = blockContainerThis.getBlockList();
                    blockList.forEach(block => {
                        if (block.getType() === BLOCK_CODE_TYPE.HOLDER) {
                            $(block.getMainDom()).css('transform', `translate(0px, 0px)`); 
                        }
                        var rootBlock = block.getRootBlock();
                        if (rootBlockList.includes(rootBlock)) {
                        } else {
                            rootBlockList.push(rootBlock);
                        }
                        
                    });
    
                    shadowBlockList.forEach(shadowBlock => {
                        if ( $(shadowBlock.getMainDom()).hasClass('selected-shadowblock') ) {
                            selectedBlock = shadowBlock.getSelectBlock();
                        } else {
                        };
                    })
       
                    rootBlockList.forEach(rootBlock => {
                        var rootBlockContainerDom = rootBlock.getContainerDom();
                        $(rootBlockContainerDom).find('.vp-block-shadowblock').remove();
                    });
    
                    var type = that.getType();
                    if (selectedBlock !== null) {
                        if ((selectedBlock.getType() === BLOCK_CODE_TYPE.CLASS || selectedBlock.getType() === BLOCK_CODE_TYPE.DEF
                            || selectedBlock.getType() === BLOCK_CODE_TYPE.IF || selectedBlock.getType() === BLOCK_CODE_TYPE.FOR
                            || selectedBlock.getType() === BLOCK_CODE_TYPE.WHILE ||  selectedBlock.getType() === BLOCK_CODE_TYPE.TRY
                            || selectedBlock.getType() === BLOCK_CODE_TYPE.FOR_ELSE || selectedBlock.getType() === BLOCK_CODE_TYPE.EXCEPT 
                            || selectedBlock.getType() === BLOCK_CODE_TYPE.FINALLY)
                            && selectedBlock.getNullBlock() !== null) {
                            selectedBlock.getNullBlock().deleteBlockOne();
                            selectedBlock.setNullBlock(null);
                        } 
    
                        var block = mapTypeToBlock(blockContainerThis, type, {pointX: 0, pointY: 0})
                        selectedBlock.appendBlock(block, selectedBlockDirection);
    
                        var rootBlock = selectedBlock.getRootBlock();
                        var x = rootBlock.getContainerPointX();
                        var y = rootBlock.getContainerPointY();
                        newPointX = x - $('.vp-nodeeditor-left').offset().left;
                        newPointY = y - $('.vp-nodeeditor-left').offset().top;
                        var containerDom = rootBlock.getContainerDom();
    
                        $(containerDom).css('top',`${y}px`);
                        $(containerDom).css('left',`${x}px`);
                        rootBlock.setContainerPointX(x);
                        rootBlock.setContainerPointY(y);
    
                        block.renderBottomOption();
                        block.renderWhiteColor();
                    } else {    
      
                        var block = mapTypeToBlock(blockContainerThis, type, {pointX: 0, pointY: 0})
                        var _containerDom = block.getContainerDom();
                        $(_containerDom).empty();
                        $(_containerDom).remove();
                    
                        var containerDom = document.createElement('div');
                        containerDom.classList.add('vp-block-container');
                        block.setContainerDom(containerDom);
    
                        var blockMainDom = block.getMainDom();
                        $(containerDom).append(blockMainDom);
    
                        block.setContainerPointX(newPointX);
                        block.setContainerPointY(newPointY);
    
                        $(containerDom).css('top',`${newPointY}px`);
                        $(containerDom).css('left',`${newPointX}px`);
                   
                        if (type === BLOCK_CODE_TYPE.CLASS || type === BLOCK_CODE_TYPE.DEF || type === BLOCK_CODE_TYPE.IF ||
                            type === BLOCK_CODE_TYPE.FOR || type === BLOCK_CODE_TYPE.WHILE || type === BLOCK_CODE_TYPE.TRY
                            || type === BLOCK_CODE_TYPE.FOR_ELSE || type === BLOCK_CODE_TYPE.EXCEPT || type === BLOCK_CODE_TYPE.FINALLY) {
                   
                            $(containerDom).append(block.getNullBlock().getMainDom());
                            $(containerDom).append(block.getHolderBlock().getMainDom());
                
                            block.bindDragEvent();
                            block.bindClickEvent();
                        }
                        // block.renderMyColor();
                        $('.vp-nodeeditor-left').append(containerDom);
    
                        block.renderBottomOption();
                        block.renderWhiteColor();
                    }
    
                    var blockList = blockContainerThis.getBlockList();
                    blockList.forEach(block => {
                        var mainDom = block.getMainDom();
                        $(mainDom).find('.vp-block-delete-btn').remove();
                    });
    
                    blockContainerThis.renderBlockLeftHolderListHeight();
                    /** 메모리에 남은 shadowBlockList 삭제 */
                    shadowBlockList = [];
                    that.setIsStart(false);
                }
            }).mousedown( () => { 
    
            });
        }
    
        var blockContainer = new BlockContainer();
    
        var createBlockBtnArray = Object.values(BLOCK_CODE_BTN_TYPE);
        new CreateBlockBtn(blockContainer, 999);
        createBlockBtnArray.forEach(enumData => {
            /** api 건너뛴다 */
            if (enumData === 7 || enumData === 999) {
                return;
            }
            new CreateBlockBtn(blockContainer, enumData);
        });


        var controlToggleInput = function() {
            $(`.vp-nodeeditor-body`).on("focus", "input", function() {
                Jupyter.notebook.keyboard_manager.disable();
            });
            $(`.vp-nodeeditor-body`).on("blur", "input", function() {
                Jupyter.notebook.keyboard_manager.enable();
            });
        }
        controlToggleInput();
        return blockContainer;
    }

    return init;
});
