# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Vasv2taxOrderInformationLineItems(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'product_sku': 'str',
        'product_code': 'str',
        'quantity': 'int',
        'product_name': 'str',
        'unit_price': 'str',
        'tax_amount': 'str',
        'order_acceptance': 'Vasv2taxOrderInformationOrderAcceptance',
        'order_origin': 'Vasv2taxOrderInformationOrderOrigin',
        'ship_from_country': 'str',
        'ship_from_administrative_area': 'str',
        'ship_from_locality': 'str',
        'ship_from_postal_code': 'str',
        'buyer_vat_registration_number': 'str',
        'seller_vat_registration_number': 'str'
    }

    attribute_map = {
        'product_sku': 'productSKU',
        'product_code': 'productCode',
        'quantity': 'quantity',
        'product_name': 'productName',
        'unit_price': 'unitPrice',
        'tax_amount': 'taxAmount',
        'order_acceptance': 'orderAcceptance',
        'order_origin': 'orderOrigin',
        'ship_from_country': 'shipFromCountry',
        'ship_from_administrative_area': 'shipFromAdministrativeArea',
        'ship_from_locality': 'shipFromLocality',
        'ship_from_postal_code': 'shipFromPostalCode',
        'buyer_vat_registration_number': 'buyerVatRegistrationNumber',
        'seller_vat_registration_number': 'sellerVatRegistrationNumber'
    }

    def __init__(self, product_sku=None, product_code=None, quantity=None, product_name=None, unit_price=None, tax_amount=None, order_acceptance=None, order_origin=None, ship_from_country=None, ship_from_administrative_area=None, ship_from_locality=None, ship_from_postal_code=None, buyer_vat_registration_number=None, seller_vat_registration_number=None):
        """
        Vasv2taxOrderInformationLineItems - a model defined in Swagger
        """

        self._product_sku = None
        self._product_code = None
        self._quantity = None
        self._product_name = None
        self._unit_price = None
        self._tax_amount = None
        self._order_acceptance = None
        self._order_origin = None
        self._ship_from_country = None
        self._ship_from_administrative_area = None
        self._ship_from_locality = None
        self._ship_from_postal_code = None
        self._buyer_vat_registration_number = None
        self._seller_vat_registration_number = None

        if product_sku is not None:
          self.product_sku = product_sku
        if product_code is not None:
          self.product_code = product_code
        if quantity is not None:
          self.quantity = quantity
        if product_name is not None:
          self.product_name = product_name
        if unit_price is not None:
          self.unit_price = unit_price
        if tax_amount is not None:
          self.tax_amount = tax_amount
        if order_acceptance is not None:
          self.order_acceptance = order_acceptance
        if order_origin is not None:
          self.order_origin = order_origin
        if ship_from_country is not None:
          self.ship_from_country = ship_from_country
        if ship_from_administrative_area is not None:
          self.ship_from_administrative_area = ship_from_administrative_area
        if ship_from_locality is not None:
          self.ship_from_locality = ship_from_locality
        if ship_from_postal_code is not None:
          self.ship_from_postal_code = ship_from_postal_code
        if buyer_vat_registration_number is not None:
          self.buyer_vat_registration_number = buyer_vat_registration_number
        if seller_vat_registration_number is not None:
          self.seller_vat_registration_number = seller_vat_registration_number

    @property
    def product_sku(self):
        """
        Gets the product_sku of this Vasv2taxOrderInformationLineItems.
        Product identifier code. Also known as the Stock Keeping Unit (SKU) code for the product.  For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to **default** or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S. and Canadian taxes. Not applicable to international and value added taxes. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the values related to shipping and/or handling. 

        :return: The product_sku of this Vasv2taxOrderInformationLineItems.
        :rtype: str
        """
        return self._product_sku

    @product_sku.setter
    def product_sku(self, product_sku):
        """
        Sets the product_sku of this Vasv2taxOrderInformationLineItems.
        Product identifier code. Also known as the Stock Keeping Unit (SKU) code for the product.  For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to **default** or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S. and Canadian taxes. Not applicable to international and value added taxes. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the values related to shipping and/or handling. 

        :param product_sku: The product_sku of this Vasv2taxOrderInformationLineItems.
        :type: str
        """
        if product_sku is not None and len(product_sku) > 255:
            raise ValueError("Invalid value for `product_sku`, length must be less than or equal to `255`")

        self._product_sku = product_sku

    @property
    def product_code(self):
        """
        Gets the product_code of this Vasv2taxOrderInformationLineItems.
        Type of product. The value for this field is used to identify the product category (electronic, handling, physical, service, or shipping). The default value is `default`.  If you are performing an authorization transaction (`processingOptions.capture` is set to `false`), and you set this field to a value other than `default` or one of the values related to shipping and/or handling, then `orderInformation.lineItems[].quantity`, `orderInformation.lineItems[].productName`, and `orderInformation.lineItems[].productSku` fields are required.  Optional field.  For details, see the `product_code` field description in the [Credit Card Services Using the SCMP API Guide](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/).  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  To use the tax calculation service, use values listed in the Tax Product Code Guide. For information about this document, contact customer support. See \"Product Codes,\" page 14, for more information. 

        :return: The product_code of this Vasv2taxOrderInformationLineItems.
        :rtype: str
        """
        return self._product_code

    @product_code.setter
    def product_code(self, product_code):
        """
        Sets the product_code of this Vasv2taxOrderInformationLineItems.
        Type of product. The value for this field is used to identify the product category (electronic, handling, physical, service, or shipping). The default value is `default`.  If you are performing an authorization transaction (`processingOptions.capture` is set to `false`), and you set this field to a value other than `default` or one of the values related to shipping and/or handling, then `orderInformation.lineItems[].quantity`, `orderInformation.lineItems[].productName`, and `orderInformation.lineItems[].productSku` fields are required.  Optional field.  For details, see the `product_code` field description in the [Credit Card Services Using the SCMP API Guide](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/).  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  To use the tax calculation service, use values listed in the Tax Product Code Guide. For information about this document, contact customer support. See \"Product Codes,\" page 14, for more information. 

        :param product_code: The product_code of this Vasv2taxOrderInformationLineItems.
        :type: str
        """
        if product_code is not None and len(product_code) > 255:
            raise ValueError("Invalid value for `product_code`, length must be less than or equal to `255`")

        self._product_code = product_code

    @property
    def quantity(self):
        """
        Gets the quantity of this Vasv2taxOrderInformationLineItems.
        Number of units for this order. Must be a non-negative integer.  The default is `1`. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. 

        :return: The quantity of this Vasv2taxOrderInformationLineItems.
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """
        Sets the quantity of this Vasv2taxOrderInformationLineItems.
        Number of units for this order. Must be a non-negative integer.  The default is `1`. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. 

        :param quantity: The quantity of this Vasv2taxOrderInformationLineItems.
        :type: int
        """
        if quantity is not None and quantity > 999999999:
            raise ValueError("Invalid value for `quantity`, must be a value less than or equal to `999999999`")
        if quantity is not None and quantity < 1:
            raise ValueError("Invalid value for `quantity`, must be a value greater than or equal to `1`")

        self._quantity = quantity

    @property
    def product_name(self):
        """
        Gets the product_name of this Vasv2taxOrderInformationLineItems.
        For an authorization or capture transaction (`processingOptions.capture` is `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. 

        :return: The product_name of this Vasv2taxOrderInformationLineItems.
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """
        Sets the product_name of this Vasv2taxOrderInformationLineItems.
        For an authorization or capture transaction (`processingOptions.capture` is `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. 

        :param product_name: The product_name of this Vasv2taxOrderInformationLineItems.
        :type: str
        """
        if product_name is not None and len(product_name) > 255:
            raise ValueError("Invalid value for `product_name`, length must be less than or equal to `255`")

        self._product_name = product_name

    @property
    def unit_price(self):
        """
        Gets the unit_price of this Vasv2taxOrderInformationLineItems.
        Per-item price of the product. This value for this field cannot be negative.  You must include either this field or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  You can include a decimal point (.), but you cannot include any other special characters. The value is truncated to the correct number of decimal places.  #### DCC with a Third-Party Provider Set this field to the converted amount that was returned by the DCC provider. You must include either the 1st line item in the order and this field, or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  #### FDMS South If you accept IDR or CLP currencies, see the entry for FDMS South in the [Merchant Descriptors Using the SCMP API Guide.] (https://apps.cybersource.com/library/documentation/dev_guides/Merchant_Descriptors_SCMP_API/html/)  #### Tax Calculation Required field for U.S., Canadian, international and value added taxes.  #### Zero Amount Authorizations If your processor supports zero amount authorizations, you can set this field to 0 for the authorization to check if the card is lost or stolen.  #### Maximum Field Lengths For GPN and JCN Gateway: Decimal (10) All other processors: Decimal (15) 

        :return: The unit_price of this Vasv2taxOrderInformationLineItems.
        :rtype: str
        """
        return self._unit_price

    @unit_price.setter
    def unit_price(self, unit_price):
        """
        Sets the unit_price of this Vasv2taxOrderInformationLineItems.
        Per-item price of the product. This value for this field cannot be negative.  You must include either this field or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  You can include a decimal point (.), but you cannot include any other special characters. The value is truncated to the correct number of decimal places.  #### DCC with a Third-Party Provider Set this field to the converted amount that was returned by the DCC provider. You must include either the 1st line item in the order and this field, or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  #### FDMS South If you accept IDR or CLP currencies, see the entry for FDMS South in the [Merchant Descriptors Using the SCMP API Guide.] (https://apps.cybersource.com/library/documentation/dev_guides/Merchant_Descriptors_SCMP_API/html/)  #### Tax Calculation Required field for U.S., Canadian, international and value added taxes.  #### Zero Amount Authorizations If your processor supports zero amount authorizations, you can set this field to 0 for the authorization to check if the card is lost or stolen.  #### Maximum Field Lengths For GPN and JCN Gateway: Decimal (10) All other processors: Decimal (15) 

        :param unit_price: The unit_price of this Vasv2taxOrderInformationLineItems.
        :type: str
        """
        if unit_price is not None and len(unit_price) > 15:
            raise ValueError("Invalid value for `unit_price`, length must be less than or equal to `15`")

        self._unit_price = unit_price

    @property
    def tax_amount(self):
        """
        Gets the tax_amount of this Vasv2taxOrderInformationLineItems.
        Total tax to apply to the product. This value cannot be negative. The tax amount and the offer amount must be in the same currency. The tax amount field is additive.  The following example uses a two-exponent currency such as USD:   1. You include each line item in your request.  ..- 1st line item has amount=10.00, quantity=1, and taxAmount=0.80  ..- 2nd line item has amount=20.00, quantity=1, and taxAmount=1.60  2. The total amount authorized will be 32.40, not 30.00 with 2.40 of tax included.  Optional field.  #### Airlines processing Tax portion of the order amount. This value cannot exceed 99999999999999 (fourteen 9s). Format: English characters only. Optional request field for a line item.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  Note if you send this field in your tax request, the value in the field will override the tax engine 

        :return: The tax_amount of this Vasv2taxOrderInformationLineItems.
        :rtype: str
        """
        return self._tax_amount

    @tax_amount.setter
    def tax_amount(self, tax_amount):
        """
        Sets the tax_amount of this Vasv2taxOrderInformationLineItems.
        Total tax to apply to the product. This value cannot be negative. The tax amount and the offer amount must be in the same currency. The tax amount field is additive.  The following example uses a two-exponent currency such as USD:   1. You include each line item in your request.  ..- 1st line item has amount=10.00, quantity=1, and taxAmount=0.80  ..- 2nd line item has amount=20.00, quantity=1, and taxAmount=1.60  2. The total amount authorized will be 32.40, not 30.00 with 2.40 of tax included.  Optional field.  #### Airlines processing Tax portion of the order amount. This value cannot exceed 99999999999999 (fourteen 9s). Format: English characters only. Optional request field for a line item.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  Note if you send this field in your tax request, the value in the field will override the tax engine 

        :param tax_amount: The tax_amount of this Vasv2taxOrderInformationLineItems.
        :type: str
        """
        if tax_amount is not None and len(tax_amount) > 15:
            raise ValueError("Invalid value for `tax_amount`, length must be less than or equal to `15`")

        self._tax_amount = tax_amount

    @property
    def order_acceptance(self):
        """
        Gets the order_acceptance of this Vasv2taxOrderInformationLineItems.

        :return: The order_acceptance of this Vasv2taxOrderInformationLineItems.
        :rtype: Vasv2taxOrderInformationOrderAcceptance
        """
        return self._order_acceptance

    @order_acceptance.setter
    def order_acceptance(self, order_acceptance):
        """
        Sets the order_acceptance of this Vasv2taxOrderInformationLineItems.

        :param order_acceptance: The order_acceptance of this Vasv2taxOrderInformationLineItems.
        :type: Vasv2taxOrderInformationOrderAcceptance
        """

        self._order_acceptance = order_acceptance

    @property
    def order_origin(self):
        """
        Gets the order_origin of this Vasv2taxOrderInformationLineItems.

        :return: The order_origin of this Vasv2taxOrderInformationLineItems.
        :rtype: Vasv2taxOrderInformationOrderOrigin
        """
        return self._order_origin

    @order_origin.setter
    def order_origin(self, order_origin):
        """
        Sets the order_origin of this Vasv2taxOrderInformationLineItems.

        :param order_origin: The order_origin of this Vasv2taxOrderInformationLineItems.
        :type: Vasv2taxOrderInformationOrderOrigin
        """

        self._order_origin = order_origin

    @property
    def ship_from_country(self):
        """
        Gets the ship_from_country of this Vasv2taxOrderInformationLineItems.
        Country from which the order is shipped. This field is used only when `orderInformation.shippingDetails.shipFromLocality` and `orderInformation.shippingDetails.shipFromAdministrativeArea` are present. Use the [ISO Standard Country Codes](http://apps.cybersource.com/library/documentation/sbc/quickref/countries_alpha_list.pdf).  **NOTE** If this field appears in a `lineItems` object, then the value of this field in the `lineItems` object overrides the value of the corresponding field at the request-level or order-level object.  #### Tax Calculation This field is used to determine tax rules and/ or rates applied to the transaction based on sourcing.  Optional for U.S., Canadian, international tax, and value added taxes. 

        :return: The ship_from_country of this Vasv2taxOrderInformationLineItems.
        :rtype: str
        """
        return self._ship_from_country

    @ship_from_country.setter
    def ship_from_country(self, ship_from_country):
        """
        Sets the ship_from_country of this Vasv2taxOrderInformationLineItems.
        Country from which the order is shipped. This field is used only when `orderInformation.shippingDetails.shipFromLocality` and `orderInformation.shippingDetails.shipFromAdministrativeArea` are present. Use the [ISO Standard Country Codes](http://apps.cybersource.com/library/documentation/sbc/quickref/countries_alpha_list.pdf).  **NOTE** If this field appears in a `lineItems` object, then the value of this field in the `lineItems` object overrides the value of the corresponding field at the request-level or order-level object.  #### Tax Calculation This field is used to determine tax rules and/ or rates applied to the transaction based on sourcing.  Optional for U.S., Canadian, international tax, and value added taxes. 

        :param ship_from_country: The ship_from_country of this Vasv2taxOrderInformationLineItems.
        :type: str
        """
        if ship_from_country is not None and len(ship_from_country) > 2:
            raise ValueError("Invalid value for `ship_from_country`, length must be less than or equal to `2`")

        self._ship_from_country = ship_from_country

    @property
    def ship_from_administrative_area(self):
        """
        Gets the ship_from_administrative_area of this Vasv2taxOrderInformationLineItems.
        State from which the order is shipped. This field is used only when `orderInformation.shippingDetails.shipFromLocality` and `orderInformation.shippingDetails.shipFromCountry` are present. Use the [State, Province, and Territory Codes for the United States and Canada](http://apps.cybersource.com/library/documentation/sbc/quickref/states_and_provinces.pdf).  **NOTE** If this field appears in a `lineItems` object, then the value of this field in the `lineItems` object overrides the value of the corresponding field at the request-level or order-level object.  #### Tax Calculation This field is used to determine tax rules and/or rates applied to the transaction based on sourcing.  Optional for U.S. and Canadian taxes. Not applicable to international and value added taxes. 

        :return: The ship_from_administrative_area of this Vasv2taxOrderInformationLineItems.
        :rtype: str
        """
        return self._ship_from_administrative_area

    @ship_from_administrative_area.setter
    def ship_from_administrative_area(self, ship_from_administrative_area):
        """
        Sets the ship_from_administrative_area of this Vasv2taxOrderInformationLineItems.
        State from which the order is shipped. This field is used only when `orderInformation.shippingDetails.shipFromLocality` and `orderInformation.shippingDetails.shipFromCountry` are present. Use the [State, Province, and Territory Codes for the United States and Canada](http://apps.cybersource.com/library/documentation/sbc/quickref/states_and_provinces.pdf).  **NOTE** If this field appears in a `lineItems` object, then the value of this field in the `lineItems` object overrides the value of the corresponding field at the request-level or order-level object.  #### Tax Calculation This field is used to determine tax rules and/or rates applied to the transaction based on sourcing.  Optional for U.S. and Canadian taxes. Not applicable to international and value added taxes. 

        :param ship_from_administrative_area: The ship_from_administrative_area of this Vasv2taxOrderInformationLineItems.
        :type: str
        """
        if ship_from_administrative_area is not None and len(ship_from_administrative_area) > 2:
            raise ValueError("Invalid value for `ship_from_administrative_area`, length must be less than or equal to `2`")

        self._ship_from_administrative_area = ship_from_administrative_area

    @property
    def ship_from_locality(self):
        """
        Gets the ship_from_locality of this Vasv2taxOrderInformationLineItems.
        City where the product is shipped from. This field is used only when the `orderInformation.shipTo.administrativeArea` and `orderInformation.shipTo.country` fields are present.  **NOTE** If this field appears in a `lineItems` object, then the value of this field in the `lineItems` object overrides the value of the corresponding field at the request-level or order-level object.  #### Tax Calculation This field is used to determine tax rules and/or rates applied to the transaction based on sourcing.  Optional for U.S. and Canadian taxes. Not applicable to international and value added taxes. 

        :return: The ship_from_locality of this Vasv2taxOrderInformationLineItems.
        :rtype: str
        """
        return self._ship_from_locality

    @ship_from_locality.setter
    def ship_from_locality(self, ship_from_locality):
        """
        Sets the ship_from_locality of this Vasv2taxOrderInformationLineItems.
        City where the product is shipped from. This field is used only when the `orderInformation.shipTo.administrativeArea` and `orderInformation.shipTo.country` fields are present.  **NOTE** If this field appears in a `lineItems` object, then the value of this field in the `lineItems` object overrides the value of the corresponding field at the request-level or order-level object.  #### Tax Calculation This field is used to determine tax rules and/or rates applied to the transaction based on sourcing.  Optional for U.S. and Canadian taxes. Not applicable to international and value added taxes. 

        :param ship_from_locality: The ship_from_locality of this Vasv2taxOrderInformationLineItems.
        :type: str
        """
        if ship_from_locality is not None and len(ship_from_locality) > 50:
            raise ValueError("Invalid value for `ship_from_locality`, length must be less than or equal to `50`")

        self._ship_from_locality = ship_from_locality

    @property
    def ship_from_postal_code(self):
        """
        Gets the ship_from_postal_code of this Vasv2taxOrderInformationLineItems.
        Postal code where the product is shipped from.  #### Tax Calculation This field is used to determine tax rules and/or rates applied to the transaction based on sourcing.  Optional for U.S. and Canadian taxes. Not applicable to international and value added taxes. 

        :return: The ship_from_postal_code of this Vasv2taxOrderInformationLineItems.
        :rtype: str
        """
        return self._ship_from_postal_code

    @ship_from_postal_code.setter
    def ship_from_postal_code(self, ship_from_postal_code):
        """
        Sets the ship_from_postal_code of this Vasv2taxOrderInformationLineItems.
        Postal code where the product is shipped from.  #### Tax Calculation This field is used to determine tax rules and/or rates applied to the transaction based on sourcing.  Optional for U.S. and Canadian taxes. Not applicable to international and value added taxes. 

        :param ship_from_postal_code: The ship_from_postal_code of this Vasv2taxOrderInformationLineItems.
        :type: str
        """
        if ship_from_postal_code is not None and len(ship_from_postal_code) > 10:
            raise ValueError("Invalid value for `ship_from_postal_code`, length must be less than or equal to `10`")

        self._ship_from_postal_code = ship_from_postal_code

    @property
    def buyer_vat_registration_number(self):
        """
        Gets the buyer_vat_registration_number of this Vasv2taxOrderInformationLineItems.
        Buyer’s VAT registration number.  **NOTE** If this field appears in a `lineItems` object, then the value of this field in the `lineItems` object overrides the value of the corresponding field at the request-level or order-level object.  #### Tax Calculation Optional field for international and value added taxes only. Not applicable to U.S. and Canadian taxes. 

        :return: The buyer_vat_registration_number of this Vasv2taxOrderInformationLineItems.
        :rtype: str
        """
        return self._buyer_vat_registration_number

    @buyer_vat_registration_number.setter
    def buyer_vat_registration_number(self, buyer_vat_registration_number):
        """
        Sets the buyer_vat_registration_number of this Vasv2taxOrderInformationLineItems.
        Buyer’s VAT registration number.  **NOTE** If this field appears in a `lineItems` object, then the value of this field in the `lineItems` object overrides the value of the corresponding field at the request-level or order-level object.  #### Tax Calculation Optional field for international and value added taxes only. Not applicable to U.S. and Canadian taxes. 

        :param buyer_vat_registration_number: The buyer_vat_registration_number of this Vasv2taxOrderInformationLineItems.
        :type: str
        """
        if buyer_vat_registration_number is not None and len(buyer_vat_registration_number) > 25:
            raise ValueError("Invalid value for `buyer_vat_registration_number`, length must be less than or equal to `25`")

        self._buyer_vat_registration_number = buyer_vat_registration_number

    @property
    def seller_vat_registration_number(self):
        """
        Gets the seller_vat_registration_number of this Vasv2taxOrderInformationLineItems.
        VAT seller registration number.  For details, see \"International Taxes and Value-Added Tax (VAT)\" in [Tax Calculation Service Using the SCMP API](https://apps.cybersource.com/library/documentation/dev_guides/Tax_SCMP_API/html/).  **NOTE** If this field appears in a `lineItems` object, then the value of this field in the `lineItems` object overrides the value of the corresponding field at the request-level or order-level object.  #### Tax Calculation Optional field for international and value added taxes only. Not applicable to U.S. and Canadian taxes. 

        :return: The seller_vat_registration_number of this Vasv2taxOrderInformationLineItems.
        :rtype: str
        """
        return self._seller_vat_registration_number

    @seller_vat_registration_number.setter
    def seller_vat_registration_number(self, seller_vat_registration_number):
        """
        Sets the seller_vat_registration_number of this Vasv2taxOrderInformationLineItems.
        VAT seller registration number.  For details, see \"International Taxes and Value-Added Tax (VAT)\" in [Tax Calculation Service Using the SCMP API](https://apps.cybersource.com/library/documentation/dev_guides/Tax_SCMP_API/html/).  **NOTE** If this field appears in a `lineItems` object, then the value of this field in the `lineItems` object overrides the value of the corresponding field at the request-level or order-level object.  #### Tax Calculation Optional field for international and value added taxes only. Not applicable to U.S. and Canadian taxes. 

        :param seller_vat_registration_number: The seller_vat_registration_number of this Vasv2taxOrderInformationLineItems.
        :type: str
        """
        if seller_vat_registration_number is not None and len(seller_vat_registration_number) > 25:
            raise ValueError("Invalid value for `seller_vat_registration_number`, length must be less than or equal to `25`")

        self._seller_vat_registration_number = seller_vat_registration_number

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Vasv2taxOrderInformationLineItems):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
