# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class TssV2TransactionsGet200ResponsePaymentInformationBank(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'routing_number': 'str',
        'branch_code': 'str',
        'swift_code': 'str',
        'bank_code': 'str',
        'iban': 'str',
        'account': 'TssV2TransactionsGet200ResponsePaymentInformationBankAccount',
        'mandate': 'TssV2TransactionsGet200ResponsePaymentInformationBankMandate'
    }

    attribute_map = {
        'routing_number': 'routingNumber',
        'branch_code': 'branchCode',
        'swift_code': 'swiftCode',
        'bank_code': 'bankCode',
        'iban': 'iban',
        'account': 'account',
        'mandate': 'mandate'
    }

    def __init__(self, routing_number=None, branch_code=None, swift_code=None, bank_code=None, iban=None, account=None, mandate=None):
        """
        TssV2TransactionsGet200ResponsePaymentInformationBank - a model defined in Swagger
        """

        self._routing_number = None
        self._branch_code = None
        self._swift_code = None
        self._bank_code = None
        self._iban = None
        self._account = None
        self._mandate = None

        if routing_number is not None:
          self.routing_number = routing_number
        if branch_code is not None:
          self.branch_code = branch_code
        if swift_code is not None:
          self.swift_code = swift_code
        if bank_code is not None:
          self.bank_code = bank_code
        if iban is not None:
          self.iban = iban
        if account is not None:
          self.account = account
        if mandate is not None:
          self.mandate = mandate

    @property
    def routing_number(self):
        """
        Gets the routing_number of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        Bank routing number. This is also called the transit number.  For details, see `ecp_rdfi` field description in the [Electronic Check Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/EChecks_SCMP_API/html/) 

        :return: The routing_number of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :rtype: str
        """
        return self._routing_number

    @routing_number.setter
    def routing_number(self, routing_number):
        """
        Sets the routing_number of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        Bank routing number. This is also called the transit number.  For details, see `ecp_rdfi` field description in the [Electronic Check Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/EChecks_SCMP_API/html/) 

        :param routing_number: The routing_number of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :type: str
        """

        self._routing_number = routing_number

    @property
    def branch_code(self):
        """
        Gets the branch_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        Code used to identify the branch of the customer’s bank. Required for some countries if you do not or are not allowed to provide the IBAN. Use this field only when scoring a direct debit transaction.  For all possible values, see the `branch_code` field description in the _Decision Manager Using the SCMP API Developer Guide_ on the [CyberSource Business Center.](https://ebc2.cybersource.com/ebc2/) Click **Decision Manager** > **Documentation** > **Guides** > _Decision Manager Using the SCMP API Developer Guide_ (PDF link). 

        :return: The branch_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :rtype: str
        """
        return self._branch_code

    @branch_code.setter
    def branch_code(self, branch_code):
        """
        Sets the branch_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        Code used to identify the branch of the customer’s bank. Required for some countries if you do not or are not allowed to provide the IBAN. Use this field only when scoring a direct debit transaction.  For all possible values, see the `branch_code` field description in the _Decision Manager Using the SCMP API Developer Guide_ on the [CyberSource Business Center.](https://ebc2.cybersource.com/ebc2/) Click **Decision Manager** > **Documentation** > **Guides** > _Decision Manager Using the SCMP API Developer Guide_ (PDF link). 

        :param branch_code: The branch_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :type: str
        """

        self._branch_code = branch_code

    @property
    def swift_code(self):
        """
        Gets the swift_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        Bank’s SWIFT code. You can use this field only when scoring a direct debit transaction. Required only for crossborder transactions.  For all possible values, see the `bank_swiftcode` field description in the _Decision Manager Using the SCMP API Developer Guide_ on the [CyberSource Business Center.](https://ebc2.cybersource.com/ebc2/) Click **Decision Manager** > **Documentation** > **Guides** > _Decision Manager Using the SCMP API Developer Guide_ (PDF link). 

        :return: The swift_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :rtype: str
        """
        return self._swift_code

    @swift_code.setter
    def swift_code(self, swift_code):
        """
        Sets the swift_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        Bank’s SWIFT code. You can use this field only when scoring a direct debit transaction. Required only for crossborder transactions.  For all possible values, see the `bank_swiftcode` field description in the _Decision Manager Using the SCMP API Developer Guide_ on the [CyberSource Business Center.](https://ebc2.cybersource.com/ebc2/) Click **Decision Manager** > **Documentation** > **Guides** > _Decision Manager Using the SCMP API Developer Guide_ (PDF link). 

        :param swift_code: The swift_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :type: str
        """

        self._swift_code = swift_code

    @property
    def bank_code(self):
        """
        Gets the bank_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        Country-specific code used to identify the customer’s bank. Required for some countries if you do not or are not allowed to provide the IBAN instead. You can use this field only when scoring a direct debit transaction.  For all possible values, see the `bank_code` field description in the _Decision Manager Using the SCMP API Developer Guide_ on the [CyberSource Business Center.](https://ebc2.cybersource.com/ebc2/) Click **Decision Manager** > **Documentation** > **Guides** > _Decision Manager Using the SCMP API Developer Guide_ (PDF link). 

        :return: The bank_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :rtype: str
        """
        return self._bank_code

    @bank_code.setter
    def bank_code(self, bank_code):
        """
        Sets the bank_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        Country-specific code used to identify the customer’s bank. Required for some countries if you do not or are not allowed to provide the IBAN instead. You can use this field only when scoring a direct debit transaction.  For all possible values, see the `bank_code` field description in the _Decision Manager Using the SCMP API Developer Guide_ on the [CyberSource Business Center.](https://ebc2.cybersource.com/ebc2/) Click **Decision Manager** > **Documentation** > **Guides** > _Decision Manager Using the SCMP API Developer Guide_ (PDF link). 

        :param bank_code: The bank_code of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :type: str
        """

        self._bank_code = bank_code

    @property
    def iban(self):
        """
        Gets the iban of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        International Bank Account Number (IBAN) for the bank account. For some countries you can provide this number instead of the traditional bank account information. You can use this field only when scoring a direct debit transaction.  For all possible values, see the `bank_iban` field description in the _Decision Manager Using the SCMP API Developer Guide_ on the [CyberSource Business Center.](https://ebc2.cybersource.com/ebc2/) Click **Decision Manager** > **Documentation** > **Guides** > _Decision Manager Using the SCMP API Developer Guide_ (PDF link). 

        :return: The iban of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :rtype: str
        """
        return self._iban

    @iban.setter
    def iban(self, iban):
        """
        Sets the iban of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        International Bank Account Number (IBAN) for the bank account. For some countries you can provide this number instead of the traditional bank account information. You can use this field only when scoring a direct debit transaction.  For all possible values, see the `bank_iban` field description in the _Decision Manager Using the SCMP API Developer Guide_ on the [CyberSource Business Center.](https://ebc2.cybersource.com/ebc2/) Click **Decision Manager** > **Documentation** > **Guides** > _Decision Manager Using the SCMP API Developer Guide_ (PDF link). 

        :param iban: The iban of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :type: str
        """

        self._iban = iban

    @property
    def account(self):
        """
        Gets the account of this TssV2TransactionsGet200ResponsePaymentInformationBank.

        :return: The account of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :rtype: TssV2TransactionsGet200ResponsePaymentInformationBankAccount
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this TssV2TransactionsGet200ResponsePaymentInformationBank.

        :param account: The account of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :type: TssV2TransactionsGet200ResponsePaymentInformationBankAccount
        """

        self._account = account

    @property
    def mandate(self):
        """
        Gets the mandate of this TssV2TransactionsGet200ResponsePaymentInformationBank.

        :return: The mandate of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :rtype: TssV2TransactionsGet200ResponsePaymentInformationBankMandate
        """
        return self._mandate

    @mandate.setter
    def mandate(self, mandate):
        """
        Sets the mandate of this TssV2TransactionsGet200ResponsePaymentInformationBank.

        :param mandate: The mandate of this TssV2TransactionsGet200ResponsePaymentInformationBank.
        :type: TssV2TransactionsGet200ResponsePaymentInformationBankMandate
        """

        self._mandate = mandate

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TssV2TransactionsGet200ResponsePaymentInformationBank):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
