# Generated by Django 3.2.7 on 2021-09-23 12:43

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('changelog', '0002_delete_all_previous'),
    ]

    operations = [
        migrations.CreateModel(
            name='Commit',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name='SHA')),
                ('message', models.TextField(verbose_name='Message')),
                ('created_at', models.DateTimeField(verbose_name='Created at')),
                ('hidden', models.BooleanField(default=False, verbose_name='Hidden')),
                ('sent', models.BooleanField(default=False, verbose_name='Sent')),
                ('done', models.BooleanField(default=False, verbose_name='Done')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Release',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(blank=True, editable=False, max_length=20)),
                ('text', models.TextField(blank=True, null=True, verbose_name='Text')),
                ('sent_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='Sent at')),
                ('commits', models.ManyToManyField(blank=True, related_name='releases', to='changelog.Commit')),
                ('email_recipient_users', models.ManyToManyField(blank=True, related_name='releases', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Release',
                'verbose_name_plural': 'Release',
            },
        ),
        migrations.CreateModel(
            name='Repository',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='Name')),
                ('path', models.CharField(blank=True, help_text='Basedir if blank', max_length=150, unique=True, verbose_name='Path')),
            ],
            options={
                'verbose_name': 'Repository',
                'verbose_name_plural': 'Repositories',
            },
        ),
        migrations.CreateModel(
            name='TelegramBot',
            fields=[
                ('id', models.CharField(help_text='eg. 123456789:QwErtzuIoPpjHgHlkhKGkjlHLhjLhlK-749', max_length=250, primary_key=True, serialize=False, verbose_name='Token')),
            ],
            options={
                'verbose_name': 'Telegram bot',
                'verbose_name_plural': 'Telegram bots',
            },
        ),
        migrations.CreateModel(
            name='TelegramChat',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Chat ID')),
                ('type', models.CharField(choices=[('private', 'Private'), ('group', 'Group'), ('supergroup', 'Supergroup'), ('channel', 'Channel')], max_length=10)),
                ('telegram_bot', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='changelog.telegrambot')),
            ],
            options={
                'verbose_name': 'Telegram chat',
                'verbose_name_plural': 'Telegram chats',
            },
        ),
        migrations.CreateModel(
            name='ReleaseAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(upload_to='', verbose_name='File')),
                ('release', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='changelog.release')),
            ],
            options={
                'verbose_name': 'Attachment',
                'verbose_name_plural': 'Attachments',
            },
        ),
        migrations.AddField(
            model_name='release',
            name='repository',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='changelog.repository'),
        ),
        migrations.AddField(
            model_name='release',
            name='telegram_chats',
            field=models.ManyToManyField(blank=True, related_name='releases', to='changelog.TelegramChat'),
        ),
        migrations.AddField(
            model_name='commit',
            name='repository',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='commits', to='changelog.repository'),
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='Name')),
                ('message', models.TextField(blank=True, null=True, verbose_name='Message')),
                ('commit', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tags', to='changelog.commit')),
            ],
            options={
                'verbose_name': 'Tag',
                'verbose_name_plural': 'Tags',
                'unique_together': {('commit', 'name')},
            },
        ),
        migrations.CreateModel(
            name='ReleaseProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='Profile name')),
                ('text', models.TextField(blank=True, null=True, verbose_name='Text')),
                ('recipient_users', models.ManyToManyField(blank=True, related_name='release_profiles', to=settings.AUTH_USER_MODEL)),
                ('repository', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='changelog.repository')),
                ('telegram_chats', models.ManyToManyField(blank=True, related_name='release_profiles', to='changelog.TelegramChat')),
            ],
            options={
                'verbose_name': 'Release Profile',
                'verbose_name_plural': 'Release Profiles',
                'unique_together': {('name', 'repository')},
            },
        ),
        migrations.AlterUniqueTogether(
            name='release',
            unique_together={('repository', 'version')},
        ),
        migrations.CreateModel(
            name='Branch',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='Name')),
                ('enabled', models.BooleanField(default=True, verbose_name='Enabled')),
                ('commits', models.ManyToManyField(blank=True, related_name='branches', to='changelog.Commit')),
                ('repository', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='branches', to='changelog.repository')),
            ],
            options={
                'verbose_name': 'Branch',
                'verbose_name_plural': 'Branches',
                'unique_together': {('repository', 'name')},
            },
        ),
    ]
